ScriptName TGAH:TermMenu_SettingsMiscScript Extends TerminalMenu hidden

;-- Properties --------------------------------------

GlobalVariable Property COM_FlirtCooldownDays Auto Mandatory
GlobalVariable Property COM_WantsToTalk_CooldownDays Auto Mandatory
GlobalVariable Property TGAF_Global_COM_AutoGiveItems Auto Mandatory
Message Property TGAH_SettingsMisc_Flirt_0 Auto Const Mandatory
Message Property TGAH_SettingsMisc_Flirt_3 Auto Const Mandatory
Message Property TGAH_SettingsMisc_TalkCooldown_0 Auto Const Mandatory
Message Property TGAH_SettingsMisc_TalkCooldown_16 Auto Const Mandatory
Message Property TGAH_SettingsMisc_TalkCooldown_02 Auto Const Mandatory
Message Property TGAH_Off Auto Const Mandatory
Message Property TGAH_On Auto Const Mandatory
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory

Float fCurrentFlirt
Float fCurrentCooldown
Int iCurrentGiveItems

;-- Events ------------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  fCurrentFlirt = COM_FlirtCooldownDays.GetValue() 
  fCurrentCooldown = COM_WantsToTalk_CooldownDays.GetValue()
  iCurrentGiveItems = TGAF_Global_COM_AutoGiveItems.GetValue() as Int
  If fCurrentFlirt == 3.0
    akTerminalRef.AddTextReplacementData("CurrentFlirt", TGAH_SettingsMisc_Flirt_3)
  ElseIf fCurrentFlirt == 0.0
    akTerminalRef.AddTextReplacementData("CurrentFlirt", TGAH_SettingsMisc_Flirt_0)
  EndIf 
  If fCurrentCooldown == 0.16
    akTerminalRef.AddTextReplacementData("CurrentCooldown", TGAH_SettingsMisc_TalkCooldown_16)
  ElseIf fCurrentCooldown == 0.02
    akTerminalRef.AddTextReplacementData("CurrentCooldown", TGAH_SettingsMisc_TalkCooldown_02)
  ElseIf fCurrentCooldown == 0.0
    akTerminalRef.AddTextReplacementData("CurrentCooldown", TGAH_SettingsMisc_TalkCooldown_0)
  EndIf
  If iCurrentGiveItems == 0
    akTerminalRef.AddTextReplacementData("CurrentGiveItems", TGAH_Off)
  ElseIf iCurrentGiveItems == 1
    akTerminalRef.AddTextReplacementData("CurrentGiveItems", TGAH_On)
  EndIf 
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    fCurrentFlirt = COM_FlirtCooldownDays.GetValue() 
    fCurrentCooldown = COM_WantsToTalk_CooldownDays.GetValue()
    iCurrentGiveItems = TGAF_Global_COM_AutoGiveItems.GetValue() as Int
    If auiMenuItemID == 0
      If fCurrentFlirt == 3.0
        COM_FlirtCooldownDays.SetValue(0.0)
        akTerminalRef.AddTextReplacementData("CurrentFlirt", TGAH_SettingsMisc_Flirt_0)
      ElseIf fCurrentFlirt == 0.0
        COM_FlirtCooldownDays.SetValue(3.0)
        akTerminalRef.AddTextReplacementData("CurrentFlirt", TGAH_SettingsMisc_Flirt_3)
      EndIf 
    ElseIf auiMenuItemID == 1
      If fCurrentCooldown == 0.16
        COM_WantsToTalk_CooldownDays.SetValue(0.02)
        akTerminalRef.AddTextReplacementData("CurrentCooldown", TGAH_SettingsMisc_TalkCooldown_02)
      ElseIf fCurrentCooldown == 0.02
        COM_WantsToTalk_CooldownDays.SetValue(0.0)
        akTerminalRef.AddTextReplacementData("CurrentCooldown", TGAH_SettingsMisc_TalkCooldown_0)
      ElseIf fCurrentCooldown == 0.0
        COM_WantsToTalk_CooldownDays.SetValue(0.16)
        akTerminalRef.AddTextReplacementData("CurrentCooldown", TGAH_SettingsMisc_TalkCooldown_16)
      EndIf
    ElseIf auiMenuItemID == 2
      If iCurrentGiveItems == 0
        TGAF_Global_COM_AutoGiveItems.SetValue(1.0)
        akTerminalRef.AddTextReplacementData("CurrentGiveItems", TGAH_On)
      ElseIf iCurrentGiveItems == 1
        TGAF_Global_COM_AutoGiveItems.SetValue(0.0)
        akTerminalRef.AddTextReplacementData("CurrentGiveItems", TGAH_Off)
      EndIf
    EndIf
  EndIf
EndEvent