ScriptName TGAH:TGAH_CompanionsScript Extends Quest

Group ActorValues_Autofill
  ActorValue Property COM_ActiveCompanion Auto Const mandatory
  ActorValue Property TGAH_COM_Setting_Chat_Triggers Auto mandatory
  { 1.0 for companion that will comment during Trigger }
  ActorValue Property TGAH_COM_Setting_Chat_Looting Auto mandatory
  { 1.0 for companion that will comment during looting events }
EndGroup

Group CompanionRef_Autofill
  ObjectReference Property AndrejaRef Auto Const Mandatory
  ObjectReference Property BarrettRef Auto Const Mandatory
  ObjectReference Property SamCoeRef Auto Const Mandatory
  ObjectReference Property SarahMorganRef Auto Const Mandatory
  Actor Property PlayerRef Auto Const Mandatory
EndGroup

Group Misc
  Form[] Property AllCompanionActors Auto Const Mandatory
  Form[] Property AllCompanionPerks Auto Const Mandatory
  Form[] Property AllCompanionQuests Auto Const Mandatory
  Form[] Property AllCompanionRefs Auto Const Mandatory
  Form[] Property AllCompanionAndCrewRefs Auto Const Mandatory
  ReferenceAlias Property Alias_ActiveCompanion Auto mandatory
EndGroup

Group GlobalVariables_Autofill
  GlobalVariable Property TGAF_Global_COM_ID_Main Auto mandatory
  GlobalVariable Property TGAF_Global_COM_LootCommentsAllowed Auto mandatory
  GlobalVariable Property TGAF_Global_COM_TriggerCommentsAllowed Auto mandatory
EndGroup

Event OnQuestInit()
  ; This will add the companioncheckperk for all active companions to the player.
  Self.AddActiveCompanionPerks()
EndEvent

;*****************************************************************************************
;
; Updating/Retaining Chat Options when picking up and dismissing
;
;*****************************************************************************************

Function UpdateChatOptionsPickedUp(Actor ActorToUpdate)
  ; Get current MC and make sure they remain MC (added to ActiveCompanion alias as vanilla function replaces them)
  Int iCurrentMain = Self.GetMainCompanionIdAsInt()
  Int iActorToUpdateID = (ActorToUpdate as companionactorscript).GetCompanionIDValue() as Int
  ObjectReference ActorToUpdateRef = GetCompanionRefByID(iActorToUpdateID)
  ObjectReference currentMCRef = GetCompanionRefByID(iCurrentMain)
 
  ; Find current loot and Trigger companion (this is needed because setting a new main overwrites these)
  ObjectReference lootComp = Self.GetLootCommentCompanion()
  ObjectReference TriggerComp = Self.GetTriggerCommentCompanion()

  ; If less than 0, no main has been selected so set the newly hired companion as the main companion. 
  If iCurrentMain < 0
    Self.SetMainCompanionOnChange(ActorToUpdateRef)
  Else
    Self.SetMainCompanionOnChange(currentMCRef)
  EndIf

  ; If original comment companions aren't the picked up companion, are still active and Trigger comments are allowed, set it back to them
  ; We need to do this because SetMainCompanionOnChange changes these values
  If TriggerComp != ActorToUpdateRef && Self.IsActiveCompanion(TriggerComp) && TGAF_Global_COM_TriggerCommentsAllowed.GetValue() > 0 
    Self.SetTriggerCommentsCompanion(TriggerComp)
  EndIf

  If lootComp != ActorToUpdateRef && Self.IsActiveCompanion(lootComp) && TGAF_Global_COM_LootCommentsAllowed.GetValue() > 0 
    Self.SetLootCommentsCompanion(TriggerComp)
  EndIf
EndFunction

Function UpdateChatOptionsDismissed(Actor ActorToUpdate)
  Int iCurrentMain = Self.GetMainCompanionIdAsInt()
  Int iActorToUpdateID = (ActorToUpdate as companionactorscript).GetCompanionIDValue() as Int
  ObjectReference ActorToUpdateRef = GetCompanionRefByID(iActorToUpdateID)

  ; Find current loot and Trigger companion
  ObjectReference lootComp = Self.GetLootCommentCompanion()
  ObjectReference TriggerComp = Self.GetTriggerCommentCompanion()
  
  ObjectReference firstActive = FindFirstActiveCompanion()
  
  ; If current MC is the companion being dismissed, choose another active companion to fill the role. If no other active, then set it to none
  If iCurrentMain == iActorToUpdateID
    If firstActive
      Self.SetMainCompanionOnChange(firstActive)
    Else
      Self.SetMainCompanionID(-1.0)
      ; Since we are not setting an MC in this case, we need to make sure companion perks are also updated. This is part SetMainCompanionOnChange function, but we are not using that here.
      Self.AddActiveCompanionPerks()
      ; Also need to do cleanup. If there are no active companions, we need to reset everything.
      Int I = 0
      While I < AllCompanionRefs.Length
        ObjectReference compRef = AllCompanionRefs[I] as ObjectReference
        compRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 0.0)
        compRef.SetValue(TGAH_COM_Setting_Chat_Looting, 0.0)
        I += 1
      EndWhile
    EndIf
  EndIf

  ; If the original Trigger/loot comment companion isn't the dismissed companion, is still active and comments are allowed, set it back to them
  If TriggerComp != ActorToUpdateRef && Self.IsActiveCompanion(TriggerComp) && TGAF_Global_COM_TriggerCommentsAllowed.GetValue() > 0 
    Self.SetTriggerCommentsCompanion(TriggerComp)
  EndIf

  If lootComp != ActorToUpdateRef && Self.IsActiveCompanion(lootComp) && TGAF_Global_COM_LootCommentsAllowed.GetValue() > 0 
    Self.SetLootCommentsCompanion(TriggerComp)
  EndIf
EndFunction

;*****************************************************************************************
;
; Chat Options Functions
;
;*****************************************************************************************

; This will set all chat options to use the same companion. Speak for me will be allowed on all active companions regardless of the main companion.
; This will not turn on the global setting for looting and Trigger triggers if they have been disabled.
Function SetMainCompanion(ObjectReference theCompanion)
  String CompleteMessage
  If theCompanion
    Int I = 0
    While I < AllCompanionRefs.Length
      Actor currentCompanionActor = AllCompanionActors[I] as Actor
      ObjectReference currentCompanionRef = AllCompanionRefs[I] as ObjectReference
      Perk currentCompanionPerk = AllCompanionPerks[I] as Perk 
      Quest currentCompanionQuest = AllCompanionQuests[I] as Quest
      If theCompanion != currentCompanionRef 
        ;Change AVIFs for all other companions to remove them from any chat settings they may have previously been selected for.
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 0.0)
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Looting, 0.0)
      ElseIf theCompanion == currentCompanionRef
        ;Set AVIFs and GLOB to 1.0
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 1.0)
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Looting, 1.0)
        TGAF_Global_COM_ID_Main.SetValue((currentCompanionRef as companionactorscript).GetCompanionIDValue())
        ;If the companion is not active, make active and telport to the player
        If !IsActiveCompanion(currentCompanionRef)
          currentCompanionRef.MoveTo(PlayerRef as ObjectReference, 0.0, 0.0, 0.0, True, False)
          ; This will function just as if the player used vanilla dialogue. 
          ; Sets the selected companion as the active companion.
          ; Add the perk
          ; Starts the story gate timers
          ; Can't use PickupSceneEnded since this function is called in SQ_CompanionsScript. Would cause a loop.
          ;(currentCompanionQuest as COM_CompanionQuestScript).PickupSceneEnded()
          ;This ensures story gate timers start up as they should
          (currentCompanionQuest as COM_CompanionQuestScript).PickedUpAsCompanion()
        EndIf
        ; This will add the companioncheckperk for all active companions to the player.
        Self.AddActiveCompanionPerks()
        ; Add to ActiveCompanion alias (determines who speaks during quests)
        Alias_ActiveCompanion.ForceRefTo(theCompanion)
        ; Just a message to let the player know the process is complete and verification of who is now the main companion.
        If I == 0
          CompleteMessage = "Andreja is now your Main Companion"
        ElseIf I == 1
          CompleteMessage = "Barrett is now your Main Companion"
        ElseIf I == 2
          CompleteMessage = "Sam is now your Main Companion"
        ElseIf I == 3
          CompleteMessage = "Sarah is your the Main Companion"
        EndIf
      EndIf
      I += 1
    EndWhile
    Debug.Notification(CompleteMessage)
  EndIf
EndFunction

;*****************************************************************************************
;
; Chat Options - Set different companions for different comments
;
;*****************************************************************************************

Function SetQuestSceneCompanion(ObjectReference theCompanion)
  ; Make sure theCompanion is not blank
  If theCompanion
    ; If theCompanion is not already an active companion, we will teleport them to the player and make them active. 
    If !IsActiveCompanion(theCompanion)
      theCompanion.MoveTo(PlayerRef as ObjectReference, 0.0, 0.0, 0.0, True, False)
      ; This will function just as if the player used vanilla dialogue. 
      ; Sets the selected companion as the active companion.
      ; Add the perk
      ; Starts the story gate timers
      GetCompanionQuest(theCompanion).PickupSceneEnded()
      GetCompanionQuest(theCompanion).PickedUpAsCompanion()
    EndIf
    TGAF_Global_COM_ID_Main.SetValue((theCompanion as companionactorscript).GetCompanionIDValue())
    Alias_ActiveCompanion.ForceRefTo(theCompanion)
  EndIf
EndFunction

Function SetTriggerCommentsCompanion(ObjectReference theCompanion)
  If theCompanion
    ; Cleanup any previously selected companions
    Int I = 0
    While I < AllCompanionAndCrewRefs.Length
      ObjectReference compRef = AllCompanionAndCrewRefs[I] as ObjectReference
      If compRef != theCompanion
        compRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 0.0)
      ElseIf compRef == theCompanion 
        compRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 1.0)
      EndIf
      I += 1
    EndWhile
    ; Turn on Trigger comments by setting the global to 1 if it isn't already
    If TGAF_Global_COM_TriggerCommentsAllowed.GetValue() <= 0
      TGAF_Global_COM_TriggerCommentsAllowed.SetValue(1.0)
    EndIf
  EndIf
EndFunction

Function SetLootCommentsCompanion(ObjectReference theCompanion)
  If theCompanion
    ; Cleanup any previously selected companions
    Int I = 0
    While I < AllCompanionAndCrewRefs.Length
      ObjectReference compRef = AllCompanionAndCrewRefs[I] as ObjectReference
      If compRef != theCompanion
        compRef.SetValue(TGAH_COM_Setting_Chat_Looting, 0.0)
      ElseIf compRef == theCompanion 
        compRef.SetValue(TGAH_COM_Setting_Chat_Looting, 1.0)
      EndIf
      I += 1
    EndWhile
    ; Turn on Loot comments by setting the global to 1 if it isn't already
    If TGAF_Global_COM_LootCommentsAllowed.GetValue() <= 0
      TGAF_Global_COM_LootCommentsAllowed.SetValue(1.0)
    EndIf
  EndIf
EndFunction

;*****************************************************************************************
;
; Chat Options - Toggle Loot and Trigger comments
;
;*****************************************************************************************

Function ToggleLootComments()
  bool bLootCommentsOn = TGAF_Global_COM_LootCommentsAllowed.GetValue() as bool 
  If bLootCommentsOn
    TGAF_Global_COM_LootCommentsAllowed.SetValue(1.0)
  ElseIf !bLootCommentsOn
    TGAF_Global_COM_LootCommentsAllowed.SetValue(0.0)
  EndIf
EndFunction

Function ToggleTriggerComments()
  bool bTriggerCommentsOn = TGAF_Global_COM_TriggerCommentsAllowed.GetValue() as bool 
  If bTriggerCommentsOn
    TGAF_Global_COM_TriggerCommentsAllowed.SetValue(1.0)
  ElseIf !bTriggerCommentsOn
    TGAF_Global_COM_TriggerCommentsAllowed.SetValue(0.0)
  EndIf
EndFunction

ObjectReference Function GetLootCommentCompanion()
  bool bFoundCompanion = false
  ObjectReference LootCompanionRef
  Int I = 0
  While I < AllCompanionAndCrewRefs.Length && !bFoundCompanion
    ObjectReference compRef = AllCompanionAndCrewRefs[I] as ObjectReference
    If compRef.GetValue(TGAH_COM_Setting_Chat_Looting) > 0
      LootCompanionRef = compRef
      bFoundCompanion = true
    EndIf
    I += 1
  EndWhile
  return LootCompanionRef
EndFunction

ObjectReference Function GetTriggerCommentCompanion()
  bool bFoundCompanion = false
  ObjectReference TriggerCompanionRef
  Int I = 0
  While I < AllCompanionAndCrewRefs.Length && !bFoundCompanion
    ObjectReference compRef = AllCompanionAndCrewRefs[I] as ObjectReference
    If compRef.GetValue(TGAH_COM_Setting_Chat_Triggers) > 0
      TriggerCompanionRef = compRef
      bFoundCompanion = true
    EndIf
    I += 1
  EndWhile
  return TriggerCompanionRef
EndFunction

;*****************************************************************************************
;
; SetMainCompanion to use when picking up and dismissing
;
;*****************************************************************************************

Function SetMainCompanionOnChange(ObjectReference theCompanion)
  String CompleteMessage
  If theCompanion
    Int I = 0
    While I < AllCompanionRefs.Length
      Actor currentCompanionActor = AllCompanionActors[I] as Actor
      ObjectReference currentCompanionRef = AllCompanionRefs[I] as ObjectReference
      Perk currentCompanionPerk = AllCompanionPerks[I] as Perk 
      Quest currentCompanionQuest = AllCompanionQuests[I] as Quest
      If theCompanion != currentCompanionRef 
        ;Change AVIFs for all other companions to remove them from any chat settings they may have previously been selected for.
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 0.0)
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Looting, 0.0)
      ElseIf theCompanion == currentCompanionRef
        ;Set AVIFs and GLOB to 1.0
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 1.0)
        currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Looting, 1.0)
        TGAF_Global_COM_ID_Main.SetValue((currentCompanionRef as companionactorscript).GetCompanionIDValue())
        (currentCompanionQuest as COM_CompanionQuestScript).PickedUpAsCompanion()
        ; This will add the companioncheckperk for all active companions to the player.
        Self.AddActiveCompanionPerks()
        ; Add to ActiveCompanion alias (determines who speaks during quests)
        Alias_ActiveCompanion.ForceRefTo(theCompanion)
        ; Just a message to let the player know the process is complete and verification of who is now the main companion.
        If I == 0
          CompleteMessage = "Andreja is now your Main Companion"
        ElseIf I == 1
          CompleteMessage = "Barrett is now your Main Companion"
        ElseIf I == 2
          CompleteMessage = "Sam is now your Main Companion"
        ElseIf I == 3
          CompleteMessage = "Sarah is now your Main Companion"
        EndIf
      EndIf
      I += 1
    EndWhile
    Debug.Notification(CompleteMessage)
  EndIf
EndFunction

;*****************************************************************************************
;
; Helper functions for stuff that we do a lot
;
;*****************************************************************************************

com_companionquestscript Function GetCompanionQuest(ObjectReference theCompanion) 
  com_companionquestscript compQuest 
  Int I = 0
  bool bFoundCompanion = false
  While I < AllCompanionRefs.Length && !bFoundCompanion
    ObjectReference compRef = AllCompanionRefs[I] as ObjectReference
    If compRef == theCompanion
      compQuest = AllCompanionQuests[I] as com_companionquestscript 
      bFoundCompanion = true
    EndIf
    I += 1
  EndWhile
  return compQuest 
EndFunction

ObjectReference Function FindFirstActiveCompanion()
  Int I = 0
  Bool bFound = false
  ObjectReference theActiveCompanion
  While I < AllCompanionRefs.Length && !bFound
    ObjectReference currentCompanionRef = AllCompanionRefs[I] as ObjectReference
    If IsActiveCompanion(currentCompanionRef) 
      theActiveCompanion = currentCompanionRef
      bFound = true
    EndIf
    I += 1
  EndWhile
  return theActiveCompanion
EndFunction

Function AddActiveCompanionPerks()
  Int I = 0
  While I < AllCompanionRefs.Length
    Perk currentCompanionPerk = AllCompanionPerks[I] as Perk
    ObjectReference currentCompanionRef = AllCompanionRefs[I] as ObjectReference
    If IsActiveCompanion(currentCompanionRef)
      If !PlayerRef.HasPerk(currentCompanionPerk)
        PlayerRef.AddPerk(currentCompanionPerk, False)
      EndIf
    ElseIf !IsActiveCompanion(currentCompanionRef) 
      If PlayerRef.HasPerk(currentCompanionPerk)
        PlayerRef.RemovePerk(currentCompanionPerk)
      EndIf 
    EndIf
    I += 1
  EndWhile
EndFunction

ObjectReference Function GetCompanionRefByID(Int theCompanionID)
  ObjectReference theCompanion
  If theCompanionID == (AndrejaRef as companionactorscript).GetCompanionIDValueInt()
     theCompanion = AndrejaRef
  ElseIf theCompanionID == (BarrettRef as companionactorscript).GetCompanionIDValueInt()
    theCompanion = BarrettRef
  ElseIf theCompanionID == (SamCoeRef as companionactorscript).GetCompanionIDValueInt()
    theCompanion = SamCoeRef
  ElseIf theCompanionID == (SarahMorganRef as companionactorscript).GetCompanionIDValueInt()
    theCompanion = SarahMorganRef
  EndIf
  return theCompanion
EndFunction

Int Function GetMainCompanionIdAsInt()
  Int iMain = TGAF_Global_COM_ID_Main.GetValue() as Int
  return iMain
EndFunction

Function SetMainCompanionID(Float theMain)
  TGAF_Global_COM_ID_Main.SetValue(theMain)
EndFunction

bool Function IsActiveCompanion(ObjectReference akCompanion)
  bool bIsActiveCompanion
  bIsActiveCompanion = akCompanion.GetValue(COM_ActiveCompanion) as bool 
  return bIsActiveCompanion
EndFunction

TGAH:TGAH_CompanionsScript Function GetScript() Global
  Return (Game.GetFormFromFile(0x00000883, "TheGangsAllHere.esm") as Quest) as TGAH:TGAH_CompanionsScript
EndFunction
