ScriptName TGAH:TermMenu_Affinity_RequiredScript Extends TerminalMenu hidden

;-- Variables ---------------------------------------

;-- Properties --------------------------------------

Form[] Property AffinityRequiredGlobals Auto Const Mandatory 
GlobalVariable Property TGAF_Global_COM_Affinity_Required_ModifyBy Auto Const Mandatory
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
{ fill with the current menu }

;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  ;Updates the text so we know the current value when we open the menu
  Int I = 0
  While I < AffinityRequiredGlobals.Length
    GlobalVariable currentGlobal = AffinityRequiredGlobals[I] as GlobalVariable
    Int iValue = currentGlobal.GetValue() as Int
    akTerminalRef.AddTextReplacementValue("CurrentIncrement" + I as string, iValue as Float)
    I += 1
  EndWhile
  Int iModifyBy = TGAF_Global_COM_Affinity_Required_ModifyBy.GetValue() as Int
  akTerminalRef.AddTextReplacementValue("ModifyBy", iModifyBy as Float)  
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    If auiMenuItemID == 0 || auiMenuItemID == 1   
      GlobalVariable startglobal = AffinityRequiredGlobals[0] as GlobalVariable
      Int startingIncrement = startglobal.GetValue() as Int
      Int iModifyBy = TGAF_Global_COM_Affinity_Required_ModifyBy.GetValue() as Int
      Int iNewIncrement
      ; Add or subtract
      If auiMenuItemID == 0
        iNewIncrement = startingIncrement + iModifyBy
      ElseIf auiMenuItemID == 1
        iNewIncrement = startingIncrement - iModifyBy
      EndIf
      ; Update the globals in the form list
      Int I = 0
      Int multi = 1
      While I < AffinityRequiredGlobals.Length
        GlobalVariable currentGlobal = AffinityRequiredGlobals[I] as GlobalVariable
        Int newValue = iNewIncrement*multi 
        currentGlobal.SetValue(newValue as Float)
        akTerminalRef.AddTextReplacementValue("CurrentIncrement" + I as string, newValue as Float)
        multi += 1
        I += 1
      EndWhile 
    EndIf
  EndIf 
EndEvent

