ScriptName TGAH:TermMenu_AllCommandScript Extends TerminalMenu hidden

;-- Properties --------------------------------------

Group RelatedQuests_Autofill
  SQ_FollowersScript Property SQ_Followers Auto Const Mandatory
  SQ_CompanionsScript Property SQ_Companions Auto Const Mandatory
  SQ_CrewScript Property SQ_Crew Auto Const Mandatory
  SQ_PlayerShipScript Property SQ_PlayerShip Auto Const Mandatory
EndGroup

Group Keywords_Autofill
  Keyword Property Crew_CrewTypeCompanion Auto Const Mandatory 
  Keyword Property Crew_CrewTypeElite Auto Const Mandatory 
  Keyword Property Crew_CrewTypeGeneric Auto Const Mandatory 
EndGroup

Group Misc
  Alias Property Alias_Active Auto Mandatory
  { 017 ActiveFollowers on SQ_Followers }
  ReferenceAlias Property ActiveEliteCrew Auto Const mandatory
  { 030 ActiveEliteCrew on SQ_Crew } 
  TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
  ObjectReference Property PlayerRef Auto Const Mandatory 
EndGroup

;-- Events ------------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  ; Don't need to do anything when we open the menu
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    If auiMenuItemID == 0
      ; Everyone Wait
      SQ_Followers.AllFollowersWait(None, True, False)
    ElseIf auiMenuItemID == 1
      ; Everyone Follow
      SQ_Followers.AllFollowersFollow(None)
    ElseIf auiMenuItemID == 2
      ; Dismiss all
      Self.DismissAll()
    ElseIf auiMenuItemID == 3
      ; Teleport to Me
      SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, True, False, False)
    ElseIf auiMenuItemID == 4
      ; Teleport to Me and Wait
      SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, False, True, True)
    ElseIf auiMenuItemID == 5
      ; Teleport to Me and Follow
      SQ_Followers.TeleportFollowers(PlayerRef, None, True, True, True, False, False)
    ElseIf auiMenuItemID == 6
      ; Teleport to Ship and Wait
      SQ_Followers.AllFollowersWait(SQ_PlayerShip.HomeShipCrewMarker.GetRef(), False, False)
    EndIf
  EndIf

EndEvent

;-- Functions ----------------------------------------

Function DismissAll()
  Actor[] ActiveFollowersArray = SQ_Followers.GetFollowers(True, True)
  Int I = 0
  While I < ActiveFollowersArray.Length
  Actor currentFollower = ActiveFollowersArray[I]
  If currentFollower 
    If SQ_Companions.IsCompanionLockedIn(currentFollower as companionactorscript) == False && SQ_Companions.IsCompanion(currentFollower, True)
      Quest CompanionQuest = (currentFollower as companionactorscript).COM_CompanionQuest
      com_companionquestscript compQuest = CompanionQuest as com_companionquestscript
      compQuest.DismissSceneEnded()
      compQuest.DismissedAsCompanion()
    ElseIf currentFollower.HasKeyword(Crew_CrewTypeElite)
      Quest EliteQuest = (currentFollower as elitecrewdebugscript).CrewQuest
      Crew_EliteCrewQuestScript crewQuest = EliteQuest as Crew_EliteCrewQuestScript
      ;We must first make sure they are in the activeelitecrew alias or they will not be dismissed properly.
      ActiveEliteCrew.Clear()
      ActiveEliteCrew.ForceRefTo(currentFollower as ObjectReference)
      crewQuest.DismissSceneEnded()
    Else 
      SQ_Followers.SetRoleInactive(currentFollower, False, False, False)
    EndIf
  EndIf
  I += 1
  EndWhile
  ; Just in case someone was missed
  ; (Alias_Active as RefCollectionAlias).RemoveAll()
EndFunction