ScriptName TGAH:TermMenu_ChatOptionsTriggersScript Extends TerminalMenu hidden

Form[] Property AllCompanionsAndCrewRef Auto Const Mandatory
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
ActorValue Property TGAH_COM_Setting_Chat_Triggers Auto Const Mandatory
Message Property TGAH_TriggerCommentsOn Auto Const Mandatory 
Message Property TGAH_EmptyMsg Auto Const Mandatory 
TGAH:TGAH_CompanionsScript Property TGAH_Companions Auto Const Mandatory 

;-- Events ------------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  Int I
  While I < AllCompanionsAndCrewRef.Length
    ObjectReference theFollower = AllCompanionsAndCrewRef[I] as ObjectReference
    Int currentlySelected = (theFollower as Actor).GetValue(TGAH_COM_Setting_Chat_Triggers) as Int
    If currentlySelected == 0
      akTerminalRef.AddTextReplacementData("CommentsOn" + I as String, TGAH_EmptyMsg)
    ElseIf currentlySelected == 1  
      akTerminalRef.AddTextReplacementData("CommentsOn" + I as String, TGAH_TriggerCommentsOn)
    EndIf
    I += 1
  EndWhile 
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    Int I
    While I < AllCompanionsAndCrewRef.Length
      ObjectReference theFollower = AllCompanionsAndCrewRef[I] as ObjectReference
      akTerminalRef.AddTextReplacementData("CommentsOn" + I as String, TGAH_EmptyMsg)  
      I += 1
    EndWhile
    ObjectReference CompanionRef = AllCompanionsAndCrewRef[auiMenuItemID] as ObjectReference 
    TGAH_Companions.SetTriggerCommentsCompanion(CompanionRef)
    akTerminalRef.AddTextReplacementData("CommentsOn" + auiMenuItemID as String, TGAH_TriggerCommentsOn)
  EndIf
endEvent