ScriptName TGAH:TGAH_SystemQuestScript Extends Quest

;-- Properties --------------------------------------
Group Required
  TGAH:TGAH_CompanionsScript Property TGAH_Companions Auto Const mandatory
   Alias Property Alias_Active Auto Mandatory 
  { SQ_Followers 017 ActiveFollowers }
  Actor Property PlayerRef Auto Mandatory
EndGroup

Group Companion_References_Autofill
  ObjectReference Property AndrejaRef Auto Const mandatory
  ObjectReference Property BarrettRef Auto Const mandatory
  ObjectReference Property SamCoeRef Auto Const mandatory
  ObjectReference Property SarahMorganRef Auto Const mandatory
EndGroup

;***********************************************************************************************************
;
; Setting Hotkey Functions
;
;***********************************************************************************************************

; To use this as a hotkey 
; NumPad5=cqf xx000886 "TGAH:TGAH_SystemQuestScript.TeleportAllFollowersHotkey";﻿cgf "Debug.Notification" "All followers teleported"
Function TeleportAllFollowersHotkey()
  Actor[] SpecificFollowersToTeleport = new Actor[0]
  SpecificFollowersToTeleport = (Alias_Active as RefCollectionAlias).GetActorArray()
  Int I = 0
  While I < SpecificFollowersToTeleport.Length
    Actor currentActor = SpecificFollowersToTeleport[I]
    currentActor.MoveTo(Game.GetPlayer(), 0.0, 0.0, 0.0, True, False)
    I += 1
  EndWhile
EndFunction

; To use this as a hotkey 
; NumPad1=cqf xx000886 "TGAH:TGAH_SystemQuestScript.SetMCHotkey" 1
; Number at the end determines the companion set
; 1 = Andreja
; 2 = Barrett
; 3 = Sam
; 4 = Sarah
Function SetMCHotkey(Int iCompanionRef)
  If iCompanionRef == 1
    TGAH_Companions.SetMainCompanion(AndrejaRef)
  ElseIf iCompanionRef == 2
    TGAH_Companions.SetMainCompanion(BarrettRef)
  ElseIf iCompanionRef == 3
    TGAH_Companions.SetMainCompanion(SamCoeRef)
  ElseIf iCompanionRef == 4
    TGAH_Companions.SetMainCompanion(SarahMorganRef)
  EndIf
EndFunction

;***********************************************************************************************************
;
; Make the script global
;
;***********************************************************************************************************

TGAH:TGAH_SystemQuestScript Function GetScript() Global
  Return (Game.GetFormFromFile(0x00000886, "TheGangsAllHere.esm") as Quest) as TGAH:TGAH_SystemQuestScript
EndFunction

