ScriptName avontech_castershot Extends ActiveMagicEffect

;-- Functions ---------------------------------------
;LeveledItem Property AddObject Auto Const
Spell Property SpellToCast Auto Const mandatory

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  Self.RegisterForAnimationEvent(Game.GetPlayer() as ObjectReference, "WeaponFire") ; #DEBUG_LINE_NO:4
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  ;Debug.TraceAndBox("Effect ended", 1)
EndEvent

Event OnAnimationEvent(ObjectReference akSource, String asEventName)
  If asEventName == "WeaponFire" ; #DEBUG_LINE_NO:486
    Self.UnRegisterForAnimationEvent(Game.GetPlayer() as ObjectReference, "WeaponFire") ; #DEBUG_LINE_NO:8
    SpellToCast.Cast(Game.GetPlayer() as ObjectReference, Game.GetPlayer() as ObjectReference) ; #DEBUG_LINE_NO:8
    Self.Dispel()
  endif
EndEvent

; Game.FindClosestReferenceOfType(LC165_Engineering_GravityWellSourceMarker as Form, player.GetPositionX(), player.GetPositionY(), player.GetPositionZ(), CONST_StarbornEngineering_GravWellCastDistance) ; #DEBUG_LINE_NO:2022