ScriptName GWI_QuestScript Extends Quest

;shoutout to SKK50 for pioneering this stuff and sharing his compile/decompile.cmd!

Actor Property PlayerRef Auto Const mandatory
Perk Property BookInteractionPerk Auto Const mandatory
Perk Property DoorInteractionPerk Auto Const mandatory
Perk Property GlobalInteractionPerk Auto Const mandatory
Perk Property TraderInteractionPerk Auto Const mandatory

Event OnQuestInit()
	Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
	Self.AddInteractPerk()
EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)
	Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
	Self.AddInteractPerk()
EndEvent

Function AddInteractPerk()
	If !PlayerRef.HasPerk(BookInteractionPerk)
		PlayerRef.AddPerk(BookInteractionPerk, False)
		;Debug.Messagebox("Player has Book Perk added = " + PlayerRef.HasPerk(BookInteractionPerk))
	EndIf
	If !PlayerRef.HasPerk(DoorInteractionPerk)
		PlayerRef.AddPerk(DoorInteractionPerk, False)	
	EndIf
	If !PlayerRef.HasPerk(GlobalInteractionPerk)
		PlayerRef.AddPerk(GlobalInteractionPerk, False)		
	EndIf	
	If !PlayerRef.HasPerk(TraderInteractionPerk)
		PlayerRef.AddPerk(TraderInteractionPerk, False)		
	EndIf	
EndFunction

Function InteractWorld(ObjectReference akTargetRef, Actor akActor)
	If akTargetRef && akTargetRef as Actor
		Actor actorTarget = akTargetRef as Actor	
		actorTarget.OpenInventory(True, None, True)
	EndIf
	Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")	
EndFunction

Function InteractDoor(ObjectReference akTargetRef, Actor akActor)	
	If akTargetRef
		akTargetRef.Lock(true, false, false)
	EndIf
EndFunction

Function InteractBook(ObjectReference akTargetRef, Actor akActor)
	If akTargetRef
		PlayerRef.AddItem(akTargetRef, 1, false)
	EndIf
EndFunction

Function InteractTrader(ObjectReference akTargetRef, Actor akActor)
	If akTargetRef && akTargetRef as Actor
		Actor actorTarget = akTargetRef as Actor	
		actorTarget.ShowBarterMenu()
	EndIf
EndFunction