ScriptName SRB_QuestScript Extends Quest

;shoutout to SKK50 for pioneering this stuff and sharing his compile/decompile.cmd!

Actor Property PlayerRef Auto Const mandatory
FormList Property BookList01 Auto mandatory
FormList Property BookList02 Auto mandatory
Perk Property BookInteractionPerk Auto Const mandatory

Event OnQuestInit()
	Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
	Self.AddInteractPerk()
EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)
	Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
	Self.AddInteractPerk()
EndEvent

Function AddInteractPerk()
	If !PlayerRef.HasPerk(BookInteractionPerk)
		PlayerRef.AddPerk(BookInteractionPerk, False)
	EndIf
EndFunction

Function InteractBook(ObjectReference akTargetRef, Actor akActor)
	If akTargetRef
		PlayerRef.AddItem(akTargetRef, 1, false)
		If !BookList01.HasForm(akTargetRef.GetBaseObject()) && !BookList02.HasForm(akTargetRef.GetBaseObject())
			Book akBook = akTargetRef.GetBaseObject() as Book
			If BookList01.GetSize() >= 254
				BookList02.AddForm(akBook)
			Else
				BookList01.AddForm(akBook)
			EndIf
		EndIf
	EndIf
EndFunction