ScriptName KeepRampClosedOnLanding Extends Quest
{ Quest script for ImmersiveLandingRamps.esm }

ReferenceAlias Property PlayerShip Auto mandatory
Keyword Property SpaceshipPreventRampOpenOnLanding Auto Const mandatory

Event OnQuestInit()
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipLanding")
  Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnExitShipInterior")
EndEvent

Event Actor.OnExitShipInterior(Actor akSender, ObjectReference akShip)
  akShip.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
EndEvent

Event ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
  spaceshipreference playerShipRef = PlayerShip.GetShipRef() ; #DEBUG_LINE_NO:603
  If !abComplete ; #DEBUG_LINE_NO:606
    If playerShipRef != None ; #DEBUG_LINE_NO:608
      playerShipRef.AddKeyword(SpaceshipPreventRampOpenOnLanding)
    EndIf
  EndIf
EndEvent