ScriptName OpenCloseLandingBay Extends ObjectReference
{ Quest script for ImmersiveLandingRamps.esm }

Message Property FailedActivationMessage Auto Const mandatory

Event OnActivate(ObjectReference akActionRef)
  Self.GoToState("Busy") ; #DEBUG_LINE_NO:7
  If Game.IsMenuControlsEnabled() ; #DEBUG_LINE_NO:8

    SpaceshipReference HomeShip = Game.GetPlayerHomeSpaceShip()
    ObjectReference[] LandingRamps = HomeShip.GetLandingRamps()
    ObjectReference LandingRamp = LandingRamps[0]

    If (LandingRamp.GetOpenState() == 1)
      Self.ControlLandingBay(akShip = HomeShip, abOpen = false)
    ElseIf (LandingRamp.GetOpenState() == 3)
      Self.ControlLandingBay(akShip = HomeShip, abOpen = true)
    EndIf
  Else
    FailedActivationMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) ; #DEBUG_LINE_NO:11
  EndIf
  Self.GoToState("") ; #DEBUG_LINE_NO:13
EndEvent

State Busy
  Event OnActivate(ObjectReference akActionRef)
    ; Debug.Notification("Button Busy.")
  EndEvent
EndState

Function ControlLandingBay(SpaceshipReference akShip, Bool abOpen)

  ObjectReference[] LandingRamps = akShip.GetLandingRamps()

  If LandingRamps != None ; #DEBUG_LINE_NO:38
    Int i = 0 ; #DEBUG_LINE_NO:39
    While i < LandingRamps.Length ; #DEBUG_LINE_NO:40
      LandingRamps[i].SetOpen(abOpen) ; #DEBUG_LINE_NO:41
      i += 1 ; #DEBUG_LINE_NO:42
    EndWhile
  EndIf
EndFunction