Scriptname CS7_SpaceShipLandingScript extends Quest
{Quest script for SpaceShipLandingReloaded.esm}

sq_playershipscript Property SQ_PlayerShip Auto
sq_followersscript Property SQ_Followers Auto
Keyword Property SpaceshipEnabledLandingLink Auto
Keyword Property CurrentInteractionLinkedRefKeyword Auto
Keyword Property SpaceshipPreventRampOpenOnLanding Auto
LocationRefType Property Ship_PilotSeat_RefType Auto
ImageSpaceModifier Property Pitch_Black_Imod Auto


spaceshipreference playerShipRef
Bool bPlayerInShipPilotSeat
Bool bFollowersArePaused
Bool bPitchBlackImod
Bool bUpdateDone
Int FailSafeTimer = 10


EVENT OnQuestInit()
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnSit") 
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnGetUp")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnPlayerLoadGame")
	bUpdateDone = True
ENDEVENT


EVENT Actor.OnPlayerLoadGame(Actor akSender)
	If (Game.IsPluginInstalled("SpaceShipLandingReloaded.esm") == False)
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnSit") 
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnGetUp")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnPlayerLoadGame")
		CancelTimer(FailSafeTimer)
		Self.Stop()
		Debug.Notification("Script events unregistered and quest ended.")
	EndIf
ENDEVENT


EVENT OnTimer(Int aiTimerID)
	If aiTimerID == FailSafeTimer
		Self.UnregisterAndResetMod()
	EndIf
ENDEVENT


EVENT Actor.OnSit(Actor akSender, ObjectReference akFurniture)
	If (akSender == Game.GetPlayer()) && akFurniture.HasRefType(Ship_PilotSeat_RefType)
		bPlayerInShipPilotSeat = True
    EndIf
	If !bUpdateDone
		Self.UpdateTo_1_2()
	EndIf
ENDEVENT


EVENT Actor.OnGetUp(Actor akSender, ObjectReference akFurniture)
	If (akSender == Game.GetPlayer()) && akFurniture.HasRefType(Ship_PilotSeat_RefType)
		bPlayerInShipPilotSeat = False
		if bFollowersArePaused
			UnregisterAndResetMod()
		endif
	EndIf
	If !bUpdateDone
		Self.UpdateTo_1_2()
	EndIf
ENDEVENT


EVENT Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
	Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
	IF (akSender == Game.GetPlayer()) && !bPlayerInShipPilotSeat
		Pitch_Black_Imod.Apply(1.0)
		Game.FadeOutGame(False, True, 10.0, 0.00015, False)
		bPitchBlackImod = True
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipFarTravel(ReferenceAlias akSender, Location aDepartureLocation, Location aArrivalLocation, Int aState)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	planet thePlanetOrbit = aDepartureLocation.GetCurrentPlanet()
	planet thePlanetSurface = aArrivalLocation.GetCurrentPlanet()
	If ((akSender != SQ_PlayerShip.PlayerShip) || (aState == 1) || (thePlanetOrbit != thePlanetSurface) || playerShipRef.IsLanded() || !playerShipRef.IsInSpace())
		RETURN
	Else
		bPitchBlackImod = False
		CancelTimer(FailSafeTimer)
		if !bFollowersArePaused
			Self.PauseCrewAndFollowers()
		endif
		playerShipRef.AddKeyword(SpaceshipPreventRampOpenOnLanding)
		Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
		Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		StartTimer(15.0, FailSafeTimer)
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnLocationChange(ReferenceAlias akSender, Location akOldLoc, Location akNewLoc)
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
	StartTimer(10.0, FailSafeTimer)
	If (akSender != SQ_PlayerShip.PlayerShip) || (akOldLoc == akNewLoc) || bPlayerInShipPilotSeat || Game.GetPlayer().GetParentCell().IsInterior() || (akNewLoc != Game.GetPlayer().GetCurrentLocation())
		; game is going to handle the landing
		playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		if bPitchBlackImod
			bPitchBlackImod = False
			Pitch_Black_Imod.Remove()
			Game.FadeOutGame(False, True, 0.0, 0.1, False)
		endif
		if bFollowersArePaused
			if bPlayerInShipPilotSeat
				Self.UnpauseCrewAndFollowers(False)
			else
				Self.UnpauseCrewAndFollowers(True)
			endif
		endif
	Else
		Game.FadeOutGame(False, True, 10.0, 0.00015, False)
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	If !bPlayerInShipPilotSeat
		CancelTimer(FailSafeTimer)
		ObjectReference LandingMarker = Self.GetShipLandingMarker(playerShipRef)
		if (LandingMarker as Bool)	; play landing animation
			if bPitchBlackImod
				Pitch_Black_Imod.PopTo(Pitch_Black_Imod, 1.0)
			else
				Pitch_Black_Imod.Apply(1.0)
				bPitchBlackImod = True
			endif
			playerShipRef.MoveTo(LandingMarker, 0.0, 0.0, 155.0, True, False)
			Game.FadeOutGame(False, True, 5.0, 0.00015, False)
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
			if playerShipRef.IsRampDown()
				Self.OpenOrCloseLandingRamps(playerShipRef, False)
			endif
			Self.MovePlayerIntoPilotSeat(SQ_PlayerShip.PlayerShipPilotSeat.GetRef())
			bPitchBlackImod = False
			Pitch_Black_Imod.Remove()
			Game.FadeOutGame(False, True, 1.0, 0.5, False)
			playerShipRef.SetLinkedRef(LandingMarker, SpaceshipEnabledLandingLink, True)
			playerShipRef.EnableWithLanding()
			Utility.Wait(0.01)
			playerShipRef.SetAngle(LandingMarker.GetAngleX(), LandingMarker.GetAngleY(), LandingMarker.GetAngleZ())
			if bFollowersArePaused
				Self.UnpauseCrewAndFollowers(False)
			endif
		else	; no landing animation 
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
			bPitchBlackImod = False
			Pitch_Black_Imod.Remove()
			Game.FadeOutGame(False, True, 0.0, 0.1, False)
			if !playerShipRef.IsRampDown()
				Self.OpenOrCloseLandingRamps(playerShipRef, True)
			endif
			if bFollowersArePaused
				Self.UnpauseCrewAndFollowers(True)
			endif
		endif
		StartTimer(5.0, FailSafeTimer)
	EndIf
ENDEVENT


ObjectReference Function GetShipLandingMarker(spaceshipreference akShip)
	ObjectReference theLandingMarker
	ObjectReference MarkerRef = akShip.GetLinkedRef(SQ_PlayerShip.LandingMarkerKeyword)
	If MarkerRef && (MarkerRef.GetDistance(Game.GetPlayer()) < 200)
		theLandingMarker = MarkerRef
	Else
		MarkerRef = akShip.GetLinkedRef(CurrentInteractionLinkedRefKeyword)
		If MarkerRef && (MarkerRef.GetDistance(Game.GetPlayer()) < 150)
			theLandingMarker = MarkerRef
		EndIf
	EndIf
	Return theLandingMarker
EndFunction


Function MovePlayerIntoPilotSeat(ObjectReference akPilotSeat)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	inputenablelayer myEnableLayer = inputenablelayer.Create()
	myEnableLayer.DisablePlayerControls(True, True, True, False, False, True, True, False, True, True, False)
	If (Self.PopPlayerIntoPilotSeat(akPilotSeat) == False)
		Game.GetPlayer().MoveToFurniture(akPilotSeat)
	EndIf
	Utility.Wait(0.01)
	myEnableLayer.Delete()
EndFunction


Bool Function PopPlayerIntoPilotSeat(ObjectReference akTargetFurniture)
	Actor PlayerRef = Game.GetPlayer()
	PlayerRef.MoveTo(akTargetFurniture, 0.0, 0.0, 0.0, True, False)
	Return PlayerRef.SnapIntoInteraction(akTargetFurniture)
EndFunction


Function OpenOrCloseLandingRamps(spaceshipreference akShip, Bool bOpen = True)
	ObjectReference[] landingRamps = playerShipRef.GetLandingRamps()
	If (landingRamps != None)
		Int i = 0
		While i < landingRamps.Length
			landingRamps[i].SetOpen(bOpen)
			i += 1
		EndWhile
	EndIf
EndFunction

Actor[] crewMembers
Actor[] currentFollowers
Function PauseCrewAndFollowers()
	bFollowersArePaused = True
	crewMembers = playerShipRef.GetAllCrewMembers()
	int i = 0
	While (i < crewMembers.Length)
		crewMembers[i].SetUnconscious(True)
		i += 1
	EndWhile
	currentFollowers = Game.GetPlayerFollowers()
	i = 0
	While (i < currentFollowers.Length)
		SQ_Followers.SetRoleInactive(currentFollowers[i], False, False, False)
		i += 1
	EndWhile
EndFunction


Function UnpauseCrewAndFollowers(Bool bMoveToPlayer = False)
	bFollowersArePaused = False
	Actor PlayerRef = Game.GetPlayer()
	int i = 0
	While (i < crewMembers.Length)
		crewMembers[i].SetUnconscious(False)
		crewMembers[i].EvaluatePackage(False)
		i += 1
	EndWhile
	i = 0
	While (i < currentFollowers.Length)
		SQ_Followers.SetRoleActive(currentFollowers[i], False, True, 0.0, 0.0)
		if bMoveToPlayer
			currentFollowers[i].MoveTo(PlayerRef as ObjectReference, 0.0, 0.0, 0.0, True, False)
		endif
		SQ_Followers.CommandFollow(currentFollowers[i])
		currentFollowers[i].EvaluatePackage(False)
		i += 1
	EndWhile
EndFunction


Function UnregisterAndResetMod()
	CancelTimer(FailSafeTimer)
	Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
	If bPitchBlackImod
		Pitch_Black_Imod.Remove()
		bPitchBlackImod = False
	EndIf
	If bFollowersArePaused
		Self.UnpauseCrewAndFollowers(False)
	EndIf
	If playerShipRef.IsRampDown()
		if playerShipRef.IsInSpace()
			Self.OpenOrCloseLandingRamps(playerShipRef, False)
		endif
	Else
		if playerShipRef.IsLanded()
			Self.OpenOrCloseLandingRamps(playerShipRef, True)
		endif
	EndIf
EndFunction


Function UpdateTo_1_2()
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnPlayerLoadGame")
	bUpdateDone = True
EndFunction
