ScriptName AUR:UpgradePowersScript Extends Quest Hidden

;-- Properties --------------------------------------

Perk[] Property PowerPerks Auto Const Mandatory
Perk Property PowerPerkAntiGravityField Auto Const Mandatory
Perk Property PowerPerkParallelSelf Auto Const Mandatory

Spell[] Property PowerSpells Auto Const Mandatory
Spell Property PowerSpellAntiGravityField Auto Const Mandatory
Spell Property PowerSpellParallelSelf Auto Const Mandatory

Spell[] Property GrantSpells Auto Const Mandatory
Spell Property GrantSpellAntiGravityField Auto Const Mandatory
Spell Property GrantSpellParallelSelf Auto Const Mandatory

ActorValue Property PlayerUnityTimesEntered Auto Const Mandatory
GlobalVariable Property MQ401_VariantCurrent Auto Const Mandatory
ObjectReference Property PlayerREF Auto Mandatory 
Quest Property MQ401 Auto Const Mandatory
Quest[] Property MQ401VariantsArray Auto Const Mandatory

Int iAntiGravityFieldTimer = 5
Int iParallelSelfTimer = 10
Int iTimerDelay = 10

Event OnInit()
  PlayerREF = Game.GetPlayer()
EndEvent

Event OnQuestInit()
  RegisterForRemoteEvent(MQ401, "OnStageSet")
EndEvent

Event OnTimer(int aiTimerID)
  Int iTargetPowerRank = Self.GetTargetPowerRank(True)
  If aiTimerID == iAntiGravityFieldTimer
    Self.UpgradeAntiGravityField(iTargetPowerRank)
  EndIf
  If aiTimerID == iParallelSelfTimer
    Self.UpgradeParallelSelf(iTargetPowerRank)
  EndIf
EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)
  ; After crossing the Unity
  If (akSender == MQ401) && (auiStageID == 10)
    Self.UpgradePowers()
    Utility.Wait(5.0)
    ; If the variant is anything other than Other You or Normal Start
    If IsVariantUniverse()
      Self.UnRegisterForRemoteEvent(MQ401, "OnStageSet")
      Self.StartTimer(iTimerDelay, iAntiGravityFieldTimer)
      Self.StartTimer(iTimerDelay, iParallelSelfTimer)
    EndIf
  EndIf
  ; Choose to Skip Main Quest
  If (akSender == MQ401) && (auiStageID == 300)
    Self.UnRegisterForRemoteEvent(MQ401, "OnStageSet")
    Self.StartTimer(iTimerDelay, iAntiGravityFieldTimer)
  EndIf
  ; Repeat Main Quest
  If (akSender == MQ401) && (auiStageID == 200)
    Self.UnRegisterForRemoteEvent(MQ401, "OnStageSet")
  EndIf
EndEvent

Function UpgradePowers()
  Int iTargetPowerRank = Self.GetTargetPowerRank(True)
  Int iTargetPowerRankMinusOne = Self.GetTargetPowerRank(False)
  Int I = 0
  While I < PowerSpells.Length
    Spell currentRankUpSpell = GrantSpells[I]
    Spell currentPowerSpell = PowerSpells[I]
    Perk currentPowerPerk = PowerPerks[I]
    Self.AddPowers(iTargetPowerRank, currentPowerSpell, currentRankUpSpell, currentPowerPerk)
    I += 1
  EndWhile
  Utility.Wait(0.1)
  Self.UpgradeAntiGravityField(iTargetPowerRankMinusOne)
  Utility.Wait(0.1)
  Self.UpgradeParallelSelf(iTargetPowerRankMinusOne)
EndFunction

Function UpgradeAntiGravityField(Int iTargetPowerRank)
  Self.AddPowers(iTargetPowerRank, PowerSpellAntiGravityField, GrantSpellAntiGravityField, PowerPerkAntiGravityField)
EndFunction

Function UpgradeParallelSelf(Int iTargetPowerRank)
  Self.AddPowers(iTargetPowerRank, PowerSpellParallelSelf, GrantSpellParallelSelf, PowerPerkParallelSelf)
EndFunction

Function AddPowers(Int iTargetPowerRank, Spell PowerSpell, Spell RankUpSpell, Perk PowerPerk)
  (PlayerREF as Actor).RemoveSpell(PowerSpell)
  (PlayerREF as Actor).RemovePerk(PowerPerk)
  Int I = 0
  While I < iTargetPowerRank
    RankUpSpell.Cast(PlayerREF, PlayerREF)
    I += 1
  EndWhile
EndFunction

Int Function GetTargetPowerRank(Bool bMaxLevel)
  Int iTargetPowerRank
  Int iUnityEntered = PlayerREF.GetValue(PlayerUnityTimesEntered) as Int
  If iUnityEntered <= 9 && bMaxLevel
    iTargetPowerRank = iUnityEntered + 1
  ElseIf iUnityEntered <= 9 && !bMaxLevel
    iTargetPowerRank = iUnityEntered 
  ElseIf iUnityEntered >= 10
    iTargetPowerRank = 10
  EndIf
  return iTargetPowerRank 
EndFunction

Bool Function IsVariantUniverse()
  Bool bVariantUniverse = false  
  Int I
  While I < MQ401VariantsArray.Length && !bVariantUniverse
    Quest currentQuest = MQ401VariantsArray[I]
    If currentQuest.IsRunning()
      bVariantUniverse = true
    EndIf
    I += 1
  EndWhile
  return bVariantUniverse
EndFunction
