Scriptname AUR:SitAnywhere Extends Quest

Actor Property PlayerRef Auto Const Mandatory
Message Property AUR_SitAnywhereChoices Auto Const Mandatory
FormList Property AUR_SitFurnitureList Auto Const Mandatory
Form Property AUR_NPCKneeling Auto Const Mandatory
Form Property AUR_NPCKneelingPraying Auto Const Mandatory
Form Property AUR_NPCSitOnGround Auto Const Mandatory
Form Property AUR_NPCSitOnGround02 Auto Const Mandatory
Form Property AUR_NPCPushUp Auto Const Mandatory
Form Property AUR_NPCSitFloorCaptive_Kneeling Auto Const Mandatory
Idle Property Furniture_ExitQuick Auto Const Mandatory
Bool Property bSkipAnims = False Auto Hidden
ObjectReference Property SitMarker Auto Hidden
Float[] Property OffsetValues Auto Const Mandatory

Event Actor.OnGetUp(Actor akActor, ObjectReference akFurniture)
  UnregisterForRemoteEvent(akActor, "OnGetUp")
  If SitMarker == akFurniture
    DeleteMarker()
  EndIf
EndEvent

Function DeleteMarker()
  If SitMarker
    SitMarker.Disable(False)
    SitMarker.Delete()
    SitMarker = none
  EndIf
EndFunction

Function ShowSitChoices(Int currentSitPose)
  If !Game.IsMenuControlsEnabled() || !Game.IsFavoritesControlsEnabled() || PlayerRef.IsUnconscious() || PlayerRef.IsFlying()
    Return
  EndIf
  Bool bInSitMarker = false
  If PlayerRef.GetSitState() == 3
    ObjectReference currentFurniture = PlayerRef.GetFurnitureUsing()
    If currentFurniture
      If AUR_SitFurnitureList.Find(currentFurniture.GetBaseObject()) < 0
        Debug.Notification("Exit current furniture first")
        Return
      EndIf
      bInSitMarker = true
    EndIf
  ElseIf PlayerRef.GetSitState() != 0
    Return
  EndIf
  Form currentMarkerForm = none
  If currentSitPose < 0
    currentSitPose = AUR_SitAnywhereChoices.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf
  If currentSitPose == 0
    currentMarkerForm = AUR_NPCSitOnGround
  ElseIf currentSitPose == 1
    currentMarkerForm = AUR_NPCSitOnGround02
  ElseIf currentSitPose == 2
    currentMarkerForm = AUR_NPCSitFloorCaptive_Kneeling
  ElseIf currentSitPose == 3
    currentMarkerForm = AUR_NPCKneeling
  ElseIf currentSitPose == 4
    currentMarkerForm = AUR_NPCKneelingPraying
  ElseIf currentSitPose == 5
    currentMarkerForm = AUR_NPCPushUp
  EndIf
  ObjectReference currentSitMarker
  If currentMarkerForm
    currentSitMarker = PlayerRef.PlaceAtMe(currentMarkerForm, 1, False, False, False, OffsetValues, None, False)
    currentSitMarker.Enable(False)
      currentSitMarker.MoveTo(PlayerRef, 0.0, 0.0, 0.0, False, False)
      currentSitMarker.SetAngle(0.0, 0.0, SitMarker.GetAngleZ())
      RegisterForRemoteEvent(PlayerRef, "OnGetUp")
      If bSkipAnims || bInSitMarker
        If bInSitMarker
          PlayerRef.PlayIdle(Furniture_ExitQuick)
        EndIf
        PlayerRef.SnapIntoInteraction(currentSitMarker)
      Else
        currentSitMarker.Activate(PlayerRef, True)
      EndIf
  EndIf
  DeleteMarker()
  If currentSitMarker
    SitMarker = currentSitMarker
  EndIf
EndFunction