ScriptName UB_Script_BrigManager Extends Quest
{ Logically assigns and manages the lists and functions for brigs and prisoners }

;-- Variables ---------------------------------------



;-- Properties --------------------------------------

RefCollectionAlias Property BrigCellBeds Auto
RefCollectionAlias Property BrigPrisoners Auto
RefCollectionAlias Property ReleasedPrisoners Auto
ReferenceAlias Property CargoHold Auto Const
Armor Property PrisonerClothes Auto Const
Faction Property CaptiveFaction Auto Const
Keyword Property UB_Keyword_LinkedCell Auto Const
Perk Property UB_Perk_SendToBrig Auto Const
ObjectReference Property OverflowBrigCellMarker Auto Const
Bool Property IsDebug=false Auto

Race Property ChildRace Auto
Keyword Property ActorTypeLegendary Auto
FormList Property UB_FLST_CriminalFactions Auto
FormList Property UB_FLST_PrisonerListCriminals Auto

GlobalVariable Property UB_Global_PrisonerCountTotal Auto
GlobalVariable Property UB_Global_PrisonerCountCitizens Auto
GlobalVariable Property UB_Global_PrisonerCountCriminals Auto
GlobalVariable Property UB_Global_SellPrisonerRewardUCTotal Auto
GlobalVariable Property UB_Global_SellPrisonerRewardFCTotal Auto
GlobalVariable Property UB_Global_SellPrisonerRewardCFTotal Auto

GlobalVariable Property UB_Global_BusySendingToBrig Auto

;-- Events ---------------------------------------

Event OnQuestInit()

    If !Game.GetPlayer().HasPerk(UB_Perk_SendToBrig)
        Game.GetPlayer().AddPerk(UB_Perk_SendToBrig, False)
    EndIf
	
    RefreshBrigs()
	
EndEvent

;-- Functions ---------------------------------------

; Determines number of available beds and attempts to fill/refill them.
; Parses existing prisoners, removes null, releases dead/disabled.
Function RefreshBrigs(Bool CleanOverflow=false)
	
    BrigCellBeds.RefillAlias() ; Dumps alias content and re-adds
	
	Actor[] prisoners = BrigPrisoners.GetActorArray()
	ObjectReference[] beds = BrigCellBeds.GetArray()
	
	int initialPrisoners = prisoners.length
	
;debug.notification("numBeds = "+BrigCellBeds.GetCount())
    
    int index = 0
	
    While index < prisoners.length
	
		actor prisoner = prisoners[index]
		
		If (prisoner == none)
		
			BrigPrisoners.RemoveRef(prisoner)
			
		ElseIf prisoner.IsDead() || prisoner.IsDisabled()
		
			Release(prisoner, False, False)
			
		Else
		
			;If this Prisoner's old bed is not found or is a member of overflow re-arrest
			ObjectReference prisonerLinkedCell = prisoner.GetLinkedRef(UB_Keyword_LinkedCell)
			
			if (prisonerLinkedCell == OverflowBrigCellMarker && CleanOverflow)
				Release(prisoner, True, False)
			elseif (beds.Find(prisonerLinkedCell) < 0 || prisoner.GetSitState() < 2 || (prisonerLinkedCell == OverflowBrigCellMarker))
				Arrest(prisoner, True, True, False)
			endif
			
		Endif
		
		index += 1
		
    EndWhile
	
	; If the number of prisoners changed, calc the value of prisoners.
	If initialPrisoners != BrigPrisoners.GetCount()
		CalcPrisonerValues()
	EndIf
	
;debug.notification("Refresh complete")
	
EndFunction

; The value of prisoners is dependent on where you're trying to profit off of them
; Turning in criminals for a reward pays well, but is more restrictive.
; Selling citizens into slavery or for kidnapping/extortion pays less, but are easier targets if you have the right connections to make the sale.
Function CalcPrisonerValues()

	
	int numPrisoners = BrigPrisoners.GetCount()
	UB_FLST_PrisonerListCriminals.Revert()
	
	if numPrisoners == 0 ; No need to do math if we have no prisoners
	
		UB_Global_PrisonerCountTotal.SetValueInt(0)
		UpdateCurrentInstanceGlobal(UB_Global_PrisonerCountTotal)
		UB_Global_PrisonerCountCitizens.SetValueInt(0)
		UpdateCurrentInstanceGlobal(UB_Global_PrisonerCountCitizens)
		UB_Global_PrisonerCountCriminals.SetValueInt(0)
		UpdateCurrentInstanceGlobal(UB_Global_PrisonerCountCriminals)
		UB_Global_SellPrisonerRewardUCTotal.SetValueInt(0)
		UpdateCurrentInstanceGlobal(UB_Global_SellPrisonerRewardUCTotal)
		UB_Global_SellPrisonerRewardFCTotal.SetValueInt(0)
		UpdateCurrentInstanceGlobal(UB_Global_SellPrisonerRewardFCTotal)
		UB_Global_SellPrisonerRewardCFTotal.SetValueInt(0)
		UpdateCurrentInstanceGlobal(UB_Global_SellPrisonerRewardCFTotal)
		
	else
	
		int x = 0
		
		; calc variables
		; prisoners are classified as either criminals or citizens
		int numCriminals = 0
		int numCitizens = numPrisoners ; initially equal to numPrisoners, but will be decremented for each criminal
		; bonus variables
		; bonus payout for certain groups. Not every group may care about these, but others may pay extra.
		int numChildren = 0
		int numFemale = 0
		int numLegendary = 0
		
		While x < numPrisoners ; iterate through each prisoner
		
			ObjectReference prisoner = BrigPrisoners.GetAt(x)
		
			int y = 0
			
			int numCriminalFactions = UB_FLST_CriminalFactions.GetSize()
			
			While y < numCriminalFactions ; check prisoner against each faction deemed criminal to determine who guards would pay bounty for
		
				If (prisoner as Actor).IsInFaction(UB_FLST_CriminalFactions.GetAt(y) as Faction) ; Is this prisoner in a criminal faction?
					y=numCriminalFactions ; no need to iterate through other factions, we have a match.
					UB_FLST_PrisonerListCriminals.AddForm(prisoner) ; add criminals to their own formlist because it will be easier to sell them to the guards.
				EndIf
			
				y += 1
			
			EndWhile
			
			; Determine bonus categories
			
			If (prisoner as Actor).GetRace() == ChildRace
				numChildren+=1
			EndIf
			
			If (prisoner.GetBaseObject() as ActorBase).GetSex() == 1
				numFemale+=1
			Endif
			
			If prisoner.HasKeyword(ActorTypeLegendary)
				numLegendary+=1
			EndIf
			
			x += 1
			
		EndWhile
		
		numCriminals = UB_FLST_PrisonerListCriminals.GetSize()
		numCitizens = numCitizens - numCriminals ; instead of decrementing numCitizens as we add criminals, it is more efficient to the subtraction here.
		
		UB_Global_PrisonerCountTotal.SetValueInt(numPrisoners)
		UpdateCurrentInstanceGlobal(UB_Global_PrisonerCountTotal)
		UB_Global_PrisonerCountCitizens.SetValueInt(numCitizens)
		UpdateCurrentInstanceGlobal(UB_Global_PrisonerCountCitizens)
		UB_Global_PrisonerCountCriminals.SetValueInt(numCriminals)
		UpdateCurrentInstanceGlobal(UB_Global_PrisonerCountCriminals)

;debug.notification("numCriminals = " + numCriminals)
		
		int legendaryBonusRandom = Utility.RandomInt(200, 1200)
		int femaleBonusRandom = Utility.RandomInt(100, 500)
		int childrenBonusRandom = Utility.RandomInt(500, 1000)
		
		UB_Global_SellPrisonerRewardUCTotal.SetValueInt(((numCriminals * 835) + (numLegendary * (235 + legendaryBonusRandom))))
		UpdateCurrentInstanceGlobal(UB_Global_SellPrisonerRewardUCTotal)
		UB_Global_SellPrisonerRewardFCTotal.SetValueInt(((numCriminals * 655) + (numLegendary * (415 + legendaryBonusRandom))))
		UpdateCurrentInstanceGlobal(UB_Global_SellPrisonerRewardFCTotal)
		UB_Global_SellPrisonerRewardCFTotal.SetValueInt(((numPrisoners * 323) + (numFemale * (200 + femaleBonusRandom)) + (numChildren * (500 + childrenBonusRandom))))
		UpdateCurrentInstanceGlobal(UB_Global_SellPrisonerRewardCFTotal)
		
	EndIf
	
EndFunction

ObjectReference Function AssignCell()

	Actor[] prisoners = BrigPrisoners.GetActorArray()
	ObjectReference[] beds = BrigCellBeds.GetArray()

    int index = 0
	int numBeds = beds.length
	
    While index < numBeds
	
        ObjectReference marker = beds[index]
        
        bool inUse = False
        int prisonerIndex = 0
		int numPrisoners = prisoners.length
		
        While prisonerIndex < numPrisoners
            
            If prisoners[prisonerIndex].GetLinkedRef(UB_Keyword_LinkedCell) == marker
                inUse = True
            EndIf

            prisonerIndex += 1
			
        EndWhile
		
;If (marker.IsFurnitureInUse(true) && !inUse)
;    debug.notification("Error: There is furniture in use that isnt assigned to a prisoner!")
;EndIf

        If (!inUse)
            return marker
        EndIf

        index += 1
		
    EndWhile

    return none

EndFunction

Bool Function Arrest(Actor act, Bool force=false, Bool SkipClean=false, Bool DoCalcGlobals=true)
	
	;If !SkipClean && !force
	;	RefreshBrigs(true) ; We refresh brigs on arrest to check actors ...and in case the player installs or updates a mod that adds brig space.
	;EndIf
	
	;If prisoner was released and re-arrested, remove released status
	If ReleasedPrisoners.GetCount() > 0 && ReleasedPrisoners.Find(act) > -1
		ReleasedPrisoners.RemoveRef(act)
	EndIf

    ; If we have more prisoners than beds, brig(s) are full so return false
    If BrigPrisoners.GetCount() >= BrigCellBeds.GetCount() && !force
		return false
    EndIf
	
	; As the player adds more prisoners, the AssignCell function becomes more time consuming as there is a lot of iterate through. By moving the actor to the overflow cell before processing, it makes the feedback seem more instantaneous, even if it will take time before the prisoner populates to their brig cell bed.
	;act.disable(false)
	act.MoveTo(OverflowBrigCellMarker, 0, 0, 0, False, False)
	
	If UB_Global_BusySendingToBrig.GetValue() == 1
		UB_Global_BusySendingToBrig.SetValueInt(0)
	EndIf

    ObjectReference marker = AssignCell()
	
    If marker == none
        marker = OverflowBrigCellMarker ; the overflow cell is used to store prisoners while player is modifying their ship.
    EndIf

	If !SkipClean

		act.Kill(none) ; kill the actor to complete any quest requirement, so the player doesnt need to run back to the ship. Also, this will populate the death items to actor inventory.

		; If npc has a prisoner outfit, removes it to avoid continously adding prisoner outfits to player ship when being re-arrested.
		if act.GetItemCount(PrisonerClothes) > 1
			act.RemoveItem(PrisonerClothes, act.GetItemCount(PrisonerClothes), true, none)
		endif
	
		act.RemoveAllItems(CargoHold.GetReference(), False, False) ; Player is rewarded with loot.

		act.Resurrect()
		;act.RemoveFromAllFactions()
		act.SetCrimeFaction(none)
		act.StopCombat()
		act.StopCombatAlarm()
		act.RemoveAllItems(none, False, False) ; This removes all items the actor would have been given after being resurrected.
		act.EquipItem(PrisonerClothes, True, True)

	EndIf
	
    act.SetLinkedRef(marker, UB_Keyword_LinkedCell, false)

	BrigPrisoners.addRef(act)
	;act.MoveToFurniture(marker)
	;act.Disable(false)
	act.MoveToFurniture(marker)
	;act.Enable(false)
	
	;StartTimer(BrigPrisoners.Find(act),1)
    
    act.EvaluatePackage(False)

    If DoCalcGlobals
        CalcPrisonerValues()
    EndIf
	
;debug.notification("numPrisoners = "+BrigPrisoners.GetCount())
	
    return true
	
EndFunction

Function Release(Actor prisoner, Bool FreeToGo = false, Bool DoCalcGlobals = true)

	prisoner.SetCrimeFaction((prisoner.GetBaseObject() as Actor).GetCrimeFaction())
    BrigPrisoners.RemoveRef(prisoner)
	prisoner.SetLinkedRef(none, UB_Keyword_LinkedCell, false)
	
	If FreeToGo
	
		prisoner.EvaluatePackage(false)
	
		; If the player makes an Arrest() while there are prisoners in overflow, the overflow prisoners are cleared.
		; Overflow exists to allow player to have some grace period while changing ships whether for story or shipbuilding and to allow for capturing other ships without losing the prisoners.
		If (prisoner.GetLinkedRef(UB_Keyword_LinkedCell) == OverflowBrigCellMarker)
		
			(prisoner as ObjectReference).Reset(none) ; Should reset actor inventory.
			Utility.Wait(0.1)
			(prisoner as ObjectReference).MoveToMyEditorLocation()
			
		Else
			Utility.Wait(5.0)
			While (prisoner.GetSitState() > 2)
				Utility.Wait(1.0)
			EndWhile
			(prisoner as ObjectReference).Reset((prisoner as ObjectReference)) ; Should reset actor inventory.
			ReleasedPrisoners.AddRef(prisoner)
		EndIf
	ElseIf prisoner.IsDead()
		ReleasedPrisoners.AddRef(prisoner) ; body will be cleaned up when prisoners are released.
	EndIf
	
    If DoCalcGlobals
        CalcPrisonerValues()
    EndIf
	
;debug.notification("numReleasedPrisoners = "+ReleasedPrisoners.GetCount())
	
EndFunction

; We are either selling all, or selling against a specific list of prisoners. We also need to know which formula is being paid against.
Function SellPrisoners(FormList PrisonerList=none, GlobalVariable Payment)

    int prisonerIndex = 0
	int numPrisoners
	Actor prisoner
	
	If PrisonerList == none
	
		Actor[] prisoners = BrigPrisoners.GetActorArray()
		numPrisoners = prisoners.length
	
		While prisonerIndex < prisoners.length
		
			prisoner = prisoners[prisonerIndex]
		
			prisoner.SetCrimeFaction((prisoner.GetBaseObject() as Actor).GetCrimeFaction())
			BrigPrisoners.RemoveRef(prisoner)
			prisoner.SetLinkedRef(none, UB_Keyword_LinkedCell, false)
			prisoner.Disable(False)
			prisoner.moveTo(OverflowBrigCellMarker, 0, 0, 0, False, False)
			prisoner.Kill(none)
			
			prisonerIndex += 1
		
		EndWhile
		
	Else
	
		numPrisoners = PrisonerList.GetSize()
		
		While prisonerIndex <= numPrisoners
		
			prisoner = PrisonerList.GetAt(prisonerIndex) as Actor
		
			prisoner.SetCrimeFaction((prisoner.GetBaseObject() as Actor).GetCrimeFaction())
			BrigPrisoners.RemoveRef(prisoner)
			prisoner.SetLinkedRef(none, UB_Keyword_LinkedCell, false)
			prisoner.Disable(False)
			prisoner.moveTo(OverflowBrigCellMarker, 0, 0, 0, False, False)
			prisoner.Kill(none)
	
			prisonerIndex += 1
		
		EndWhile
		
	EndIf
	
	Game.GetPlayer().AddItem(Game.GetCredits(), Payment.GetValueInt(), False)
    
    CalcPrisonerValues()

EndFunction

Function ReleasedPrisonersLeaveShip()

;debug.notification("numReleasedPrisoners = "+ReleasedPrisoners.GetCount())

	; This typically won't be true, so let's check to avoid wasting time trying to set up an array/loop.
	If ReleasedPrisoners.GetCount() > 0

		Actor[] prisoners = ReleasedPrisoners.GetActorArray()

		int prisonerIndex = 0
		int numPrisoners = prisoners.length
		
		While prisonerIndex < numPrisoners
		
			If prisoners[prisonerIndex].IsDead()
				prisoners[prisonerIndex].MoveTo(OverflowBrigCellMarker, 0, 0, 0, False, False)
			Else
				prisoners[prisonerIndex].MoveToMyEditorLocation()
			EndIf
			ReleasedPrisoners.RemoveRef(prisoners[prisonerIndex])
		
		EndWhile
	
	EndIf

EndFunction