Scriptname UB_Script_BrigPrisonersAlias extends RefCollectionAlias
{ Detect if prisoners become hostile and stop them. This is used because if hostile by accident, they will prevent fast travel. }

Keyword Property UB_Keyword_LinkedCell Auto

Event OnCombatStateChanged(ObjectReference akSenderRef, ObjectReference akTarget, Int aeCombatState)
    If aeCombatState > 0
        akSenderRef.TryToStopCombat()
    EndIf
EndEvent

Event OnCellAttach(ObjectReference akSenderRef)
	if akSenderRef.GetLinkedRef(UB_Keyword_LinkedCell) != none
		(akSenderRef as Actor).SnapIntoInteraction(akSenderRef.GetLinkedRef(UB_Keyword_LinkedCell))
	else
;debug.messagebox("Error: Actor missing linked brig cell bed ref")
	endif
EndEvent

Event OnDying(ObjectReference akSenderRef, ObjectReference akKiller)
	If (akKiller != none)
		(GetOwningQuest() as UB_Script_BrigManager).Release(akSenderRef as Actor)
	endIf
endEvent