Scriptname av_DeploymentDeckScript extends activemagiceffect

Event OnInit()
	;Player used a radio, give it back - silently.
	Game.GetPlayer().AddItem(av_Deployment_Deck, 1, true)
	;Display the radio menu
	DisplayMainMenu()
EndEvent

Function DisplayMainMenu() ; Displays the revelevant main menu. Additional logic can be added here if it were needed to choose which menu shows first.
	if Vasco.GetRace() == SupportedRaces[0] ; Model A
		MainMenu()
	elseif Vasco.GetRace() == SupportedRaces[1] ; Model S
		ModelS_MainMenu()
	elseif Vasco.GetRace() == SupportedRaces[2] ; MiniBot
		MiniBot_MainMenu()
	endif
EndFunction

Function MainMenu()
	int choice = av_MainMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Weapon Loadout
		WeaponMenu()
	elseif (choice == 1) ; Body Kit
		SkinsMenu()
	elseif (choice == 2) ; Voice Module Control
		VoiceMenu()
	elseif (choice == 3) ; Combat Style Parameters
		CombatStyleMenu()
	elseif (choice == 4) ; Frame Swap
		RaceChangeMenu()
	else ; Exit
	endif
EndFunction

Function RaceChangeMenu()
	ObjectReference tempMarker = none
	int choice = av_RaceChangeMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		DisplayMainMenu()
	elseif (choice == 1) ; Model A
		tempMarker = Vasco.PlaceAtMe(XMarkerHeading, 1, false, false, false, none, none, false)
		Vasco.MoveTo(avHoldingCellMarker, 0, 0, 0, false, false)
		RemoveAllRaceSpecificModules()
		Vasco.SetRace(SupportedRaces[0])
		while (Vasco.GetRace() != SupportedRaces[0])
			Utility.Wait(0.1)
		endWhile
		Vasco.MoveTo(tempMarker, 0, 0, 0, true, true)
		EquipObject(Skins, 14)
		Vasco.SetCombatStyle(CombatStyles[0])
		tempMarker.Delete()
		Vasco.EvaluatePackage(False)
;		RaceChangeMenu()
	elseif (choice == 2) ; Model S
		tempMarker = Vasco.PlaceAtMe(XMarkerHeading, 1, false, false, false, none, none, false)
		Vasco.MoveTo(avHoldingCellMarker, 0, 0, 0, false, false)
		RemoveAllRaceSpecificModules()
		Vasco.SetRace(SupportedRaces[1])
		while (Vasco.GetRace() != SupportedRaces[1])
			Utility.Wait(0.1)
		endWhile
		Vasco.MoveTo(tempMarker, 0, 0, 0, true, true)
		EquipObject(ModelS_Skins, 0)
		Vasco.SetCombatStyle(ModelS_CombatStyles[0])
		tempMarker.Delete()
		Vasco.EvaluatePackage(False)
;		RaceChangeMenu()
	elseif (choice == 3) ; MiniBot
		tempMarker = Vasco.PlaceAtMe(XMarkerHeading, 1, false, false, false, none, none, false)
		Vasco.MoveTo(avHoldingCellMarker, 0, 0, 0, false, false)
		RemoveAllRaceSpecificModules()
		Vasco.SetRace(SupportedRaces[2])
		while (Vasco.GetRace() != SupportedRaces[2])
			Utility.Wait(0.1)
		endWhile
		Vasco.MoveTo(tempMarker, 0, 0, 0, true, true)
		EquipObject(MiniBot_Skins, 0)
		Vasco.SetCombatStyle(MiniBot_CombatStyles[0])
		Vasco.EvaluatePackage(False)
		tempMarker.Delete()
;		RaceChangeMenu()
	else ; Exit
	endif
EndFunction

Function VoiceMenu()
	int choice = av_VoiceMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		DisplayMainMenu()
	elseif (choice == 1) ; Lithe
		RemoveListObjects(VoiceModules)
		EquipObject(VoiceModules, 0)
		VoiceMenu()
	elseif (choice == 2) ; Heavy
		RemoveListObjects(VoiceModules)
		EquipObject(VoiceModules, 1)
		VoiceMenu()
	elseif (choice == 3) ; Vasco
		RemoveListObjects(VoiceModules)
		VoiceMenu()
	else ; Exit
	endif
EndFunction

Function SkinsMenu()
	int choice = av_SkinsMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		MainMenu()
	elseif (choice == 1) ; Brute
		SkinsMenuBrute()
	elseif (choice == 2) ; Combat
		SkinsMenuCombat()
	elseif (choice == 3) ; Expedition
		SkinsMenuExpedition()
	elseif (choice == 4) ; Farmer
		SkinsMenuFarmer()
	elseif (choice == 5) ; Industrial
		SkinsMenuIndustrial()
	elseif (choice == 6) ; Medic
		SkinsMenuMedic()
	elseif (choice == 7) ; Security
		SkinsMenuSecurity()
	else ; Exit
	endif
EndFunction

Function SkinsMenuBrute()
	int choice = av_SkinsMenuBrute.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Generic
		EquipObject(Skins, 0)
;		SkinsMenuBrute()
	elseif (choice == 2) ; Generic Heavy
		EquipObject(Skins, 1)
;		SkinsMenuBrute()
	elseif (choice == 3) ; Crimson Fleet
		EquipObject(Skins, 2)
;		SkinsMenuBrute()
	elseif (choice == 4) ; Crimson Fleet Heavy
		EquipObject(Skins, 3)
;		SkinsMenuBrute()
	elseif (choice == 5) ; Crimson Fleet Armored
		EquipObject(Skins, 4)
;		SkinsMenuBrute()
	else ; Exit
	endif
EndFunction

Function SkinsMenuCombat()
	int choice = av_SkinsMenuCombat.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Generic
		EquipObject(Skins, 5)
;		SkinsMenuCombat()
	elseif (choice == 2) ; Generic Heavy
		EquipObject(Skins, 6)
;		SkinsMenuCombat()
	elseif (choice == 3) ; Generic Armored
		EquipObject(Skins, 7)
;		SkinsMenuCombat()
	elseif (choice == 4) ; Grafitti
		EquipObject(Skins, 26)
;		SkinsMenuCombat()
	elseif (choice == 5) ; Grafitti Heavy
		EquipObject(Skins, 8)
;		SkinsMenuCombat()
	elseif (choice == 6) ; Grafitti Armored
		EquipObject(Skins, 28)
;		SkinsMenuCombat()
	elseif (choice == 7) ; Red Devil
		EquipObject(Skins, 25)
;		SkinsMenuCombat()
	elseif (choice == 8) ; Red Devil Heavy
		EquipObject(Skins, 9)
;		SkinsMenuCombat()
	elseif (choice == 9) ; Red Devil Armored
		EquipObject(Skins, 27)
;		SkinsMenuCombat()
	else ; Exit
	endif
EndFunction

Function SkinsMenuExpedition()
	int choice = av_SkinsMenuExpedition.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Generic Black
		EquipObject(Skins, 10)
;		SkinsMenuExpedition()
	elseif (choice == 2) ; Generic Yellow
		EquipObject(Skins, 11)
;		SkinsMenuExpedition()
	elseif (choice == 3) ; NASA
		EquipObject(Skins, 12)
;		SkinsMenuExpedition()
	elseif (choice == 4) ; Ryujin
		EquipObject(Skins, 13)
;		SkinsMenuExpedition()
	elseif (choice == 5) ; Vasco
		EquipObject(Skins, 14)
;		SkinsMenuExpedition()
	else ; Exit
	endif
EndFunction

Function SkinsMenuFarmer()
	int choice = av_SkinsMenuFarmer.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Generic
		EquipObject(Skins, 15)
;		SkinsMenuFarmer()
	else ; Exit
	endif
EndFunction

Function SkinsMenuIndustrial()
	int choice = av_SkinsMenuIndustrial.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Construction
		EquipObject(Skins, 16)
;		SkinsMenuIndustrial()
	elseif (choice == 2) ; Junkyard
		EquipObject(Skins, 17)
;		SkinsMenuIndustrial()
	elseif (choice == 3) ; Mining
		EquipObject(Skins, 18)
;		SkinsMenuIndustrial()
	elseif (choice == 4) ; Spaceport
		EquipObject(Skins, 19)
;		SkinsMenuIndustrial()
	elseif (choice == 5) ; Warehouse
		EquipObject(Skins, 20)
;		SkinsMenuIndustrial()
	else ; Exit
	endif
EndFunction

Function SkinsMenuMedic()
	int choice = av_SkinsMenuMedic.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Generic
		EquipObject(Skins, 21)
;		SkinsMenuMedic()
	elseif (choice == 2) ; Va'ruun
		EquipObject(Skins, 22)
;		SkinsMenuMedic()
	elseif (choice == 3) ; Viator
		EquipObject(Skins, 23)
;		SkinsMenuMedic()
	else ; Exit
	endif
EndFunction

Function SkinsMenuSecurity()
	int choice = av_SkinsMenuSecurity.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		SkinsMenu()
	elseif (choice == 1) ; Generic
		EquipObject(Skins, 24)
;		SkinsMenuSecurity()
	else ; Exit
	endif
EndFunction

Function CombatStyleMenu()
	int choice = av_CombatStyleMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		MainMenu()
	elseif (choice == 1) ; Model A
		Vasco.SetCombatStyle(CombatStyles[0])
		CombatStyleMenu()
	elseif (choice == 2) ; Model A Combat
		Vasco.SetCombatStyle(CombatStyles[1])
		CombatStyleMenu()
	elseif (choice == 3) ; Model A Melee
		Vasco.SetCombatStyle(CombatStyles[2])
		CombatStyleMenu()
	elseif (choice == 4) ; Model A Vasco
		Vasco.SetCombatStyle(CombatStyles[3])
		CombatStyleMenu()
	else ; Exit
	endif
EndFunction

Function WeaponMenu()
	int choice = av_WeaponMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		MainMenu()
	elseif (choice == 1) ; Left Hand Weapons
		WeaponMenuLeftHand()
	elseif (choice == 2) ; Right Hand Weapons
		WeaponMenuRightHand()
	elseif (choice == 3) ; Head
		WeaponMenuMiddleHand()
	else ; Exit
	endif
EndFunction

Function WeaponMenuLeftHand()
	int choice = av_WeaponMenuLeftHand.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; 
		WeaponMenu()
	elseif (choice == 1) ; Combat Gun Auto
		PlayerProvideAmmo(10) ; 7.77mm Caseless
		EquipObject(WeaponLeft, 0)
		WeaponMenuLeftHand()
	elseif (choice == 2) ; Crimson Fleet Flamethrower
		EquipObject(WeaponLeft, 1)
		WeaponMenuLeftHand()
	elseif (choice == 3) ; Crimson Fleet Gun Auto
		PlayerProvideAmmo(10) ; 7.77mm Caseless
		EquipObject(WeaponLeft, 2)
		WeaponMenuLeftHand()
	elseif (choice == 4) ; Security Gun Auto
		PlayerProvideAmmo(12) ; 3kV LZR Cartridge
		EquipObject(WeaponLeft, 3)
		WeaponMenuLeftHand()
	elseif (choice == 5) ; EM Laser Left Gun
		PlayerProvideAmmo(17) ; Heavy Particle Fuse
		EquipObject(WeaponLeft, 4)
		WeaponMenuLeftHand()
	elseif (choice == 6) ; None
		RemoveListObjects(WeaponLeft)
		WeaponMenuLeftHand()
	else ; Exit
	endif
EndFunction

Function WeaponMenuRightHand()
	int choice = av_WeaponMenuRightHand.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; 
		WeaponMenu()
	elseif (choice == 1) ; Combat Gun Auto
		PlayerProvideAmmo(10) ; 7.77mm Caseless
		EquipObject(WeaponRight, 0)
		WeaponMenuRightHand()
	elseif (choice == 2) ; Crimson Fleet Flamethrower
		EquipObject(WeaponRight, 1)
		WeaponMenuRightHand()
	elseif (choice == 3) ; Crimson Fleet Gun Auto
		PlayerProvideAmmo(10) ; 7.77mm Caseless
		EquipObject(WeaponRight, 2)
		WeaponMenuRightHand()
	elseif (choice == 4) ; Security Gun Auto
		PlayerProvideAmmo(12) ; 3kV LZR Cartridge
		EquipObject(WeaponRight, 3)
		WeaponMenuRightHand()
	elseif (choice == 5) ; EM Laser Right Gun
		PlayerProvideAmmo(17) ; Heavy Particle Fuse
		EquipObject(WeaponRight, 4)
		WeaponMenuRightHand()
	elseif (choice == 6) ; None
		RemoveListObjects(WeaponRight)
		WeaponMenuRightHand()
	else ; Exit
	endif
EndFunction

Function WeaponMenuMiddleHand()
	int choice = av_WeaponMenuMiddleHand.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; 
		WeaponMenu()
	elseif (choice == 1) ; Laser
		PlayerProvideAmmo(12) ; 3kV LZR Cartridge
		EquipObject((WeaponMiddle), 0)
		WeaponMenuMiddleHand()
	elseif (choice == 2) ; Rocketpod
		PlayerProvideAmmo(3) ; 40mm XPL
		EquipObject((WeaponMiddle), 1)
		WeaponMenuMiddleHand()
	elseif (choice == 3) ; EM Laser
		PlayerProvideAmmo(17) ; Heavy Particle Fuse
		EquipObject((WeaponMiddle), 2)
		WeaponMenuMiddleHand()
	elseif (choice == 4) ; None
		RemoveListObjects(WeaponMiddle)
		WeaponMenuMiddleHand()
	else ; Exit
	endif
EndFunction

; ############## MODEL S ##############

Function ModelS_MainMenu()
	int choice = av_ModelS_MainMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Weapon Loadout - Model S only uses right hand
		;ModelS_WeaponMenu()
		ModelS_WeaponMenuRightHand()
	elseif (choice == 1) ; Body Kit
		ModelS_SkinsMenu()
	elseif (choice == 2) ; Voice Module Control
		VoiceMenu()
	elseif (choice == 3) ; Combat Style Parameters
		ModelS_CombatStyleMenu()
	elseif (choice == 4) ; Frame Swap
		RaceChangeMenu()
	else ; Exit
	endif
EndFunction

Function ModelS_SkinsMenu()
	int choice = av_ModelS_SkinsMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		ModelS_MainMenu()
	elseif (choice == 1) ; Brute
		ModelS_SkinsMenuBrute()
	elseif (choice == 2) ; Combat
		ModelS_SkinsMenuCombat()
	elseif (choice == 3) ; Expedition
		ModelS_SkinsMenuExpedition()
	elseif (choice == 4) ; Tactical
		ModelS_SkinsMenuTactical()
	else ; Exit
	endif
EndFunction

Function ModelS_SkinsMenuBrute()
	int choice = av_ModelS_SkinsMenuBrute.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		ModelS_SkinsMenu()
	elseif (choice == 1) ; Generic Heavy
		EquipObject(ModelS_Skins, 0)
;		ModelS_SkinsMenuBrute()
	elseif (choice == 2) ; Crimson Fleet
		EquipObject(ModelS_Skins, 1)
;		ModelS_SkinsMenuBrute()
	elseif (choice == 3) ; Crimson Fleet Heavy
		EquipObject(ModelS_Skins, 2)
;		ModelS_SkinsMenuBrute()
	else ; Exit
	endif
EndFunction

Function ModelS_SkinsMenuCombat()
	int choice = av_ModelS_SkinsMenuCombat.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		ModelS_SkinsMenu()
	elseif (choice == 1) ; Generic
		EquipObject(ModelS_Skins, 3)
;		ModelS_SkinsMenuCombat()
	elseif (choice == 2) ; Generic Heavy
		EquipObject(ModelS_Skins, 4)
;		ModelS_SkinsMenuCombat()
	elseif (choice == 3) ; Generic Armored
		EquipObject(ModelS_Skins, 5)
;		ModelS_SkinsMenuCombat()
	elseif (choice == 4) ; Slayton
		EquipObject(ModelS_Skins, 6)
;		ModelS_SkinsMenuCombat()
	else ; Exit
	endif
EndFunction

Function ModelS_SkinsMenuExpedition()
	int choice = av_ModelS_SkinsMenuExpedition.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		ModelS_SkinsMenu()
	elseif (choice == 1) ; Generic v1
		EquipObject(ModelS_Skins, 7)
;		ModelS_SkinsMenuExpedition()
	elseif (choice == 2) ; Generic v2
		EquipObject(ModelS_Skins, 8)
;		ModelS_SkinsMenuExpedition()
	elseif (choice == 3) ; Generic v3
		EquipObject(ModelS_Skins, 9)
;		ModelS_SkinsMenuExpedition()
	elseif (choice == 4) ; Generic v4
		EquipObject(ModelS_Skins, 10)
;		ModelS_SkinsMenuExpedition()
	elseif (choice == 5) ; Va'ruun
		EquipObject(ModelS_Skins, 11)
;		ModelS_SkinsMenuExpedition()
	else ; Exit
	endif
EndFunction

Function ModelS_SkinsMenuTactical()
	int choice = av_ModelS_SkinsMenuTactical.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		ModelS_SkinsMenu()
	elseif (choice == 1) ; Ecliptic
		EquipObject(ModelS_Skins, 12)
;		ModelS_SkinsMenuTactical()
	else ; Exit
	endif
EndFunction

Function ModelS_CombatStyleMenu()
	int choice = av_ModelS_CombatStyleMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		MainMenu()
	elseif (choice == 1) ; Model S Flanking
		Vasco.SetCombatStyle(ModelS_CombatStyles[0])
		ModelS_CombatStyleMenu()
	elseif (choice == 2) ; Model S Melee
		Vasco.SetCombatStyle(ModelS_CombatStyles[1])
		ModelS_CombatStyleMenu()
	elseif (choice == 3) ; Model S Ranged
		Vasco.SetCombatStyle(ModelS_CombatStyles[2])
		ModelS_CombatStyleMenu()
	else ; Exit
	endif
EndFunction

Function ModelS_WeaponMenuRightHand()
	int choice = av_ModelS_WeaponMenuRightHand.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; 
		;ModelS_WeaponMenu()
		ModelS_MainMenu()
	elseif (choice == 1) ; Model S Turret Auto
		PlayerProvideAmmo(11) ; 9x39mm
		EquipObject(ModelS_WeaponRight, 0)
		ModelS_WeaponMenuRightHand()
	elseif (choice == 2) ; Model S Turret Semi-Auto
		PlayerProvideAmmo(11) ; 9x39mm
		EquipObject(ModelS_WeaponRight, 1)
		ModelS_WeaponMenuRightHand()
	elseif (choice == 3) ; Model S Turret EM Auto
		PlayerProvideAmmo(17) ; Heavy Particle Fuse
		EquipObject(ModelS_WeaponRight, 2)
		ModelS_WeaponMenuRightHand()
	elseif (choice == 4) ; None
		RemoveListObjects(ModelS_WeaponRight)
		ModelS_WeaponMenuRightHand()
	else ; Exit
	endif
EndFunction

; #####################################

; ############## MINIBOT ##############

Function MiniBot_MainMenu()
	int choice = av_MiniBot_MainMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Weapon Loadout - Mini Bot only uses mouth
		MiniBot_WeaponMenuMouth()
	elseif (choice == 1) ; Body Kit
		MiniBot_SkinsMenu()
	elseif (choice == 2) ; Voice Module Control
		VoiceMenu()
	elseif (choice == 3) ; Combat Style Parameters
		MiniBot_CombatStyleMenu()
	elseif (choice == 4) ; Frame Swap
		RaceChangeMenu()
	else ; Exit
	endif
EndFunction

Function MiniBot_SkinsMenu()
	int choice = av_MiniBot_SkinsMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		MiniBot_MainMenu()
	elseif (choice == 1) ; DRONE
		EquipObject(MiniBot_Skins, 0)
;		MiniBot_SkinsMenu()
	elseif (choice == 2) ; DRONE Clean
		EquipObject(MiniBot_Skins, 1)
;		MiniBot_SkinsMenu()
	elseif (choice == 3) ; Gardening
		EquipObject(MiniBot_Skins, 2)
;		MiniBot_SkinsMenu()
	elseif (choice == 4) ; Gardening Clean
		EquipObject(MiniBot_Skins, 3)
;		MiniBot_SkinsMenu()
	elseif (choice == 5) ; Sanitation
		EquipObject(MiniBot_Skins, 4)
;		MiniBot_SkinsMenu()
	elseif (choice == 6) ; Sanitation Clean
		EquipObject(MiniBot_Skins, 5)
;		MiniBot_SkinsMenu()
	elseif (choice == 7) ; Security
		EquipObject(MiniBot_Skins, 6)
;		MiniBot_SkinsMenu()
	elseif (choice == 8) ; Security Clean
		EquipObject(MiniBot_Skins, 7)
;		MiniBot_SkinsMenu()
	else ; Exit
	endif
EndFunction

Function MiniBot_CombatStyleMenu()
	int choice = av_MiniBot_CombatStyleMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; Back
		MainMenu()
	elseif (choice == 1) ; Mini Bot Factory Default
		Vasco.SetCombatStyle(MiniBot_CombatStyles[0])
		MiniBot_CombatStyleMenu()
	elseif (choice == 2) ; Mini Bot Security
		Vasco.SetCombatStyle(MiniBot_CombatStyles[1])
		MiniBot_CombatStyleMenu()
	else ; Exit
	endif
EndFunction

Function MiniBot_WeaponMenuMouth()
	int choice = av_MiniBot_WeaponMenuMouth.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
	if (choice == 0) ; 
		;MiniBot_WeaponMenu()
		MiniBot_MainMenu()
	elseif (choice == 1) ; Laser
		EquipObject(MiniBot_WeaponMouth, 0)
		MiniBot_WeaponMenuMouth()
	elseif (choice == 2) ; EM Laser
		EquipObject(MiniBot_WeaponMouth, 1)
		MiniBot_WeaponMenuMouth()
	elseif (choice == 3) ; None
		RemoveListObjects(MiniBot_WeaponMouth)
		MiniBot_WeaponMenuMouth()
	else ; Exit
	endif
EndFunction

; #####################################

;Centralizes player provide ammo function in case we want to add additional steps in the future.
Function PlayerProvideAmmo(int choice)
	objectreference pc = Game.GetPlayer()
	if pc.GetItemCount(AmmoTypes[choice]) > 0 && Vasco.GetItemCount(AmmoTypes[choice]) == 0
		pc.RemoveItem(AmmoTypes[choice], 1, true, Vasco)
	endif
EndFunction

;Checks for, and removes, weapons and armor to ensure we are not just adding endless non-playable objects to Vasco.
Function RemoveListObjects(Form[] object)
	int i = 0
	int j = object.length
	while i<j
		int x = Vasco.GetItemCount(object[i])
		if x > 0
			if ((object[i] as weapon || object[i] as armor) && Vasco.IsEquipped(object[i]))
				;(object[i] as ObjectReference).RemoveAllMods()
				Vasco.UnequipItem(object[i], false, true)
			endif
			Vasco.RemoveItem(object[i], x, true, None)
		endif
		i = i + 1
	endwhile
EndFunction

;Removes all Weapons/Armors for race swap.
Function RemoveAllRaceSpecificModules()
	if Vasco.GetRace() == SupportedRaces[0] ; Model A
		RemoveListObjects(WeaponLeft)
		RemoveListObjects(WeaponRight)
		RemoveListObjects(WeaponMiddle)
		RemoveListObjects(Skins)
	elseif Vasco.GetRace() == SupportedRaces[1] ; Model S
		RemoveListObjects(ModelS_WeaponRight)
		RemoveListObjects(ModelS_Skins)
	elseif Vasco.GetRace() == SupportedRaces[2] ; MiniBot
		RemoveListObjects(MiniBot_WeaponMouth)
		RemoveListObjects(MiniBot_Skins)
	endif
EndFunction

;Centralizes equip function in case we want to add additional steps in the future.
Function EquipObject(Form[] objectList, int choice)
	if !Vasco.IsEquipped(objectList[choice]) ; make sure we aren't equipping what we already have equipped.
		RemoveListObjects(objectList)
		Vasco.AddItem(objectList[choice], 1, false)
		Vasco.EquipItem(objectList[choice],false,true)
		if objectList[choice] as Armor ; If changing equipment, re-equip weapons because otherwise it bugs out
			int x=0
			While x < 3 ; Seems right hand is 0, left hand is 1, and head is 2
				Weapon myWeapon = Vasco.GetEquippedWeapon(x)
				if (myWeapon)
					;debug.notification("Found weapon at slot: ["+x+"]")
					Vasco.UnEquipItem(myWeapon, false, true)
					Utility.Wait(0.1)
					Vasco.EquipItem(myWeapon, false, true)
					x+=1
				endif
			endWhile
		endif
	endif
EndFunction

;PROPERTIES
Actor Property Vasco Auto Const
Potion Property av_Deployment_Deck Auto Const
Message Property av_VoiceMenu Auto Const
Message Property av_RaceChangeMenu Auto Const
Form[] Property VoiceModules Auto
Ammo[] Property AmmoTypes Auto
Race[] Property SupportedRaces Auto
ObjectReference Property avHoldingCellMarker Auto Const
Static Property XMarkerHeading Auto Const Mandatory

; Model A
Message Property av_MainMenu Auto Const
Message Property av_CombatStyleMenu Auto Const
Message Property av_WeaponMenu Auto Const
Message Property av_WeaponMenuLeftHand Auto Const
Message Property av_WeaponMenuRightHand Auto Const
Message Property av_WeaponMenuMiddleHand Auto Const
Message Property av_SkinsMenu Auto Const
Message Property av_SkinsMenuBrute Auto Const
Message Property av_SkinsMenuCombat Auto Const
Message Property av_SkinsMenuExpedition Auto Const
Message Property av_SkinsMenuFarmer Auto Const
Message Property av_SkinsMenuIndustrial Auto Const
Message Property av_SkinsMenuMedic Auto Const
Message Property av_SkinsMenuSecurity Auto Const

Form[] Property WeaponLeft Auto
Form[] Property WeaponRight Auto
Form[] Property WeaponMiddle Auto
Form[] Property Skins Auto
CombatStyle[] Property CombatStyles Auto

; Model S
Message Property av_ModelS_MainMenu Auto Const
Message Property av_ModelS_CombatStyleMenu Auto Const
Message Property av_ModelS_WeaponMenuRightHand Auto Const

Message Property av_ModelS_SkinsMenu Auto Const
Message Property av_ModelS_SkinsMenuBrute Auto Const
Message Property av_ModelS_SkinsMenuCombat Auto Const
Message Property av_ModelS_SkinsMenuExpedition Auto Const
Message Property av_ModelS_SkinsMenuTactical Auto Const

Form[] Property ModelS_WeaponRight Auto
Form[] Property ModelS_Skins Auto
CombatStyle[] Property ModelS_CombatStyles Auto

; MiniBot
Message Property av_MiniBot_MainMenu Auto Const
Message Property av_MiniBot_CombatStyleMenu Auto Const
Message Property av_MiniBot_WeaponMenuMouth Auto Const
Message Property av_MiniBot_SkinsMenu Auto Const

Form[] Property MiniBot_WeaponMouth Auto
Form[] Property MiniBot_Skins Auto
CombatStyle[] Property MiniBot_CombatStyles Auto

;DEPRECATED
;ActorBase Property VascoActorBase Auto Const
;LeveledItem Property LL_Vasco_Voice_Container Auto Const -- DEPRECATED
;Outfit Property av_Outfit_Armor_Vasco_Voice_Choice Auto Const -- DEPRECATED
;Message Property av_ModelS_WeaponMenuMiddleHand Auto Const
;Message Property av_ModelS_WeaponMenu Auto Const
;Message Property av_ModelS_WeaponMenuLeftHand Auto Const

;Function ModelS_WeaponMenuMiddleHand()
;	int choice = av_WeaponMenuMiddleHand.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
;	if (choice == 0) ; 
;		WeaponMenu()
;	elseif (choice == 1) ; Equinox
;		PlayerProvideAmmo(12) ; 3kV LZR Cartridge
;		EquipObject((WeaponMiddle), 0)
;	elseif (choice == 2) ; Rocketpod
;		PlayerProvideAmmo(3) ; 40mm XPL
;		EquipObject((WeaponMiddle), 1)
;	elseif (choice == 3) ; None
;		RemoveListObjects(WeaponMiddle)
;	else ; Exit
;	endif
;EndFunction

;Function ModelS_WeaponMenu()
;	int choice = av_ModelS_WeaponMenu.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
;	if (choice == 0) ; Back
;		MainMenu()
;	elseif (choice == 1) ; Left Hand Weapons
;		WeaponMenuLeftHand()
;	elseif (choice == 2) ; Right Hand Weapons
;		WeaponMenuRightHand()
;	elseif (choice == 3) ; Head
;		WeaponMenuMiddleHand()
;	else ; Exit
;	endif
;EndFunction

;Function ModelS_WeaponMenuLeftHand()
;	int choice = av_ModelS_WeaponMenuLeftHand.Show(1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0)
;	if (choice == 0) ; 
;		WeaponMenu()
;	elseif (choice == 1) ; Combat Gun Auto
;		PlayerProvideAmmo(10) ; 7.77mm Caseless
;		EquipObject(WeaponLeft, 0)
;	elseif (choice == 3) ; Crimson Fleet Flamethrower
;		EquipObject(WeaponLeft, 2)
;	elseif (choice == 4) ; Crimson Fleet Gun Auto
;		PlayerProvideAmmo(10) ; 7.77mm Caseless
;		EquipObject(WeaponLeft, 3)
;	elseif (choice == 5) ; Security Gun Auto
;		PlayerProvideAmmo(12) ; 3kV LZR Cartridge
;		EquipObject(WeaponLeft, 4)
;	elseif (choice == 6) ; None
;		RemoveListObjects(WeaponLeft)
;	else ; Exit
;	endif
;EndFunction