Scriptname NLF_Script_RestrainedNPCsManager extends Quest

RefCollectionAlias Property RestrainedNPCs Auto
RefCollectionAlias Property RestrainedMarkers Auto
RefCollectionAlias Property ReleasedNPCs Auto
Furniture Property NPCSitFloorCaptive_Kneeling Auto
Keyword Property NLF_Keyword_LinkedMarker Auto Const
Perk Property NLF_Perk_Restrain Auto Const
Spell Property NLF_Spell_Disarm Auto Const
Spell Property NLF_Spell_ReleasedFlee Auto Const
MiscObject Property NLF_Misc_Handcuffs Auto Const
LeveledItem Property NLF_LVLI_Handcuffs100 Auto
LeveledItem Property NLF_LVLI_Handcuffs75 Auto
LeveledItem Property NLF_LVLI_Handcuffs50 Auto
LeveledItem Property NLF_LVLI_Handcuffs25 Auto
LeveledItem Property LLC_Vendor_Any_TradeAuthority Auto
LeveledItem Property LLC_Vendor_City_NA_UCDistributionContainer Auto
LeveledItem Property LLC_Vendor_City_NA_UCSurplusContainer Auto
LeveledItem Property LLI_Loot_Corpse_LC030_Guard Auto
LeveledItem Property LLI_Security Auto

;Float fUpdateTime = 60.0 Const
;Int iUpdateTimerID = 1

Event OnQuestInit()

    If !Game.GetPlayer().HasPerk(NLF_Perk_Restrain)
        Game.GetPlayer().AddPerk(NLF_Perk_Restrain, False)
    EndIF
	
	LLC_Vendor_Any_TradeAuthority.AddForm(NLF_LVLI_Handcuffs50, 0, 3) ; Trade Authority Vendors
	LLC_Vendor_City_NA_UCDistributionContainer.AddForm(NLF_LVLI_Handcuffs75, 0, 4) ; UC Distribution Center
	LLC_Vendor_City_NA_UCSurplusContainer.AddForm(NLF_LVLI_Handcuffs75, 0, 9) ; UC Surplus
	LLI_Loot_Corpse_LC030_Guard.AddForm(NLF_LVLI_Handcuffs25, 0, 1) ; UC Guard Corpse
	LLI_Security.AddForm(NLF_LVLI_Handcuffs75, 0, 1) ; Security General LLI
	
EndEvent

Bool Function Restrain(Actor npc, Bool force=false)

    CleanRestrainedNPCs()
	CleanRestrainedMarkers()
	CleanReleasedNPCs()
	
	if (Game.GetPlayer().GetItemCount(NLF_Misc_Handcuffs) == 0 && force==false)
		return false
	endif
	
	Game.GetPlayer().RemoveItem(NLF_Misc_Handcuffs, 1, false, none)
	
	RestrainedNPCs.addRef(npc)
	if npc.IsUnconscious()
		npc.SetUnconscious(false)
	endif
	npc.StopCombat()
    npc.StopCombatAlarm()
	
	ObjectReference marker = npc.placeatme(NPCSitFloorCaptive_Kneeling, 1, true, false, false, none, none, false)
	marker.PushActorAway(npc, 0.1)
	npc.SetLinkedRef(marker, NLF_Keyword_LinkedMarker, false)
	RestrainedMarkers.addRef(marker)
	marker.SetLinkedRef(npc, NLF_Keyword_LinkedMarker, false) ; We also set the inverse linkedref to track if an NPC reference has been deleted/removed unexpectedly.

	marker.MoveToNearestNavmeshLocation()
	npc.MoveTo(marker, 0.0, 0.0, 0.0, True, False)
	Utility.Wait(0.5)
	NLF_Spell_Disarm.Cast(npc, none)
	
    return true
	
EndFunction

Function Release(Actor npc)

	ObjectReference marker = npc.GetLinkedRef(NLF_Keyword_LinkedMarker)
    npc.SetLinkedRef(none, NLF_Keyword_LinkedMarker, false)
    RestrainedNPCs.RemoveRef(npc)
	npc.EvaluatePackage(false)
	RestrainedMarkers.RemoveRef(marker)
	;NLF_Spell_ReleasedFlee.Cast(npc, none)
	
	if IsNearPlayer(npc) && !npc.IsDead() && !npc.IsDisabled()
		Game.GetPlayer().AddItem(NLF_Misc_Handcuffs, 1, false)
		ReleasedNPCs.AddRef(npc)
		;npcStartTimer(npc)
	endif
	
	Utility.Wait(1.5)
	marker.Delete()
	
EndFunction

;Returns the amount of restrained actors
Int Function CleanRestrainedNPCs()

    int index = 0
    int count = 0
	int numNPCs = RestrainedNPCs.GetCount()
	
    While index < numNPCs
        
        ObjectReference ref = RestrainedNPCs.GetAt(index)
        Actor npc = ref as Actor
		
        ;If this is disabled, dead, or not an actor
        If npc == none
			RestrainedNPCs.RemoveRef(npc)
		ElseIf npc.IsDead() || npc.IsDisabled()
            Release(npc)
        Else
            count += 1
        EndIf

        index += 1
		
    EndWhile
	
    return count
	
EndFunction

;Returns the amount of restrained actors
Int Function CleanRestrainedMarkers()

;debug.MessageBox("CleanRestrainedMarkers init")
    int index = 0
    int count = 0
	int numMarkers = RestrainedMarkers.GetCount()

;debug.MessageBox("Markers Count: "+numMarkers)
	
    While index < numMarkers
        
        ObjectReference ref = RestrainedMarkers.GetAt(index)
		
        If ref == none
            RestrainedMarkers.RemoveRef(ref)
		ElseIf ref.GetLinkedRef(NLF_Keyword_LinkedMarker) == none
			RestrainedMarkers.RemoveRef(ref)
			ref.Delete()
        Else
            count += 1
        EndIf

        index += 1
		
    EndWhile
	
    return count
	
EndFunction

;Returns the amount of restrained actors
Int Function CleanReleasedNPCs()

    int index = 0
    int count = 0
	int numNPCs = RestrainedNPCs.GetCount()
	location playerLocation = Game.GetPlayer().GetCurrentLocation()
	
    While index < numNPCs
        
        ObjectReference ref = RestrainedNPCs.GetAt(index)
        Actor npc = ref as Actor
		
        ;If this is disabled, dead, or not an actor
        If npc == none
			RestrainedNPCs.RemoveRef(npc)
		ElseIf IsNearPlayer(npc) || npc.IsDead() || npc.IsDisabled() || npc.IsUnconscious() || npc.GetLinkedRef(NLF_Keyword_LinkedMarker)
            ReleasedNPCs.RemoveRef(npc)
        Else
            count += 1
        EndIf

        index += 1
		
    EndWhile
	
    return count
	
EndFunction

Function ReleaseAll()

    int index = 0
	
    While index < RestrainedNPCs.getCount()
        Release(RestrainedNPCs.GetAt(index) as Actor)
        index += 1
    EndWhile
	
EndFunction

;Function npcStartTimer(Actor ref)
;    iUpdateTimerID = ReleasedNPCs.Find(ref)
;	Self.StartTimer(fUpdateTime, iUpdateTimerID)
;EndFunction

;Event OnTimer(Int aiTimerID)
;debug.messagebox("OnTimer triggered. Count of released: "+ReleasedNPCs.getCount())
;    Actor npc = ReleasedNPCs.GetAt(aiTimerID) as Actor
;	If npc == none || !IsNearPlayer(npc)
;		debug.messagebox("WE DID IT CHIEF! ID: "+iUpdateTimerID+" removed and confidence set to "+npc.GetBaseValue(Game.GetConfidenceAV()))
;		CleanReleasedNPCs()
;	Else
;		debug.messagebox("We are near the player... check again")
;		npcStartTimer(npc)
;	EndIf
;EndEvent

Bool Function IsNearPlayer(Actor npc)
  Actor player = Game.getplayer()
  Cell targetCell = npc.GetParentCell()
  Cell playerCell = player.GetParentCell()
  If targetCell != playerCell
    If (targetCell as Bool && targetCell.IsInterior()) || (playerCell as Bool && playerCell.IsInterior())
      Return False
    ElseIf player.getDistance(npc) > 3000.0
      Return False
    Else
      Return True
    EndIf
  Else
    Return True
  EndIf
EndFunction