Scriptname DC_DoorCloserScript extends Quest

Actor Property PlayerRef Auto Const mandatory
FormList Property DoorList Auto
GlobalVariable Property DoorDistanceCheck Auto mandatory
GlobalVariable Property DoorDistanceFrom Auto mandatory
GlobalVariable Property DoorCloseTimer Auto mandatory

ObjectReference[] AllDoors

Event OnQuestInit()
	Self.InitMod()
EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)
	Self.InitMod()
EndEvent

Function InitMod()

	Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerLoadGame")
	StartTimer(1.0, 1)
	
EndFunction

Event OnTimer(int aiTimerID)

	If aiTimerID == 1
	
		AllDoors.Clear()
		If !PlayerRef.IsInCombat()
			AllDoors = PlayerRef.FindAllReferencesOfType(DoorList, DoorDistanceCheck.GetValue())	
			If AllDoors
				int index = 0
				While (index < AllDoors.Length)
					ObjectReference ClosestDoor = AllDoors[index]
					index = index + 1
					If ClosestDoor && !ClosestDoor.IsLocked() && ClosestDoor.GetDistance(PlayerRef) >= DoorDistanceFrom.GetValue()
						Int OpenState = ClosestDoor.GetOpenState()
						If OpenState <= 2 && OpenState != 0
							ClosestDoor.SetOpen(false)			
						EndIf
					EndIf
				EndWhile	
			EndIf
		EndIf	
		StartTimer(DoorCloseTimer.GetValue(), 1)
	EndIf

EndEvent