Scriptname LInfScript_PlayerAlias extends ReferenceAlias

FormList Property BedList Auto Const
Message Property HealMessage Auto Const
Spell Property CureAfflictions Auto Const
RefCollectionAlias Property CurrentCrew Auto
Perk Property CrewMedicinePerk Auto Const
Keyword Property BedFurnitureKeyword Auto Const

import Utility


Event OnActorActivatedRef(ObjectReference akActivatedRef)

    Actor doc = GetShipDoctor()
    If doc && BedList.HasForm(akActivatedRef.GetBaseObject())
        if akActivatedRef.HasKeyword(BedFurnitureKeyword) ;Bed furniture does not call OnSit, so this is done here
            OpenMenuAndHandle(doc)
        EndIf

    EndIf


EndEvent

Event OnSit(ObjectReference akFurniture)
    Actor doc = GetShipDoctor()
    If doc && BedList.HasForm(akFurniture.GetBaseObject())
        wait(0.5)
        OpenMenuAndHandle(doc)

    EndIf

EndEvent
  

Actor Function GetShipDoctor()
    int i = 0
    While i < CurrentCrew.GetCount()
        Actor actor = CurrentCrew.GetAt(i) as Actor
        if actor && actor.HasPerk(CrewMedicinePerk)
            return actor
        EndIf

        i += 1
    EndWhile
    return none
EndFunction

Function OpenMenuAndHandle(Actor doctor)
    int buttonSelected = HealMessage.Show(0, 0, 0, 0, 0, 0, 0, 0, 0)
    If buttonSelected == 0
        CureAfflictions.Cast(doctor, Game.GetPlayer())
    ElseIf buttonSelected == 1
        Game.GetPlayer().ResetHealthAndLimbs()
    EndIf
EndFunction