ScriptName GravWaveFallDamageScript Extends ActiveMagicEffect

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
	Self.RegisterForAnimationEvent(akTarget, "GetUpStart")
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnCellDetach")
	;Debug.MessageBox("Fall damage script added to actor.")
EndEvent

Event OnAnimationEvent(ObjectReference akSource, String asEventName)
	Self.Dispel()
	;Debug.MessageBox("OnAnimationEvent Dispel was hit.")
EndEvent

Event OnCellDetach()
	Self.Dispel()
	;Debug.MessageBox("OnCellDetach Dispel was hit.")
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
	Self.UnRegisterForAnimationEvent(akTarget, "GetUpStart")
	Self.UnRegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnCellDetach")
    ;Debug.MessageBox("Fall damage script removed from actor.")
EndEvent