ScriptName AUR:SBHT:TrackPlayerSealedEnvEffectScript Extends ActiveMagicEffect Hidden

Group Required
  Actor Property PlayerRef Auto Mandatory
  AUR:SBHT:StarbornHelmetTransparencyScript Property SBHT_TransparentStarbornHelmetHandler Auto Mandatory
EndGroup

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  ; When the player enters a sealed environment
  If PlayerRef.WaitFor3DLoad()
    ;Debug.Notification("Player entered sealed environment.")
    Utility.Wait(0.1) ; Required
    SBHT_TransparentStarbornHelmetHandler.SetHelmetTransparent()
  EndIf
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
  ; When the player leaves a sealed environment
  If PlayerRef.WaitFor3DLoad()
    ;Debug.Notification("Player left sealed environment.")
    Utility.Wait(0.1) ; Required
    SBHT_TransparentStarbornHelmetHandler.SetHelmetTransparent()
  EndIf
EndEvent