Scriptname IFF_Configurator Extends ActiveMagicEffect


;-- Variables ---------------------------------------

;-- Properties --------------------------------------

GlobalVariable Property IFF_Config_Version Auto
GlobalVariable Property IFF_Aid_Destination Auto
GlobalVariable Property IFF_Ammo_Destination Auto
GlobalVariable Property IFF_Apparel_Destination Auto
GlobalVariable Property IFF_Armor_AboveCut_Destination Auto
GlobalVariable Property IFF_Armor_BelowCut_Destination Auto
GlobalVariable Property IFF_Armor_Cut_LegendaryRank Auto
GlobalVariable Property IFF_Armor_Cut_QualityLevel Auto
GlobalVariable Property IFF_Books_Destination Auto
GlobalVariable Property IFF_Chems_Destination Auto
GlobalVariable Property IFF_Contraband_Destination Auto
GlobalVariable Property IFF_CraftingGeneric_Destination Auto
GlobalVariable Property IFF_Drinks_Destination Auto
GlobalVariable Property IFF_Fauna_Destination Auto
GlobalVariable Property IFF_Flora_Destination Auto
GlobalVariable Property IFF_Food_Destination Auto
GlobalVariable Property IFF_Junk_Destination Auto
GlobalVariable Property IFF_Manufactured_Destination Auto
GlobalVariable Property IFF_Resources_AboveCut_Destination Auto
GlobalVariable Property IFF_Resources_BelowCut_Destination Auto
GlobalVariable Property IFF_Resources_Cut_Rarity Auto
GlobalVariable Property IFF_ShipRepairKits_MaxNumberAtPrimary Auto
GlobalVariable Property IFF_ShipRepairKits_Primary_Destination Auto
GlobalVariable Property IFF_ShipRepairKits_Secondary_Destination Auto
GlobalVariable Property IFF_Surveys_Destination Auto
GlobalVariable Property IFF_Throwables_Destination Auto
GlobalVariable Property IFF_Uncategorized_Destination Auto
GlobalVariable Property IFF_Weapon_AboveCut_Destination Auto
GlobalVariable Property IFF_Weapon_BelowCut_Destination Auto
GlobalVariable Property IFF_Weapon_Cut_LegendaryRank Auto
GlobalVariable Property IFF_Weapon_Cut_QualityLevel Auto

Message Property Menu1_MESG Auto
Message Property Menu2_MESG Auto
Message Property Menu3_MESG Auto
Message Property Menu4_MESG Auto
Message Property MenuArmor_MESG Auto
Message Property MenuRepairKits_MESG Auto
Message Property MenuResources_MESG Auto
Message Property MenuWeapon_MESG Auto
Message Property PickDestination_MESG Auto
Message Property PickDestinationFloraFauna_MESG Auto
Message Property PickLegendary_MESG Auto
Message Property PickRarity_MESG Auto
Message Property PickMaxRepairKits_MESG Auto
Message Property PickQualityArmor_MESG Auto
Message Property PickQualityWeapon_MESG Auto




Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)

	ShowMenu1()
EndEvent


Function ShowMenu1()

	; Debug.Trace("IFC --> Menu1",0)
	int aiButton
	aiButton = Menu1_MESG.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0 
		ShowMenu4()
	elseif aiButton == 1
		PickDestination(IFF_Aid_Destination, 1)
	elseif aiButton == 2
		PickDestination(IFF_Ammo_Destination, 1)
	elseif aiButton == 3
		PickDestination(IFF_Apparel_Destination, 1)
	elseif aiButton == 4
		ShowMenuArmor()
	elseif aiButton == 5
		PickDestination(IFF_Books_Destination, 1)
	elseif aiButton == 6
		ShowMenu2()
	endif
EndFunction


Function ShowMenu2()

	; Debug.Trace("IFC --> Menu2",0)
	int aiButton
	aiButton = Menu2_MESG.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0 
		ShowMenu1()
	elseif aiButton == 1
		PickDestination(IFF_Chems_Destination, 2)
	elseif aiButton == 2
		PickDestination(IFF_Contraband_Destination, 2)
	elseif aiButton == 3
		PickDestination(IFF_CraftingGeneric_Destination, 2)
	elseif aiButton == 4
		PickDestination(IFF_Drinks_Destination, 2)
	elseif aiButton == 5
		PickDestinationFloraFauna(IFF_Fauna_Destination, 2)
	elseif aiButton == 6
		ShowMenu3()
	endif
EndFunction


Function ShowMenu3()

	; Debug.Trace("IFC --> Menu3",0)
	int aiButton
	aiButton = Menu3_MESG.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0 
		ShowMenu2()
	elseif aiButton == 1
		PickDestinationFloraFauna(IFF_Flora_Destination, 3)
	elseif aiButton == 2
		PickDestination(IFF_Food_Destination, 3)
	elseif aiButton == 3
		PickDestination(IFF_Junk_Destination, 3)
	elseif aiButton == 4
		PickDestination(IFF_Manufactured_Destination, 3)
	elseif aiButton == 5
		ShowMenuRepairKits()
	elseif aiButton == 6
		ShowMenu4()
	endif
EndFunction


Function ShowMenu4()

	; Debug.Trace("IFC --> Menu4",0)
	int aiButton
	aiButton = Menu4_MESG.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0 
		ShowMenu3()
	elseif aiButton == 1
		ShowMenuResources()
	elseif aiButton == 2
		PickDestination(IFF_Surveys_Destination, 4)
	elseif aiButton == 3
		PickDestination(IFF_Throwables_Destination, 4)
	elseif aiButton == 4
		PickDestination(IFF_Uncategorized_Destination, 4)
	elseif aiButton == 5
		ShowMenuWeapon()
	elseif aiButton == 6
		ShowMenu1()
	endif
EndFunction


Function ShowMenuArmor()

	; Debug.Trace("IFC --> MenuArmor",0)
	int aiButton
	aiButton = MenuArmor_MESG.Show(IFF_Armor_Cut_LegendaryRank.GetValueInt(), IFF_Armor_Cut_QualityLevel.GetValueInt(), IFF_Armor_AboveCut_Destination.GetValueInt(), IFF_Armor_BelowCut_Destination.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0 
		PickLegendary(IFF_Armor_Cut_LegendaryRank,1)
	elseif aiButton == 1
		PickQualityArmor()
	elseif aiButton == 2
		PickDestination(IFF_Armor_AboveCut_Destination, 5)
	elseif aiButton == 3
		PickDestination(IFF_Armor_BelowCut_Destination, 5)
	elseif aiButton == 4
		ShowMenu1()
	endif
EndFunction


Function ShowMenuRepairKits()

	; Debug.Trace("IFC --> MenuRepairKits",0)
	int aiButton
	aiButton = MenuRepairKits_MESG.Show(IFF_ShipRepairKits_MaxNumberAtPrimary.GetValueInt(), IFF_ShipRepairKits_Primary_Destination.GetValueInt(), IFF_ShipRepairKits_Secondary_Destination.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0
		PickMaxRepairKits()
	elseif aiButton == 1
		PickDestination(IFF_ShipRepairKits_Primary_Destination, 6)
	elseif aiButton == 2
		PickDestination(IFF_ShipRepairKits_Secondary_Destination, 6)
	elseif aiButton == 3
		ShowMenu3()
	endif
EndFunction


Function ShowMenuResources()

	; Debug.Trace("IFC --> MenuResources",0)
	int aiButton
	aiButton = MenuResources_MESG.Show(IFF_Resources_Cut_Rarity.GetValueInt(), IFF_Resources_AboveCut_Destination.GetValueInt(), IFF_Resources_BelowCut_Destination.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0
		PickRarity()
	elseif aiButton == 1
		PickDestination(IFF_Resources_AboveCut_Destination, 7)
	elseif aiButton == 2
		PickDestination(IFF_Resources_BelowCut_Destination, 7)
	elseif aiButton == 3
		ShowMenu4()
	endif
EndFunction


Function ShowMenuWeapon()

	; Debug.Trace("IFC --> MenuWeapon",0)
	int aiButton
	aiButton = MenuWeapon_MESG.Show(IFF_Weapon_Cut_LegendaryRank.GetValueInt(), IFF_Weapon_Cut_QualityLevel.GetValueInt(), IFF_Weapon_AboveCut_Destination.GetValueInt(), IFF_Weapon_BelowCut_Destination.GetValueInt(), 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton == 0 
		PickLegendary(IFF_Weapon_Cut_LegendaryRank, 2)
	elseif aiButton == 1
		PickQualityWeapon()
	elseif aiButton == 2
		PickDestination(IFF_Weapon_AboveCut_Destination, 8)
	elseif aiButton == 3
		PickDestination(IFF_Weapon_BelowCut_Destination, 8)
	elseif aiButton == 4
		ShowMenu4()
	endif
EndFunction


Function PickDestination(GlobalVariable destinationGlobal, int callerMenu)

	; Debug.Trace("IFC --> PickDestination " + ( destinationGlobal as string) + " " + callerMenu,0)
	int aiButton
	aiButton = PickDestination_MESG.Show(destinationGlobal.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton < 3 
		destinationGlobal.SetValueInt(aiButton)
	endif
	if callerMenu == 1 
		ShowMenu1()
	elseif callerMenu == 2 
		ShowMenu2()
	elseif callerMenu == 3 
		ShowMenu3()
	elseif callerMenu == 4 
		ShowMenu4()
	elseif callerMenu == 5 
		ShowMenuArmor()
	elseif callerMenu == 6 
		ShowMenuRepairKits()
	elseif callerMenu == 7 
		ShowMenuResources()
	elseif callerMenu == 8 
		ShowMenuWeapon()
	endif
EndFunction


Function PickDestinationFloraFauna(GlobalVariable destinationGlobal, int callerMenu)

	; Debug.Trace("IFC --> PickDestinationFloraFauna " + ( destinationGlobal as string) + " " + callerMenu,0)
	int aiButton
	aiButton = PickDestinationFloraFauna_MESG.Show(destinationGlobal.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton < 4 
		destinationGlobal.SetValueInt(aiButton)
	endif
	if callerMenu == 1 
		ShowMenu1()
	elseif callerMenu == 2 
		ShowMenu2()
	elseif callerMenu == 3 
		ShowMenu3()
	elseif callerMenu == 4 
		ShowMenu4()
	endif
EndFunction


Function PickLegendary(GlobalVariable legendaryGlobal, int callerMenu)

	; Debug.Trace("IFC --> PickLegendary " + ( legendaryGlobal as string) + " " + callerMenu,0)
	int aiButton
	aiButton = PickLegendary_MESG.Show(legendaryGlobal.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton < 5 
		legendaryGlobal.SetValueInt(aiButton)
	endif
	if callerMenu == 1 
		ShowMenuArmor()
	elseif callerMenu == 2 
		ShowMenuWeapon()
	endif
EndFunction


Function PickQualityArmor()

	; Debug.Trace("IFC --> PickQualityArmor " + ( IFF_Armor_Cut_QualityLevel as string),0)
	int aiButton
	aiButton = PickQualityArmor_MESG.Show(IFF_Armor_Cut_QualityLevel.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton < 6 
		IFF_Armor_Cut_QualityLevel.SetValueInt(aiButton)
	endif
	ShowMenuArmor()
EndFunction


Function PickQualityWeapon()

	; Debug.Trace("IFC --> PickQualityWeapon " + ( IFF_Weapon_Cut_QualityLevel as string),0)
	int aiButton
	aiButton = PickQualityWeapon_MESG.Show(IFF_Weapon_Cut_QualityLevel.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton < 5 
		IFF_Weapon_Cut_QualityLevel.SetValueInt(aiButton)
	endif
	ShowMenuWeapon()
EndFunction


Function PickRarity()

	; Debug.Trace("IFC --> PickRarity " + ( IFF_Resources_Cut_Rarity as string),0)
	int aiButton
	aiButton = PickRarity_MESG.Show(IFF_Resources_Cut_Rarity.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
	if aiButton < 6 
		IFF_Resources_Cut_Rarity.SetValueInt(aiButton)
	endif
	ShowMenuResources()
EndFunction


Function PickMaxRepairKits()

	; Debug.Trace("IFC --> PickMaxRepairKits " + ( IFF_ShipRepairKits_MaxNumberAtPrimary as string),0)
	int aiButton = 0
	While aiButton < 5
		aiButton = PickMaxRepairKits_MESG.Show(IFF_ShipRepairKits_MaxNumberAtPrimary.GetValueInt() as float, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 )
		if aiButton == 0
			IFF_ShipRepairKits_MaxNumberAtPrimary.SetValueInt(0)
		elseif aiButton == 1
			IFF_ShipRepairKits_MaxNumberAtPrimary.SetValueInt(IFF_ShipRepairKits_MaxNumberAtPrimary.GetValueInt() - 10)
		elseif aiButton == 2
			IFF_ShipRepairKits_MaxNumberAtPrimary.SetValueInt(IFF_ShipRepairKits_MaxNumberAtPrimary.GetValueInt() - 1)
		elseif aiButton == 3
			IFF_ShipRepairKits_MaxNumberAtPrimary.SetValueInt(IFF_ShipRepairKits_MaxNumberAtPrimary.GetValueInt() + 1)
		elseif aiButton == 4
			IFF_ShipRepairKits_MaxNumberAtPrimary.SetValueInt(IFF_ShipRepairKits_MaxNumberAtPrimary.GetValueInt() + 10)
		endif
	EndWhile
	ShowMenuResources()
EndFunction



