Scriptname IFF_FilterLoot extends ObjectReference

;-- Properties --------------------------------------

;------ Containers ----------------------------------
ObjectReference Property Container_OutgoingREF Auto Const
Actor Property PC Auto
ReferenceAlias Property CargoHold Auto



;------ Miscs ---------------------------
MiscObject Property CurrencyCredits Auto
MiscObject Property Digipick Auto

;------ Itemtype Keywords ---------------------------
Keyword Property Keyword_Aid Auto Const
Keyword Property Keyword_Ammo Auto Const
Keyword Property Keyword_Apparel Auto Const
Keyword Property Keyword_Backpack Auto Const
Keyword Property Keyword_Book Auto Const
Keyword Property Keyword_Chem1 Auto Const ; Normal Chems
Keyword Property Keyword_Chem2 Auto Const ;Alien Genetic
Keyword Property Keyword_Contraband Auto Const 
Keyword Property Keyword_CraftingGeneric Auto Const ;Chambass;Teas
Keyword Property Keyword_Drink Auto Const
Keyword Property Keyword_Fauna Auto Const
Keyword Property Keyword_Flora Auto Const
Keyword Property Keyword_Food Auto Const
Keyword Property Keyword_Gas Auto Const
Keyword Property Keyword_Helmet Auto Const
Keyword Property Keyword_Junk Auto Const
Keyword Property Keyword_Key Auto Const
Keyword Property Keyword_Liquid Auto Const
Keyword Property Keyword_Manufactured Auto Const
Keyword Property Keyword_MissionCargo Auto Const
Keyword Property Keyword_MQArtifact Auto Const
Keyword Property Keyword_Organic Auto Const
Keyword Property Keyword_ShipRepairKit Auto Const
Keyword Property Keyword_Solid Auto Const
Keyword Property Keyword_Suit Auto Const
Keyword Property Keyword_Survey Auto Const
Keyword Property Keyword_Throwable Auto Const
Keyword Property Keyword_Weapon Auto Const
Keyword Property Keyword_WeaponMelee Auto Const


;------ Quality Keywords ---------------------------
Keyword Property Keyword_ArmorLegendaryRank1 Auto Const
Keyword Property Keyword_ArmorLegendaryRank2 Auto Const
Keyword Property Keyword_ArmorLegendaryRank3 Auto Const
Keyword Property Keyword_ArmorQuality2 Auto Const
Keyword Property Keyword_ArmorQuality3 Auto Const
Keyword Property Keyword_ArmorQuality4 Auto Const
Keyword Property Keyword_ArmorQuality5 Auto Const
Keyword Property Keyword_ResourceRarity00Common Auto Const
Keyword Property Keyword_ResourceRarity01Uncommon Auto Const
Keyword Property Keyword_ResourceRarity02Rare Auto Const
Keyword Property Keyword_ResourceRarity03Exotic Auto Const
Keyword Property Keyword_ResourceRarity04Unique Auto Const
Keyword Property Keyword_WeaponLegendaryRank1 Auto Const
Keyword Property Keyword_WeaponLegendaryRank2 Auto Const
Keyword Property Keyword_WeaponLegendaryRank3 Auto Const
Keyword Property Keyword_WeaponQuality2 Auto Const
Keyword Property Keyword_WeaponQuality3 Auto Const
Keyword Property Keyword_WeaponQuality4 Auto Const




;------ IFF Config Globals ---------------------------------

GlobalVariable Property IFF_Config_Version Auto
GlobalVariable Property IFF_Aid_Destination Auto  
GlobalVariable Property IFF_Ammo_Destination Auto
GlobalVariable Property IFF_Apparel_Destination Auto
GlobalVariable Property IFF_Armor_AboveCut_Destination Auto
GlobalVariable Property IFF_Armor_BelowCut_Destination Auto
GlobalVariable Property IFF_Armor_Cut_LegendaryRank Auto
GlobalVariable Property IFF_Armor_Cut_QualityLevel Auto
GlobalVariable Property IFF_Books_Destination Auto
GlobalVariable Property IFF_Chems_Destination Auto
GlobalVariable Property IFF_Contraband_Destination Auto
GlobalVariable Property IFF_CraftingGeneric_Destination Auto
GlobalVariable Property IFF_Drinks_Destination Auto
GlobalVariable Property IFF_Fauna_Destination Auto
GlobalVariable Property IFF_Flora_Destination Auto
GlobalVariable Property IFF_Food_Destination Auto
GlobalVariable Property IFF_Junk_Destination Auto
GlobalVariable Property IFF_Manufactured_Destination Auto
GlobalVariable Property IFF_Resources_AboveCut_Destination Auto
GlobalVariable Property IFF_Resources_BelowCut_Destination Auto
GlobalVariable Property IFF_Resources_Cut_Rarity Auto
GlobalVariable Property IFF_ShipRepairKits_MaxNumberAtPrimary Auto
GlobalVariable Property IFF_ShipRepairKits_Primary_Destination Auto
GlobalVariable Property IFF_ShipRepairKits_Secondary_Destination Auto
GlobalVariable Property IFF_Surveys_Destination Auto
GlobalVariable Property IFF_Throwables_Destination Auto
GlobalVariable Property IFF_Uncategorized_Destination Auto
GlobalVariable Property IFF_Weapon_AboveCut_Destination Auto
GlobalVariable Property IFF_Weapon_BelowCut_Destination Auto
GlobalVariable Property IFF_Weapon_Cut_LegendaryRank Auto
GlobalVariable Property IFF_Weapon_Cut_QualityLevel Auto




;-- Events ---------------------------------------

Event OnInit()
	AddInventoryEventFilter(none)
EndEvent


Event OnItemAdded(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)


	; Debug.Trace("IFF --> SourceContainer : " + akSourceContainer.GetFormID() + " " + akSourceContainer as string + "   " + akSourceContainer.getBaseObject() as string + " Reason = " + aiTransferReason,0)  

;Fixed destinations
	if akBaseItem == Digipick || akBaseItem == CurrencyCredits || akBaseItem.hasKeyword(Keyword_Key) || akBaseItem.hasKeyword(Keyword_MQArtifact)
		; Debug.Trace("IFF --> Digipick,Credits,Keys, Artifact",0)  
		RemoveItem(akBaseItem, aiItemCount, false, PC as ObjectReference)
	elseif akBaseItem.hasKeyword(Keyword_MissionCargo)
		; Debug.Trace("IFF --> MissionCargo",0)  
		RemoveItem(akBaseItem, aiItemCount, true, CargoHold.GetRef())
;Configurable destinations
	elseif akBaseItem.hasKeyword(Keyword_Contraband) ; Contraband can be any kind of itemtype; treat first
		; Debug.Trace("IFF --> Contraband",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Contraband_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Aid)
		; Debug.Trace("IFF --> Aid",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Aid_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Ammo)
		; Debug.Trace("IFF --> Ammo",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Ammo_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Apparel)
		; Debug.Trace("IFF --> Apparel",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Apparel_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Backpack)
		; Debug.Trace("IFF --> Backpack",0)  
		handleArmor( akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Survey)                        ; Surveys are subset of books, treat before books
		; Debug.Trace("IFF --> Survey",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Surveys_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Book)
		; Debug.Trace("IFF --> Book",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Books_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Chem1) || akBaseItem.hasKeyword(Keyword_Chem1)
		; Debug.Trace("IFF --> Chem",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Chems_Destination)
	elseif akBaseItem.hasKeyword(Keyword_CraftingGeneric)
		; Debug.Trace("IFF --> CraftingGeneric",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_CraftingGeneric_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Drink)
		; Debug.Trace("IFF --> Drink",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Drinks_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Fauna)
		; Debug.Trace("IFF --> Fauna",0)  
		if IFF_Fauna_Destination.getValueInt() == 3  ; 3 : Treat like regular resources
			handleResource( akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
		else	
			moveItem(akBaseItem, aiItemCount, true, IFF_Fauna_Destination)
		endif
	elseif akBaseItem.hasKeyword(Keyword_Flora)
		; Debug.Trace("IFF --> Flora",0)  
		if IFF_Flora_Destination.getValueInt() == 3   ; 3 : Treat like regular resources
			handleResource( akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
		else	
			moveItem(akBaseItem, aiItemCount, true, IFF_Flora_Destination)
		endif
	elseif akBaseItem.hasKeyword(Keyword_Food)
		; Debug.Trace("IFF --> Food",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Food_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Gas)
		; Debug.Trace("IFF --> Gas",0)  
		handleResource( akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Helmet)
		; Debug.Trace("IFF --> Helmet",0)  
		handleArmor( akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Junk)
		; Debug.Trace("IFF --> Junk",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Junk_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Liquid)
		; Debug.Trace("IFF --> Liquid",0)  
		handleResource( akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Manufactured)
		; Debug.Trace("IFF --> Manufactured",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Manufactured_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Organic)
		; Debug.Trace("IFF --> Organic",0)  
		handleResource(akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_ShipRepairKit)
		; Debug.Trace("IFF --> ShipRepairKit",0)  
		handleShipRepairKit(akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Solid)
		; Debug.Trace("IFF --> Solid",0)  
		handleResource(akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Suit)
		; Debug.Trace("IFF --> Suit",0)  
		handleArmor(akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	elseif akBaseItem.hasKeyword(Keyword_Throwable)
		; Debug.Trace("IFF --> Throwable",0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Throwables_Destination)
	elseif akBaseItem.hasKeyword(Keyword_Weapon) ||  akBaseItem.hasKeyword(Keyword_WeaponMelee)
		; Debug.Trace("IFF --> Weapon",0)  
		handleWeapon(akBaseItem,  aiItemCount,  akItemReference,  akSourceContainer,  aiTransferReason)
	else
		Debug.Trace("IFF --> WHOAAA!!! Something else : " + akBaseItem.GetFormID(),0)  
		moveItem(akBaseItem, aiItemCount, true, IFF_Uncategorized_Destination)
	endif
EndEvent


;-- Functions ---------------------------------------


Function moveItem(Form akBaseItem, Int aiItemCount, bool abSilent, GlobalVariable itemTypeDestinationGlobal)

	int itemTypeDestination = itemTypeDestinationGlobal.GetValueInt()
	if itemTypeDestination == 0
		RemoveItem(akBaseItem, aiItemCount, abSilent, None)
	elseif itemTypeDestination == 1
		RemoveItem(akBaseItem, aiItemCount, abSilent, ( PC as ObjectReference ))
	elseif itemTypeDestination == 2
		RemoveItem(akBaseItem, aiItemCount, abSilent, CargoHold.GetRef())
	else
		RemoveItem(akBaseItem, aiItemCount, abSilent, ( PC as ObjectReference ))
	endif
EndFunction


Function removeItemFromOutgoing(Form akBaseItem, Int aiItemCount, bool abSilent, GlobalVariable itemTypeDestinationGlobal)

	int itemTypeDestination = itemTypeDestinationGlobal.GetValueInt()
	if itemTypeDestination == 0
		Container_OutgoingREF.RemoveItem(akBaseItem, aiItemCount, abSilent, None)
	elseif itemTypeDestination == 1
		Container_OutgoingREF.RemoveItem(akBaseItem, aiItemCount, abSilent, ( PC as ObjectReference ))
	elseif itemTypeDestination == 2
		Container_OutgoingREF.RemoveItem(akBaseItem, aiItemCount, abSilent, CargoHold.GetRef())
	else
		Container_OutgoingREF.RemoveItem(akBaseItem, aiItemCount, abSilent, ( PC as ObjectReference ))
	endif
EndFunction


Function handleWeapon(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)

	int i = 0
	While i < aiItemCount ; 
		ObjectReference itemRef = Self.DropObject(akBaseItem, 1) 
		int lrank = 0
		int lcount = 0
		int qrank = 0
		int qcount = 0
		if itemRef.hasKeyword(Keyword_WeaponLegendaryRank1)
			lrank = 1
			lcount = lcount + 1
		endif
		if itemRef.hasKeyword(Keyword_WeaponLegendaryRank2)
			lrank = 2
			lcount = lcount + 1
		endif
		if itemRef.hasKeyword(Keyword_WeaponLegendaryRank3)
			lrank = 3
			lcount = lcount + 1
		endif
		if itemRef.hasKeyword(Keyword_WeaponQuality2)
			qrank = 1
			qcount = qcount + 1
		endif
		if itemRef.hasKeyword(Keyword_WeaponQuality3)
			qrank = 2
			qcount = qcount + 1
		endif
		if itemRef.hasKeyword(Keyword_WeaponQuality4)
			qrank = 3
			qcount = qcount + 1
		endif

		Container_OutgoingREF.AddItem(itemRef as Form, 1, True) ;move to outgoing so can avoid filtering loops if destination has itemfilterframework too
		if lrank < IFF_Weapon_Cut_LegendaryRank.getValueInt() && qrank < IFF_Weapon_Cut_QualityLevel.getValueInt()
			removeItemFromOutgoing(akBaseItem, 1, false, IFF_Weapon_BelowCut_Destination)
		else
			removeItemFromOutgoing(akBaseItem, 1, false, IFF_Weapon_AboveCut_Destination)
		endif
		i += 1 ; 
	EndWhile
EndFunction



Function handleArmor(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)

	int i = 0
	While i < aiItemCount 
		ObjectReference itemRef = Self.DropObject(akBaseItem, 1) 
		int lrank = 0
		int lcount = 0
		int qrank = 0
		int qcount = 0
		if itemRef.hasKeyword(Keyword_ArmorLegendaryRank1)
			lrank = 1
			lcount = lcount + 1
		endif
		if itemRef.hasKeyword(Keyword_ArmorLegendaryRank2)
			lrank = 2
			lcount = lcount + 1
		endif
		if itemRef.hasKeyword(Keyword_ArmorLegendaryRank3)
			lrank = 3
			lcount = lcount + 1
		endif
		if itemRef.hasKeyword(Keyword_ArmorQuality2)
			qrank = 1
			qcount = qcount + 1
		endif
		if itemRef.hasKeyword(Keyword_ArmorQuality3)
			qrank = 2
			qcount = qcount + 1
		endif
		if itemRef.hasKeyword(Keyword_ArmorQuality4)
			qrank = 3
			qcount = qcount + 1
		endif
		if itemRef.hasKeyword(Keyword_ArmorQuality5)
			qrank = 4
			qcount = qcount + 1
		endif

		If lrank > 0 || lcount > 0
			; Debug.Trace("IFF --> ALegendary " + i + " " + lrank + " " + lcount,0)  
		endif
		If qrank > 0 || qcount > 0
			; Debug.Trace("IFF --> AQuality "   + i + " " + qrank + " " + qcount,0)  
		endif

		Container_OutgoingREF.AddItem(itemRef as Form, 1, True) ;move to outgoing so can avoid filtering loops if destination has itemfilterframework too
		if lrank < IFF_Armor_Cut_LegendaryRank.getValueInt() && qrank < IFF_Armor_Cut_QualityLevel.getValueInt()
			removeItemFromOutgoing(akBaseItem, 1, false, IFF_Armor_BelowCut_Destination)
		else
			removeItemFromOutgoing(akBaseItem, 1, false, IFF_Armor_AboveCut_Destination)
		endif
		i += 1 ; 
	EndWhile
EndFunction


Function handleResource(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)

	int rarity = 0
	if akBaseItem.hasKeyword(Keyword_ResourceRarity00Common)
		rarity = 1
	elseif akBaseItem.hasKeyword(Keyword_ResourceRarity01Uncommon)
		rarity = 2
	elseif akBaseItem.hasKeyword(Keyword_ResourceRarity02Rare)
		rarity = 3
	elseif akBaseItem.hasKeyword(Keyword_ResourceRarity03Exotic)
		rarity = 4
	elseif akBaseItem.hasKeyword(Keyword_ResourceRarity04Unique)
		rarity = 5
	endif
	
	if rarity < IFF_Resources_Cut_Rarity.getValueInt()
		moveItem(akBaseItem, aiItemCount, true, IFF_Resources_BelowCut_Destination)
	else
		moveItem(akBaseItem, aiItemCount, true, IFF_Resources_AboveCut_Destination)
	endif
	
	; Debug.Trace("IFF --> Rarity " + rarity,0)  
EndFunction


Function handleShipRepairKit(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)

	int countAtPrimary 
	int itemTypeDestination = IFF_ShipRepairKits_Primary_Destination.GetValueInt()
	if itemTypeDestination == 0
		countAtPrimary = -1
	elseif itemTypeDestination == 1
		countAtPrimary = ( PC as ObjectReference ).GetItemCount(akBaseItem)
	elseif itemTypeDestination == 2
		countAtPrimary = CargoHold.GetRef().GetItemCount(akBaseItem)
	else
		countAtPrimary = ( PC as ObjectReference ).GetItemCount(akBaseItem)
	endif
	if countAtPrimary > IFF_ShipRepairKits_MaxNumberAtPrimary.getValueInt() || IFF_ShipRepairKits_MaxNumberAtPrimary.getValueInt() < 1
		moveItem(akBaseItem, aiItemCount, true,IFF_ShipRepairKits_Secondary_Destination)
	else 
		moveItem(akBaseItem, aiItemCount, true,IFF_ShipRepairKits_Primary_Destination)
	endif

	; Debug.Trace("IFF --> PrimaryCount " + countAtPrimary,0)  
EndFunction



