ScriptName MissionBoardsAnywhereAliasScript Extends ReferenceAlias

ObjectReference Property MissionBoardsAnywhereItemRef Auto
Message Property MissionBoardsAnywhereMessage Auto
Form Property MissionBoardsAnywhereItem Auto
Actor Property PlayerRef Auto
ObjectReference[] Property MissionBoards Auto
Location[] Property MissionBoardLocations Auto

Event OnAliasInit()
	SetUp()
EndEvent

Event OnPlayerLoadGame()
	SetUp()
EndEvent

Function SetUp()
	PlayerRef.AddItem(MissionBoardsAnywhereItemRef, 1, False)
EndFunction

Event OnItemEquipped(Form akBaseObject, ObjectReference akReference)
	PlayerRef.UnequipItem(MissionBoardsAnywhereItem, False, True)
	If Game.IsMenuControlsEnabled() || Game.IsFavoritesControlsEnabled()
		If akBaseObject == MissionBoardsAnywhereItem
			ShowBoardSelector()
		EndIf
	EndIf
EndEvent

Function ShowBoardSelector()
	Int index = MissionBoardsAnywhereMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	If index >= 0
		MissionBoardActivatorScript boardRef = MissionBoards[index] As MissionBoardActivatorScript
		If boardRef
			RegisterForMenuOpenCloseEvent("MissionBoard")
			Location boardLocation = MissionBoardLocations[index]
			boardRef.MB_Parent.ResetMissions(False, False, boardLocation, True)
			boardRef.Activate(PlayerRef, False)
		Else
			RegisterForMenuOpenCloseEvent("GenesisTerminalMenu")
			MissionBoards[index].Activate(PlayerRef, False)
		EndIf
	EndIf
EndFunction

Event OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)
	If !abOpening
		UnregisterForAllMenuOpenCloseEvents()
		ShowBoardSelector()
	EndIf
EndEvent