// ReShade.fxh is included here
#include "ReShade.fxh"

// UIDetect.fxh is included here
#include "UIDetect.fxh"

// Define the uniform variables with annotations
uniform float SaturationThreshold < 
    ui_label = "Saturation Threshold";
    ui_tooltip = "Threshold for adjusting saturation";
    ui_min = 0.0; ui_max = 1.0;
> = 0.5;

uniform float ExposureIntensity < 
    ui_label = "Exposure Intensity";
    ui_tooltip = "Intensity of the exposure adjustment";
    ui_min = 0.0; ui_max = 2.0;
> = 0.5;

float3 ReshadeSaturationExposure(float4 position : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
    float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;

    // Convert the color to grayscale
    float luminance = dot(color.rgb, float3(0.299, 0.587, 0.114));

    // Calculate the saturation
    float saturation = 1.0 - saturate(luminance);

    // Adjust exposure for pixels below the threshold
    color.rgb *= saturate(1.0 - saturation * ExposureIntensity);

    return color;
}

// Technique and pass definition
technique ReshadeSaturationExposure
{
    pass
    {
        VertexShader = PostProcessVS;
        PixelShader = ReshadeSaturationExposure;
    }
}

