// ReShade.fxh is included here
#include "ReShade.fxh"

// UIDetect.fxh is included here
#include "UIDetect.fxh"

// Define the uniform variables with annotations
uniform float SaturationThreshold < 
    ui_label = "Saturation Threshold";
    ui_tooltip = "Threshold for adjusting saturation";
    ui_min = 0.0; ui_max = 1.0;
> = 0.5;

uniform float SaturationIntensity < 
    ui_label = "Saturation Intensity";
    ui_tooltip = "Intensity of the saturation adjustment";
    ui_min = 0.0; ui_max = 2.0;
> = 1.0;

float3 SaturationControl(float4 position : SV_Position, float2 texcoord : TexCoord) : SV_Target
{
    float3 color = tex2D(ReShade::BackBuffer, texcoord).rgb;

    // Convert the color to grayscale
    float luminance = dot(color.rgb, float3(0.299, 0.587, 0.114));

    // Calculate the saturation
    float saturation = 1.0 - saturate(luminance);

    // Adjust saturation for pixels below the threshold
    color.rgb = (saturation < SaturationThreshold) ? color.rgb * (2 * SaturationIntensity) : color.rgb;

    return color;
}

// Technique and pass definition
technique SaturationControl
{
    pass
    {
        VertexShader = PostProcessVS;
        PixelShader = SaturationControl;
    }
}
