ScriptName Starvegas_Killcam_SlowmoFX extends activemagiceffect

Actor Property PlayerRef Auto Const
ActorValue Property MovementSpeed Auto Const
Quest Property RedirectToStarvegasKillcamMain Auto Const
ImageSpaceModifier Property StarvegasKillcam_IMAD_SlowmoShootIn Auto Const
ImageSpaceModifier Property StarvegasKillcam_IMAD_SlowmoShootOut Auto Const
ImageSpaceModifier Property StarvegasKillcam_IMAD_Flash Auto Const
MusicType Property MusicSilence Auto Const
GlobalVariable Property StarvegasKillcam_IMADs_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_SoundsFX_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_MusicMute_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_UI_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_Invincibility_Toggle Auto Const
wwiseevent Property StarvegasKillcam_AudioFXEnter Auto Const
wwiseevent Property StarvegasKillcam_AudioFXEnd Auto Const
wwiseevent SlowmoSoundFX
Int SlowmoSoundFXInstance = -1

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
				
        SpecialFXStart()
		AnimationSpeedMod()
		RegisterForAnimationEvent(PlayerRef, "weaponFire")				
        RegisterForMenuOpenCloseEvent("ContainerMenu")
        RegisterForMenuOpenCloseEvent("PauseMenu")
        RegisterForMenuOpenCloseEvent("DataMenu")

EndEvent

Event OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)

         If asMenuName == "ContainerMenu" || asMenuName == "PauseMenu" || asMenuName == "DataMenu"
                  If abOpening == True
					 	  If StarvegasKillcam_UI_Toggle.GetValue() == 1		 
							 Debug.EnableMenus(True)
                             Game.SetCharGenHUDMode(0)
					   EndIf	
			 Else
					 	  If StarvegasKillcam_UI_Toggle.GetValue() == 1		 
		                     Debug.EnableMenus(False)
                             Game.SetCharGenHUDMode(3)
					   EndIf
			   EndIf
        
      EndIf

EndEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
     
     If(asEventName == "weaponFire")
        SpecialFXOnFireEvent()
  EndIf

EndEvent

Function SpecialFXOnFireEvent()
      
	  If StarvegasKillcam_IMADs_Toggle.GetValue() == 1
         StarvegasKillcam_IMAD_SlowmoShootIn.Apply(0.2)
         StarvegasKillcam_IMAD_SlowmoShootIn.PopTo(StarvegasKillcam_IMAD_SlowmoShootOut, 0.2)
   EndIf

Endfunction

Function SpecialFXStart()
      
	  If StarvegasKillcam_Invincibility_Toggle.GetValue() == 1
		 PlayerRef.SetGhost(True)
   EndIf	 
	  
	  If StarvegasKillcam_UI_Toggle.GetValue() == 1
		 Debug.EnableMenus(False)
         Game.SetCharGenHUDMode(3)
   EndIf
	  
	  If StarvegasKillcam_IMADs_Toggle.GetValue() == 1
		 StarvegasKillcam_IMAD_Flash.Apply(1.0)
   EndIf
	  
	  If StarvegasKillcam_MusicMute_Toggle.GetValue() == 1
		 MusicSilence.Add()
   EndIf
	  
	  If StarvegasKillcam_SoundsFX_Toggle.GetValue() == 1
		 StarvegasKillcam_AudioFXEnd.Play(PlayerRef, None, None)
		 wwiseevent.StopInstance(SlowmoSoundFXInstance)
         SlowmoSoundFX = StarvegasKillcam_AudioFXEnter
         SlowmoSoundFXInstance = SlowmoSoundFX.Play(PlayerRef, None, None)
   EndIf

Endfunction

Function SpecialFXEnd()
      
	  If StarvegasKillcam_Invincibility_Toggle.GetValue() == 1
		 PlayerRef.SetGhost(False)
   EndIf	 
	  	  
	  If StarvegasKillcam_IMADs_Toggle.GetValue() == 1
		 StarvegasKillcam_IMAD_Flash.Apply(1.0)		 
   EndIf	 
	  
	  If StarvegasKillcam_MusicMute_Toggle.GetValue() == 1		 
		 MusicSilence.Remove()
   EndIf	 
	 
	  If StarvegasKillcam_SoundsFX_Toggle.GetValue() == 1
		 wwiseevent.StopInstance(SlowmoSoundFXInstance)		
	     StarvegasKillcam_AudioFXEnd.Play(PlayerRef, None, None) 
   EndIf

Endfunction

Function AnimationSpeedMod()

        Float fMotion = PlayerRef.GetValue(MovementSpeed) - (RedirectToStarvegasKillcamMain as Starvegas_Killcam).AnimationSpeedMult

        PlayerRef.ModValue(MovementSpeed, -fMotion)

Endfunction

Function AnimationSpeedReset()

        Float fMotionRestore = 100 - PlayerRef.GetValue(MovementSpeed)

        PlayerRef.ModValue(MovementSpeed, fMotionRestore)

Endfunction

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
        
		UnregisterForAnimationEvent(PlayerRef, "weaponFire")
		UnregisterForMenuOpenCloseEvent("ContainerMenu")
        UnregisterForMenuOpenCloseEvent("PauseMenu")
        UnregisterForMenuOpenCloseEvent("DataMenu")		
		
		SpecialFXEnd()
		AnimationSpeedReset()
        
		Game.SetCameraTarget(PlayerRef)
		
		(RedirectToStarvegasKillcamMain as Starvegas_Killcam).StartCooler()
		(RedirectToStarvegasKillcamMain as Starvegas_Killcam).CinematicFOVReturn()
		(RedirectToStarvegasKillcamMain as Starvegas_Killcam).HUDTurnOn()

EndEvent

