ScriptName Starvegas_Killcam extends Quest

string Property COM = "COM" Auto conditional

Quest Property RestartTranslation Auto Const

Actor Property PlayerRef Auto Const
ActorBase Property StarvegasKillcam_Camera Auto

ActorValue Property StarvegasKillcam_AV_SlowmotionSpeed Auto Const
ActorValue Property StarvegasKillcam_AV_SlowmotionDur Auto Const
ActorValue Property StarvegasKillcam_AV_AnimationSpeed Auto Const

Spell Property StarvegasKillcam_SlowmoEffect Auto
Spell Property StarvegasKillcam_SlowmoEffect_Spaceship Auto

Perk Property StarvegasKillcam_SlowmotionMode_Always Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_Combat Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_LastHostile Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_Oneshot Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_OneshotLastHostile Auto Const
Perk Property StarvegasKillcam_SlowmoPower Auto Const

Message Property MSG_StarvegasConfBookMain Auto Const
Message Property MSG_StarvegasConfBookMainCooldown Auto Const
Message Property MSG_StarvegasConfBookMainProperties Auto Const
Message Property MSG_StarvegasConfBookMainDebug Auto Const
Message Property MSG_StarvegasConfBookMainModes Auto Const
Message Property MSG_StarvegasConfBookMainEnabledRaces Auto Const
Message Property MSG_StarvegasConfBookMainTriggerChance Auto Const
Message Property MSG_StarvegasConfBookMainSpecialFX Auto Const
Message Property MSG_StarvegasConfBookMainCamera Auto Const
Message Property MSG_StarvegasConfBookMainCameraPlayer Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcam Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcamFOV Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcamDistance Auto Const
Message Property MSG_StarvegasConfBookNotificationReset Auto Const
Message Property MSG_StarvegasConfBookNotificationUninstall Auto Const

GlobalVariable Property StarvegasKillcam_SlowmoChanceLastHostile Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceLastHostileOneshot Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceOneshot Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceCombat Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceAlways Auto Const
GlobalVariable Property StarvegasKillcam_Modes Auto Const
GlobalVariable Property StarvegasKillcam_CinematicChance Auto Const
GlobalVariable Property StarvegasKillcam_PlayerVsTargetChance Auto Const
GlobalVariable Property StarvegasKillcam_IMADs_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_IMADs_SS_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_SoundsFX_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_RecoilFX_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_MusicMute_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_UI_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_Invincibility_Toggle Auto Const

GlobalVariable Property StarvegasKillcam_ActiveRaceHuman Auto Const
GlobalVariable Property StarvegasKillcam_ActiveRaceCreature Auto Const
GlobalVariable Property StarvegasKillcam_ActiveRaceRobot Auto Const
GlobalVariable Property StarvegasKillcam_ActiveRaceSpaceship Auto Const

FormList Property StarvegasKillcam_HumanRaces Auto Const
FormList Property StarvegasKillcam_RobotRaces Auto Const
FormList Property StarvegasKillcam_CreatureRaces Auto Const
FormList Property StarvegasKillcam_SpaceshipRaces Auto Const

float Property CinematicCameraFirstPersonFOV5 = 60.0 Auto
float Property CinematicCameraFirstPersonGeometryFOV5 = 60.0 Auto
float Property CinematicCameraThirdPersonFOV5 = 40.0 Auto

float Property CinematicCameraFirstPersonFOV25 = 40.0 Auto
float Property CinematicCameraFirstPersonGeometryFOV25 = 40.0 Auto
float Property CinematicCameraThirdPersonFOV25 = 30.0 Auto

float Property DefaultCameraFirstPersonFOV = 94.0 Auto
float Property DefaultCameraFirstPersonGeometryFOV = 94.0 Auto
float Property DefaultCameraThirdPersonFOV = 94.0 Auto

float Property DefaultFlightCameraFOV = 90.0 Auto
float Property CinematicFlightCameraFOV = 40.0 Auto

float Property Cooldown = 15.0 Auto

float Property CinematicCameraTriggerDistanceShort = 8.0 Auto
float Property CinematicCameraTriggerDistanceMedium = 24.0 Auto
float Property CinematicCameraTriggerDistanceLong = 50.0 Auto

float Property SlowmotionSpeedMult = 0.1 Auto
float Property SlowmotionSpeedDur = 4.0 Auto
float Property AnimationSpeedMult = 20.0 Auto

float Property CinematicZoomOutMin = 0.21 Auto
float Property CinematicZoomOutMax = 0.24 Auto

bool KillcamCooldown = False

Actor View

Event OnQuestInit()
      
	  PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile, False)
	  PlayerRef.Addperk(StarvegasKillcam_SlowmoPower, False)
	  RegisterForAnimationEvent(PlayerRef, "weaponFire")
      RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
	  SlowmotionAVUpdate()
      
	  Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 0)

EndEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
     
     If(asEventName == "weaponFire")
         If StarvegasKillcam_RecoilFX_Toggle.GetValue() == 1
		    Game.ShakeCamera(PlayerRef, 0.5, 0.2)
      EndIf
  EndIf

EndEvent

Event OnTimer(int aiTimerID)

	If (aiTimerID == 0)
	   Cooler()      
 EndIf

EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)

    CinematicFOVReturn()
	KillcamReset()
    SlowmotionAVUpdate()
	Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 0)

EndEvent

Function FullyReset()
         		 
		 PlayerRef.DispelSpell(StarvegasKillcam_SlowmoEffect)
		 
		 Utility.Wait(0.5)
		 
		 UnregisterForAnimationEvent(PlayerRef, "weaponFire")
         UnregisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
         
		 Utility.Wait(0.5)
		 
		 KillcamReset()
         
		 Utility.Wait(0.5)
		 
		 Utility.SetINIFloat("fDefault1stPersonFOV:Camera", 90) 
	     Utility.SetINIFloat("fFPWorldFOV:Camera", 90) 
	     Utility.SetINIFloat("fTPWorldFOV:Camera", 90)
		 Utility.SetINIFloat("fFPGeometryFOV:Camera", 90)		 
		 
		 Utility.Wait(0.5)
         
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Always)	
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)
		 PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile, False)					 
		 PlayerRef.Addperk(StarvegasKillcam_SlowmoPower, False)		
		 
		 StarvegasKillcam_Modes.SetValue(2)		 
		 
		 Utility.Wait(0.5)
		 
		 RegisterForAnimationEvent(PlayerRef, "weaponFire")
         RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
        
	     Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 0)
		 
		 RestartTranslation.Stop()
		 RestartTranslation.Start()
		 
		 MSG_StarvegasConfBookNotificationReset.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

EndFunction

Function EmergencyFallout()
		 
		 PlayerRef.DispelSpell(StarvegasKillcam_SlowmoEffect)          
		 
		 Utility.Wait(0.5)
		 
		 UnregisterForAnimationEvent(PlayerRef, "weaponFire")
         UnregisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
         
		 Utility.Wait(0.5)
		 
		 KillcamReset()
         
		 Utility.Wait(0.5)
		 
		 Utility.SetINIFloat("fDefault1stPersonFOV:Camera", 90) 
	     Utility.SetINIFloat("fFPWorldFOV:Camera", 90) 
	     Utility.SetINIFloat("fTPWorldFOV:Camera", 90)
		 Utility.SetINIFloat("fFPGeometryFOV:Camera", 90)
		 
		 Utility.Wait(0.5)
		 
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Always)	
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
		 PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)      
		 
		 Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 1.429)
		 
		 RestartTranslation.Stop()
		 
		 MSG_StarvegasConfBookNotificationReset.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

EndFunction

Function SlowmotionAVUpdate()

	     PlayerRef.SetValue(StarvegasKillcam_AV_SlowmotionSpeed, SlowmotionSpeedMult)
	     PlayerRef.SetValue(StarvegasKillcam_AV_SlowmotionDur, SlowmotionSpeedDur)
         PlayerRef.SetValue(StarvegasKillcam_AV_AnimationSpeed, AnimationSpeedMult)

EndFunction

Function KillcamReset()
        
		If KillcamCooldown == True
           KillcamCooldown = False
     EndIf

EndFunction

Function StartCooler()

    StartTimer(Cooldown, 0)

EndFunction

Function Cooler()

	    KillcamCooldown()

EndFunction

Function KillcamCooldown()

        If  KillcamCooldown == True
			KillcamCooldown = False
      EndIf

EndFunction

Function Killcam(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
      
	  If KillcamCooldown == False
         KillcamCooldown = True   	 		 
		 RaceChecker(Target)    
 EndIf

EndFunction

Function RaceChecker(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
         Race TargetRace = Target.GetRace()

			   If StarvegasKillcam_ActiveRaceHuman.Getvalue() == 1
				     If StarvegasKillcam_HumanRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						CinematicKillcam(Target) 
                  EndIf
            EndIf		       

			   If StarvegasKillcam_ActiveRaceCreature.Getvalue() == 1        
				     If StarvegasKillcam_CreatureRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						CinematicKillcam(Target) 
                  EndIf
            EndIf	 		       
			   
			   If StarvegasKillcam_ActiveRaceRobot.Getvalue() == 1    
				     If StarvegasKillcam_RobotRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						CinematicKillcam(Target) 
                  EndIf
            EndIf	 		      

			  If StarvegasKillcam_ActiveRaceSpaceship.Getvalue() == 1    
				     If StarvegasKillcam_SpaceshipRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect_Spaceship.Cast(PlayerRef, None)
				  EndIf
            EndIf	

EndFunction

Function RaceCheckerBasic(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
         Race TargetRace = Target.GetRace()

			   If StarvegasKillcam_ActiveRaceHuman.Getvalue() == 1
				     If StarvegasKillcam_HumanRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						CinematicKillcamBasic(Target)
                  EndIf
            EndIf		       

			   If StarvegasKillcam_ActiveRaceCreature.Getvalue() == 1        
				     If StarvegasKillcam_CreatureRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						CinematicKillcamBasic(Target)
                  EndIf
            EndIf	 		       
			   
			   If StarvegasKillcam_ActiveRaceRobot.Getvalue() == 1    
				     If StarvegasKillcam_RobotRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						CinematicKillcamBasic(Target)
                  EndIf
            EndIf	 		      

			  If StarvegasKillcam_ActiveRaceSpaceship.Getvalue() == 1    
				     If StarvegasKillcam_SpaceshipRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect_Spaceship.Cast(PlayerRef, None)
                  EndIf
            EndIf	

EndFunction

Function KillcamBasic(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
      
	  If KillcamCooldown == False
         KillcamCooldown = True           		 	 
   		 RaceCheckerBasic(Target) 
   EndIf

EndFunction

Function CinematicKillcam(ObjectReference akNewContainer)
		 	 		 
		     Actor Target = akNewContainer as Actor 		           
		     
			 Float Zoom = Utility.RandomFloat(CinematicZoomOutMin, CinematicZoomOutMax)			  	  	  
	  		  
		  If PlayerRef.GetDistance(Target) > CinematicCameraTriggerDistanceShort  	     
			 Game.ForceThirdPerson()
			 View = Target.PlaceActorAtMe(StarvegasKillcam_Camera, 4, None, False, False, True, None, True)
			 View.killsilent(Target)
			 View.moveto(Target, 0, 0, 0.6, True, False)
			 View.SplineTranslateToRefNode(PlayerRef, COM, 1.0, 1.0, 1.0)
			 Game.SetCameraTarget(View)
			 PlayerRef.SetLookAt(Target, True)			 
                  
			 Utility.Wait(Zoom)
 			 View.StopTranslation()																													
		     View.Delete()	
	         RestartTranslation.Stop()
		     RestartTranslation.Start()
	 Else

             CinematicFOVCalculation(CinematicCameraFirstPersonFOV5, CinematicCameraThirdPersonFOV5, CinematicCameraFirstPersonGeometryFOV5)

       EndIf

EndFunction                                                          

Function CinematicKillcamBasic(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor		  
	  		  
		  If PlayerRef.GetDistance(Target) <= CinematicCameraTriggerDistanceShort		     
			 CinematicFOVCalculation(CinematicCameraFirstPersonFOV5, CinematicCameraThirdPersonFOV5, CinematicCameraFirstPersonGeometryFOV5)
      ElseIf PlayerRef.GetDistance(Target) <= CinematicCameraTriggerDistanceMedium
			 CinematicFOVCalculation(CinematicCameraFirstPersonFOV25, CinematicCameraThirdPersonFOV25, CinematicCameraFirstPersonGeometryFOV25)		 										
      ElseIf PlayerRef.GetDistance(Target) <= CinematicCameraTriggerDistanceLong || PlayerRef.GetDistance(Target) > CinematicCameraTriggerDistanceLong
			 RaceChecker(Target)
	   EndIf	 															

EndFunction  

Function CinematicFOVCalculation(Float Default1stPFOV, Float Default3rdPFOV, Float Default1stPGeometryFOV)
  
	      Utility.SetINIFloat("fDefault1stPersonFOV:Camera", Default1stPFOV) 
	      Utility.SetINIFloat("fFPWorldFOV:Camera", Default1stPFOV) 
	      Utility.SetINIFloat("fTPWorldFOV:Camera", Default3rdPFOV)  
	      Utility.SetINIFloat("fFPGeometryFOV:Camera", Default1stPGeometryFOV) 

EndFunction

Function CinematicFOVReturn()
		  
		  Utility.SetINIFloat("fDefault1stPersonFOV:Camera", DefaultCameraFirstPersonFOV) 
	      Utility.SetINIFloat("fFPWorldFOV:Camera", DefaultCameraFirstPersonFOV) 
	      Utility.SetINIFloat("fTPWorldFOV:Camera", DefaultCameraThirdPersonFOV) 
	      Utility.SetINIFloat("fFPGeometryFOV:Camera", DefaultCameraFirstPersonGeometryFOV)

EndFunction

Function HUDTurnOn()
		  
	  If StarvegasKillcam_UI_Toggle.GetValue() == 1		 
		 Debug.EnableMenus(True)
         Game.SetCharGenHUDMode(0)
   EndIf	

EndFunction

Function Main(Int Message = 0, Int Button = 0, Bool MenuOpened = True)

  While MenuOpened

	 If Button == -1

 ElseIf Message == 0
		button = MSG_StarvegasConfBookMain.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                            Message = 1

	                                ElseIf (button == 1)
            
		                                    Message = 2

	                                ElseIf (button == 2)

 		                                    Message = 3                                           

	                                ElseIf (button == 3)

		                                    Message = 4
              
	                                ElseIf (button == 4)

		                                    Message = 5

	                                ElseIf (button == 5)

		                                    Message = 7

	                                ElseIf (button == 6)

		                                    Message = 8

	                                ElseIf (button == 7)

		                                    Message = 6

	                                ElseIf (button == 8)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 1
		button = MSG_StarvegasConfBookMainModes.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                            StarvegasKillcam_Modes.SetValue(1)
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_Oneshot, False)
	                                
									ElseIf (button == 1)
            
		                                    StarvegasKillcam_Modes.SetValue(2)
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile, False)
	                                
									ElseIf (button == 2)

 		                                    StarvegasKillcam_Modes.SetValue(3)                                           
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_Combat, False)

	                                ElseIf (button == 3)

		                                    StarvegasKillcam_Modes.SetValue(4)
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_Always, False)              
	                                
									ElseIf (button == 4)

		                                    StarvegasKillcam_Modes.SetValue(5)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Always)	
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)
	                                
									ElseIf (button == 5)

		                                    StarvegasKillcam_Modes.SetValue(0)
                                            PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_LastHostile, False)	
	                                
									ElseIf (button == 6)

		                                    Message = 0

	                                ElseIf (button == 7)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 2
		button = MSG_StarvegasConfBookMainCamera.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                            Message = 22

	                                ElseIf (button == 1)
            
		                                    Message = 222
              
	                                ElseIf (button == 2)

		                                    Message = 0

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 22
		button = MSG_StarvegasConfBookMainCameraPlayer.show(DefaultCameraFirstPersonFOV, DefaultCameraThirdPersonFOV, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

 		                                    DefaultCameraFirstPersonFOV += 2                                          
                                            DefaultCameraFirstPersonGeometryFOV += 2
	                                
									ElseIf (button == 1)

                                               If DefaultCameraFirstPersonFOV == 2
											      DefaultCameraFirstPersonFOV = 2
                                                  DefaultCameraFirstPersonGeometryFOV = 2
											Else
		                                          DefaultCameraFirstPersonFOV -= 2
											      DefaultCameraFirstPersonGeometryFOV -= 2
											EndIf
              
	                                ElseIf (button == 2)

		                                    DefaultCameraThirdPersonFOV += 2

	                                ElseIf (button == 3)

                                               If DefaultCameraThirdPersonFOV == 2
											      DefaultCameraThirdPersonFOV = 2
                                            Else
		                                          DefaultCameraThirdPersonFOV -= 2
											EndIf
              
	                                ElseIf (button == 4)

		                                    Message = 2
                                            CinematicFOVReturn()
	                                
									ElseIf (button == 5)

                                           ; Exit
                                           MenuOpened = False
                                           CinematicFOVReturn()
									 EndIf

 ElseIf Message == 222
		button = MSG_StarvegasConfBookMainCameraKillcam.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                            Message = 2222
											
	                                ElseIf (button == 1)
            		                                  
                                            Message = 22222		                                    
											
	                                ElseIf (button == 2)

		                                    Message = 2

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 2222
		button = MSG_StarvegasConfBookMainCameraKillcamFOV.show(CinematicCameraFirstPersonFOV5, CinematicCameraThirdPersonFOV5, CinematicCameraFirstPersonFOV25, CinematicCameraThirdPersonFOV25, CinematicZoomOutMin, CinematicZoomOutMax, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

		                                    CinematicCameraFirstPersonFOV5 += 2
	                                        CinematicCameraFirstPersonGeometryFOV5 += 2
									
									ElseIf (button == 1)

                                               If CinematicCameraFirstPersonFOV5 == 2
											      CinematicCameraFirstPersonFOV5 = 2
                                                  CinematicCameraFirstPersonGeometryFOV5 = 2
											Else
		                                          CinematicCameraFirstPersonFOV5 -= 2
											      CinematicCameraFirstPersonGeometryFOV5 -= 2
											EndIf                            
											
	                                ElseIf (button == 2)

		                                    CinematicCameraThirdPersonFOV5 += 2

	                                ElseIf (button == 3)

                                               If CinematicCameraThirdPersonFOV5 == 2
											      CinematicCameraThirdPersonFOV5 = 2
                                            Else
		                                          CinematicCameraThirdPersonFOV5 -= 2
											EndIf 
	                                
									ElseIf (button == 4)
            		                                  
                                            CinematicCameraFirstPersonFOV25 += 2		                                    
											CinematicCameraFirstPersonGeometryFOV25 += 2
	                                
									ElseIf (button == 5)

                                               If CinematicCameraFirstPersonFOV25 == 2
											      CinematicCameraFirstPersonFOV25 = 2
                                                  CinematicCameraFirstPersonGeometryFOV25 = 2
											Else
		                                          CinematicCameraFirstPersonFOV25 -= 2
											      CinematicCameraFirstPersonGeometryFOV25 -= 2
											EndIf   		                                    

	                                ElseIf (button == 6)

                                            CinematicCameraThirdPersonFOV25 += 2
	                                
									ElseIf (button == 7)
            		                                  
                                               If CinematicCameraThirdPersonFOV25 == 2
											      CinematicCameraThirdPersonFOV25 = 2
                                            Else
		                                          CinematicCameraThirdPersonFOV25 -= 2
											EndIf                                              		                                    

	                                ElseIf (button == 8)

                                               If CinematicZoomOutMin == 0.30
											      CinematicZoomOutMin = 0.30
                                            Else
		                                          CinematicZoomOutMin += 0.01
											EndIf 
	                                
									ElseIf (button == 9)
            		                                  
                                               If CinematicZoomOutMin == 0.20
											      CinematicZoomOutMin = 0.20
                                            Else
		                                          CinematicZoomOutMin -= 0.01
											EndIf 

	                                ElseIf (button == 10)

                                               If CinematicZoomOutMax == 0.30
											      CinematicZoomOutMax = 0.30
                                            Else
		                                          CinematicZoomOutMax += 0.01
											EndIf 
	                                
									ElseIf (button == 11)
            		                                  
                                               If CinematicZoomOutMax == 0.20
											      CinematicZoomOutMax = 0.20
                                            Else
		                                          CinematicZoomOutMax -= 0.01
											EndIf 
											                                									
									ElseIf (button == 12)
            		                                  
	                                       Message = 222
											
	                                ElseIf (button == 13)
                                           
										   ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 22222
		button = MSG_StarvegasConfBookMainCameraKillcamDistance.show(CinematicCameraTriggerDistanceShort, CinematicCameraTriggerDistanceMedium, CinematicCameraTriggerDistanceLong, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                            CinematicCameraTriggerDistanceShort += 2
											
	                                ElseIf (button == 1)
            		                                  
                                               If CinematicCameraTriggerDistanceShort == 2
											      CinematicCameraTriggerDistanceShort = 2
                                            Else
		                                          CinematicCameraTriggerDistanceShort -= 2
											EndIf 	                                    
											
	                                ElseIf (button == 2)

		                                    CinematicCameraTriggerDistanceMedium += 2

	                                ElseIf (button == 3)
            		                                  
                                               If CinematicCameraTriggerDistanceMedium == 2
											      CinematicCameraTriggerDistanceMedium = 2
                                            Else
		                                          CinematicCameraTriggerDistanceMedium -= 2
											EndIf                                     
											
	                                ElseIf (button == 4)

		                                    CinematicCameraTriggerDistanceLong += 2

	                                ElseIf (button == 5)
            		                                  
                                               If CinematicCameraTriggerDistanceLong == 2
											      CinematicCameraTriggerDistanceLong = 2
                                            Else
		                                          CinematicCameraTriggerDistanceLong -= 2
											EndIf  	                                    
											                                   										
	                                ElseIf (button == 6)

		                                    Message = 222

	                                ElseIf (button == 7)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 3

                               Float AlwaysTriggerChance = StarvegasKillcam_SlowmoChanceAlways.Getvalue()
                               Float CombatTriggerChance = StarvegasKillcam_SlowmoChanceCombat.Getvalue()
                               Float LastHostileTriggerChance = StarvegasKillcam_SlowmoChanceLastHostile.Getvalue()
                               Float OneshotTriggerChance = StarvegasKillcam_SlowmoChanceOneshot.Getvalue()
                               Float OneshotAndLastHostileTriggerChance = StarvegasKillcam_SlowmoChanceLastHostileOneshot.Getvalue()
                               Float CinematicCameraTriggerChance = StarvegasKillcam_CinematicChance.Getvalue()

                               Float AlwaysTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceAlways.Getvalue() + 2
                               Float AlwaysTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceAlways.Getvalue() - 2
                               Float CombatTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceCombat.Getvalue() + 2
                               Float CombatTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceCombat.Getvalue() - 2
                               Float LastHostileTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceLastHostile.Getvalue() + 2
                               Float LastHostileTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceLastHostile.Getvalue() - 2
                               Float OneshotTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceOneshot.Getvalue() + 2
                               Float OneshotTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceOneshot.Getvalue() - 2
                               Float OneshotAndLastHostileTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceLastHostileOneshot.Getvalue() + 2
                               Float OneshotAndLastHostileTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceLastHostileOneshot.Getvalue() - 2
                               Float CinematicCameraTriggerChanceIncrease = StarvegasKillcam_CinematicChance.Getvalue() + 5
                               Float CinematicCameraTriggerChanceDecrease = StarvegasKillcam_CinematicChance.Getvalue() - 5

		button = MSG_StarvegasConfBookMainTriggerChance.show(AlwaysTriggerChance, CombatTriggerChance, LastHostileTriggerChance, OneshotTriggerChance, OneshotAndLastHostileTriggerChance, CinematicCameraTriggerChance, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                               If AlwaysTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceAlways.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceAlways.SetValue(AlwaysTriggerChanceIncrease)
											EndIf 
											
	                                ElseIf (button == 1)
            		                                  
                                               If AlwaysTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceAlways.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceAlways.SetValue(AlwaysTriggerChanceDecrease)
											EndIf                                    
											
	                                ElseIf (button == 2)

                                               If CombatTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceCombat.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceCombat.SetValue(CombatTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 3)
            		                                  
                                               If CombatTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceCombat.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceCombat.SetValue(CombatTriggerChanceDecrease)
											EndIf                                      
											
	                                ElseIf (button == 4)

                                               If LastHostileTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceLastHostile.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostile.SetValue(LastHostileTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 5)
            		                                  
                                               If LastHostileTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceLastHostile.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostile.SetValue(LastHostileTriggerChanceDecrease)
											EndIf  	                                    
											
	                                ElseIf (button == 6)

                                               If OneshotTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceOneshot.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceOneshot.SetValue(OneshotTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 7)
            		                                  
                                               If OneshotTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceOneshot.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceOneshot.SetValue(OneshotTriggerChanceDecrease)
											EndIf   	                                    

	                                ElseIf (button == 8)

                                               If OneshotAndLastHostileTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(OneshotAndLastHostileTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 9)
            		                                  
                                               If OneshotAndLastHostileTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(OneshotAndLastHostileTriggerChanceDecrease)
											EndIf

	                                ElseIf (button == 10)

                                               If CinematicCameraTriggerChance == 100
											      StarvegasKillcam_CinematicChance.SetValue(100)
                                            Else
		                                          StarvegasKillcam_CinematicChance.SetValue(CinematicCameraTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 11)
            		                                  
                                               If CinematicCameraTriggerChance == 0
											      StarvegasKillcam_CinematicChance.SetValue(0)
                                            Else
		                                          StarvegasKillcam_CinematicChance.SetValue(CinematicCameraTriggerChanceDecrease)
											EndIf
											
	                                ElseIf (button == 12)

		                                    Message = 0

	                                ElseIf (button == 13)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 4
		button = MSG_StarvegasConfBookMainCooldown.show(Cooldown, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                           Cooldown += 1
											
	                                ElseIf (button == 1)
            		                                  
                                               If Cooldown == 1
											      Cooldown = 1
                                            Else
		                                          Cooldown -= 1
											EndIf  	                              										
											
	                                ElseIf (button == 2)

		                                    Message = 0

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 5
		button = MSG_StarvegasConfBookMainSpecialFX.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                            StarvegasKillcam_SoundsFX_Toggle.SetValue(0) 
											
	                                ElseIf (button == 1)
            		                                  
                                            StarvegasKillcam_SoundsFX_Toggle.SetValue(1)                                   
											
	                                ElseIf (button == 2)

                                            StarvegasKillcam_IMADs_Toggle.SetValue(0) 

	                                ElseIf (button == 3)
            		                                  
                                            StarvegasKillcam_IMADs_Toggle.SetValue(1)                                     

	                                ElseIf (button == 4)

                                            StarvegasKillcam_IMADs_SS_Toggle.SetValue(0) 

	                                ElseIf (button == 5)
            		                                  
                                            StarvegasKillcam_IMADs_SS_Toggle.SetValue(1)       
											
	                                ElseIf (button == 6)

                                            StarvegasKillcam_RecoilFX_Toggle.SetValue(0) 

	                                ElseIf (button == 7)
            		                                  
                                            StarvegasKillcam_RecoilFX_Toggle.SetValue(1) 	                                    
											
	                                ElseIf (button == 8)

                                            StarvegasKillcam_MusicMute_Toggle.SetValue(0)  

	                                ElseIf (button == 9)
            		                                  
                                            StarvegasKillcam_MusicMute_Toggle.SetValue(1)   	                                    

	                                ElseIf (button == 10)

                                            StarvegasKillcam_UI_Toggle.SetValue(0) 

	                                ElseIf (button == 11)
            		                                  
                                            StarvegasKillcam_UI_Toggle.SetValue(1) 

	                                ElseIf (button == 12)

                                            StarvegasKillcam_Invincibility_Toggle.SetValue(0) 

	                                ElseIf (button == 13)
            		                                  
                                            StarvegasKillcam_Invincibility_Toggle.SetValue(1) 
											
	                                ElseIf (button == 14)

		                                    Message = 0

	                                ElseIf (button == 15)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 6
		button = MSG_StarvegasConfBookMainDebug.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                           FullyReset()
											
	                                ElseIf (button == 1)
            		                                  
                                           EmergencyFallout()  	                              										
											
	                                ElseIf (button == 2)

		                                    Message = 0

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 7
		button = MSG_StarvegasConfBookMainProperties.show(SlowmotionSpeedMult, AnimationSpeedMult, SlowmotionSpeedDur, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                           If SlowmotionSpeedMult == 0.40
											  SlowmotionSpeedMult = 0.40
	                                   Else
									          SlowmotionSpeedMult += 0.01
									    EndIf
									
									ElseIf (button == 1)
            		                                  
                                           If SlowmotionSpeedMult == 0.01
											  SlowmotionSpeedMult = 0.01
	                                   Else
									          SlowmotionSpeedMult -= 0.01
									    EndIf 	                              										

	                                ElseIf (button == 2)

                                           If AnimationSpeedMult == 100
											  AnimationSpeedMult = 100
	                                   Else
									          AnimationSpeedMult += 5.0
									    EndIf

	                                ElseIf (button == 3)
											
                                           If AnimationSpeedMult == 5.0
											  AnimationSpeedMult = 5.0
	                                   Else
									          AnimationSpeedMult -= 5.0
									    EndIf 

	                                ElseIf (button == 4)

									       SlowmotionSpeedDur += 1

	                                ElseIf (button == 5)
											
                                           If SlowmotionSpeedDur == 1
											  SlowmotionSpeedDur = 1
	                                   Else
									          SlowmotionSpeedDur -= 1
									    EndIf 											
																						
	                                ElseIf (button == 6)

		                                    Message = 0
                                            SlowmotionAVUpdate()
	                                
									ElseIf (button == 7)

                                           ; Exit
                                           MenuOpened = False
                                           SlowmotionAVUpdate()                                          
									 
									 EndIf

 ElseIf Message == 8
		button = MSG_StarvegasConfBookMainEnabledRaces.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
            
                                           StarvegasKillcam_ActiveRaceHuman.SetValue(0)
									
									ElseIf (button == 1)
            		                                  
                                           StarvegasKillcam_ActiveRaceHuman.SetValue(1)	                              										

	                                ElseIf (button == 2)

                                           StarvegasKillcam_ActiveRaceCreature.SetValue(0)

	                                ElseIf (button == 3)
											
                                           StarvegasKillcam_ActiveRaceCreature.SetValue(1)	 											

	                                ElseIf (button == 4)

                                           StarvegasKillcam_ActiveRaceRobot.SetValue(0)

	                                ElseIf (button == 5)
											
                                           StarvegasKillcam_ActiveRaceRobot.SetValue(1)										

	                                ElseIf (button == 6)

                                           StarvegasKillcam_ActiveRaceSpaceship.SetValue(0)

	                                ElseIf (button == 7)
											
                                           StarvegasKillcam_ActiveRaceSpaceship.SetValue(1)	
											
	                                ElseIf (button == 8)

		                                    Message = 0
	                               
									ElseIf (button == 9)

                                           ; Exit
                                           MenuOpened = False                                          
									 
									 EndIf

  EndIf
EndWhile
EndFunction