unit userscript;

// INSTRUCTIONS ------------- //
// 1 - Create a NEW esm
// 2 - Copy the following COBJ files from DarkStar_Manufacturing.esm as Overrides into that new esm (depending on what you're overriding)
//	   ** note: sort by EDID and they'll be at the top of the list **
//     a - co_-_ApparelCrafting_EXAMPLE
//     b - co_-_ApparelEnhancement_EXAMPLE
//     c - co_-_ArmorBackpackCrafting_EXAMPLE
//     d - co_-_ArmorBackpackEnhancement_EXAMPLE
//     e - co_-_ArmorCrafting_EXAMPLE
//     f - co_-_ArmorEnhancement_EXAMPLE
//     g - co_-_ArmorHelmetCrafting_EXAMPLE
//     h - co_-_ArmorHelmetEnhancement_EXAMPLE
// 3 - Copy the ARMO files from the mod you're patching into the new esm as Overrides
// 4 - Select the new ARMO overrides created from the target mod
// 5 - Run this patch against those files
// 6 - Verify the new COBJ's were created for both _Crafting and _Enhanced versions of the Overrides
// 7 - Edit the ARMO that got created and add the appropriate MOD ASSOCIATIONS from DarkStar (add to Keywords)
//     apparel     - ma_DarkStar_Apparel [KYWD:030001A7]
//     cyberware   - ma_DarkStar_Cyberware [KYWD:030009C9]
//     apparel hat - ma_DarkStar_Headwear [KYWD:030009BD]
// 8 - Edit the ARMO that got created and add the Attach points if Apparel/Hat/Cyberware
//     Apparel/Hat/Cyberware
//       quality     - ap_armor_Quality "Quality" [KYWD:0011E2C1]
//       lining      - ap_armor_Lining "Lining" [KYWD:00022821]
//       legendaries - ap_Legendary_rank_1 "Legendary Slot 1" [KYWD:001E32C8]
//                     ap_Legendary_rank_2 "Legendary Slot 2" [KYWD:00329ABC]
//                     ap_Legendary_rank_3 "Legendary Slot 3" [KYWD:00329ABD]
//       APPAREL/CYBER/HAT: ADD THIS TO INRD = dn_CommonArmor [INNR:00184BC1]
//     Spacesuit     - ap_armor_Lining "Lining" [KYWD:00022821]
//     Helmet        - ap_armor_Lining "Lining" [KYWD:00022821]
// 9 - Edit the ARMO combinations and assign DarkStar quality that is relevant to the piece
//       ** note: for all, make sure the combination ends in 0, false, true **
//       ** note 2: for ARMOR pieces, you only need to add Quality/Lining to the Entry combination **
//       ** note 3: Make sure these are the ONLY quality/lining attachments on the default/entry combination **
//     apparel     - amod_DarkStar_Apparel_Quality_1 "Basic Apparel" [OMOD:0300018D]
//     apparel hat - amod_DarkStar_Headwear_Quality_1 "Basic Headwear" [OMOD:030009BF]
//                   amod_DarkStar_Apparel_Lining_HandStitching "Handstitched Lining" [OMOD:03000191]
//     cyberware   - amod_DarkStar_Cyberware_Quality_1 "Basic Cyberware" [OMOD:030009C4]
//     spacesuit   - amod_DarkStar_Apparel_Lining_HandStitching "Handstitched Lining" [OMOD:03000191]
//                   amod_DarkStar_Spacesuit_Quality_01 "Basic Spacesuit" [OMOD:03000BF3]
//     helmet      - amod_DarkStar_Apparel_Lining_HandStitching "Handstitched Lining" [OMOD:03000191]
//                   amod_DarkStar_Helmet_Quality_01 "Basic Helmet" [OMOD:03000BED]
//     backpack    - amod_DarkStar_Pack_Quality_01 "Basic Backpack" [OMOD:03000BE7]
//  10 - Correct any ARMO EDID naming on the new elements. The naming convention is detected through the FULL-Name field 
//       of the override ARMO. If the mod author added the word Spacesuit, for example, then this script will think it's 
//       a spacesuit. You may have to correct the EDID and change it to co_DarkStar_Apparel... for example.
//  11 - Check the CONDITION 1 of all new COBJ and make sure the filter_DarkStar_WB is pointed to the correct filter for the piece
//       Double click the value and scroll up and down. Make sure Apparel is pointed to Apparel, etc, etc
//       This applies to both the Crafting and Enhancement COBJs created. Make sure they're pointed to the correct _Crafting and _Enhancement filters.
//       If you had to do this, you will also want to Compare between the Apparel COBJ example and the new COBJ, and drag the Component values over to the new COBJ.
//       The Enhancement COBJ's components should point to a Quantum Harness, and the original EDID of the ARMO you are overriding.
//  12 - Once you have these set, you are finished! Remove all overrides, and enjoy!
//                   
// 
// It is NOT recommended that you add anything to the Leveled Lists or the Container that DarkStar uses to make items purchasable.
// If every patch mod did that, only the last one loaded would win. So, there's really no point in bothering. Your patched equipment
// will be Craftable, and Upgradable, with just a simple execution of this script.

function handleBackpack(e: IInterface): integer;
var
  f: IwbFile;
  sedid, sfull, sformid, n, d, prefix, prefix2, c2edid, suffix2, prefix3, c3edid, suffix3, xnam: String;
  c, c2, c3, x: IwbMainRecord;
begin
  Result := 0;
  f := GetFile(e);
  sedid := GetElementEditValues(e, 'EDID');
  sfull := GetElementEditValues(e, 'FULL');
  sformid := BaseName(e);
  
	d := StringReplace(sfull, ' space helmet', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' helmet', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' backpack', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' spacesuit', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(d, ' ', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '.', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '-', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''_', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	d := d+' Backpack';

  prefix := 'DarkStar_Armor_Backpack_';
  AddMessage('Building Backpack ARMO with new EDID: '+prefix+n);
  c := wbCopyElementToFile(e, f, true, true);
  SetEditorID(c, prefix+n);
  SetElementEditValues(c, 'FULL', Format(d+' Backpack', [GetElementEditValues(c, 'FULL'), IntToHex(FormID(c),8)]));
  
  AddMessage('Creating Crafting recipe for: ' + FullPath(e));
  prefix2 := 'co_Armor_Backpack_';
  suffix2 := '_Crafting';
  c2edid := prefix2+n+suffix2;
  c2 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ArmorBackpackCrafting_EXAMPLE');
  c2 := wbCopyElementToFile(c2, f, true, true);
  SetEditorID(c2, c2edid);
  SetElementEditValues(c2, 'CNAM', Format(sformid, [GetElementEditValues(c2, 'CNAM'), IntToHex(FormID(c2),8)]));
  SetElementEditValues(c2, 'DESC', Format(d, [GetElementEditValues(c2, 'DESC'), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c2),8)]));
  
  AddMessage('Searching for: '+prefix+n);
  xnam := BaseName(c);
  
  AddMessage('Creating Enhancement recipe for: ' + FullPath(e));
  prefix3 := 'co_Armor_Backpack_';
  suffix3 := '_Enhancement';
  c3edid := prefix3+n+suffix3;
  c3 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ArmorBackpackEnhancement_EXAMPLE');
  c3 := wbCopyElementToFile(c3, f, true, true);
  SetEditorID(c3, c3edid);
  SetElementEditValues(c3, 'CNAM', Format(xnam, [GetElementEditValues(c3, 'CNAM'), IntToHex(FormID(c3),8)]));
  SetElementEditValues(c3, 'DESC', Format(d, [GetElementEditValues(c3, 'DESC'), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[5]\[0]\[0]'), Format(sformid, [GetEditValue(ElementByPath(c3, '[5]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c3),8)]));
end;

function handleHelmet(e: IInterface): integer;
var
  f: IwbFile;
  sedid, sfull, sformid, n, d, prefix, prefix2, c2edid, suffix2, prefix3, c3edid, suffix3, xnam: String;
  c, c2, c3, x: IwbMainRecord;
begin
  Result := 0;
  f := GetFile(e);
  sedid := GetElementEditValues(e, 'EDID');
  sfull := GetElementEditValues(e, 'FULL');
  sformid := BaseName(e);
  
	d := StringReplace(sfull, ' space helmet', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' helmet', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' backpack', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' spacesuit', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(d, ' ', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '.', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '-', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''_', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	d := d+' Helmet';

  prefix := 'DarkStar_Armor_Helmet_';
  AddMessage('Building Helmet ARMO with new EDID: '+prefix+n);
  c := wbCopyElementToFile(e, f, true, true);
  SetEditorID(c, prefix+n);
  SetElementEditValues(c, 'FULL', Format(d, [GetElementEditValues(c, 'FULL'), IntToHex(FormID(c),8)]));
  
  AddMessage('Creating Crafting recipe for: ' + FullPath(e));
  prefix2 := 'co_Armor_Helmet_';
  suffix2 := '_Crafting';
  c2edid := prefix2+n+suffix2;
  c2 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ArmorHelmetCrafting_EXAMPLE');
  c2 := wbCopyElementToFile(c2, f, true, true);
  SetEditorID(c2, c2edid);
  SetElementEditValues(c2, 'CNAM', Format(sformid, [GetElementEditValues(c2, 'CNAM'), IntToHex(FormID(c2),8)]));
  SetElementEditValues(c2, 'DESC', Format(d, [GetElementEditValues(c2, 'DESC'), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c2),8)]));
  
  AddMessage('Searching for: '+prefix+n);
  xnam := BaseName(c);
  
  AddMessage('Creating Enhancement recipe for: ' + FullPath(e));
  prefix3 := 'co_Armor_Helmet_';
  suffix3 := '_Enhancement';
  c3edid := prefix3+n+suffix3;
  c3 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ArmorHelmetEnhancement_EXAMPLE');
  c3 := wbCopyElementToFile(c3, f, true, true);
  SetEditorID(c3, c3edid);
  SetElementEditValues(c3, 'CNAM', Format(xnam, [GetElementEditValues(c3, 'CNAM'), IntToHex(FormID(c3),8)]));
  SetElementEditValues(c3, 'DESC', Format(d, [GetElementEditValues(c3, 'DESC'), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[5]\[0]\[0]'), Format(sformid, [GetEditValue(ElementByPath(c3, '[5]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c3),8)]));
end;

function handleSpacesuit(e: IInterface): integer;
var
  f: IwbFile;
  sedid, sfull, sformid, n, d, prefix, prefix2, c2edid, suffix2, prefix3, c3edid, suffix3, xnam: String;
  c, c2, c3, x: IwbMainRecord;
begin
  Result := 0;
  f := GetFile(e);
  sedid := GetElementEditValues(e, 'EDID');
  sfull := GetElementEditValues(e, 'FULL');
  sformid := BaseName(e);
  
	d := StringReplace(sfull, ' space helmet', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' helmet', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' backpack', '', [rfReplaceAll, rfIgnoreCase]);
	d := StringReplace(d, ' spacesuit', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(d, ' ', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '.', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '-', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''_', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	d := d+' Spacesuit';

  prefix := 'DarkStar_Armor_Spacesuit_';
  AddMessage('Building ARMO with new EDID: '+prefix+n);
  c := wbCopyElementToFile(e, f, true, true);
  SetEditorID(c, prefix+n);
  SetElementEditValues(c, 'FULL', Format(d, [GetElementEditValues(c, 'FULL'), IntToHex(FormID(c),8)]));
  
  AddMessage('Creating Crafting recipe for: ' + FullPath(e));
  prefix2 := 'co_Armor_';
  suffix2 := '_Crafting';
  c2edid := prefix2+n+suffix2;
  c2 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ArmorCrafting_EXAMPLE');
  c2 := wbCopyElementToFile(c2, f, true, true);
  SetEditorID(c2, c2edid);
  SetElementEditValues(c2, 'CNAM', Format(sformid, [GetElementEditValues(c2, 'CNAM'), IntToHex(FormID(c2),8)]));
  SetElementEditValues(c2, 'DESC', Format(d, [GetElementEditValues(c2, 'DESC'), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c2),8)]));
  
  AddMessage('Searching for: '+prefix+n);
  xnam := BaseName(c);
  
  AddMessage('Creating Enhancement recipe for: ' + FullPath(e));
  prefix3 := 'co_Armor_';
  suffix3 := '_Enhancement';
  c3edid := prefix3+n+suffix3;
  c3 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ArmorEnhancement_EXAMPLE');
  c3 := wbCopyElementToFile(c3, f, true, true);
  SetEditorID(c3, c3edid);
  SetElementEditValues(c3, 'CNAM', Format(xnam, [GetElementEditValues(c3, 'CNAM'), IntToHex(FormID(c3),8)]));
  SetElementEditValues(c3, 'DESC', Format(d, [GetElementEditValues(c3, 'DESC'), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[5]\[0]\[0]'), Format(sformid, [GetEditValue(ElementByPath(c3, '[5]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c3),8)]));
end;

function handleApparel(e: IInterface): integer;
var
  f: IwbFile;
  sedid, sfull, sformid, n, d, prefix, prefix2, c2edid, suffix2, prefix3, c3edid, suffix3, xnam: String;
  c, c2, c3, x: IwbMainRecord;
begin
  Result := 0;
  f := GetFile(e);
  sedid := GetElementEditValues(e, 'EDID');
  sfull := GetElementEditValues(e, 'FULL');
  sformid := BaseName(e);
  
	d := StringReplace(sfull, ' apparel', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(d, ' ', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '.', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '-', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''', '', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '''_', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);
	n := StringReplace(n, '__', '_', [rfReplaceAll, rfIgnoreCase]);

  prefix := 'DarkStar_Apparel_';
  AddMessage('Building ARMO with new EDID: '+prefix+n);
  c := wbCopyElementToFile(e, f, true, true);
  SetEditorID(c, prefix+n);
  SetElementEditValues(c, 'FULL', Format(d, [GetElementEditValues(c, 'FULL'), IntToHex(FormID(c),8)]));
  
  AddMessage('Creating Crafting recipe for: ' + FullPath(e));
  prefix2 := 'co_Apparel_';
  suffix2 := '_Crafting';
  c2edid := prefix2+n+suffix2;
  c2 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ApparelCrafting_EXAMPLE');
  c2 := wbCopyElementToFile(c2, f, true, true);
  SetEditorID(c2, c2edid);
  SetElementEditValues(c2, 'CNAM', Format(sformid, [GetElementEditValues(c2, 'CNAM'), IntToHex(FormID(c2),8)]));
  SetElementEditValues(c2, 'DESC', Format(d, [GetElementEditValues(c2, 'DESC'), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c2),8)]));
  SetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c2, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c2),8)]));
  
  AddMessage('Searching for: '+prefix+n);
  xnam := BaseName(c);
  
  AddMessage('Creating Enhancement recipe for: ' + FullPath(e));
  prefix3 := 'co_Apparel_';
  suffix3 := '_Enhancement';
  c3edid := prefix3+n+suffix3;
  c3 := MainRecordByEditorID(GroupBySignature(f, 'COBJ'), 'co_-_ApparelEnhancement_EXAMPLE');
  c3 := wbCopyElementToFile(c3, f, true, true);
  SetEditorID(c3, c3edid);
  SetElementEditValues(c3, 'CNAM', Format(xnam, [GetElementEditValues(c3, 'CNAM'), IntToHex(FormID(c3),8)]));
  SetElementEditValues(c3, 'DESC', Format(d, [GetElementEditValues(c3, 'DESC'), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[5]\[0]\[0]'), Format(sformid, [GetEditValue(ElementByPath(c3, '[5]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]'), Format(11000000, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[0]')), IntToHex(FormID(c3),8)]));
  SetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]'), Format(1, [GetEditValue(ElementByPath(c3, '[4]\[1]\[0]\[2]')), IntToHex(FormID(c3),8)]));
end;

function Process(e: IInterface): integer;
var
  f: IwbFile;
  sedid, helmcheck, packcheck: String;
  apparelcheck: Boolean;
begin
  Result := 0;
  f := GetFile(e);
  sedid := GetElementEditValues(e, 'EDID');
  
  apparelcheck := (StringReplace(sedid, 'clothes', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid) OR (StringReplace(sedid, 'clothing', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid) OR (StringReplace(sedid, 'outfit', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid) OR (StringReplace(sedid, 'hat', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid) OR (StringReplace(sedid, 'apparel', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid) OR (StringReplace(sedid, 'attire', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid) OR (StringReplace(sedid, 'tattoo', 'XX', [rfReplaceAll, rfIgnoreCase]) <> sedid);
  helmcheck := StringReplace(sedid, 'helmet', 'XX', [rfReplaceAll, rfIgnoreCase]);
  packcheck := StringReplace(sedid, 'backpack', 'YY', [rfReplaceAll, rfIgnoreCase]);
  if apparelcheck then handleApparel(e);
  if helmcheck <> sedid then handleHelmet(e);
  if packcheck <> sedid then handleBackpack(e);
  if (helmcheck = sedid) and (packcheck = sedid) and (not apparelcheck) then handleSpacesuit(e);
end;

end.