ScriptName TGAH:TermMenu_ChatOptionsScript Extends TerminalMenu hidden

;-- Properties --------------------------------------

GlobalVariable Property TGAF_Global_COM_TriggerCommentsAllowed Auto Mandatory
GlobalVariable Property TGAF_Global_COM_LootCommentsAllowed Auto Mandatory
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory

;-- Events ------------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  ; Don't need to do anything when we open the menu
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    If auiMenuItemID == 0
      ; Turn Off Loot
      TGAF_Global_COM_LootCommentsAllowed.SetValue(0.0)
    ElseIf auiMenuItemID == 1
      ; Turn On Loot
      TGAF_Global_COM_LootCommentsAllowed.SetValue(1.0)
    ElseIf auiMenuItemID == 2
      ; Turn Off Triggers
      TGAF_Global_COM_TriggerCommentsAllowed.SetValue(0.0)
    ElseIf auiMenuItemID == 3
      ; Turn On Triggers
      TGAF_Global_COM_TriggerCommentsAllowed.SetValue(1.0)
    EndIf
  EndIf
EndEvent