ScriptName TGAH:TermMenu_Affinity_EventsScript Extends TerminalMenu hidden

;-- Variables ---------------------------------------

;-- Properties --------------------------------------

GlobalVariable Property TGAF_Global_COM_Affinity_Events_ModifyBy Auto Const Mandatory
GlobalVariable Property EventSmall Auto Const Mandatory
{ used for Likes/Dislikes }
GlobalVariable Property EventLarge Auto Const Mandatory
{ used for Loves/Hates }
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory

;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  akTerminalRef.AddTextReplacementValue("SmallCurrent", EventSmall.GetValue())
  akTerminalRef.AddTextReplacementValue("LargeCurrent", EventLarge.GetValue())
  akTerminalRef.AddTextReplacementValue("ModifyBy", TGAF_Global_COM_Affinity_Events_ModifyBy.GetValue())
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    If auiMenuItemID == 0
      AffinityEvent_Small_Increase()
    ElseIf auiMenuItemID == 1
      AffinityEvent_Small_Decrease()
    ElseIf auiMenuItemID == 2
      AffinityEvent_Large_Increase()
    ElseIf auiMenuItemID == 3
      AffinityEvent_Large_Decrease()
    EndIf
    akTerminalRef.AddTextReplacementValue("SmallCurrent", EventSmall.GetValue())
    akTerminalRef.AddTextReplacementValue("LargeCurrent", EventLarge.GetValue())
    akTerminalRef.AddTextReplacementValue("ModifyBy", TGAF_Global_COM_Affinity_Events_ModifyBy.GetValue())
  EndIf
EndEvent

Function AffinityEvent_Small_Increase()
  Int iEventSmall = EventSmall.GetValue() as Int
  iEventSmall += TGAF_Global_COM_Affinity_Events_ModifyBy.GetValue() as Int
  EventSmall.SetValue(iEventSmall as Float)
EndFunction

Function AffinityEvent_Small_Decrease()
  Int iEventSmall = EventSmall.GetValue() as Int
  iEventSmall -= TGAF_Global_COM_Affinity_Events_ModifyBy.GetValue() as Int
  EventSmall.SetValue(iEventSmall as Float)
EndFunction

Function AffinityEvent_Large_Increase()
  Int iEventLarge = EventLarge.GetValue() as Int
  iEventLarge += TGAF_Global_COM_Affinity_Events_ModifyBy.GetValue() as Int
  EventLarge.SetValue(iEventLarge as Float)
EndFunction

Function AffinityEvent_Large_Decrease()
  Int iEventLarge = EventLarge.GetValue() as Int
  iEventLarge -= TGAF_Global_COM_Affinity_Events_ModifyBy.GetValue() as Int
  EventLarge.SetValue(iEventLarge as Float)
EndFunction
