ScriptName TGAH:TermMenu_CompanionInfoScript Extends TerminalMenu hidden

;-- Variables ---------------------------------------

;-- Properties --------------------------------------

Form[] Property AllCompanionRefs Auto Const Mandatory
Form[] Property AllCompanionActors Auto Const Mandatory

Group ActorValue_Autofill
  ActorValue Property COM_ActiveCompanion Auto Const mandatory
  ActorValue Property COM_Affinity Auto Const Mandatory
  ActorValue Property COM_AffinityLevel Auto Const Mandatory
  ActorValue Property COM_AngerLevel Auto Const Mandatory
  ActorValue Property COM_IsCommitted Auto Const Mandatory
  ActorValue Property COM_IsRomantic Auto Const Mandatory
EndGroup

Group Terminal
  TerminalMenu Property CurrentTerminalMenu Auto Const mandatory
EndGroup

Group GlobalVariable_Autofill
  GlobalVariable Property COM_AffinityLevel_0_Neutral Auto Const Mandatory
  GlobalVariable Property COM_AffinityLevel_1_Friendship Auto Const Mandatory
  GlobalVariable Property COM_AffinityLevel_2_Affection Auto Const Mandatory
  GlobalVariable Property TGAF_Global_COM_CurrentMenuItem Auto Mandatory
  GlobalVariable Property TGAF_Global_COM_ID_Main Auto Mandatory
EndGroup

Group Messages_Autofill
  Message Property TGAH_AffinityLevelCommittedMsg Auto Const Mandatory
  Message Property TGAH_AffinityLevelFriendAllyMsg Auto Const Mandatory
  Message Property TGAH_AffinityLevelFriendMsg Auto Const Mandatory
  Message Property TGAH_AffinityLevelNeutralMsg Auto Const Mandatory
  Message Property TGAH_AffinityLevelRomanticMsg Auto Const Mandatory
  Message Property TGAH_AngerLevelAngryMsg Auto Const Mandatory
  Message Property TGAH_AngerLevelAnnoyedMsg Auto Const Mandatory
  Message Property TGAH_AngerLevelFuriousMsg Auto Const Mandatory
  Message Property TGAH_AngerLevelNotAngryMsg Auto Const Mandatory
  Message Property TGAH_EmptyMsg Auto Const mandatory
  Message Property TGAH_FollowerActiveMsg Auto Const mandatory
  Message Property TGAH_IsMainCompanionMsg Auto Const Mandatory 
EndGroup

;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  Int I = 0
  While I < AllCompanionActors.Length
    ; Ordered list of all Companions. Need as Form for text replacement
    Form theCompanion = AllCompanionActors[I]
    ; Get the corresponding ACHR for the NPC in order to filter 
    ObjectReference theCompanionRef = AllCompanionRefs[I] as ObjectReference
    Int iMain = TGAF_Global_COM_ID_Main.GetValue() as Int
    Int iCompID = (theCompanionRef as companionactorscript).GetCompanionIDValue() as Int
    bool isActive = theCompanionRef.GetValue(COM_ActiveCompanion) as bool
    akTerminalRef.AddTextReplacementData("Companion" + I as String, theCompanion)
    ;Actively following
    If isActive
      akTerminalRef.AddTextReplacementData("CompanionActive" + I as String, TGAH_FollowerActiveMsg)
    ElseIf !isActive
      akTerminalRef.AddTextReplacementData("CompanionActive" + I as String, TGAH_EmptyMsg)
    EndIf
    ;Main Companion
    If iMain == iCompID
      akTerminalRef.AddTextReplacementData("CompanionMain" + I as String, TGAH_IsMainCompanionMsg)
    ElseIf iMain != iCompID
      akTerminalRef.AddTextReplacementData("CompanionMain" + I as String, TGAH_EmptyMsg)
    EndIf
    ; Cast as Int then back to Float to remove decimals in when displayed.
    Int iAffinity = theCompanionRef.GetValue(COM_Affinity) as Int
    akTerminalRef.AddTextReplacementValue("Affinity" + I as String, iAffinity as Float)
    akTerminalRef.AddTextReplacementData("AffinityLevel" + I as String, GetCurrentAffinityLevel(theCompanionRef))
    akTerminalRef.AddTextReplacementData("AngerLevel" + I as String, GetAngry(theCompanionRef))
    I += 1
  EndWhile
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    TGAF_Global_COM_CurrentMenuItem.SetValue(auiMenuItemID as Float)
    ObjectReference theCompanionRef = AllCompanionRefs[auiMenuItemID] as ObjectReference
    ; Cast as Int then back to Float to remove decimals in when displayed.
    Int iAffinity = theCompanionRef.GetValue(COM_Affinity) as Int
    akTerminalRef.AddTextReplacementValue("SelectedAffinity", iAffinity as Float)
    akTerminalRef.AddTextReplacementData("SelectedAffinityLevel", GetCurrentAffinityLevel(theCompanionRef))
    akTerminalRef.AddTextReplacementData("SelectedAngerLevel", GetAngry(theCompanionRef))
  EndIf
EndEvent

Message Function GetCurrentAffinityLevel(ObjectReference akCompanion)
  Message msgCompanionRelationship
  Int fAffinityLevel = akCompanion.GetValue(COM_AffinityLevel) as Int
  bool bIsCommitted = akCompanion.GetValue(COM_IsCommitted) as bool
  bool bIsRomantic = akCompanion.GetValue(COM_IsRomantic) as bool
  If bIsCommitted
    msgCompanionRelationship = TGAH_AffinityLevelCommittedMsg
  ElseIf bIsRomantic && !bIsCommitted
    msgCompanionRelationship = TGAH_AffinityLevelRomanticMsg
  ElseIf fAffinityLevel == COM_AffinityLevel_2_Affection.GetValueInt()
    msgCompanionRelationship = TGAH_AffinityLevelFriendAllyMsg
  ElseIf fAffinityLevel == COM_AffinityLevel_1_Friendship.GetValueInt()
    msgCompanionRelationship = TGAH_AffinityLevelFriendMsg
  ElseIf fAffinityLevel == COM_AffinityLevel_0_Neutral.GetValueInt()
    msgCompanionRelationship = TGAH_AffinityLevelNeutralMsg
  EndIf
  return msgCompanionRelationship      
EndFunction

Message Function GetAngry(ObjectReference akCompanion)
  Message msgCompanionAnger
  Int fAngerLevel = akCompanion.GetValue(COM_AngerLevel) as Int
  If fAngerLevel == 0
    msgCompanionAnger = TGAH_AngerLevelNotAngryMsg
  ElseIf fAngerLevel == 1
    msgCompanionAnger = TGAH_AngerLevelAnnoyedMsg
  ElseIf fAngerLevel == 2
    msgCompanionAnger = TGAH_AngerLevelAngryMsg
  ElseIf fAngerLevel == 3
    msgCompanionAnger = TGAH_AngerLevelFuriousMsg
  EndIf
  return msgCompanionAnger
EndFunction