ScriptName TGAH:TermMenu_RandomizeMCScript Extends TerminalMenu hidden

;-- Properties --------------------------------------

GlobalVariable Property TGAF_Global_COM_RandomizeMC_Delay Auto Mandatory
GlobalVariable Property TGAF_Global_COM_RandomizeMC_Notifications Auto Mandatory
GlobalVariable Property TGAF_Global_COM_RandomizeMC_Toggle Auto Mandatory
Message Property TGAH_SettingsMisc_RandomizeMCDelay_1 Auto Const Mandatory
Message Property TGAH_SettingsMisc_RandomizeMCDelay_2 Auto Const Mandatory
Message Property TGAH_SettingsMisc_RandomizeMCDelay_3 Auto Const Mandatory
Message Property TGAH_SettingsMisc_RandomizeMCDelay_4 Auto Const Mandatory
Message Property TGAH_SettingsMisc_RandomizeMCDelay_5 Auto Const Mandatory
Message Property TGAH_Off Auto Const Mandatory
Message Property TGAH_On Auto Const Mandatory
TGAH:RandomizeMC Property TGAH_SystemQuest Auto Const Mandatory
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory

Int iCurrentDelay
Float fCurrentNotifications
Float fCurrentToggle

;-- Events ------------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  iCurrentDelay = TGAF_Global_COM_RandomizeMC_Delay.GetValue() as Int
  fCurrentNotifications = TGAF_Global_COM_RandomizeMC_Notifications.GetValue()
  fCurrentToggle = TGAF_Global_COM_RandomizeMC_Toggle.GetValue()
  If fCurrentToggle == 0.0
    akTerminalRef.AddTextReplacementData("CurrentRandomizeBool", TGAH_Off)
  ElseIf fCurrentToggle == 1.0
    akTerminalRef.AddTextReplacementData("CurrentRandomizeBool", TGAH_On)
  EndIf 
  If iCurrentDelay == 60
    akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_1)
  ElseIf iCurrentDelay == 120
    akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_2)
  ElseIf iCurrentDelay == 180
    akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_3)
  ElseIf iCurrentDelay == 240
    akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_4)
  ElseIf iCurrentDelay == 300
    akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_5)
  EndIf
  If fCurrentNotifications == 0.0
    akTerminalRef.AddTextReplacementData("CurrentNoficationsBool", TGAH_Off)
  ElseIf fCurrentNotifications == 1.0
    akTerminalRef.AddTextReplacementData("CurrentNoficationsBool", TGAH_On)
  EndIf 
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    iCurrentDelay = TGAF_Global_COM_RandomizeMC_Delay.GetValue() as Int
    fCurrentNotifications = TGAF_Global_COM_RandomizeMC_Notifications.GetValue()
    fCurrentToggle = TGAF_Global_COM_RandomizeMC_Toggle.GetValue()
    If auiMenuItemID == 0
      If fCurrentToggle == 0.0
        TGAH_SystemQuest.ToggleRandomizing()
        akTerminalRef.AddTextReplacementData("CurrentRandomizeBool", TGAH_On)
      ElseIf fCurrentToggle == 1.0
        TGAH_SystemQuest.ToggleRandomizing()
        akTerminalRef.AddTextReplacementData("CurrentRandomizeBool", TGAH_Off)
      EndIf 
    ElseIf auiMenuItemID == 1
      If fCurrentNotifications == 0.0
        TGAF_Global_COM_RandomizeMC_Notifications.SetValue(1.0)
        akTerminalRef.AddTextReplacementData("CurrentNoficationsBool", TGAH_On)
      ElseIf fCurrentNotifications == 1.0
        TGAF_Global_COM_RandomizeMC_Notifications.SetValue(0.0)
        akTerminalRef.AddTextReplacementData("CurrentNoficationsBool", TGAH_Off)
      EndIf 
    ElseIf auiMenuItemID == 2
      If iCurrentDelay == 60
        TGAF_Global_COM_RandomizeMC_Delay.SetValue(120.0)
        akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_2)
      ElseIf iCurrentDelay == 120
        TGAF_Global_COM_RandomizeMC_Delay.SetValue(180.0)
        akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_3)
      ElseIf iCurrentDelay == 180
        TGAF_Global_COM_RandomizeMC_Delay.SetValue(240.0)
        akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_4)
      ElseIf iCurrentDelay == 240
        TGAF_Global_COM_RandomizeMC_Delay.SetValue(300.0)
        akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_5)
      ElseIf iCurrentDelay == 300
        TGAF_Global_COM_RandomizeMC_Delay.SetValue(60.0)
        akTerminalRef.AddTextReplacementData("CurrentDelay", TGAH_SettingsMisc_RandomizeMCDelay_1)
      EndIf
    EndIf
  EndIf
EndEvent