ScriptName TGAH:RandomizeMC Extends Quest Hidden

Form[] Property AllCompanionRefs Auto Const Mandatory
ActorValue Property TGAH_COM_Setting_Chat_Triggers Auto Mandatory
ActorValue Property TGAH_COM_Setting_Chat_Looting Auto Mandatory
GlobalVariable Property TGAF_Global_COM_ID_Main Auto Mandatory
GlobalVariable Property TGAF_Global_COM_RandomizeMC_Toggle Auto Mandatory
GlobalVariable Property TGAF_Global_COM_RandomizeMC_Delay Auto Const Mandatory
GlobalVariable Property TGAF_Global_COM_RandomizeMC_Notifications Auto Const Mandatory
GlobalVariable Property COM_CompanionID_Andreja Auto Const Mandatory
GlobalVariable Property COM_CompanionID_Barrett Auto Const Mandatory
GlobalVariable Property COM_CompanionID_SamCoe Auto Const Mandatory
GlobalVariable Property COM_CompanionID_SarahMorgan Auto Const Mandatory
SQ_FollowersScript Property SQ_Followers Auto Const Mandatory
TGAH:TGAH_CompanionsScript Property TGAH_Companions Auto Const Mandatory
ReferenceAlias Property Alias_ActiveCompanion Auto Const Mandatory
Alias Property Alias_Active Auto Const Mandatory

Int randomSpeakerTimerID = 5 Auto Const 
Int iRandomizeToggle Auto
Bool bShowNotifications Auto

Event OnTimer(int aiTimerID)
  If aiTimerID == randomSpeakerTimerID
    iRandomizeToggle = TGAF_Global_COM_RandomizeMC_Toggle.GetValue() as Int
    bShowNotifications = TGAF_Global_COM_RandomizeMC_Notifications.GetValue() as Bool
    If iRandomizeToggle == 1
      AutoRandomizeMainCompanion(bShowNotifications)
      StartTimer(TGAF_Global_COM_RandomizeMC_Delay.GetValue() as Int, randomSpeakerTimerID)
    EndIf
  EndIf
EndEvent

Function ToggleRandomizing()
  iRandomizeToggle = TGAF_Global_COM_RandomizeMC_Toggle.GetValue() as Int
  If iRandomizeToggle == 0
    TGAF_Global_COM_RandomizeMC_Toggle.SetValue(1.0)
    Debug.Notification("The Main Companion will now be randomized.")
    StartTimer(TGAF_Global_COM_RandomizeMC_Delay.GetValue() as Int, randomSpeakerTimerID)
  ElseIf iRandomizeToggle == 1
    TGAF_Global_COM_RandomizeMC_Toggle.SetValue(0.0)
    Debug.Notification("The Main Companion will no longer be randomized.")
    CancelTimer(randomSpeakerTimerID)
  EndIf
EndFunction

Function AutoRandomizeMainCompanion(Bool bShowMessages)
  ; Get active companions as only a currently active companion should be selected
  Int iCurrentMC = TGAF_Global_COM_ID_Main.GetValue() as Int
  ; This gets all followers, even crew members
  ObjectReference[] ActiveCompanionsArray = (Alias_Active as RefCollectionAlias).GetArray()
  Int I = 0
  While I < ActiveCompanionsArray.Length
    ObjectReference currentCompanion = ActiveCompanionsArray[I]
    ; If the active follower is NOT a Constellation companion, remove them. Crew cannot be the MC.
    If AllCompanionRefs.Find(currentCompanion as Form) < 0
      ActiveCompanionsArray.Remove(I)
    ; If the active follower is a Constellation companion, check to see if they are the current main companion
    ElseIf AllCompanionRefs.Find(currentCompanion as Form) >= 0
      Int iCurrentCompID = (currentCompanion as companionactorscript).GetCompanionIDValue() as Int
      ; If they are the current MC, remove them so they are not selected twice in a row.
      If  iCurrentMC == iCurrentCompID
        ActiveCompanionsArray.Remove(I)
      EndIf
    EndIf
    I += 1
  EndWhile

  ; Find a random active companion
  Int randomArrayIndex = 0
  ObjectReference theRandomActiveCompanion
  theRandomActiveCompanion = None
  ;If there's more than one companion available, randomize who is going to be the new MC
  If ActiveCompanionsArray.Length > 1 
    randomArrayIndex = Utility.RandomInt(0, ActiveCompanionsArray.Length - 1)
    theRandomActiveCompanion = ActiveCompanionsArray[randomArrayIndex]
  ;If there is only one, just pick them
  ElseIf ActiveCompanionsArray.Length == 1
    theRandomActiveCompanion = ActiveCompanionsArray[0]
  EndIf

  ; Reset AVIFs for all companions
  Int J = 0
  While J < AllCompanionRefs.Length
    ObjectReference currentCompanionRef = AllCompanionRefs[J] as ObjectReference
    ;Reset AVIFs for all companions to remove them from any chat settings they may have previously been selected for.
    currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Triggers, 0.0)
    currentCompanionRef.SetValue(TGAH_COM_Setting_Chat_Looting, 0.0)
    J += 1
  EndWhile

  ; Set the random companion as the MC
  ; Set AVIFs and GLOB
  theRandomActiveCompanion.SetValue(TGAH_COM_Setting_Chat_Triggers, 1.0)
  theRandomActiveCompanion.SetValue(TGAH_COM_Setting_Chat_Looting, 1.0)
  TGAF_Global_COM_ID_Main.SetValue((theRandomActiveCompanion as companionactorscript).GetCompanionIDValue())
  ; This will add the companioncheckperk for the main companion to the player.
  TGAH_Companions.AddMainCompanionPerk(theRandomActiveCompanion)
  ; Add to ActiveCompanion alias (determines who speaks during quests)
  Alias_ActiveCompanion.ForceRefTo(theRandomActiveCompanion)

  ; Get selected MC Message
  String NewMCMessage
  Float currentMCID = (theRandomActiveCompanion as companionactorscript).GetCompanionIDValue()
  If currentMCID == COM_CompanionID_Andreja.GetValue()
     NewMCMessage = "Andreja is now your Main Companion"
  ElseIf currentMCID == COM_CompanionID_Barrett.GetValue()
    NewMCMessage = "Barrett is now your Main Companion"
  ElseIf currentMCID == COM_CompanionID_SamCoe.GetValue()
    NewMCMessage = "Sam is now your Main Companion"
  ElseIf currentMCID == COM_CompanionID_SarahMorgan.GetValue()
    NewMCMessage = "Sarah is now your Main Companion"
  EndIf
  If bShowMessages
    Debug.Notification(NewMCMessage)
  EndIf
EndFunction