ScriptName TGAH:TermMenu_CompanionsCommandScript Extends TerminalMenu hidden


;-- Properties --------------------------------------

Form[] Property AllCompanionRefs Auto Const Mandatory
Form[] Property AllCompanionActors Auto Const Mandatory

Group Misc_Autofill
  GlobalVariable Property TGAF_Global_COM_CurrentMenuItem Auto Mandatory
  GlobalVariable Property TGAF_Global_COM_ID_Main Auto Mandatory
  TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
  ConditionForm Property COM_CND_DIAL_TopLevel_Wait Auto Const Mandatory
  Keyword Property Contraband Auto Const mandatory
  TGAH:TGAH_CompanionsScript Property TGAH_Companions Auto Const Mandatory  
  SQ_FollowersScript Property SQ_Followers Auto Const Mandatory
  SQ_CompanionsScript Property SQ_Companions Auto Const Mandatory
EndGroup

Group ActorValue_Autofill
  Actor Property PlayerRef Auto Const mandatory
  ActorValue Property COM_ActiveCompanion Auto Const mandatory
  ActorValue Property FOL_ActiveFollower Auto Const Mandatory
  ActorValue Property TGAH_COM_MenuFilter_Active Auto mandatory
  ActorValue Property TGAH_COM_MenuFilter_Available Auto mandatory
  ActorValue Property TGAH_COM_MenuFilter_Main Auto Mandatory
  ActorValue Property TGAH_COM_MenuFilter_Waiting Auto mandatory
  ActorValue Property COM_CurrentStoryGateTimerExpired Auto mandatory
EndGroup

Group Messages_Autofill
  Message Property TGAH_EmptyMsg Auto Const mandatory
  Message Property TGAH_FollowerActiveMsg Auto Const mandatory
  Message Property TGAH_IsMainCompanionMsg Auto Const Mandatory 
  Message Property TGAH_IsWaitingMsg Auto Const mandatory
EndGroup


Int TimerID_CompanionFollowFix = 1
Int iTryFixNo = 0

;-- Events ------------------------------------------

Event OnTimer(Int aiTimerID)
  ; Resets the type of fix to apply for Fix Companion Stopped Following
  If aiTimerID == TimerID_CompanionFollowFix
    iTryFixNo = 0
  EndIf
EndEvent

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  Int index = TGAF_Global_COM_CurrentMenuItem.GetValue() as Int
  Form theCompanion = AllCompanionActors[index]
  ObjectReference theCompanionRef = AllCompanionRefs[index] as ObjectReference
  Int iMain = TGAF_Global_COM_ID_Main.GetValue() as Int
  Int iCompID = (theCompanionRef as companionactorscript).GetCompanionIDValue() as Int
  bool isActive = theCompanionRef.GetValue(COM_ActiveCompanion) as bool
  akTerminalRef.AddTextReplacementData("SelectedCompanion", theCompanion)
  ;Actively following
  If isActive
    akTerminalRef.AddTextReplacementData("SelectedCompanionActive", TGAH_FollowerActiveMsg)
    akTerminalRef.SetValue(TGAH_COM_MenuFilter_Active, 1.0)
  ElseIf !isActive
    akTerminalRef.AddTextReplacementData("SelectedCompanionActive", TGAH_EmptyMsg)
    akTerminalRef.SetValue(TGAH_COM_MenuFilter_Active, 0.0)
  EndIf
  ;Main Companion
  If iMain == iCompID
    akTerminalRef.AddTextReplacementData("SelectedCompanionMain", TGAH_IsMainCompanionMsg)
    akTerminalRef.SetValue(TGAH_COM_MenuFilter_Main, 1.0)
  ElseIf iMain != iCompID
    akTerminalRef.AddTextReplacementData("SelectedCompanionMain", TGAH_EmptyMsg)
    akTerminalRef.SetValue(TGAH_COM_MenuFilter_Main, 0.0)
  EndIf
  ;Waiting
  If COM_CND_DIAL_TopLevel_Wait.IsTrue(None, theCompanionRef)
    akTerminalRef.AddTextReplacementData("SelectedCompanionWaiting", TGAH_IsWaitingMsg)
    akTerminalRef.SetValue(TGAH_COM_MenuFilter_Waiting, 1.0)
  ElseIf !COM_CND_DIAL_TopLevel_Wait.IsTrue(None, theCompanionRef)
    akTerminalRef.AddTextReplacementData("SelectedCompanionWaiting", TGAH_EmptyMsg)
    akTerminalRef.SetValue(TGAH_COM_MenuFilter_Waiting, 0.0)
  EndIf
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    Int index = TGAF_Global_COM_CurrentMenuItem.GetValue() as Int
    ObjectReference CompanionRef = AllCompanionRefs[index] as ObjectReference
    Quest CompanionQuest = (CompanionRef as companionactorscript).COM_CompanionQuest as Quest
    com_companionquestscript compQuest = CompanionQuest as com_companionquestscript
    If auiMenuItemID == 0
      ; Set Main Companion
      TGAH_Companions.SetMainCompanion(CompanionRef)
      akTerminalRef.AddTextReplacementData("SelectedCompanionMain", TGAH_IsMainCompanionMsg)
      akTerminalRef.SetValue(TGAH_COM_MenuFilter_Main, 1.0)
    ElseIf auiMenuItemID == 1
      ; Wait
      SQ_Followers.CommandWait(CompanionRef as Actor, None)
      akTerminalRef.AddTextReplacementData("SelectedCompanionWaiting", TGAH_IsWaitingMsg)
      akTerminalRef.SetValue(TGAH_COM_MenuFilter_Waiting, 1.0)
    ElseIf auiMenuItemID == 2
      ; Follow
      SQ_Followers.CommandFollow(CompanionRef as Actor)
      akTerminalRef.AddTextReplacementData("SelectedCompanionWaiting", TGAH_EmptyMsg)
      akTerminalRef.SetValue(TGAH_COM_MenuFilter_Waiting, 0.0)
    ElseIf auiMenuItemID == 3
      ; Dismiss
      If SQ_Companions.IsCompanionLockedIn(CompanionRef as companionactorscript) == False
        SQ_Companions.SetRoleInactive(CompanionRef as Actor, True, False, True)
      EndIf
      ; Removes perk and stops story gate timer
      compQuest.DismissedAsCompanion()
      akTerminalRef.AddTextReplacementData("SelectedCompanionActive", TGAH_EmptyMsg)
      akTerminalRef.SetValue(TGAH_COM_MenuFilter_Active, 0.0)
    ElseIf auiMenuItemID == 4
      ; Teleport
      ; Make sure theCompanionRef is not empty
      If CompanionRef
        CompanionRef.MoveTo(PlayerRef, 0.0, 0.0, 0.0, True, True)
        ; If CompanionRef is not active, hire them after teleporting
        If !CompanionRef.GetValue(COM_ActiveCompanion)
          ; Pickup as companion
          If SQ_Companions.IsCompanionLockedIn(None) == False
            SQ_Companions.SetRoleActive(CompanionRef as Actor, True, True, 0.0, 0.0)
          EndIf
          ; Adds perk and starts story gate timer
          compQuest.PickedUpAsCompanion()
        EndIf
        akTerminalRef.AddTextReplacementData("SelectedCompanionActive", TGAH_FollowerActiveMsg)
        akTerminalRef.SetValue(TGAH_COM_MenuFilter_Active, 1.0)
      EndIf
    ElseIf auiMenuItemID == 5
      ;Open Inventory
      (CompanionRef as Actor).OpenInventory(True, Contraband as Form, False)
    ElseIf auiMenuItemID == 6
      compQuest.CancelTimer(1)
      CompanionRef.SetValue(COM_CurrentStoryGateTimerExpired, 1.0)
      compQuest.CheckAndSetWantsToTalk(True)
    ElseIf auiMenuItemID == 7
      ; Vanilla bug that causes followers to stop following. I believe it's due to them being in a scene when changing locations. 
      ; i.e. Sam talking to Cora on the ship when you leave the ship.
      ; So going to try force stopping the scene to see if that works
      ; Start a timer so that it resets back to the first fix option after 5 minutes.
      Self.StartTimer(300, TimerID_CompanionFollowFix)
      If iTryFixNo == 0
        If (CompanionRef as Actor).IsInScene()
          Scene currentScene = CompanionRef.GetCurrentScene()
          currentScene.Stop()
        EndIf
        iTryFixNo = 1
      EndIf
      If iTryFixNo == 1 
        ; Sometimes making them wait and follow seems to work so if the above doesn't work, do this instead.
        SQ_Followers.CommandWait(CompanionRef as Actor, None)
        Utility.Wait(0.1)
        SQ_Followers.CommandFollow(CompanionRef as Actor)
        Utility.Wait(0.1)
        iTryFixNo = 0
      EndIf
    EndIf
  EndIf
EndEvent

;-- Functions ---------------------------------------
