ScriptName TGAH:TermMenu_Affinity_StoryGatesScript Extends TerminalMenu hidden

;-- Variables ---------------------------------------

;-- Properties --------------------------------------

Form[] Property StoryGateTimersNoSG01 Auto Const Mandatory
GlobalVariable Property COM_StoryGate_TimerDuration_01_Standard Auto Mandatory
GlobalVariable Property COM_StoryGate_TimerDuration_02_Standard Auto Mandatory 
GlobalVariable Property TGAF_Global_COM_StoryGate_ModifyBy Auto Const Mandatory
TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
{ fill with the current menu }

;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  Int iModifyBy = TGAF_Global_COM_StoryGate_ModifyBy.GetValue() as Int
  Int iModifyByMinutes = iModifyBy/60
  Int iTimer01 = COM_StoryGate_TimerDuration_01_Standard.GetValue() as Int
  Int iTimer01Min = iTimer01/60
  Int iTimer02 = COM_StoryGate_TimerDuration_02_Standard.GetValue() as Int
  Int iTimer02Min = iTimer02/60
  akTerminalRef.AddTextReplacementValue("Current01", iTimer01 as Float)
  akTerminalRef.AddTextReplacementValue("Current02", iTimer02 as Float)
  akTerminalRef.AddTextReplacementValue("CurrentMin01", iTimer01Min as Float)
  akTerminalRef.AddTextReplacementValue("CurrentMin02", iTimer02Min as Float)
  akTerminalRef.AddTextReplacementValue("ModifyByMinutes", iModifyByMinutes as Float)
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    Int iModifyBy = TGAF_Global_COM_StoryGate_ModifyBy.GetValue() as Int
    Int iModifyByMinutes = iModifyBy/60
    Int iTimer01 = COM_StoryGate_TimerDuration_01_Standard.GetValue() as Int
    ;We need to know if we should increase or decrease the timer
    If auiMenuItemID == 0
      iTimer01 += iModifyBy   
    ElseIf auiMenuItemID == 1
      iTimer01 -= iModifyBy
    EndIf
    ;Set the first timer to the new value
    COM_StoryGate_TimerDuration_01_Standard.SetValue(iTimer01 as Float)
    ;Then set the rest of them to double that of SG01
    Int iTimer02 = iTimer01*2
    Int I = 0
    While I < StoryGateTimersNoSG01.Length
      GlobalVariable currentGlobal = StoryGateTimersNoSG01[I] as GlobalVariable
      currentGlobal.SetValue(iTimer02 as Float)        
      I += 1
    EndWhile  
    ;The number is in seconds, so we need to divide by 60
    Int iTimer01Min = iTimer01/60
    Int iTimer02Min = iTimer02/60
    akTerminalRef.AddTextReplacementValue("Current01", iTimer01 as Float)
    akTerminalRef.AddTextReplacementValue("Current02", iTimer02 as Float)
    akTerminalRef.AddTextReplacementValue("CurrentMin01", iTimer01Min as Float)
    akTerminalRef.AddTextReplacementValue("CurrentMin02", iTimer02Min as Float)
    akTerminalRef.AddTextReplacementValue("ModifyByMinutes", iModifyByMinutes as Float)
  EndIf
EndEvent