ScriptName TGAH:TermMenu_CrewCommandScript Extends TerminalMenu hidden

Form[] Property CrewRef Auto Const

Group Misc_Autofill
  Actor Property PlayerRef Auto Const mandatory
  GlobalVariable Property CurrentItemGlobal Auto Mandatory
  TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
  Keyword Property Contraband Auto Const mandatory
  SQ_FollowersScript Property SQ_Followers Auto Const mandatory 
  SQ_CrewScript Property SQ_Crew Auto Const mandatory 
EndGroup

Group ActorValue_Autofill
  ActorValue Property FOL_ActiveFollower Auto Const mandatory
  ActorValue Property TGAH_CREW_MenuFilter_Waiting Auto mandatory
  ActorValue Property TGAH_CREW_MenuFilter_Active Auto mandatory
  ActorValue Property FollowerState Auto Mandatory 
EndGroup

Group Messages_Autofill
  Message Property TGAH_IsWaitingMsg Auto Const mandatory
  Message Property TGAH_EmptyMsg Auto Const mandatory
  Message Property TGAH_FollowerActiveMsg Auto Const mandatory
EndGroup

ReferenceAlias Property ActiveEliteCrew Auto Const mandatory
{ 030 ActiveEliteCrew on SQ_Crew } 

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  Int index = CurrentItemGlobal.GetValue() as Int
  Form selectedItem = CrewRef[index]
  If selectedItem
    ObjectReference theCrewRef = selectedItem as ObjectReference
    bool isActive = theCrewRef.GetValue(FOL_ActiveFollower) as bool
    bool isWaiting = false
    If (theCrewRef.GetValue(FollowerState) == 2.0) && (theCrewRef.GetValue(FOL_ActiveFollower) == 1.0)
      isWaiting = true
    ElseIf (theCrewRef.GetValue(FollowerState) == 1.0) && (theCrewRef.GetValue(FOL_ActiveFollower) == 1.0)
      isWaiting = false
    EndIf
    ;Actively following
    If isActive
      akTerminalRef.AddTextReplacementData("CurrentCrewActive", TGAH_FollowerActiveMsg)
      akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Active, 1.0)
    ElseIf !isActive
      akTerminalRef.AddTextReplacementData("CurrentCrewActive", TGAH_EmptyMsg)
      akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Active, 0.0)
    EndIf
    ;Waiting
    If isWaiting
      akTerminalRef.AddTextReplacementData("CurrentCrewWaiting", TGAH_IsWaitingMsg)
      akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Waiting, 1.0)
    ElseIf !isWaiting
      akTerminalRef.AddTextReplacementData("CurrentCrewWaiting", TGAH_EmptyMsg)
      akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Waiting, 0.0)
    EndIf
  EndIf
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    Int index = CurrentItemGlobal.GetValue() as Int
    Form selectedItem = CrewRef[index]
    If selectedItem
      ObjectReference theCrewRef = CrewRef[index] as ObjectReference
      If auiMenuItemID == 0
        SQ_Followers.CommandWait(theCrewRef as Actor, None)
        akTerminalRef.AddTextReplacementData("CurrentCrewWaiting", TGAH_IsWaitingMsg)
        akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Waiting, 1.0)
      ElseIf auiMenuItemID == 1
        SQ_Followers.CommandFollow(theCrewRef as Actor)
        akTerminalRef.AddTextReplacementData("CurrentCrewWaiting", TGAH_EmptyMsg)
        akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Waiting, 0.0)
      ElseIf auiMenuItemID == 2
        Quest EliteQuest = (theCrewRef as elitecrewdebugscript).CrewQuest
        Crew_EliteCrewQuestScript crewQuest = EliteQuest as Crew_EliteCrewQuestScript
        ;We must first make sure they are in the activeelitecrew alias or they will not be dismissed properly.
        ActiveEliteCrew.Clear()
        ActiveEliteCrew.ForceRefTo(theCrewRef)
        crewQuest.DismissSceneEnded()
        akTerminalRef.AddTextReplacementData("CurrentCrewActive", TGAH_EmptyMsg)
        akTerminalRef.SetValue(TGAH_CREW_MenuFilter_Active, 0.0)
      ElseIf auiMenuItemID == 3
        theCrewRef.MoveTo(PlayerRef, 0.0, 0.0, 0.0, True, True)
        If theCrewRef.GetValue(FOL_ActiveFollower) != 1.0          
          Quest EliteQuest = (theCrewRef as elitecrewdebugscript).CrewQuest
          Crew_EliteCrewQuestScript crewQuest = EliteQuest as Crew_EliteCrewQuestScript
          crewQuest.PickupSceneEnded()
        EndIf
        akTerminalRef.AddTextReplacementData("CurrentCrewActive", TGAH_FollowerActiveMsg)
      ElseIf auiMenuItemID == 4
        (theCrewRef as Actor).OpenInventory(True, Contraband as Form, False)
      EndIf 
    EndIf
  EndIf
EndEvent