ScriptName TGAH:TermMenu_CrewViewScript Extends TerminalMenu hidden

;-- Properties --------------------------------------
Group Required_Properties
  Form[] Property CrewActors Auto Const Mandatory
  Form[] Property CrewQuests Auto Const Mandatory
  Form[] Property HideMenuItemAVIFs Auto Mandatory
  TerminalMenu Property CurrentTerminalMenu Auto Const Mandatory
  TerminalMenu Property CurrentTerminalSubmenu Auto Const Mandatory
  ActorValue Property ItemCountAV Auto Mandatory
  GlobalVariable Property CurrentItemGlobal Auto Mandatory
  { Global Variable that holds the currenlty selected menu item }
  Message Property TGAH_NameChange_SupervisorLin Auto Const Mandatory
  Faction Property AvailableCrewFaction Auto Const Mandatory
EndGroup

Group DoNotFill Collapsed
  Actor Property clearTheCrew Auto
EndGroup


;-- Events ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    Self.UpdateTextReplacement(akTerminalRef)
  EndIf
EndEvent

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
  If akTerminalBase == CurrentTerminalMenu
    If auiMenuItemID < CrewActors.Length
      Form selectedItem = CrewActors[auiMenuItemID]
      If selectedItem
        CurrentItemGlobal.SetValue(auiMenuItemID as Float)
        Form theCrew = CrewActors[auiMenuItemID]        
        ; Unique case for Lin to change her name
        If auiMenuItemID == 12
          akTerminalRef.AddTextReplacementData("CurrentCrew", TGAH_NameChange_SupervisorLin)
        Else
          akTerminalRef.AddTextReplacementData("CurrentCrew", theCrew) 
        EndIf
      EndIf
    EndIf
  ElseIf akTerminalBase == CurrentTerminalSubmenu && auiMenuItemID == 0
    Self.UpdateTextReplacement(akTerminalRef)
  EndIf
EndEvent

Function UpdateTextReplacement(ObjectReference akTerminalRef)
  clearTheCrew = None
  Int I = 0
  While I < CrewActors.Length
    Form currentCrew = CrewActors[I]
    Quest currentQuest = CrewQuests[I] as Quest
    ActorValue hideMe = HideMenuItemAVIFs[I] as ActorValue
    ; Unique case for Lin to change her name
    If I == 12
      akTerminalRef.AddTextReplacementData("theCrew" + I as String, TGAH_NameChange_SupervisorLin)
    Else
      akTerminalRef.AddTextReplacementData("theCrew" + I as String, currentCrew)
    EndIf
    If currentQuest.GetStageDone(50) == true
      akTerminalRef.SetValue(hideMe, 0.0)
    ElseIf currentQuest.GetStageDone(50) == false
      akTerminalRef.SetValue(hideMe, 1.0)
    EndIf
    I += 1
  EndWhile
  akTerminalRef.SetValue(ItemCountAV, I as Float)
EndFunction