ScriptName RequisitionKioskActivatorScript Extends ObjectReference
{ script for accessing the vendor menu via an activator }

;-- Variables ---------------------------------------
Actor myVendor
ObjectReference myVendorContainer

;-- Properties --------------------------------------
conditionform Property AccessConditions Auto Const
{ optional - if included, this condition must be true to open the menu }
Message Property AccessFailureMessage Auto Const
{ optional - if included, message will be displayed if the AccessConditions are false }
ActorBase Property Vendor Auto Const mandatory
{ vendor to create on load }
Container Property VendorContainer Auto Const mandatory
{ vendor container to create on load }
Keyword Property VendorContainerKeyword01 Auto Const mandatory
{ used to link vendor container }
Bool Property ClearVendorActorInventoryOnLoad = False Auto Const
{ If true, the spawned Vendor actor will have its inventory cleared each time the Activator loads. }

;-- Functions ---------------------------------------

Event OnLoad()
  If myVendor == None ; #DEBUG_LINE_NO:21
    myVendor = Self.PlaceActorAtMe(Vendor, 4, None, False, True, True, None, True) ; #DEBUG_LINE_NO:22
    myVendorContainer = Self.PlaceAtMe(VendorContainer as Form, 1, False, True, True, None, None, True) ; #DEBUG_LINE_NO:23
    myVendor.SetLinkedRef(myVendorContainer, VendorContainerKeyword01, True) ; #DEBUG_LINE_NO:24
  EndIf
  If ClearVendorActorInventoryOnLoad ; #DEBUG_LINE_NO:28
    myVendor.RemoveAllItems(None, False, False) ; #DEBUG_LINE_NO:29
  EndIf
EndEvent

Event OnActivate(ObjectReference akActionRef)
  If akActionRef == Game.GetPlayer() as ObjectReference ; #DEBUG_LINE_NO:35
    If AccessConditions == None || AccessConditions.IsTrue(Game.GetPlayer() as ObjectReference, Self as ObjectReference) ; #DEBUG_LINE_NO:39
      myVendor.ShowBarterMenu()
    ElseIf AccessFailureMessage
      AccessFailureMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    EndIf
  EndIf
EndEvent
