ScriptName PSB:PSB_SleepingBagArmorScript Extends ObjectReference

;-- Variables ---------------------------------------

;-- Properties --------------------------------------
Actor Property PlayerRef Auto Const mandatory
Furniture Property PSB_FurnSleepingBag Auto Const mandatory

;-- Functions ---------------------------------------

Event OnContainerChanged(ObjectReference akNewContainer, ObjectReference akOldContainer)
  If !akNewContainer && (akOldContainer == PlayerRef as ObjectReference)
    Self.DisableNoWait(False)
    Self.UnpackSleepingBagNear(PlayerRef)
  EndIf
EndEvent

Function UnpackSleepingBagNear(Actor akUser)
  ObjectReference theSleepingBag = akUser.placeAtMe(PSB_FurnSleepingBag as Form, 1, False, True, True, None, None, True)
  Float playerRotation = akUser.getangleZ()
  If playerRotation > 180 as Float
    playerRotation -= 90 as Float
  Else
    playerRotation += 90 as Float
  EndIf
  theSleepingBag.SetAngle(0.0, 0.0, playerRotation)
  theSleepingBag.enable(True)
EndFunction
