ScriptName SitToAddPlayerAliasScript Extends ReferenceAlias

LocationRefType Property Ship_PilotSeat_RefType Auto
SQ_PlayerShipScript Property SQ_PlayerShip Auto
Message Property SitToAddMessage Auto
Message Property SitToAddDoneMessage Auto
ReferenceAlias Property ShipAlias Auto

Event OnSit(ObjectReference akFurniture)
  If akFurniture.HasRefType(Ship_PilotSeat_RefType) && (Game.IsGravJumpControlsEnabled() || Game.IsFarTravelControlsEnabled() || Game.IsFastTravelControlsEnabled() || Game.IsMenuControlsEnabled())
    SpaceShipReference newShip = Game.GetPlayer().GetCurrentShipRef()
    ShipAlias.ForceRefTo(newShip)
    If newShip && SQ_PlayerShip.PlayerShips.Find(newShip) < 0 && SitToAddMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) == 0
    	SQ_PlayerShip.AddPlayerOwnedShip(newShip)
    	SitToAddDoneMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    EndIf
  EndIf
EndEvent

Event OnLocationChange(Location akOldLoc, Location akNewLoc)
  SpaceShipReference oldShip = SQ_PlayerShip.HomeShip.GetShipReference()
  If SQ_PlayerShip.PlayerShip.GetShipReference() != oldShip
    SQ_PlayerShip.ResetPlayerShip(oldShip)
  EndIf
EndEvent