ScriptName SQ_PlayerIncreaseLevelScript Extends Quest

;-- Variables ---------------------------------------

;-- Properties --------------------------------------
GlobalVariable Property MB_MaxTargetLevel Auto Const mandatory
{ global for max encounter level }
GlobalVariable Property EncounterLevelMaxAdjustment Auto Const
{ how much to add to player level to get max encounter level global }
Spell Property WellnessAbilityRank01 Auto Const mandatory
Spell Property WellnessAbilityRank02 Auto Const mandatory
Spell Property WellnessAbilityRank03 Auto Const mandatory
Spell Property WellnessAbilityRank04 Auto Const mandatory

;-- Functions ---------------------------------------

Event OnQuestStarted()
  Actor playerRef = Game.GetPlayer() ; #DEBUG_LINE_NO:18
  Int playerLevel = playerRef.GetLevel() ; #DEBUG_LINE_NO:19
  MB_MaxTargetLevel.SetValueInt(playerLevel + EncounterLevelMaxAdjustment.GetValueInt()) ; #DEBUG_LINE_NO:23
  Self.RemoveAndReapplySpells(playerRef, WellnessAbilityRank01) ; #DEBUG_LINE_NO:25
  Self.RemoveAndReapplySpells(playerRef, WellnessAbilityRank02) ; #DEBUG_LINE_NO:26
  Self.RemoveAndReapplySpells(playerRef, WellnessAbilityRank03) ; #DEBUG_LINE_NO:27
  Self.RemoveAndReapplySpells(playerRef, WellnessAbilityRank04) ; #DEBUG_LINE_NO:28
  Self.Stop() ; #DEBUG_LINE_NO:30
EndEvent

Function RemoveAndReapplySpells(Actor akActor, Spell spellToRemoveAndReapply)
  Int timeoutIterations = 0 ; #DEBUG_LINE_NO:34
  If akActor.HasSpell(spellToRemoveAndReapply as Form) ; #DEBUG_LINE_NO:36
    akActor.removeSpell(spellToRemoveAndReapply) ; #DEBUG_LINE_NO:37
    While akActor.HasSpell(spellToRemoveAndReapply as Form) == True || timeoutIterations < 10 ; #DEBUG_LINE_NO:38
      Utility.Wait(0.100000001) ; #DEBUG_LINE_NO:39
      timeoutIterations += 1 ; #DEBUG_LINE_NO:40
    EndWhile
    akActor.addSpell(spellToRemoveAndReapply, True) ; #DEBUG_LINE_NO:42
    If timeoutIterations >= 10 ; #DEBUG_LINE_NO:44
      
    EndIf
  EndIf
EndFunction
