ScriptName MissionsGalore_TerminalMenu_Main_Script Extends TerminalMenu


;-- Variables ---------------------------------------

;-- Properties --------------------------------------

TerminalMenu Property MissionsGalore_TerminalMenu Auto Const mandatory
ActorValue Property MissionsGalore_AV_Settings_Selection Auto
Formlist Property MissionsGalore_FormList_MaxMissions Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Bounty Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_BountySpace Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Cargo Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Passenger Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Supply Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Survey Auto
GlobalVariable Property MissionsGalore_AutoSetActive Auto
FormList Property MissionsGalore_Messages_SetActive Auto


;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)

	If akTerminalBase == MissionsGalore_TerminalMenu 
		Debug.Trace("MG_TM " + akTerminalRef.GetValue(MissionsGalore_AV_Settings_Selection),0)
		akTerminalRef.AddTextReplacementData("MissionsGalore_AutoSetActive",MissionsGalore_Messages_SetActive.GetAt(MissionsGalore_AutoSetActive.GetValueInt()))
		int i = 0
		while i < MissionsGalore_FormList_MaxMissions.GetSize()
			akTerminalRef.AddTextReplacementValue("MissionsGalore_MBGeneric_" + i as string, (MissionsGalore_FormList_MaxMissions.GetAt(i) as GlobalVariable).GetValue())
			i = i + 1
		endwhile
	endif
EndEvent


Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)

	If akTerminalBase == MissionsGalore_TerminalMenu 
		akTerminalRef.SetValue(MissionsGalore_AV_Settings_Selection, auiMenuItemID)
		Debug.Trace("MG_TM2 " + akTerminalRef.GetValue(MissionsGalore_AV_Settings_Selection) + " " + auiMenuItemID,0)
	endif
EndEvent