ScriptName MissionsGalore_TerminalMenu_MaxMissions_Script Extends TerminalMenu


;-- Variables ---------------------------------------

;-- Properties --------------------------------------

TerminalMenu Property MissionsGalore_TerminalMenu Auto Const mandatory
ActorValue Property MissionsGalore_AV_Settings_Selection Auto
Formlist Property MissionsGalore_FormList_MaxMissions Auto
Formlist Property MissionsGalore_Messages_MaxMissionsTitles Auto

GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Bounty Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_BountySpace Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Cargo Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Passenger Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Supply Auto
GlobalVariable Property MissionsGalore_MaxMissions_MBGeneric_Survey Auto
Int[] Property MissionsGalore_Array_MissionMaximums Auto



;-- Functions ---------------------------------------

Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
 
	If akTerminalBase == MissionsGalore_TerminalMenu 
		GlobalVariable selectedGV = MissionsGalore_FormList_MaxMissions.GetAt(akTerminalRef.GetValue(MissionsGalore_AV_Settings_Selection) as int) as GlobalVariable
		Message menutitle = MissionsGalore_Messages_MaxMissionsTitles.GetAt(akTerminalRef.GetValue(MissionsGalore_AV_Settings_Selection) as int) as Message
		Debug.Trace("MG_TM_Max " + akTerminalRef.GetValue(MissionsGalore_AV_Settings_Selection) + " " + selectedGV.GetValue(),0)
		akTerminalRef.AddTextReplacementData("MissionsGalore_MaxMissions_Title", menutitle) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_p3", (selectedGV.GetValueInt() + 3 ) as Float) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_p1", (selectedGV.GetValueInt() + 1 ) as Float) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_m1", (selectedGV.GetValueInt() - 1 ) as Float) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_m3", (selectedGV.GetValueInt() - 3 ) as Float) 
	endif
EndEvent


Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)

	If akTerminalBase == MissionsGalore_TerminalMenu 
		int selected = akTerminalRef.GetValue(MissionsGalore_AV_Settings_Selection) as int
		GlobalVariable selectedGV = MissionsGalore_FormList_MaxMissions.GetAt(selected) as GlobalVariable
		Debug.Trace("MG_TM_Max2 " + selected + " " + selectedGV.GetValue() + " " + auiMenuItemID,0)
		If auiMenuItemID == 0
			selectedGV.SetValueInt(selectedGV.GetValueInt() + 3)
		elseIf auiMenuItemID == 1
			selectedGV.SetValueInt(selectedGV.GetValueInt() + 1)
		elseIf auiMenuItemID == 2
			selectedGV.SetValueInt(selectedGV.GetValueInt() - 1)
		elseIf auiMenuItemID == 3
			selectedGV.SetValueInt(selectedGV.GetValueInt() - 3)
		endif
		if selectedGV.GetValueInt() < 0 
			selectedGV.SetValueInt(0)
		elseif selectedGV.GetValueInt() > MissionsGalore_Array_MissionMaximums[selected]
			selectedGV.SetValueInt(MissionsGalore_Array_MissionMaximums[selected])
		endif
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MBGeneric_" + selected, selectedGV.GetValue())
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_p3", (selectedGV.GetValueInt() + 3 ) as Float) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_p1", (selectedGV.GetValueInt() + 1 ) as Float) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_m1", (selectedGV.GetValueInt() - 1 ) as Float) 
		akTerminalRef.AddTextReplacementValue("MissionsGalore_MaxMissions_m3", (selectedGV.GetValueInt() - 3 ) as Float) 
	endif
EndEvent

