ScriptName CS7ShipFuelFillerScript Extends Quest

sq_playershipscript Property SQ_PlayerShip Auto Const mandatory
DialogueShipServicesScript Property DialogueShipServices Auto Const mandatory

ActorValue Property SpaceshipGravJumpFuel Auto mandatory
ActorValue Property OutpostBuildAreaRadius Auto mandatory
Activator Property OutpostBeaconActivator Auto mandatory
Formlist Property CS7OutpostHe3ContainerList Auto
GlobalVariable Property CS7_ModEnabled Auto
Keyword Property CannotBeHomeShip Auto Const mandatory
Keyword Property IsStarstation Auto Const mandatory
Keyword Property LocTypeOutpost Auto Const mandatory
Message Property CS7_RefuelMessage Auto
Message Property CS7_BordingMessage Auto
Message Property CS7_LockMessage Auto
MiscObject Property InorgCommonHelium3 Auto
Perk Property CS7ShipFuelFillerButtonPerk Auto Const mandatory
Quest Property MQ101 Auto Const mandatory

Bool bAddPerk
Bool bModEnabled
Bool bDockingLink
Bool bHe3OutpostLink
Int ShipExitTimer = 10
Int ModStartTimer = 20
ObjectReference OutpostBeacon
ObjectReference[] He3Containers
spaceshipreference playerShipRef
spaceshipreference otherShipRef


EVENT OnQuestInit()
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnPlayerLoadGame")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipDock")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipUndock")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipTakeOff")
	bModEnabled = False
	bAddPerk = False
	StartTimer(1.0, ModStartTimer)
ENDEVENT


EVENT Actor.OnPlayerLoadGame(Actor akSender)
	Self.AddFuelFillerPerk()
	
	If (Game.IsPluginInstalled("SpaceShipFuelMod.esm") == False)
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnPlayerLoadGame")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnExitShipInterior")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipDock")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipUndock")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipTakeOff")
		Self.RemoveFuelFillerPerk()
		CancelTimer(ShipExitTimer)
		Self.Stop()
	EndIf
ENDEVENT


EVENT OnTimer(Int aiTimerID)
	If (aiTimerID == ShipExitTimer)
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnExitShipInterior")
		CS7_LockMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	EndIf
	If (aiTimerID == ModStartTimer)
		; first time landing in New Atlantis
		if MQ101.IsStageDone(1305) || MQ101.IsStageDone(1310)	; landing in New Atlantis
			bAddPerk = True
			Utility.Wait(0.1)
			Self.AddFuelFillerPerk()
		else
			StartTimer(20.0, ModStartTimer)
		endif
	EndIf
ENDEVENT


EVENT Actor.OnExitShipInterior(Actor akSender, ObjectReference akShip)
	CancelTimer(ShipExitTimer)
	Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnExitShipInterior")
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	If  playerShipRef
		Float fShipFuelTankCapacity = playerShipRef.GetBaseValue(SpaceshipGravJumpFuel)
		Float fShipFuelTankCurrent = playerShipRef.GetValue(SpaceshipGravJumpFuel)
	
		if bHe3OutpostLink || (GetHe3OutpostLinkFromLandingReference(Game.GetPlayer()) == True)
			fShipFuelTankCurrent = Self.He3OutpostAutoRefuelShip(fShipFuelTankCurrent, fShipFuelTankCapacity)
			Utility.Wait(3.0)
			Self.FuelGaugeMessage(fShipFuelTankCurrent, fShipFuelTankCapacity, 4)
			
		elseif Game.GetPlayer().Is3Dloaded() && akShip.Is3Dloaded() && (akShip.GetDistance(Game.GetPlayer()) < 80)
			Float fuelAvailable = (Game.GetPlayer().GetItemCount(InorgCommonHelium3) * 0.5)
			if (fuelAvailable > 0) && (fShipFuelTankCapacity > fShipFuelTankCurrent)
				Utility.Wait(3.0)
				if (CS7_RefuelMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) == 0)
					
					inputenablelayer myEnableLayer = inputenablelayer.Create()
					myEnableLayer.DisablePlayerControls(True, True, True, False, False, True, True, False, True, True, False)
					Game.FadeOutGame(True, True, 1, 0.5, True)
					Utility.Wait(1.0)
				
					Float fuelMax = (fShipFuelTankCapacity - fShipFuelTankCurrent)
					Float fuelAmount = Math.Min(fuelMax, fuelAvailable)
					playerShipRef.RestoreValue(SpaceshipGravJumpFuel, fuelAmount)
					DialogueShipServices.UpdateFuelGlobals()
					Int fuelToHe3Items = Math.Floor(fuelAmount * 2)
					Game.GetPlayer().RemoveItem(InorgCommonHelium3, fuelToHe3Items , False, None)
					fShipFuelTankCurrent += fuelAmount
					
					Utility.Wait(1.0)
					Game.FadeOutGame(False, True, 1.0, 0.5, True)
					myEnableLayer.Delete()
					Self.FuelGaugeMessage(fShipFuelTankCurrent, fShipFuelTankCapacity, 0)
				else
					CS7_LockMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
				endif
			else
				Utility.Wait(3.0)
				CS7_LockMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			endif
		endif
	EndIf
ENDEVENT


EVENT Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
	Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
	If bDockingLink && Game.GetPlayer().Is3Dloaded()
		Float fShipFuelTankCapacity = playerShipRef.GetBaseValue(SpaceshipGravJumpFuel)
		Float fShipFuelTankCurrent = playerShipRef.GetValue(SpaceshipGravJumpFuel)
		Float fuelAvailable = otherShipRef.GetValue(SpaceshipGravJumpFuel)
		if (fuelAvailable > 0) && (fShipFuelTankCapacity > fShipFuelTankCurrent)
			Utility.Wait(3.0)
			if (CS7_BordingMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) == 0)
			
				Float fuelMax = (fShipFuelTankCapacity - fShipFuelTankCurrent)
				Float fuelAmount = Math.Min(fuelMax, fuelAvailable)
				playerShipRef.RestoreValue(SpaceshipGravJumpFuel, fuelAmount)
				otherShipRef.DamageValue(SpaceshipGravJumpFuel, fuelAmount)
				DialogueShipServices.UpdateFuelGlobals()
				fShipFuelTankCurrent += fuelAmount
				
				Utility.Wait(1.0)
				Self.FuelGaugeMessage(fShipFuelTankCurrent, fShipFuelTankCapacity, 0)
			endif
		endif
		bDockingLink = False
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipDock(ReferenceAlias akSource, Bool abComplete, spaceshipreference akDocking, spaceshipreference akParent)
	If abComplete == False
		playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
		otherShipRef = None
		if playerShipRef == akDocking
			otherShipRef = akParent
		else
			otherShipRef = akDocking
		endif
		if otherShipRef && !otherShipRef.HasKeyword(IsStarstation) && !otherShipRef.HasKeyword(CannotBeHomeShip)
			if SQ_PlayerShip.PlayerShips.Find(otherShipRef as ObjectReference) == -1
				bDockingLink = True
			endif
		endif
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipUndock(ReferenceAlias akSource, Bool abComplete, spaceshipreference akUndocking, spaceshipreference akParent)
	If abComplete && bDockingLink
		bDockingLink = False
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
	If abComplete && !bHe3OutpostLink
		playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
		ObjectReference landingMarker = playerShipRef.GetLinkedRef(SQ_PlayerShip.LandingMarkerKeyword)
		Self.GetHe3OutpostLinkFromLandingReference(landingMarker)
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipTakeoff(ReferenceAlias akSender, Bool abComplete)
	If !abComplete
		bHe3OutpostLink = False
		Self.UnregisterForRemoteEvent(OutpostBeacon as ScriptObject, "OnWorkshopMode")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnExitShipInterior")
		CancelTimer(ShipExitTimer)
	EndIf
ENDEVENT


EVENT ObjectReference.OnWorkshopMode(ObjectReference akSender, Bool aStart)
	If aStart
		bHe3OutpostLink = False
	else
		Self.GetHe3OutpostLinkFromLandingReference(Game.GetPlayer())
	EndIf
ENDEVENT


Function AddFuelFillerPerk()
	Actor PlayerRef = Game.GetPlayer()
	If !PlayerRef.HasPerk(CS7ShipFuelFillerButtonPerk) && bAddPerk
		PlayerRef.AddPerk(CS7ShipFuelFillerButtonPerk, False)
	Endif
EndFunction


Function RemoveFuelFillerPerk()
	Actor PlayerRef = Game.GetPlayer()
	If PlayerRef.HasPerk(CS7ShipFuelFillerButtonPerk)
		PlayerRef.RemovePerk(CS7ShipFuelFillerButtonPerk)
	EndIf
EndFunction


Bool NoIdleA
Function PlayerRefuelShip(ObjectReference akTargetRef, Actor akActor)
	IF !NoIdleA
	NoIdleA = True
	;--------------
	Int iOpen = 0
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	If  playerShipRef
		Float fShipFuelTankCapacity = playerShipRef.GetBaseValue(SpaceshipGravJumpFuel)
		Float fShipFuelTankCurrent = playerShipRef.GetValue(SpaceshipGravJumpFuel)
		bModEnabled = CS7_ModEnabled.GetValue() as Bool
		if (bModEnabled == False)
			CS7_ModEnabled.SetValue(1.0000)
			Utility.Wait(0.1)
			iOpen = 5
		elseif (playerShipRef.IsInSpace() == False)
			Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnExitShipInterior")
			StartTimer(120.0, ShipExitTimer)	; 2 Minutes
			if bHe3OutpostLink
				iOpen = 3
			else
				iOpen = 1
			endif
		elseif bDockingLink
			Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
			iOpen = 2
		endif
		Self.FuelGaugeMessage(fShipFuelTankCurrent, fShipFuelTankCapacity, iOpen)
	EndIf
	;--------------
	NoIdleA = False
	ENDIF
EndFunction


Function FuelGaugeMessage(Float fShipFuelTankCurrent, Float fShipFuelTankCapacity, Int iOpen)
	Math.Round(fShipFuelTankCurrent)
	if iOpen == 1
		Debug.Notification("Fuel tanks unlocked.")
	elseif iOpen == 2
		Debug.Notification("Refueling coupling locked.")
	elseif iOpen == 3
		Debug.Notification("Exit ship for refueling.")
	elseif iOpen == 4
		Debug.Notification("Refueling completed.")
	elseif iOpen == 5
		Debug.Notification("The ship's tanks are full.")
	endif
	Debug.Notification("FUEL [ " + Math.Round(fShipFuelTankCurrent) + " / " +(fShipFuelTankCapacity as Int) + " ]")
EndFunction


Bool Function GetHe3OutpostLinkFromLandingReference(ObjectReference theReference)
	bHe3OutpostLink = False
	OutpostBeacon = None
	if theReference
		ObjectReference[] OutpostBeaconsArray = theReference.FindAllReferencesOfType(OutpostBeaconActivator as Form, 400)
		if (OutpostBeaconsArray.length == 1) && OutpostBeaconsArray[0].GetCurrentLocation().HasKeyword(LocTypeOutpost)
			OutpostBeacon = OutpostBeaconsArray[0]
			
			float He3SearchRadius = OutpostBeacon.GetValue(OutpostBuildAreaRadius)
			He3Containers = OutpostBeacon.FindAllReferencesOfType(CS7OutpostHe3ContainerList, He3SearchRadius)
			if He3Containers.Length > 0
				bHe3OutpostLink = True
				Self.RegisterForRemoteEvent(OutpostBeacon as ScriptObject, "OnWorkshopMode")
			endif
		endif
	endif
	Return bHe3OutpostLink
EndFunction


Float Function He3OutpostAutoRefuelShip(Float shipFuelCurrent, Float shipFuelCapacity)
	Float fuelAvailable = 0
	Int He3Count = 0
	Int i = 0
	while i < He3Containers.Length
		He3Count = He3Containers[i].GetItemCount(InorgCommonHelium3)
		fuelAvailable += (He3Count * 0.5)
		i += 1
	endwhile
	
	if fuelAvailable > 0
		Float fuelMax = (shipFuelCapacity - shipFuelCurrent)
		Float fuelAmount = Math.Min(fuelMax, fuelAvailable)
		playerShipRef.RestoreValue(SpaceshipGravJumpFuel, fuelAmount)
		DialogueShipServices.UpdateFuelGlobals()
		shipFuelCurrent += fuelAmount
		
		Float fuelToHe3Items = Math.Floor(fuelAmount * 2) 
		Float subtractor = 0
		i = 0
		while (i < He3Containers.Length) && (fuelToHe3Items > 0)
			He3Count = He3Containers[i].GetItemCount(InorgCommonHelium3)
			subtractor = Math.Min(He3Count, fuelToHe3Items)
			He3Containers[i].RemoveItem(InorgCommonHelium3, (subtractor as Int), True, None)
			fuelToHe3Items -= subtractor
			i += 1
		endwhile
	endif
	Return shipFuelCurrent
EndFunction
