Scriptname ShipFuelDataReceiverScript

; --------------------------------------------------
; Debug
Function OpenShipFuelModLog() Global
	;
EndFunction
Function CloseShipFuelModLog() Global
	;
EndFunction


; --------------------------------------------------
; C++ code calls this script because it is the default of sScriptName in ..\Starfield\Data\SFSE\Plugins\ShipFuelDataSender.ini



; -----------------------------------------------------------------------------------------------------------------------------------------------------
; Callback functions; called from C++ code (..\Starfield\Data\SFSE\Plugins\ShipFuelDataSender.dll)
; upon receiving a native event.

Function OnLandingInputInProgress(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnMarkerGroupContainerVisibilityChanged(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnMarkerGroupEntryClicked(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnMarkerGroupEntryHoverChanged(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnShowRealCursor(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnQuickSelectChange(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnHintButtonClicked(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnGalaxyFocusSystem(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnCancel(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnClearRoute(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnOutpostEntrySelected(Float sFuelConsumption, Float sMaxFuelRange) Global
	;
EndFunction

Function OnExecuteRoute(Float sFuelConsumption, Float sMaxFuelRange) Global
	String ModName
	If Game.IsPluginInstalled("SpaceShipFuelMod.esm") == 1 as Bool
		ModName = "SpaceShipFuelMod.esm"
	EndIf
	CS7SpaceShipFuelScript MyQuestScript = Game.GetFormFromFile(2048, ModName) as CS7SpaceShipFuelScript; Hex 0800 equals 2048
	If MyQuestScript as Bool
		MyQuestScript.RouteExecute(sFuelConsumption, sMaxFuelRange)
	EndIf	
EndFunction




; -----------------------------------------------------------------------------------------------------------------------------------------------------
; Callback function; called from C++ code after one of the two "Convenience functions" below is called.
; it works like this: the SFSE plugin has a native console command named "ShipFuelRequestCallback" which takes one String as parameter.
; This parameter can be either "maxfuelrange" or "fuelconsumption" (case-insensitive).
; Once the console command is received the SFSE plugin calls OnRequestedCallback.
; Depending on the provided parameter, fValue is either the max fuel range or the fuel consumption.

Function OnRequestedCallback(Float fValue) Global
	String ModName
	If Game.IsPluginInstalled("SpaceShipFuelMod.esm") == 1 as Bool
		ModName = "SpaceShipFuelMod.esm"
	EndIf
	CS7SpaceShipFuelScript MyQuestScript = Game.GetFormFromFile(2048, ModName) as CS7SpaceShipFuelScript; Hex 0800 equals 2048
	If MyQuestScript as Bool
		MyQuestScript.RouteCalculationCallback(fValue)
	EndIf
EndFunction

; -----------------------------------------------------------------------------------------------------------------------------------------------------
; Convenience Papyrus functions; the console command for example "ShipFuelRequestCallback maxfuelrange" would work too.

Function RequestMaxFuelRangeCallback() Global
	Debug.ExecuteConsole("ShipFuelRequestCallback" + " " + "MaxFuelRange")
EndFunction

Function RequestFuelConsumptionCallback() Global
	Debug.ExecuteConsole("ShipFuelRequestCallback" + " " + "FuelConsumption")
EndFunction





















