ScriptName CS7SpaceShipFuelScript Extends Quest
{ Script for the fuel calculation including flying to or over an outpost. }

Group OutpostFuelStorage
ActorValue Property ResourceInorgCommonHelium3 Auto mandatory
Activator Property OutpostBeaconActivator Auto mandatory
{ used to find an outpost and locate of the workshop reference }
ActorValue Property OutpostBuildAreaRadius Auto mandatory
{ used to find the fuel containers in the outpost area }
Keyword Property LocTypeOutpost Auto Const mandatory
{ used to identify the outpost location }
Keyword Property OutpostProductionHalted Auto Const mandatory
{ not used but might be of use }
Formlist Property CS7OutpostHe3ContainerList Auto
{ list of all kind of Fuel containers}
RefCollectionAlias Property FuelContainerOutpost00 Auto
RefCollectionAlias Property FuelContainerOutpost01 Auto
RefCollectionAlias Property FuelContainerOutpost02 Auto
RefCollectionAlias Property FuelContainerOutpost03 Auto
RefCollectionAlias Property FuelContainerOutpost04 Auto
RefCollectionAlias Property FuelContainerOutpost05 Auto
RefCollectionAlias Property FuelContainerOutpost06 Auto
RefCollectionAlias Property FuelContainerOutpost07 Auto
RefCollectionAlias Property FuelContainerOutpost08 Auto
RefCollectionAlias Property FuelContainerOutpost09 Auto
RefCollectionAlias Property FuelContainerOutpost10 Auto
RefCollectionAlias Property FuelContainerOutpost11 Auto
RefCollectionAlias Property FuelContainerOutpost12 Auto
RefCollectionAlias Property FuelContainerOutpost13 Auto
RefCollectionAlias Property FuelContainerOutpost14 Auto
RefCollectionAlias Property FuelContainerOutpost15 Auto
RefCollectionAlias Property FuelContainerOutpost16 Auto
RefCollectionAlias Property FuelContainerOutpost17 Auto
RefCollectionAlias Property FuelContainerOutpost18 Auto
RefCollectionAlias Property FuelContainerOutpost19 Auto
RefCollectionAlias Property FuelContainerOutpost20 Auto
RefCollectionAlias Property FuelContainerOutpost21 Auto
RefCollectionAlias Property FuelContainerOutpost22 Auto
RefCollectionAlias Property FuelContainerOutpost23 Auto
{ collection of Fuel containers in list per outpost}
RefCollectionAlias Property OutpostWorkshopRefs Auto
{ collection of registered outpost references }
ReferenceAlias Property CurrentOutpost Auto
{ alias for the current outpost reference }
EndGroup

Group ShipAndFuel
ActorValue Property SpaceshipGravJumpFuel Auto mandatory
{ AV on ship that tracks fuel amount /capacity BaseValue equals maximum capacyty }
ActorValue Property SpaceshipGravJumpFlatFuelCost Auto Const
{ Every grav jump takes up this much fuel, regardless of distance }
GlobalVariable Property CS7_SpaceshipFarTravelFuelCost Auto Const
{ Every far travel takes up this much fuel, regardless of distance }
MiscObject Property InorgCommonHelium3 Auto
{ autofill }
sq_playershipscript Property SQ_PlayerShip Auto Const mandatory
{ autofill }
DialogueShipServicesScript Property DialogueShipServices Auto Const mandatory
{ autofill }
EndGroup

Group OtherRequired
ActorValue Property PlayerUnityTimesEntered Auto
GlobalVariable Property CS7_ModEnabled Auto
Quest Property MQ101 Auto Const mandatory
EndGroup


Bool bModEnabled
Bool bGravJump
Float fFuelConsumptionValue = 0
Float fFuelOutpostValue = 0
Int MyUnityRuns
Int LocationTimer = 10
Int ModTimer = 20
Int AutoActivateMod = 30
Int currentOutpostID
; array holding the total workshop Helium3 count (index equals workshop ID)
Int[] Helium3PerOutpost
; array holding the workshop reference and providing the workshop ID for each outpost (i.e. 0 - 23)
ObjectReference[] OutpostWorkshopIndex
spaceshipreference playerShipRef

; ----------------------------------------------------------------------------------------

EVENT OnQuestInit()
	OutpostWorkshopIndex = new ObjectReference[0]
	Helium3PerOutpost = new Int[0]
	currentOutpostID = -1
	Actor playerRef = Game.GetPlayer()
	Self.RegisterForRemoteEvent(playerRef as ScriptObject, "OnPlayerLoadGame")
	Self.RegisterForRemoteEvent(playerRef as ScriptObject, "OnExitShipInterior")
	Self.RegisterForRemoteEvent(playerRef as ScriptObject, "OnOutpostPlaced")
	Self.RegisterForRemoteEvent(playerRef as ScriptObject, "OnHomeShipSet")
	Self.RegisterForRemoteEvent(playerRef as ScriptObject, "OnPlayerModifiedShip")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipTakeOff")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipGravJump")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
;	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipRefueled")
	Self.RegisterForMenuOpenCloseEvent("GalaxyStarMapMenu")
	bModEnabled = False
	StartTimer(5.0, ModTimer)
ENDEVENT


EVENT Actor.OnPlayerLoadGame(Actor akSender)
	
	If (Game.IsPluginInstalled("SpaceShipFuelMod.esm") == False)
	
		Actor playerRef = Game.GetPlayer()
		Self.UnregisterForRemoteEvent(playerRef as ScriptObject, "OnPlayerLoadGame")
		Self.UnregisterForRemoteEvent(playerRef as ScriptObject, "OnExitShipInterior")
		Self.UnregisterForRemoteEvent(playerRef as ScriptObject, "OnLocationChange")
		Self.UnregisterForRemoteEvent(playerRef as ScriptObject, "OnOutpostPlaced")
		Self.UnregisterForRemoteEvent(playerRef as ScriptObject, "OnHomeShipSet")
		Self.UnregisterForRemoteEvent(playerRef as ScriptObject, "OnPlayerModifiedShip")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipLanding")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipTakeOff")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnLocationChange")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipGravJump")
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipFarTravel")
;		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipRefueled")
		Self.UnregisterForMenuOpenCloseEvent("GalaxyStarMapMenu")
		Self.Stop()
	EndIf
ENDEVENT

; ----------------------------------------------------------------------------------------

; called from ShipFuelDataReceiverScript
Function RouteExecute(Float sFuelConsumption, Float sMaxFuelRange)
	fFuelConsumptionValue = sFuelConsumption
;	Debug.MessageBox("Execute Consumption: " + fFuelConsumptionValue)
EndFunction


; Call: Debug.ExecuteConsole("ShipFuelRequestCallback" + " " + "FuelConsumption")
Function RouteCalculationCallback(Float fuelConsVal)
	fFuelConsumptionValue = fuelConsVal
EndFunction

; ----------------------------------------------------------------------------------------

Int iCountdown = 10
EVENT OnTimer(Int aiTimerID)
	If (aiTimerID == LocationTimer)
		if Game.GetPlayer().GetCurrentLocation().HasKeyword(LocTypeOutpost)
			StartTimer(60.0, LocationTimer)
		else
			Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		endif
	EndIf
	If (aiTimerID == ModTimer)
		MyUnityRuns = Game.GetPlayer().GetValueInt(PlayerUnityTimesEntered)
		if MQ101.IsStageDone(1305) || MQ101.IsStageDone(1310)
		; first time landing in New Atlantis done already
			bModEnabled = CS7_ModEnabled.GetValue() as Bool
			if !bModEnabled
				if iCountdown == 10
					Debug.Notification("Press [FUEL] to activate mod.")
					iCountdown -= 1
				elseif iCountdown == 0
					iCountdown = 10
				else	
					iCountdown -= 1
				endif
				StartTimer(5.0, ModTimer)
			else
				Game.RequestAutoSave()
				Debug.Notification("Fuel consumption is now enabled.")
			endif
		elseif (MyUnityRuns == 0)
		; new game and we haven't been to New Atlantis yet
			StartTimer(20.0, AutoActivateMod)
		else
			StartTimer(20.0, ModTimer)
		endif
	EndIf
	If (aiTimerID == AutoActivateMod)
		if MQ101.IsStageDone(1305) || MQ101.IsStageDone(1310)
			CS7_ModEnabled.SetValue(1.0000)
			Utility.Wait(0.1)
			bModEnabled = CS7_ModEnabled.GetValue() as Bool
			Game.RequestAutoSave()
			Debug.Notification("Fuel consumption is now enabled.")
		else
			StartTimer(20.0, AutoActivateMod)
		endif
	EndIf
ENDEVENT


EVENT OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)
	If (asMenuName == "GalaxyStarMapMenu") && bModEnabled
		if abOpening
			Self.CollectHelium3DataForAllOutposts()
			fFuelOutpostValue = 0
			fFuelConsumptionValue = 0
		endif
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipGravJump(ReferenceAlias akSender, Location aDestination, Int aState)
	If (akSender == SQ_PlayerShip.PlayerShip)
		bGravJump = aState as Bool
	EndIf
ENDEVENT

; fuel consumption event
EVENT ReferenceAlias.OnShipFarTravel(ReferenceAlias akSender, Location aDepartureLocation, Location aArrivalLocation, Int aState)
	If (akSender == SQ_PlayerShip.PlayerShip) && (aState == 0) && bModEnabled
		if bGravJump || fFuelConsumptionValue > 0
			; do nothing
		else
			Float FarTravelFuelCost = CS7_SpaceshipFarTravelFuelCost.GetValue()
			Float fShipFuelTankCapacity = playerShipRef.GetBaseValue(SpaceshipGravJumpFuel)
			Float fShipFuelTankCurrent = playerShipRef.GetValue(SpaceshipGravJumpFuel)
			Float fuelMax = (fShipFuelTankCapacity - fShipFuelTankCurrent)
			Float fuelAmount = Math.Min(FarTravelFuelCost, fShipFuelTankCurrent)
			playerShipRef.DamageValue(SpaceshipGravJumpFuel, fuelAmount)	
			DialogueShipServices.UpdateFuelGlobals()
		endif
	EndIf
ENDEVENT

; fuel consumption event
EVENT ReferenceAlias.OnLocationChange(ReferenceAlias akSender, Location akOldLoc, Location akNewLoc)
	If (akSender == SQ_PlayerShip.PlayerShip)
		If akOldLoc.HasKeyword(LocTypeOutpost) && (akNewLoc.HasKeyword(LocTypeOutpost) == False)
			if (currentOutpostID >= 0)
				Self.OnOutpostLeft()
				Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
				CancelTimer(LocationTimer)
			endif
		Endif
		If (akOldLoc != akNewLoc) && bModEnabled
			Utility.Wait(0.1)
			if bGravJump || fFuelConsumptionValue > 0	; only true for GravJump or FastTravel to another star system
				Self.CheckRefuelingAtRegisteredOutposts()
				Utility.Wait(0.1)
;				Debug.MessageBox("Fuel Consumption: " + fFuelConsumptionValue)
				Self.UpdateFuelValues(fFuelConsumptionValue, fFuelOutpostValue)
				fFuelConsumptionValue = 0
				fFuelOutpostValue = 0
			endif
			bGravJump = False
		EndIf
	EndIf
ENDEVENT

;/ n/a
EVENT ReferenceAlias.OnShipRefueled(ReferenceAlias akSender, Int aFuelAdded)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	if playerShipRef
		float gravJumpRange = playerShipRef.GetGravJumpRange()
		Debug.MessageBox("OnShipRefueled: F+ " + aFuelAdded + " / GJ-Range: " + gravJumpRange)
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ScriptObject, "OnShipRefueled")
	endif
ENDEVENT
/;
; update fuel globals for new ship
EVENT Actor.OnHomeShipSet(Actor akSource, spaceshipreference akShip, spaceshipreference akPrevious)
	If (akShip != akPrevious)
		playerShipRef = akShip
		ResetShipServicesDialogue()
	EndIf		
ENDEVENT

; update fuel globals for new ship
EVENT Actor.OnPlayerModifiedShip(Actor akSource, spaceshipreference akShip)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	If (akShip == playerShipRef)
		ResetShipServicesDialogue()
	EndIf
ENDEVENT

; check outpost for container collection changes
EVENT ReferenceAlias.OnWorkshopMode(ReferenceAlias akSender, Bool aStart)
	If !aStart
		Self.CallForUpdateCurrentOutpostFuelContainerCollection()
	EndIf
ENDEVENT

; check outpost for new gas container or He3 harvester
EVENT ReferenceAlias.OnWorkshopObjectPlaced(ReferenceAlias akSender, ObjectReference akReference)
	If (CS7OutpostHe3ContainerList.HasForm(akReference as Form) == True)
		Self.CallForUpdateCurrentOutpostFuelContainerCollection()
	Endif
ENDEVENT

; new outpost setup
EVENT Actor.OnOutpostPlaced(Actor akSender, ObjectReference akOutpostBeacon)
	If (currentOutpostID >= 0)
		Self.OnOutpostLeft()
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		CancelTimer(LocationTimer)
		Utility.Wait(0.1)
	Endif
	
	Int playerUnityRuns = Game.GetPlayer().GetValueInt(PlayerUnityTimesEntered)
	If (playerUnityRuns > MyUnityRuns)
		MyUnityRuns = playerUnityRuns
		Self.ResetModAfterUnity()
	EndIf
		
	ObjectReference myOutpostRef = akOutpostBeacon
	If myOutpostRef && Self.CleanOutpostWorkshopIndex()
		Int myOutpostID = Self.GetOutpostID(myOutpostRef)
		if (myOutpostID < 0)
			myOutpostID = Self.SetOutpostWorkshopIndex(myOutpostRef)
			if (bModEnabled == False)
				Debug.Notification("Outpost registered.")
			endif
		endif
		; set the CURRENT OUTPOST ID and REF
		currentOutpostID = myOutpostID
		CurrentOutpost.ForceRefTo(myOutpostRef)
		Self.OnOutpostDetect()
	EndIf
ENDEVENT

; outpost removed
EVENT ReferenceAlias.OnWorkshopObjectRemoved(ReferenceAlias akSource, ObjectReference akReference)
	If akReference == CurrentOutpost.GetRef()
		OutpostWorkshopRefs.RemoveRef(akReference)
		Int myOutpostID = Self.GetOutpostID(akReference)
		if myOutpostID >= 0
			OutpostWorkshopIndex[myOutpostID] = None
			Helium3PerOutpost[myOutpostID] = 0
			currentOutpostID = -1
		endif
		Self.OnOutpostLeft()
	EndIf
ENDEVENT

; used to detect outpost arrival
EVENT Actor.OnExitShipInterior(Actor akSender, ObjectReference akShip)
	If (currentOutpostID < 0) && Game.GetPlayer().GetCurrentLocation().HasKeyword(LocTypeOutpost)
		if (Self.GetOutpostIDFromLandingReference(Game.GetPlayer()) >= 0)
			Self.OnOutpostDetect()
		endif
	Endif
ENDEVENT

; used to detect outpost arrival
EVENT ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
	If abComplete && (currentOutpostID < 0)
		playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
		ObjectReference landingMarker = playerShipRef.GetLinkedRef(SQ_PlayerShip.LandingMarkerKeyword)
		if (Self.GetOutpostIDFromLandingReference(landingMarker) >= 0)
			Self.OnOutpostDetect()
		endif
	EndIf
ENDEVENT

; used to detect outpost departure
EVENT Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
	If Game.GetPlayer().GetCurrentLocation().HasKeyword(LocTypeOutpost)
		if (currentOutpostID < 0) && (Self.GetOutpostIDFromLandingReference(Game.GetPlayer()) >= 0)
			Self.OnOutpostDetect()
		endif
	ElseIf (currentOutpostID >= 0)
		Self.OnOutpostLeft()
	EndIf
ENDEVENT

; used to detect outpost departure
EVENT ReferenceAlias.OnShipTakeoff(ReferenceAlias akSender, Bool abComplete)
	If !abComplete && (currentOutpostID >= 0)
		Self.OnOutpostLeft()
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		CancelTimer(LocationTimer)
	EndIf
ENDEVENT

; used to detect outpost departure
EVENT ObjectReference.OnUnload(ObjectReference akSender)
	If (currentOutpostID >= 0)
		Self.OnOutpostLeft()
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
		CancelTimer(LocationTimer)
	EndIf
ENDEVENT

; ----------------------------------------------------------------------------------------

Function ResetShipServicesDialogue()
	if Game.IsPlayerInDialogue()
		Game.RequestDialogueExit()
	endif
	while (Game.IsPlayerInDialogue() == True)
		Utility.Wait(0.5)
	endwhile
	DialogueShipServices.UpdateFuelGlobals()
EndFunction


Function UpdateFuelValues(Float afConsumptionVal, Float afOutpostVal)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	If playerShipRef && bModEnabled
		Float fShipFuelTankCapacity = playerShipRef.GetBaseValue(SpaceshipGravJumpFuel)
		Float fShipFuelTankCurrent = playerShipRef.GetValue(SpaceshipGravJumpFuel)
		Float fuelDiffMaxTop = (fShipFuelTankCapacity - fShipFuelTankCurrent)
		if afOutpostVal > 0	; refuled
			if afOutpostVal > afConsumptionVal	; top up
				Float fuelDiff = afOutpostVal - afConsumptionVal
				Float fuelAmount = Math.Min(fuelDiffMaxTop, fuelDiff)
				if (fuelDiffMaxTop - fuelAmount) < 1 
					fuelAmount = fuelDiffMaxTop
				endif
				playerShipRef.RestoreValue(SpaceshipGravJumpFuel, fuelAmount)
			else
				Float fuelDiff = afConsumptionVal - afOutpostVal
				if fuelDiff < 1
					fuelDiff = 0
				endif
				Float fuelAmount = Math.Min(fShipFuelTankCurrent, fuelDiff)
				playerShipRef.DamageValue(SpaceshipGravJumpFuel, fuelAmount)
			endif
		else
			Float fuelAmount = Math.Min(afConsumptionVal, fShipFuelTankCurrent)
			playerShipRef.DamageValue(SpaceshipGravJumpFuel, fuelAmount)
		endif		
		DialogueShipServices.UpdateFuelGlobals()
	EndIf
EndFunction

; ----------------------------------------------------------------------------------------

; register current outpost and workshop events
Function OnOutpostDetect()
	Self.RegisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnWorkshopMode")
	Self.RegisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnWorkshopObjectPlaced")
	Self.RegisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnUnload")
	Self.RegisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnWorkshopObjectRemoved")
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
	StartTimer(60.0, LocationTimer)
EndFunction

; unregister current outpost and workshop events
Function OnOutpostLeft()
	Self.UnregisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnWorkshopMode")
	Self.UnregisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnWorkshopObjectPlaced")
	Self.UnregisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnWorkshopObjectRemoved")
	Self.UnregisterForRemoteEvent(CurrentOutpost as ScriptObject, "OnUnload")
	CurrentOutpost.Clear()
	currentOutpostID = -1
EndFunction


Int Function GetOutpostIDFromLandingReference(ObjectReference theReference)
	Int myOutpostID = -1
	if (currentOutpostID == -1) && (theReference as Bool)
		currentOutpostID = -2	; LOCK FUNCTION
		ObjectReference[] OutpostBeaconsArray = theReference.FindAllReferencesOfType(OutpostBeaconActivator as Form, 400)
		if (OutpostBeaconsArray.length == 1) && OutpostBeaconsArray[0].GetCurrentLocation().HasKeyword(LocTypeOutpost)
			ObjectReference myOutpostRef = OutpostBeaconsArray[0]
			if myOutpostRef && Self.CleanOutpostWorkshopIndex()
				myOutpostID = Self.GetOutpostID(myOutpostRef)
				if (myOutpostID < 0)
					myOutpostID = Self.SetOutpostWorkshopIndex(myOutpostRef)
					if (bModEnabled == False)
						Debug.Notification("Outpost registered.")
					endif
				elseif (bModEnabled == False)
					Debug.Notification("Outpost registered.")
				endif
				; set the CURRENT OUTPOST ID and REF
				currentOutpostID = myOutpostID
				CurrentOutpost.ForceRefTo(myOutpostRef)
				CallForUpdateCurrentOutpostFuelContainerCollection()
			else
				; FAILSAFE - cannot happen
				Debug.MessageBox("ERROR getting Outpost Beacon !?!")
				currentOutpostID = -1
			endif
		else
			currentOutpostID = -1	; UNLOCK FUNCTION
		endif
	endif
	Return myOutpostID
EndFunction

; check for existing OutpostID (Array.Find doesn't work)
Int Function GetOutpostID(ObjectReference akOutpostRef)
	Int index = -1
	Int i = 0
	while (i < OutpostWorkshopIndex.Length) && (index == -1)
		if OutpostWorkshopIndex[i] == akOutpostRef
			index = i
		endif
		i += 1
	endwhile
	Return index
EndFunction

; assignment of a new outpost ID (prioritize unused indexes)
Int Function SetOutpostWorkshopIndex(ObjectReference akOutpostRef)
	Int newOutpostID = -1
	If (currentOutpostID < 0)
		Int i = 0
		Int j = OutpostWorkshopIndex.Length
		while (i < j) && (newOutpostID == -1)
			if OutpostWorkshopIndex[i] == None
				newOutpostID = i
				OutpostWorkshopIndex[i] = akOutpostRef
				Helium3PerOutpost[i] = 0
			endif
			i += 1
		endwhile
		if newOutpostID < 0
			OutpostWorkshopIndex.Add(akOutpostRef, 1)
			Helium3PerOutpost.Add(0, 1)
			newOutpostID = j
		endif
		OutpostWorkshopRefs.AddRef(akOutpostRef)
	EndIf
	Return newOutpostID
EndFunction

; matching the array with the RefCollectionAlias (releasing unused indexes) 
Bool Function CleanOutpostWorkshopIndex()
	Bool update = False
	Int i = 0
	while i < OutpostWorkshopIndex.Length
		if (OutpostWorkshopIndex[i] != None) && (OutpostWorkshopRefs.Find(OutpostWorkshopIndex[i]) >= 0)
			; do nothing
		else
			OutpostWorkshopIndex[i] = None
			Helium3PerOutpost[i] = 0
		endif
		i += 1
	endwhile
	update = True
	Return update
EndFunction

; assignment of variables according to the outpostID
Function CallForUpdateCurrentOutpostFuelContainerCollection()
	If currentOutpostID == 0
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost00)
	ElseIf currentOutpostID == 1
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost01)
	ElseIf currentOutpostID == 2
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost02)
	ElseIf currentOutpostID == 3
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost03)
	ElseIf currentOutpostID == 4
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost04)
	ElseIf currentOutpostID == 5
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost05)
	ElseIf currentOutpostID == 6
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost06)
	ElseIf currentOutpostID == 7
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost07)
	ElseIf currentOutpostID == 8
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost08)
	ElseIf currentOutpostID == 9
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost09)
	ElseIf currentOutpostID == 10
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost10)
	ElseIf currentOutpostID == 11
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost11)
	ElseIf currentOutpostID == 12
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost12)
	ElseIf currentOutpostID == 13
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost13)
	ElseIf currentOutpostID == 14
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost14)
	ElseIf currentOutpostID == 15
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost15)
	ElseIf currentOutpostID == 16
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost16)
	ElseIf currentOutpostID == 17
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost17)
	ElseIf currentOutpostID == 18
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost18)
	ElseIf currentOutpostID == 19
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost19)
	ElseIf currentOutpostID == 20
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost20)
	ElseIf currentOutpostID == 21
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost21)
	ElseIf currentOutpostID == 22
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost22)
	ElseIf currentOutpostID == 23
		Self.UpdateCurrentOutpostFuelContainerCollection(FuelContainerOutpost23)
	EndIf
EndFunction


; collects all He3 harvesters and all(!) gas containers for current outpost into the given RefCollectionAlias
Function UpdateCurrentOutpostFuelContainerCollection(RefCollectionAlias theFuelContainerOutpostXX)
	float searchRadius = CurrentOutpost.GetRef().GetValue(OutpostBuildAreaRadius)
	ObjectReference[] He3Containers = CurrentOutpost.GetRef().FindAllReferencesOfType(CS7OutpostHe3ContainerList, searchRadius)
	If He3Containers.Length > 0
		if theFuelContainerOutpostXX.GetCount() == 0
			theFuelContainerOutpostXX.AddArray(He3Containers)
		else
			Int i = 0
			while i < He3Containers.Length
				If (theFuelContainerOutpostXX.Find(He3Containers[i]) < 0)
					theFuelContainerOutpostXX.AddRef(He3Containers[i])
				endif
				i += 1
			endwhile
		endif
	Else
		theFuelContainerOutpostXX.RemoveAll()
	Endif
EndFunction

; ----------------------------------------------------------------------------------------

Function CollectHelium3DataForAllOutposts()
	Int i = 0
	While i < OutpostWorkshopIndex.Length
		if (OutpostWorkshopIndex[i] != None)
			Self.CallForHelium3DataArrayPerOutpostID(i)
		endif
		i += 1
	EndWhile
EndFunction

; assignment of variables according to the outpostID
Function CallForHelium3DataArrayPerOutpostID(Int aiOutpostID)
	If aiOutpostID == 0
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost00, aiOutpostID)
	ElseIf aiOutpostID == 1
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost01, aiOutpostID)
	ElseIf aiOutpostID == 2
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost02, aiOutpostID)
	ElseIf aiOutpostID == 3
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost03, aiOutpostID)
	ElseIf aiOutpostID == 4
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost04, aiOutpostID)
	ElseIf aiOutpostID == 5
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost05, aiOutpostID)
	ElseIf aiOutpostID == 6
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost06, aiOutpostID)
	ElseIf aiOutpostID == 7
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost07, aiOutpostID)
	ElseIf aiOutpostID == 8
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost08, aiOutpostID)
	ElseIf aiOutpostID == 9
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost09, aiOutpostID)
	ElseIf aiOutpostID == 10
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost10, aiOutpostID)
	ElseIf aiOutpostID == 11
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost11, aiOutpostID)
	ElseIf aiOutpostID == 12
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost12, aiOutpostID)
	ElseIf aiOutpostID == 13
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost13, aiOutpostID)
	ElseIf aiOutpostID == 14
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost14, aiOutpostID)
	ElseIf aiOutpostID == 15
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost15, aiOutpostID)
	ElseIf aiOutpostID == 16
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost16, aiOutpostID)
	ElseIf aiOutpostID == 17
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost17, aiOutpostID)
	ElseIf aiOutpostID == 18
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost18, aiOutpostID)
	ElseIf aiOutpostID == 19
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost19, aiOutpostID)
	ElseIf aiOutpostID == 20
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost20, aiOutpostID)
	ElseIf aiOutpostID == 21
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost21, aiOutpostID)
	ElseIf aiOutpostID == 22
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost22, aiOutpostID)
	ElseIf aiOutpostID == 23
		Self.CollectHelium3InventoryPerOutpostInArray(FuelContainerOutpost23, aiOutpostID)
	EndIf
EndFunction

; counts the He3 inventory per outpost and writes the item count into the array (index = outpostID)
Function CollectHelium3InventoryPerOutpostInArray(RefCollectionAlias theFuelContainerOutpostXX, Int aiOutpostID)
	Int He3CountTotal = 0
	Int i = 0
	While i < theFuelContainerOutpostXX.GetCount()
		Int He3CountPerContainer = theFuelContainerOutpostXX.GetAt(i).GetItemCount(InorgCommonHelium3)
		if He3CountPerContainer > 0	; container holds some He3
			He3CountTotal += He3CountPerContainer
		endif
		i += 1
	EndWhile
	Helium3PerOutpost[aiOutpostID] = He3CountTotal
;	Debug.MessageBox("Outpost " + aiOutpostID + " Helium3: " + He3CountTotal)
EndFunction


Function CheckRefuelingAtRegisteredOutposts()
	Int i = 0
	While i < OutpostWorkshopIndex.Length
		if (OutpostWorkshopIndex[i] != None)
			Self.CallForCheckHelium3InventoryAtRegisteredOutposts(i)
		endif
		i += 1
	EndWhile
EndFunction

; assignment of variables according to the outpostID
Function CallForCheckHelium3InventoryAtRegisteredOutposts(Int aiOutpostID)
	If aiOutpostID == 0
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost00, aiOutpostID)
	ElseIf aiOutpostID == 1
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost01, aiOutpostID)
	ElseIf aiOutpostID == 2
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost02, aiOutpostID)
	ElseIf aiOutpostID == 3
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost03, aiOutpostID)
	ElseIf aiOutpostID == 4
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost04, aiOutpostID)
	ElseIf aiOutpostID == 5
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost05, aiOutpostID)
	ElseIf aiOutpostID == 6
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost06, aiOutpostID)
	ElseIf aiOutpostID == 7
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost07, aiOutpostID)
	ElseIf aiOutpostID == 8
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost08, aiOutpostID)
	ElseIf aiOutpostID == 9
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost09, aiOutpostID)
	ElseIf aiOutpostID == 10
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost10, aiOutpostID)
	ElseIf aiOutpostID == 11
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost11, aiOutpostID)
	ElseIf aiOutpostID == 12
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost12, aiOutpostID)
	ElseIf aiOutpostID == 13
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost13, aiOutpostID)
	ElseIf aiOutpostID == 14
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost14, aiOutpostID)
	ElseIf aiOutpostID == 15
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost15, aiOutpostID)
	ElseIf aiOutpostID == 16
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost16, aiOutpostID)
	ElseIf aiOutpostID == 17
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost17, aiOutpostID)
	ElseIf aiOutpostID == 18
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost18, aiOutpostID)
	ElseIf aiOutpostID == 19
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost19, aiOutpostID)
	ElseIf aiOutpostID == 20
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost20, aiOutpostID)
	ElseIf aiOutpostID == 21
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost21, aiOutpostID)
	ElseIf aiOutpostID == 22
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost22, aiOutpostID)
	ElseIf aiOutpostID == 23
		Self.CheckHelium3InventoryAtRegisteredOutpost(FuelContainerOutpost23, aiOutpostID)
	EndIf
EndFunction

; counts and compares the He3 inventory per outpost with the item count saved in the array (index = outpostID)
Function CheckHelium3InventoryAtRegisteredOutpost(RefCollectionAlias theFuelContainerOutpostXX, Int aiOutpostID)
	Int he3CountTotal = 0
	If Helium3PerOutpost[aiOutpostID] > 0
		Int i = 0
		While i < theFuelContainerOutpostXX.GetCount()
			Int he3CountPerContainer = theFuelContainerOutpostXX.GetAt(i).GetItemCount(InorgCommonHelium3)
			if he3CountPerContainer > 0
				he3CountTotal += he3CountPerContainer
			endif
			i += 1
		EndWhile
	EndIf

	If he3CountTotal < Helium3PerOutpost[aiOutpostID]
		Float he3Difference = Helium3PerOutpost[aiOutpostID] - He3CountTotal
		Float fuelDifference = he3Difference * 0.5
		fFuelOutpostValue += Math.Ceiling(fuelDifference)
	EndIf
;	Debug.MessageBox("Outpost " + aiOutpostID + " Fuel difference: " + fFuelOutpostValue)
EndFunction

; ----------------------------------------------------------------------------------------

Function ResetModAfterUnity()
	currentOutpostID = -1
	CurrentOutpost.Clear()
	OutpostWorkshopIndex.Clear()
	Helium3PerOutpost.Clear()
	OutpostWorkshopRefs.RemoveAll()
	FuelContainerOutpost00.RemoveAll()
	FuelContainerOutpost01.RemoveAll()
	FuelContainerOutpost02.RemoveAll()
	FuelContainerOutpost03.RemoveAll()
	FuelContainerOutpost04.RemoveAll()
	FuelContainerOutpost05.RemoveAll()
	FuelContainerOutpost06.RemoveAll()
	FuelContainerOutpost07.RemoveAll()
	FuelContainerOutpost08.RemoveAll()
	FuelContainerOutpost09.RemoveAll()
	FuelContainerOutpost10.RemoveAll()
	FuelContainerOutpost11.RemoveAll()
	FuelContainerOutpost12.RemoveAll()
	FuelContainerOutpost13.RemoveAll()
	FuelContainerOutpost14.RemoveAll()
	FuelContainerOutpost15.RemoveAll()
	FuelContainerOutpost16.RemoveAll()
	FuelContainerOutpost17.RemoveAll()
	FuelContainerOutpost18.RemoveAll()
	FuelContainerOutpost19.RemoveAll()
	FuelContainerOutpost20.RemoveAll()
	FuelContainerOutpost21.RemoveAll()
	FuelContainerOutpost22.RemoveAll()
	FuelContainerOutpost23.RemoveAll()
EndFunction


;ActorValue Property SpaceshipGravJumpDistancePerFuel Auto
;{ AV on ship that tracks how far a spaceship can jump per unit of fuel }
;ActorValue Property SpaceshipGravJumpInterplanetaryDistanceMultiplier Auto
;{ This times the distance traveled in meters gets multiplied by SpaceshipGravJumpDistancePerFuel
;  to determine jump cost inside a solar system. 3.2e-17 (0.000000000000000032) is the "correct" "fair" value }
;ActorValue Property SpaceshipGravJumpInitiated Auto
;{ This variable gets set to 1 when a spaceship is in the process of calculating a grav jump }
;ActorValue Property SpaceshipGravJumpMaxDistance Auto
;{ How far a spaceship can jump in a single jump}
;Float Property FuelCostMult = 1.0 Auto Const
;{ multiplier on base value of He3 }
