ScriptName DialogueShipServicesScript Extends Quest

Quest Property QuestSpaceshipSystems Auto Const
sq_playershipscript Property SQ_PlayerShip Auto Const mandatory
{ autofill }
GlobalVariable Property ShipServicesFuelAmount Auto Const mandatory
{ will be amount of fuel player needs to buy to top up }
GlobalVariable Property ShipServicesFuelCost Auto Const mandatory
{ will be cost of fuel amount needed }
ActorValue Property SpaceshipGravJumpFuel Auto Const mandatory
ActorValue Property SpaceshipGravDriveHealth Auto Const mandatory
{ AV on ship that tracks fuel amount/capacity }
MiscObject Property InorgCommonHelium3 Auto Const mandatory
{ use to get price }
Float Property FuelCostMult = 1.0 Auto Const
{ multiplier on base value of He3 }
ActorValue Property Health Auto Const mandatory
{ autofill }
GlobalVariable Property ShipServicesRepairCost Auto Const mandatory
{ will be cost to fully repair ship }
Message Property RepairGravDrive Auto Const Const

Function UpdateFuelGlobals()

     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

       If akShip
          (QuestSpaceshipSystems as SISA_SpaceshipFuel).CalculateFuelCost()
          (QuestSpaceshipSystems as SISA_SpaceshipFuel).CalculateRepairCost()
	EndIf

EndFunction

Function RefuelPlayerShip()
  
       SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

       If akShip
             If akShip.GetValue(SpaceshipGravDriveHealth) >= akShip.GetBaseValue(SpaceshipGravDriveHealth)
				Game.GetPlayer().RemoveItem(Game.GetCredits() as Form, ShipServicesFuelCost.GetValueInt(), False, None)
                (QuestSpaceshipSystems as SISA_SpaceshipFuel).RefuelAtShipService()
                UpdateFuelGlobals()
         Else
                RepairGravDrive.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
          EndIf
	EndIf

EndFunction

Function RepairPlayerShip()

       SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
       
	   If akShip
          Game.GetPlayer().RemoveItem(Game.GetCredits() as Form, ShipServicesRepairCost.GetValueInt(), False, None)
          (QuestSpaceshipSystems as SISA_SpaceshipFuel).MaintenanceAtShipService()
          UpdateFuelGlobals()
	EndIf

EndFunction

Function ResetTechDialogues()

            UpdateCurrentInstanceGlobal(ShipServicesFuelCost)
            UpdateCurrentInstanceGlobal(ShipServicesRepairCost)

EndFunction