ScriptName SISA_SpaceshipFuel extends Quest

Quest Property DialogueShipServices Auto Const

Actor Property PlayerRef Auto Const

ActorValue Property SpaceshipMass Auto Const
ActorValue Property SpaceshipEngineThrust Auto Const
ActorValue Property SpaceshipBoostSpeed Auto Const
ActorValue Property SpaceshipBoostActive Auto Const
ActorValue Property SpaceshipFuelTank Auto Const
ActorValue Property SpaceshipGravDriveInitiated Auto Const
ActorValue Property SpaceshipGravDriveHealth Auto Const
ActorValue Property SpaceshipGravThrust Auto Const
ActorValue Property SpaceshipWeaponHealth Auto Const
ActorValue Property SpaceshipWeaponHealth02 Auto Const
ActorValue Property SpaceshipWeaponHealth03 Auto Const
ActorValue Property SpaceshipShieldHealth Auto Const
ActorValue Property SpaceshipSystemEngineHealth Auto Const
ActorValue Property SpaceshipSystemGravdriveHealth Auto Const
ActorValue Property SpaceshipHealth Auto Const
ActorValue Property SpaceshipEnginePower Auto Const
ActorValue Property SpaceshipTotalFuelAmount Auto Const
ActorValue Property SpaceshipTotalChargeAmount Auto Const
ActorValue Property SpaceshipTotalMaintenanceAmount Auto Const

Activator Property SpaceshipEmergencyBeaconActivator Auto Const

Perk Property SpaceshipEmergencyRepairBotsPerk Auto Const
Perk Property SpaceshipMaintenanceRepairPerk Auto Const
Perk Property SpaceshipMaintenanceMaxAmountPerk01 Auto Const
Perk Property SpaceshipMaintenanceMaxAmountPerk02 Auto Const
Perk Property SpaceshipMaintenanceMaxAmountPerk03 Auto Const
Perk Property SpaceshipMaintenanceMaxAmountPerk04 Auto Const
Perk Property SpaceshipFuelDiscountPerk Auto Const
Perk Property SpaceshipFuelDiscountPerk01 Auto Const
Perk Property SpaceshipFuelDiscountPerk02 Auto Const
Perk Property SpaceshipFuelDiscountPerk03 Auto Const
Perk Property SpaceshipFuelDiscountPerk04 Auto Const
Perk Property SpaceshipCrewPiloting Auto Const
Perk Property SpaceshipStarviewOpenizer Auto Const

Armor Property BlockCalculation Auto Const

Potion Property SpaceshipAnalizer Auto Const
Potion Property SpaceshipEmergencyBeaconPotion Auto Const
Potion Property SpaceshipEmergencyCallPotion Auto Const
Potion Property SongbirdPortableAudioPlayer Auto Const
Potion Property SpaceshipTeleporter Auto Const

Explosion Property ImpulseExplosion Auto Const
Explosion Property TeleportExplosion Auto Const

FormList Property SpaceshipLandingMarkers Auto

Message Property MSG_SpaceshipOutOfFuel Auto Const
Message Property MSG_StarviewMain Auto Const
Message Property MSG_StarviewRadio Auto Const
Message Property MSG_StarviewRadioSongbird Auto Const
Message Property MSG_StarviewFuelManagement Auto Const
Message Property MSG_StarviewEmergencyCall Auto Const
Message Property MSG_StarviewEmergencyResponder Auto Const
Message Property MSG_StarviewEmergencyResponderUseBeacon Auto Const
Message Property MSG_StarviewEmergencyResponderHelpIsOnTheWay Auto Const
Message Property MSG_StarviewEmergencyResponderPayment Auto Const
Message Property MSG_StarviewEmergencyResponderNotEnoughCredits Auto Const
Message Property MSG_StarviewEmergencyResponderDeptCover Auto Const
Message Property MSG_SpaceshipSystemsTurnedOff Auto Const
Message Property MSG_SpaceshipSystemsTurnedOffDC Auto Const
Message Property MSG_SpaceshipAnalizerCheckerInfo Auto Const
Message Property MSG_SpaceshipFullFuelTanks Auto Const
Message Property MSG_SpaceshipFullGravDriveCharge Auto Const
Message Property MSG_SpaceshipNoFuelTanks Auto Const
Message Property MSG_SpaceshipNoGravDriveCharge Auto Const
Message Property MSG_SpaceshipCantGravJump Auto Const
Message Property MSG_SpaceshipInformation Auto Const
Message Property MSG_SpaceshipInformationCapacity Auto Const
Message Property MSG_SpaceshipInformationSubSystems Auto Const
Message Property MSG_SpaceshipInformationTech Auto Const
Message Property MSG_SpaceshipSystemsCheck Auto Const
Message Property MSG_SpaceshipSystemsAreReady Auto Const
Message Property MSG_SpaceshipSystemsCheckFailed Auto Const
Message Property MSG_SpaceshipSystemsPilotSeat Auto Const
Message Property MSG_Tutorial_Main Auto Const
Message Property MSG_Tutorial_EmergencyBeacon Auto Const
Message Property MSG_Tutorial_EmergencyBeacon02 Auto Const
Message Property MSG_Tutorial_Refueling Auto Const
Message Property MSG_Tutorial_RefuelingApply Auto Const
Message Property MSG_Tutorial_RescueCall Auto Const
Message Property MSG_Tutorial_RescueCall02 Auto Const
Message Property MSG_Tutorial_RefuelingDone Auto Const
Message Property MSG_Tutorial_AdditionalInfo Auto Const
Message Property MSG_EmergencyBeaconShuttleArriveTime Auto Const
Message Property MSG_EmergencyGroupIsOnTheirWay Auto Const
Message Property MSG_SpaceshipCallAbort Auto Const
Message Property MSG_SpaceshipCallAbort02 Auto Const
Message Property MSG_SpaceshipCallAbort03 Auto Const
Message Property MSG_BotsAlreadyInUse Auto Const
Message Property MSG_MaintenanceKitAlreadyInUse Auto Const
Message Property MSG_NoRepairBotsAvailable Auto Const
Message Property MSG_NoMaintenanceKitsAvailable Auto Const
Message Property MSG_MaintenanceRules Auto Const
Message Property MSG_SpaceshipTeleporter Auto Const

GlobalVariable Property GV_FuelConsumeDMGOnPower Auto Const
GlobalVariable Property GV_FuelConsumeTimeOnMove Auto Const
GlobalVariable Property GV_RescuePayment Auto Const
GlobalVariable Property GV_RescueTeamTime Auto Const
GlobalVariable Property GV_PrepareFuelStandBy Auto Const
GlobalVariable Property GV_PrepareBatteryStandBy Auto Const
GlobalVariable Property GV_SpawnDistanceOffset Auto Const mandatory
GlobalVariable Property GV_BeaconTrigger Auto Const
GlobalVariable Property GV_SpaceshipSystemsToggle Auto Const
GlobalVariable Property GV_SpaceshipSystemsRadioToggle Auto Const
GlobalVariable Property GV_SpaceshipSystemsTutorial01 Auto Const
GlobalVariable Property GV_SpaceshipTutorial02 Auto Const
GlobalVariable Property GV_SpaceshipTutorial03 Auto Const
GlobalVariable Property GV_NGPlusStarted Auto Const
GlobalVariable Property GV_AutoInjector Auto Const
GlobalVariable Property GV_SpaceshipFuelCheckerType Auto Const
GlobalVariable Property GV_SpaceshipFuelConsumptionType Auto Const
GlobalVariable Property GV_DebugNotification Auto Const
GlobalVariable Property GV_SpaceshipAmmoAntiSpawner Auto Const
GlobalVariable Property GV_SpaceshipOnHomeshipChangeRestrict Auto Const
GlobalVariable Property GV_ShipServiceFuelCost Auto Const
GlobalVariable Property GV_ShipServiceRepairCost Auto Const
GlobalVariable Property GV_SpaceshipRefuelingType Auto Const
GlobalVariable Property GV_SpaceshipMaintenanceDMG Auto Const
GlobalVariable Property GV_SpaceshipMaintenanceDMGOnGravJump Auto Const
GlobalVariable Property GV_SpaceshipMaintenanceAtWork Auto Const
GlobalVariable Property GV_SpaceshipSystemDamaged Auto Const
GlobalVariable Property GV_SpaceshipRepairHullCostPerUnit Auto Const
GlobalVariable Property GV_SpaceshipRepairSystemCostPerUnit Auto Const
GlobalVariable Property GV_SpaceshipRepairMaintenanceCostPerUnit Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationMode Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationBasic Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationBasicOnBoost Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationBasicOnLanding Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationBasicOnTakeOff Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationStory Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationStoryOnBoost Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationStoryOnLanding Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationStoryOnTakeOff Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationManual Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationManualOnBoost Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationManualOnLanding Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationManualOnTakeoff Auto Const
GlobalVariable Property GV_SpaceshipChargeCalculationBasic Auto Const
GlobalVariable Property GV_SpaceshipChargeCalculationStory Auto Const
GlobalVariable Property GV_SpaceshipChargeCalculationManual Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationBasicForGravJump Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationStoryForGravJump Auto Const
GlobalVariable Property GV_SpaceshipFuelCalculationManualForGravJump Auto Const
GlobalVariable Property GV_SpaceshipGravityToggle Auto Const
GlobalVariable Property GV_SpaceshipDisableCrewBuffs Auto Const
GlobalVariable Property GV_SpaceshipNeedsRefueling Auto Const
GlobalVariable Property GV_SpaceshipNeedsRecharging Auto Const
GlobalVariable Property GV_SpaceshipNeedsMaintenanceToggle Auto Const
GlobalVariable Property GV_SpaceshipDramaticGravJumpToggle Auto Const
GlobalVariable Property GV_SpaceshipAutoRepair Auto Const
GlobalVariable Property GV_SpaceshipSystemCheckMessages Auto Const
GlobalVariable Property GV_SpaceshipFuelPriceMult Auto Const
GlobalVariable Property GV_SpaceshipChargePriceMult Auto Const

EffectShader Property GravJumpPreparationFX Auto Const Mandatory
EffectShader Property GravDriveRechargeFX Auto Const Mandatory
EffectShader Property RepairBotsVisualFX Auto Const Mandatory
EffectShader Property TeleportFX Auto Const Mandatory
EffectShader Property TeleportFX02 Auto Const Mandatory

MiscObject Property SpaceshipFuel Auto Const
MiscObject Property SpaceshipGravBattery Auto Const
MiscObject Property Credits Auto Const
MiscObject Property SpaceshipEmergencyRepairBotsMisc Auto Const 
MiscObject Property SpaceshipMaintenanceKitMisc Auto Const 

Spell Property SpaceshipCrewAstroDynamics01 Auto Const 
Spell Property SpaceshipCrewAstroDynamics02 Auto Const 
Spell Property SpaceshipCrewAstroDynamics03 Auto Const 
Spell Property SpaceshipCrewAstroDynamics04 Auto Const 

ReferenceAlias Property PlayerShipSpaceshipInventory Auto Const mandatory
ReferenceAlias Property PlayerShip Auto
ReferenceAlias Property GeneralMarker Auto Const mandatory
ReferenceAlias Property HomeShip Auto Const mandatory
ReferenceAlias Property PlayerShipPilotSeat Auto mandatory

spaceshipReference[] Property StoredPlayerShips Auto

RefCollectionAlias Property PlayerShips Auto Const mandatory
RefCollectionAlias Property CurrentCrew Auto

LeveledItem Property SpaceshipContainerType01 Auto Const
LeveledItem Property SpaceshipContainerType02 Auto Const
LeveledItem Property SpaceshipContainerType03 Auto Const
LeveledItem Property SpaceshipContainerType04 Auto Const
LeveledItem Property SpaceshipContainerType05 Auto Const
LeveledItem Property SpaceshipContainerType06 Auto Const
LeveledItem Property SpaceshipContainerType07 Auto Const
LeveledItem Property SpaceshipContainerType08 Auto Const
LeveledItem Property SpaceshipContainerType09 Auto Const
LeveledItem Property SpaceshipContainerType10 Auto Const
LeveledItem Property SpaceshipContainerType11 Auto Const
LeveledItem Property SpaceshipContainerType12 Auto Const
LeveledItem Property SpaceshipContainerType13 Auto Const
LeveledItem Property SpaceshipContainerInjectFuel Auto Const
LeveledItem Property SpaceshipContainerInjectBattery Auto Const
LeveledItem Property SpaceshipContainerInjectMaintenanceKit Auto Const
LeveledItem Property SpaceshipContainerInjectEmergencyBot Auto Const
LeveledItem Property SpaceshipResourcePackage Auto Const
LeveledItem Property SpaceshipNPCRandomAmmo Auto Const

Keyword Property SpaceshipEnabledLandingLink Auto Const mandatory
Keyword Property SpaceshipTypeStarborn Auto Const
Keyword Property SpaceshipLinkedInterior Auto Const

ObjectReference Property EmergencyResponderREF Auto Const mandatory
ObjectReference Property StarviewTerminal Auto
ObjectReference Property SpaceshipContainerVendor01 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor02 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor03 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor04 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor05 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor06 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor07 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor08 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor09 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor10 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor11 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor12 Auto Const mandatory
ObjectReference Property SpaceshipContainerVendor13 Auto Const mandatory
ObjectReference[] Property StoredPlayerShipsCargoHolders Auto

Furniture Property ShipLandingMarker Auto Const mandatory

Location Property CurrentLoc Auto
LocationAlias Property playerShipInteriorLocation Auto Const mandatory
LocationAlias Property playerShipInteriorLocation02 Auto Const mandatory

wwiseevent Property SoundEventFuelFillEnd Auto Const
wwiseevent Property SoundEventFuelFillInTheProcess Auto Const
wwiseevent Property SoundEventFuelFillBeep Auto Const
wwiseevent Property SoundEventFuelFillStart Auto Const
wwiseevent Property SoundEventChargeStart Auto Const
wwiseevent Property SoundEventChargeInTheProcess Auto Const
wwiseevent Property SoundEventChargeEnd Auto Const
wwiseevent Property SoundEventChargeBeep Auto Const
wwiseevent Property SoundEventChargeTakeoutEnd Auto Const
wwiseevent Property SoundEventClick Auto Const
wwiseevent Property SoundEventAlert Auto Const
wwiseevent Property SoundEventRadioClassicBaroque Auto Const
wwiseevent Property SoundEventRadioClassicNeoRomantic Auto Const
wwiseevent Property SoundEventRadioCountryBlues Auto Const
wwiseevent Property SoundEventRadioCrimsonMetal Auto Const
wwiseevent Property SoundEventRadioDarkSynth Auto Const
wwiseevent Property SoundEventRadioElectronica Auto Const
wwiseevent Property SoundEventRadioJazz Auto Const
wwiseevent Property SoundEventRadioPop Auto Const
wwiseevent Property SoundEventRadioTechnoAstralLounge Auto Const
wwiseevent Property SoundEventRadioTechnoClean Auto Const
wwiseevent Property SoundEventRadioTechnoParty Auto Const
wwiseevent Property SoundEventGravDrivePrepare Auto Const
wwiseevent Property SoundEventEngineOff Auto Const
wwiseevent Property SoundEventEngineOn Auto Const
wwiseevent Property SoundEventBotsRepairStart Auto Const
wwiseevent Property SoundEventBotsRepairEnd Auto Const
wwiseevent Property SoundEventCallChatter Auto Const
wwiseevent Property SoundEventCallChatterOff Auto Const
wwiseevent Property SoundEventMaintenanceEmergency Auto Const
wwiseevent Property SoundEventMaintenanceNormalized Auto Const
wwiseevent Property SoundEventMaintenanceAtWork Auto Const
wwiseevent Property SoundEventMaintenanceAtWork02 Auto Const
wwiseevent Radio

MusicType Property MusicSilence Auto Const

VisualEffect Property SpaceshipGravDriveStartFX Auto Const mandatory
VisualEffect Property SpaceshipMaintenanceFX Auto Const mandatory

Struct FriendShipDatum
  spaceshipbase ShipToSpawn
  { Leveled list we want to spawn }
  GlobalVariable MinFriends
  { Minimum number of enemy ships to spawn }
  GlobalVariable MaxFriends
  { Maximum number of enemy ships to spawn }
EndStruct

SISA_SpaceshipFuel:Friendshipdatum[] Property FriendsShipData Auto mandatory
sq_playershipscript Property SQ_PlayerShip Auto

inputEnableLayer SpaceTravel
inputEnableLayer GravJump
inputEnableLayer TakeOff
inputEnableLayer GroundAndLocalTravel

Guard GravityGuard

Bool TravelDisabled = False
Bool SpaceshipIsReadyToFly = False
Bool SpaceshipPowerValueStored = False
Bool SpaceshipEngineIgnited = False
Bool TutorialIntroduction = False
Bool TutorialEmergencyBeacon = False
Bool TutorialRefueling = False
Bool TutorialRefuelingApply = False
Bool TutorialRefuelingDone = False
Bool TutorialRescueCall = False
Bool TutorialRescueCallOnLand = False
Bool TutorialRescueCallTrigger = False
Bool TutorialAdditionalInfo = False
Bool TutorialFillFuel = False
Bool TutorialFillCharge = False
Bool EmergencyIsOnTheirWay = False
Bool SpaceshipPower = False
Bool EnginePowerRestricted = False
Bool GravJumpInitiated = False
Bool GravDriveDamaged = False
Bool RefuelFuelStarted = False
Bool RefuelChargeStarted = False
Bool CameraShakeOnFuelFill = False
Bool MaintenanceEmergency = False
Bool LandingPad = False

Int StoreShipCharge
Int ShipPowerEngine
Int ShipGravDrivePowerStore
Int RescueDebt = 0
int Property PlayerLevel_InjectList Auto Const
int Property PlayerLevel = 1 Auto Const
Int Property FriendIndex Auto
Int Property OffsetRandomizer = 30 Auto Const
Int Property OffsetDistanceY = 100 Auto Const
Int Property maxRetries = 4 Auto Const
Int AlertSoundInstance = -1
Int RadioSoundInstance = -1
Int GravDrivePrepareSoundInstance = -1
Int EngineOnSoundInstance = -1
Int BotsStartSoundInstance = -1
Int BotsEndSoundInstance = -1
Int MaintenanceEmergencySoundInstance = -1
Int StoreChargeConsumptionValues

Float Property DebugShipSpawnOffset = 250.0 Auto Const
Float StoreShipFuel
Float StoreShipMaintenance
Float StoreFuelConsumptionValues
Float StoreFuelGravDriveConsumptionValues

Event Actor.OnPlayerLoadGame(Actor akSender)

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int GravDrive = akShip.GetPartPower(3, 0)
    
	ShipGravDrivePowerStore = GravDrive
  	
    StoreValuesSpaceshipPower()

EndEvent

Event OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)

         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

	     Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int	
     	 Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount) 
     	 Float TotalMaintenance = akShip.GetValue(SpaceshipTotalMaintenanceAmount) 
         
		 If asMenuName == "GalaxyStarMapMenu"
                  If abOpening == True
					 FuelCheckFromMenuOpen()
			 Else
                     akShip.SetPartPower(3, 0, ShipGravDrivePowerStore)
                     FuelCheckFromMenuClose()
			   EndIf

     ElseIf asMenuName == "SpaceshipEditorMenu"
                   If abOpening == True
				      
					  CalculateFuelCost()
			          CalculateRepairCost()
					 	 
						 If GV_SpaceshipAmmoAntiSpawner.GetValue() == 0
                            GV_SpaceshipAmmoAntiSpawner.SetValue(1)
					        StoreShipFuel = TotalFuelInTheTank
							StoreShipCharge = TotalChargeInGravDrive
							StoreShipMaintenance = TotalMaintenance
					  EndIf

			 Else
					     
					  CalculateFuelCost()
			          CalculateRepairCost()
					 	 
						 If GV_SpaceshipAmmoAntiSpawner.GetValue() == 1
                            GV_SpaceshipAmmoAntiSpawner.SetValue(0)

					  EndIf

			   EndIf           
      EndIf

EndEvent

Event Actor.OnPlayerModifiedShip(Actor akSender, spaceshipreference akShip)
      
	  Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) as Int
	  Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int	     
	  Int RetrieveCharge = StoreShipCharge - GravDriveChargeAmount      
	  
	  Float HealthAmount = akShip.GetValue(SpaceshipHealth) 
	  Float HealthAmountBase = akShip.GetBaseValue(SpaceshipHealth) 	  
	  Float FuelTankAmount = akShip.GetValue(SpaceshipFuelTank) 
	  Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount) 
      Float TotalMaintenance = akShip.GetValue(SpaceshipTotalMaintenanceAmount)   
      Float TotalMaintenanceBase = akShip.GetBaseValue(SpaceshipTotalMaintenanceAmount)
      Float RetrieveFuel = StoreShipFuel - FuelTankAmount
	  
	  If akSender == PlayerRef
		 		 
		 akShip.DamageValue(SpaceshipTotalFuelAmount, TotalFuelInTheTank)         
		 akShip.DamageValue(SpaceshipTotalChargeAmount, TotalChargeInGravDrive)         		   
         akShip.DamageValue(SpaceshipTotalMaintenanceAmount, TotalMaintenance)			   
 		 
         If StoreShipFuel > FuelTankAmount		 
		    akShip.Additem(SpaceshipFuel, RetrieveFuel as Int, True)
			akShip.RestoreValue(SpaceshipTotalFuelAmount, FuelTankAmount)		 
	 Else
			akShip.RestoreValue(SpaceshipTotalFuelAmount, StoreShipFuel)
      EndIf
		 
		 If StoreShipCharge > GravDriveChargeAmount	
		    akShip.Additem(SpaceshipGravBattery, RetrieveCharge, True)
		    akShip.RestoreValue(SpaceshipTotalChargeAmount, GravDriveChargeAmount)         		   
     Else      
            akShip.RestoreValue(SpaceshipTotalChargeAmount, StoreShipCharge) 	  
	  EndIf
		 
		 akShip.RestoreValue(SpaceshipTotalMaintenanceAmount, StoreShipMaintenance)   

			   If TotalFuelInTheTank < FuelTankAmount
				  GV_SpaceshipNeedsRefueling.SetValue(1)
		   ElseIf TotalFuelInTheTank == FuelTankAmount
				  GV_SpaceshipNeedsRefueling.SetValue(0)
			EndIf

			   If TotalChargeInGravDrive < GravDriveChargeAmount
				  GV_SpaceshipNeedsRecharging.SetValue(1)
		   ElseIf TotalChargeInGravDrive == GravDriveChargeAmount
				  GV_SpaceshipNeedsRecharging.SetValue(0)
			EndIf

			   If akShip.GetValue(SpaceshipTotalMaintenanceAmount) > 60 
			      GV_SpaceshipAutoRepair.SetValue(1)
             Else
			      GV_SpaceshipAutoRepair.SetValue(0)
            EndIf

			   If TotalMaintenance < TotalMaintenanceBase || HealthAmount < HealthAmountBase 
			      GV_SpaceshipSystemDamaged.SetValue(1)
            Else
			      GV_SpaceshipSystemDamaged.SetValue(0)
			EndIf
		 
		 CalculateFuelCost()
		 CalculateRepairCost()
   
   EndIf

EndEvent

Event Actor.OnHomeShipSet(Actor akSource, spaceshipReference akShip, spaceshipReference akPrevious)
     
	 Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) as Int
	 Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int	
	 
	 Float HealthAmount = akShip.GetValue(SpaceshipHealth) 
	 Float HealthAmountBase = akShip.GetBaseValue(SpaceshipHealth)      
	 Float FuelTankAmount = akShip.GetValue(SpaceshipFuelTank) 
	 Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount)   	 
     Float TotalMaintenance = akShip.GetValue(SpaceshipTotalMaintenanceAmount)	 
     Float TotalMaintenanceBase = akShip.GetBaseValue(SpaceshipTotalMaintenanceAmount)		 
	 
	 If akSource == PlayerRef

			   If TotalFuelInTheTank < FuelTankAmount
				  GV_SpaceshipNeedsRefueling.SetValue(1)
		   ElseIf TotalFuelInTheTank == FuelTankAmount
				  GV_SpaceshipNeedsRefueling.SetValue(0)
			EndIf

			   If TotalChargeInGravDrive < GravDriveChargeAmount
				  GV_SpaceshipNeedsRecharging.SetValue(1)
		   ElseIf TotalChargeInGravDrive == GravDriveChargeAmount
				  GV_SpaceshipNeedsRecharging.SetValue(0)
			EndIf

			   If akShip.GetValue(SpaceshipTotalMaintenanceAmount) > 60 
			      GV_SpaceshipAutoRepair.SetValue(1)
             Else
			      GV_SpaceshipAutoRepair.SetValue(0)
            EndIf

			   If TotalMaintenance < TotalMaintenanceBase || HealthAmount < HealthAmountBase  
			      GV_SpaceshipSystemDamaged.SetValue(1)
            Else
			      GV_SpaceshipSystemDamaged.SetValue(0)
			EndIf
            
			CalculateFuelCost()
			CalculateRepairCost()
            
			GV_SpaceshipOnHomeshipChangeRestrict.SetValue(1)
  
  EndIf

EndEvent

Event ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)

     spaceshipreference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
     	 
	 If akSender == PlayerShip

	       If abComplete
              CancelFuelTimerOnLeavingSpaceship()
			  DisableGravJump() 
              DisableGroundTravel()
              DisableSpaceTravel()                    
					
					If GV_SpaceshipOnHomeshipChangeRestrict.GetValue() == 0
                       FuelConsumptionCalculation()
				 EndIf
				 
				 FuelThresholds()
					
					If GV_SpaceshipOnHomeshipChangeRestrict.GetValue() == 1
				       GV_SpaceshipOnHomeshipChangeRestrict.SetValue(0)
				 EndIf
				 					
					If akShip.GetValue(SpaceshipTotalFuelAmount) <= 0
				 	   SpaceshipIsReadyToFly = False
				       TravelDisabled = True
					   BlockTravel()
				 EndIf
				 				 
				   If GV_DebugNotification.GetValue() == 1
				      Debug.Notification("SPACESHIP CONSUMED FUEL ON LANDING EVENT, FUEL CONSUMPTION STOPPED")
		        EndIf

		EndIf
  EndIf	

	If GV_SpaceshipSystemsRadioToggle.GetValue() == 1
       wwiseevent.StopInstance(RadioSoundInstance)
       RadioSoundInstance = -1
	   RadioSoundInstance = Radio.Play(PlayerRef, None, None)
	   MusicSilence.Remove()
	   MusicSilence.Add()
 EndIf

	 wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
     GravDrivePrepareSoundInstance = -1

	 If GV_SpaceshipAmmoAntiSpawner.GetValue() == 1
        GV_SpaceshipAmmoAntiSpawner.SetValue(0)
  EndIf
  
  StartTimer(3, 6)

EndEvent

Event ReferenceAlias.OnShipTakeOff(ReferenceAlias akSender, Bool abComplete)

     spaceshipreference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

     Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue()
 
     If akSender == PlayerShip

	       If abComplete
              StartTimer(ConsumeFuelCycle, 1)
	          EnableGravJump() 
              EnableSpaceTravel() 
              EnableGroundTravel() 
              FuelConsumptionCalculation()				  
			  FuelThresholds()
				  
				  If GV_DebugNotification.GetValue() == 1
				     Debug.Notification("HOMESHIP CONSUMED FUEL ON TAKE OFF EVENT, FUEL CONSUMPTION STARTED") 
		       EndIf
		
		EndIf

  EndIf	

	 If GV_SpaceshipSystemsRadioToggle.GetValue() == 1
        wwiseevent.StopInstance(RadioSoundInstance)
        RadioSoundInstance = -1
		RadioSoundInstance = Radio.Play(akShip, None, None)
		MusicSilence.Remove()
		MusicSilence.Add()
  EndIf

EndEvent

Event ReferenceAlias.OnShipGravJump(ReferenceAlias akSender, Location aDestination, Int aState)

                                        spaceshipreference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
										
										Int GravDrive = akShip.GetPartPower(3, 0)
                                        Int Engine = akShip.GetPartPower(1, 0)	
										                                  										
										Float MaintenanceDMGOnGravJump = GV_SpaceshipMaintenanceDMGOnGravJump.GetValue()
                                        
										Int GravJumpChargeCostAdvanced = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4)
										Int GravJumpChargeCostAdvancedAstro01 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.15) 
										Int GravJumpChargeCostAdvancedAstro02 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.20) 
										Int GravJumpChargeCostAdvancedAstro03 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.25) 
										Int GravJumpChargeCostAdvancedAstro04 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.35)                                        
										
										Int GravJumpChargeCostBasic = GV_SpaceshipChargeCalculationBasic.GetValue() as Int 
                                        Int GravJumpChargeCostBasicAstro01 = Math.Round(GV_SpaceshipChargeCalculationBasic.GetValue() / 1.15)                                         
                                        Int GravJumpChargeCostBasicAstro02 = Math.Round(GV_SpaceshipChargeCalculationBasic.GetValue() / 1.20) 
										Int GravJumpChargeCostBasicAstro03 = Math.Round(GV_SpaceshipChargeCalculationBasic.GetValue() / 1.25) 
										Int GravJumpChargeCostBasicAstro04 = Math.Round(GV_SpaceshipChargeCalculationBasic.GetValue() / 1.35) 
										
										Int GravJumpChargeCostStory = GV_SpaceshipChargeCalculationStory.GetValue() as Int                                        
										Int GravJumpChargeCostStoryAstro01 = Math.Round(GV_SpaceshipChargeCalculationStory.GetValue() / 1.15)                                        
                                        Int GravJumpChargeCostStoryAstro02 = Math.Round(GV_SpaceshipChargeCalculationStory.GetValue() / 1.20) 
										Int GravJumpChargeCostStoryAstro03 = Math.Round(GV_SpaceshipChargeCalculationStory.GetValue() / 1.25) 
										Int GravJumpChargeCostStoryAstro04 = Math.Round(GV_SpaceshipChargeCalculationStory.GetValue() / 1.35) 
										
										Int GravJumpChargeCostManual = GV_SpaceshipChargeCalculationManual.GetValue() as Int 
                                        Int GravJumpChargeCostManualAstro01 = Math.Round(GV_SpaceshipChargeCalculationManual.GetValue() / 1.15)                                        
                                        Int GravJumpChargeCostManualAstro02 = Math.Round(GV_SpaceshipChargeCalculationManual.GetValue() / 1.20)  
										Int GravJumpChargeCostManualAstro03 = Math.Round(GV_SpaceshipChargeCalculationManual.GetValue() / 1.25)  
										Int GravJumpChargeCostManualAstro04 = Math.Round(GV_SpaceshipChargeCalculationManual.GetValue() / 1.35)  
										
										Float FuelCostWhileGravJumpingAdvanced = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2)
										Float FuelCostWhileGravJumpingAdvancedAstro01 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2 / 1.15)
										Float FuelCostWhileGravJumpingAdvancedAstro02 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2 / 1.20)
										Float FuelCostWhileGravJumpingAdvancedAstro03 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2 / 1.25)
										Float FuelCostWhileGravJumpingAdvancedAstro04 = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2 / 1.35)                                        
										
										Float FuelCostWhileGravJumpingBasic = GV_SpaceshipFuelCalculationBasicForGravJump.GetValue()
                                        Float FuelCostWhileGravJumpingBasicAstro01 = GV_SpaceshipFuelCalculationBasicForGravJump.GetValue() / 1.15                                        
                                        Float FuelCostWhileGravJumpingBasicAstro02 = GV_SpaceshipFuelCalculationBasicForGravJump.GetValue() / 1.20 
										Float FuelCostWhileGravJumpingBasicAstro03 = GV_SpaceshipFuelCalculationBasicForGravJump.GetValue() / 1.25 
										Float FuelCostWhileGravJumpingBasicAstro04 = GV_SpaceshipFuelCalculationBasicForGravJump.GetValue() / 1.35 
										
										Float FuelCostWhileGravJumpingStory = GV_SpaceshipFuelCalculationStoryForGravJump.GetValue()
                                        Float FuelCostWhileGravJumpingStoryAstro01 = GV_SpaceshipFuelCalculationStoryForGravJump.GetValue() / 1.15                                        
                                        Float FuelCostWhileGravJumpingStoryAstro02 = GV_SpaceshipFuelCalculationStoryForGravJump.GetValue() / 1.20 
										Float FuelCostWhileGravJumpingStoryAstro03 = GV_SpaceshipFuelCalculationStoryForGravJump.GetValue() / 1.25 
										Float FuelCostWhileGravJumpingStoryAstro04 = GV_SpaceshipFuelCalculationStoryForGravJump.GetValue() / 1.35 
										
										Float FuelCostWhileGravJumpingManual = GV_SpaceshipFuelCalculationManualForGravJump.GetValue()
                                        Float FuelCostWhileGravJumpingManualAstro01 = GV_SpaceshipFuelCalculationManualForGravJump.GetValue() / 1.15                                        
                                        Float FuelCostWhileGravJumpingManualAstro02 = GV_SpaceshipFuelCalculationManualForGravJump.GetValue() / 1.20
										Float FuelCostWhileGravJumpingManualAstro03 = GV_SpaceshipFuelCalculationManualForGravJump.GetValue() / 1.25
										Float FuelCostWhileGravJumpingManualAstro04 = GV_SpaceshipFuelCalculationManualForGravJump.GetValue() / 1.35

			                            Int i = -1
                                        Actor CrewMember = CurrentCrew.GetAt(i) as Actor
   If akSender == PlayerShip
		
		If aState == 0 	   		   			   
		     
			 If GravDrive <= 0 || Engine <= 0
		        akShip.setvalue(SpaceshipGravDriveInitiated, -1)
                SpaceshipGravDriveStartFX.Stop(akShip)
		Else		   
		        GravJumpInitiated = True
		         
				 If akShip.IsInSpace() == True
				    GravDrivePrepareSoundInstance = SoundEventGravDrivePrepare.Play(PlayerRef, None, None)
		      EndIf
				
				GravDriveCheck()						 
          EndIf
	 EndIf	

		If aState == 1 
			
		   wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
           GravDrivePrepareSoundInstance = -1
		   CancelTimer(15)	
	 EndIf	

		If aState == 2 
               
			   If akShip
						           If GV_SpaceshipFuelCalculationMode.GetValue() == 0
								      									    
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingAdvancedAstro04)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingAdvancedAstro04
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostAdvancedAstro04)
										          StoreChargeConsumptionValues = GravJumpChargeCostAdvancedAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingAdvancedAstro03)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingAdvancedAstro03
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostAdvancedAstro03)
										          StoreChargeConsumptionValues = GravJumpChargeCostAdvancedAstro03 
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingAdvancedAstro02)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingAdvancedAstro02
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostAdvancedAstro02)
										          StoreChargeConsumptionValues = GravJumpChargeCostAdvancedAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingAdvancedAstro01)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingAdvancedAstro01
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostAdvancedAstro01)
                                                  StoreChargeConsumptionValues = GravJumpChargeCostAdvancedAstro01
										  Else
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingAdvanced)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingAdvanced
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostAdvanced)
											      StoreChargeConsumptionValues = GravJumpChargeCostAdvanced
											EndIf
					   							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 1
										       
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingBasicAstro04)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingBasicAstro04
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostBasicAstro04)
										          StoreChargeConsumptionValues = GravJumpChargeCostBasicAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingBasicAstro03)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingBasicAstro03
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostBasicAstro03)
										          StoreChargeConsumptionValues = GravJumpChargeCostBasicAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingBasicAstro02)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingBasicAstro02
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostBasicAstro02)
										          StoreChargeConsumptionValues = GravJumpChargeCostBasicAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingBasicAstro01)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingBasicAstro01
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostBasicAstro01)
                                                  StoreChargeConsumptionValues = GravJumpChargeCostBasicAstro01
										  Else
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingBasic)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingBasic
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostBasic)
											      StoreChargeConsumptionValues = GravJumpChargeCostBasic
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 2
											   
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingStoryAstro04)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingStoryAstro04
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostStoryAstro04)
										          StoreChargeConsumptionValues = GravJumpChargeCostStoryAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingStoryAstro03)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingStoryAstro03
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostStoryAstro03)
										          StoreChargeConsumptionValues = GravJumpChargeCostStoryAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingStoryAstro02)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingStoryAstro02
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostStoryAstro02)
										          StoreChargeConsumptionValues = GravJumpChargeCostStoryAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingStoryAstro01)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingStoryAstro01
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostStoryAstro01)
                                                  StoreChargeConsumptionValues = GravJumpChargeCostStoryAstro01
										  Else
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingStory)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingStory
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostStory)
											      StoreChargeConsumptionValues = GravJumpChargeCostStory
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 3
											   
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingManualAstro04)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingManualAstro04
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostManualAstro04)
										          StoreChargeConsumptionValues = GravJumpChargeCostManualAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingManualAstro03)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingManualAstro03
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostManualAstro03)
										          StoreChargeConsumptionValues = GravJumpChargeCostManualAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingManualAstro02)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingManualAstro02
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostManualAstro02)
										          StoreChargeConsumptionValues = GravJumpChargeCostManualAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingManualAstro01)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingManualAstro01
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostManualAstro01)
                                                  StoreChargeConsumptionValues = GravJumpChargeCostManualAstro01
										  Else
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, FuelCostWhileGravJumpingManual)
										          StoreFuelGravDriveConsumptionValues = FuelCostWhileGravJumpingManual
												  akShip.Damagevalue(SpaceshipTotalChargeAmount, GravJumpChargeCostManual)
											      StoreChargeConsumptionValues = GravJumpChargeCostManual
											EndIf
								
								EndIf
				  
				  If GV_SpaceshipNeedsMaintenanceToggle.GetValue() == 1
				     akShip.Damagevalue(SpaceshipTotalMaintenanceAmount, MaintenanceDMGOnGravJump)
			         MaintenanceThresholds()
			   EndIf
				  
				  FuelThresholds()
				  StartTimer(3, 3)
				   
				   If akShip.IsInSpace() == True
				      GravJumpPreparationFX.Play(akShip, 1)   
                EndIf
			
			EndIf
            
			If GV_SpaceshipNeedsRecharging.GetValue() == 0
			   GV_SpaceshipNeedsRecharging.SetValue(1)
	     EndIf
	 
	 EndIf	

EndIf	

EndEvent

Event Actor.OnEnterShipInterior(Actor akSender, ObjectReference akShip)
               
	 If akSender == PlayerRef && akShip == PlayerRef.GetCurrentShipRef()
        CancelFuelTimerOnLeavingSpaceship() 
        CalculateRandomValuesForSpaceships()
		CalculateFuelCost()
		CalculateRepairCost()					 
				 
		   If GV_DebugNotification.GetValue() == 1
		      Debug.Notification("PLAYER ENTERED SHIP AT ENTER EVENT") 
	    EndIf
		   
  EndIf

EndEvent

Event Actor.OnExitShipInterior(Actor akSender, ObjectReference akShip)

     If akSender == PlayerRef && akShip == SQ_PlayerShip.PlayerShip.GetShipRef()
        
		CancelFuelTimerOnLeavingSpaceship()
        GV_SpaceshipMaintenanceAtWork.SetValue(0)
        BlockTravelWithoutPiloting()
        SpaceshipEngineIgnited = False
        StartTimer(3, 6)    				
		   
		   If GV_DebugNotification.GetValue() == 1
              Debug.Notification("PLAYER EXITED SHIP INTERIOR")  
        EndIf
  
  EndIf

EndEvent

Event OnTimer(int aiTimerID)

             SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef() 
           
			 CurrentLoc = PlayerRef.GetCurrentlocation()
                          
     	     If (aiTimerID == 1)

                FuelConsumption()
              
			  If GV_SpaceshipNeedsMaintenanceToggle.GetValue() == 1
				 MaintenanceSystem()
           EndIf
              
			  If GV_AutoInjector.GetValue() == 1
                  AutoRefuelingFuel()
		   EndIf

     	 ElseIf (aiTimerID == 3)       

                SpaceshipDamage()

              If GV_AutoInjector.GetValue() == 1
                 AutoRefuelingCharge()
		   EndIf

     	 ElseIf (aiTimerID == 4)       
				  
			    SpawnEmergencyResponder()

     	 ElseIf (aiTimerID == 5)       

                DebtChecker()

     	 ElseIf (aiTimerID == 6)       

                CheckAndStoreFuelValuesForTech()

     	 ElseIf (aiTimerID == 7)       
				
				EnableGroundTravel()
                EnableSpaceTravel()
                EnableTakeoff()
                               					   
                MaintenanceAtShipService()

     	 ElseIf (aiTimerID == 8)       

                If CameraShakeOnFuelFill == True
                   Game.ShakeCamera(PlayerRef, 0.02, 2)
                   Game.ShakeController(0.02, 0.02, 2)
                   StartTimer(1, 8)
            Else
                   CancelTimer(8)
             EndIf

     	 ElseIf (aiTimerID == 10)

                akShip.setvalue(SpaceshipGravDriveInitiated, 1)
                CancelTimer(10)

		 ElseIf (aiTimerID == 11)       

             If TutorialAdditionalInfo == True
                CancelTimer(11)
         Else
                SpaceshipSystemsTutorials()		  
                StartTimer(1, 11)
          EndIf

     	 ElseIf (aiTimerID == 12)       
		  				                 
				If TutorialIntroduction == False
			           If PlayerRef.GetFurnitureUsing() == PlayerShipPilotSeat.GetRef()
                          SpaceshipSystemsIntroduction()				   
				          CancelTimer(12)
                    EndIf
             		StartTimer(2, 12)
			 EndIf

     	 ElseIf (aiTimerID == 14)       

			    RepairBotsVisualFX.Play(akShip, 5) 
		    
				akShip.RestoreValue(SpaceshipHealth, 99999.0)
		        akShip.RestoreValue(SpaceshipSystemEngineHealth, 99999.0) 
				akShip.RestoreValue(SpaceshipShieldHealth, 99999.0) 
				akShip.RestoreValue(SpaceshipSystemGravdriveHealth, 99999.0) 
				akShip.RestoreValue(SpaceshipWeaponHealth, 99999.0) 
				akShip.RestoreValue(SpaceshipWeaponHealth02, 99999.0)
				akShip.RestoreValue(SpaceshipWeaponHealth03, 99999.0)
	            
				PlayerRef.RemovePerk(SpaceshipEmergencyRepairBotsPerk)			
				
				Utility.Wait(5.0)
		        wwiseevent.StopInstance(BotsStartSoundInstance)
                BotsStartSoundInstance = -1
                BotsEndSoundInstance = SoundEventBotsRepairEnd.Play(akShip, None, None)               				
				Utility.Wait(5.0)
				wwiseevent.StopInstance(BotsEndSoundInstance)
                BotsEndSoundInstance = -1

     	 ElseIf (aiTimerID == 15)       
                
				If GV_SpaceshipDramaticGravJumpToggle.GetValue() == 1
			          If akShip.IsInSpace() == True
				         SpaceshipGravDriveStartFX.Play(akShip, 10.0, None)
                         StartTimer(4, 15)
                   EndIf
			 EndIf
     	 
		 ElseIf (aiTimerID == 16)       
			    
				If GV_SpaceshipMaintenanceAtWork.GetValue() >= 1
				   SpaceshipMaintenanceFX.Play(akShip, 10.0, None)
                   SoundEventMaintenanceAtWork02.Play(akShip, None, None)
				   StartTimer(0.5, 16)
            Else
		           CancelTimer(16)
		           SoundEventFuelFillStart.Play(akShip, None, None) 
			       SoundEventChargeEnd.Play(akShip, None, None) 
				   RepairBotsVisualFX.Play(akShip, 5) 
			 EndIf
		  
		  EndIf

EndEvent

Function CancelFuelTimerOnLeavingSpaceship()

        CancelTimer(1)	

        If GV_DebugNotification.GetValue() == 1
		   Debug.Notification("ALL FUEL CONSUMPTION TIMERS CANCELED")
     EndIf

EndFunction

Function CheckSystemsMessageControl()

          spaceshipreference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
    
	If GV_SpaceshipSystemCheckMessages.GetValue() == 1
          If akShip.IsDocked() == True || akShip.IsLanded() == True
                If SpaceshipIsReadyToFly == True && TravelDisabled == False
				   MSG_SpaceshipSystemsCheck.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                   Utility.Wait(2.0)
                   MSG_SpaceshipSystemsAreReady.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
            Else
	               Utility.Wait(0.5)
				   MSG_SpaceshipSystemsCheckFailed.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
	         EndIf
	   EndIf
 EndIf

EndFunction

Function CheckSystems()

                         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                         Int TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount) as Int
		
		If GV_SpaceshipSystemsToggle.GetValue() == 1

							  If TotalFuelInTheTank > 0
                                 EnginePowerRestricted = False
								 SpaceshipIsReadyToFly = True
				                 TravelDisabled = False
					             CheckSystemsMessageControl()
									 
									 If GV_SpaceshipMaintenanceAtWork.GetValue() == 0
								        UnblockTravel()
                                  EndIf
				                 
								 AllPowerOn()
								 
								     If GV_DebugNotification.GetValue() == 1
								        Debug.Notification("FUEL CHECK COMPLETED!")
			                      EndIf
						  
						  Else  
                                 EnginePowerRestricted = True
								 SpaceshipIsReadyToFly = False
				                 TravelDisabled = True
                                 CheckSystemsMessageControl()
					             BlockTravel()
									
									If EnginePowerRestricted == False
                                       EnginePowerRestricted = True
                                 EndIf
                                 
								 AllPowerOff()
								 
								    If GV_DebugNotification.GetValue() == 1
								       Debug.Notification("CHECKING FOR FUEL!")
         				         EndIf
						   EndIf
	   
			  If akShip.IsLanded() == True
				 DisableGravJump() 
                 DisableGroundTravel()
                 DisableSpaceTravel()
		   EndIf

              If GV_AutoInjector.GetValue() == 1
                 AutoRefuelingFuel()
		         AutoRefuelingCharge()
		   EndIf

           StoreValuesSpaceshipPower()
    EndIf

EndFunction

Function GravDriveCheck()

                         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                         Int GravJumpChargeCost = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4)
                         Int FuelCostWhileGravJumping = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2)
	                     
						 Int TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount) as Int
	                     Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int 
                  
				  If akShip.HasKeyword(SpaceshipTypeStarborn) == True

                              If TotalFuelInTheTank > FuelCostWhileGravJumping
                                 EnableGravJump()
			              		 GravDriveCalculatePreparation()
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("STARBORN SHIP GRAV DRIVE IS READY")
	                               EndIf
						  Else  
								 SpaceshipGravDriveStartFX.Stop(akShip)
								 akShip.setvalue(SpaceshipGravDriveInitiated, -1)
						   		 wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
                                 GravDrivePrepareSoundInstance = -1
						         GravJumpInitiated = False
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("STARBORN SHIP GRAV DRIVE IS NOT READY")
	                               EndIf
						   EndIf

              ElseIf akShip.HasKeyword(SpaceshipTypeStarborn) == False

                              If TotalChargeInGravDrive > GravJumpChargeCost && TotalFuelInTheTank > FuelCostWhileGravJumping && akShip.GetValue(SpaceshipSystemGravdriveHealth) > 0 
                                 EnableGravJump()
			                     GravDriveCalculatePreparation()
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("SHIP GRAV DRIVE IS READY")
	                               EndIf
						  Else  
								 SpaceshipGravDriveStartFX.Stop(akShip)
								 akShip.setvalue(SpaceshipGravDriveInitiated, -1)
						   		 wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
                                 GravDrivePrepareSoundInstance = -1
						         GravJumpInitiated = False
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("SHIP GRAV DRIVE IS NOT READY")
	                               EndIf
						   EndIf
               EndIf

EndFunction

Function FuelCheckFromMenuOpen()

                         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                         Int GravJumpChargeCost = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4)
                         Int FuelCostWhileGravJumping = Math.Round(akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) / 2)
						 
						 Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount)
	                     Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int 
                         Int GravDrive = akShip.GetPartPower(3, 0)
                         Int Engine = akShip.GetPartPower(1, 0)			  

				  If akShip.HasKeyword(SpaceshipTypeStarborn) == True
                              
							  If TotalFuelInTheTank > StoreFuelGravDriveConsumptionValues
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("STARBORN SHIP GRAV DRIVE IS READY")
	                               EndIf
			              Else  
                                 DisableGravJump()
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("STARBORN SHIP GRAV DRIVE IS NOT READY, NOT ENOUGH FUEL")
	                               EndIf
						   EndIf

                              If TotalFuelInTheTank > StoreFuelConsumptionValues
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("STARBORN SHIP LANDING APPROVED")
	                               EndIf
			              Else  
                                 DisableGravJump() 
                                 DisableGroundTravel()
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("STARBORN SHIP LANDING DECLINED, NOT ENOUGH FUEL")
	                               EndIf
						   EndIf

              ElseIf akShip.HasKeyword(SpaceshipTypeStarborn) == False

                              If TotalChargeInGravDrive > StoreChargeConsumptionValues && TotalFuelInTheTank > StoreFuelGravDriveConsumptionValues && GravDrive > 0 && Engine > 0
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("SHIP GRAV DRIVE IS READY")
	                               EndIf
			              Else  
                                 DisableGravJump()
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("SHIP GRAV DRIVE IS NOT READY, NOT ENOUGH FUEL OR CHARGE")
	                               EndIf
						   EndIf

                              If TotalFuelInTheTank > StoreFuelConsumptionValues
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("SHIP LANDING APPROVED")
	                               EndIf
			              Else  
                                 
								 DisableGravJump() 
                                 DisableGroundTravel()
						              
									  If GV_DebugNotification.GetValue() == 1
								         Debug.Notification("SHIP LANDING DECLINED, NOT ENOUGH FUEL")
	                               EndIf
						   EndIf

               EndIf

EndFunction

Function FuelCheckFromMenuClose()

         EnableGravJump()

         If SpaceshipIsReadyToFly == True && TravelDisabled == False 
            EnableGroundTravel()
      EndIf

EndFunction

Function GravDriveCalculatePreparation()

         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
         Int GravDrive = akShip.GetPartPower(3, 0)

   If GravJumpInitiated == True

         akShip.setvalue(SpaceshipGravDriveInitiated, -1)
         SpaceshipGravDriveStartFX.Stop(akShip)
		 CancelTimer(10)    
         CancelTimer(15)  

         If GravDrive == 1
            StartTimer(20, 10)  
            StartTimer(0, 15) 
	 ElseIf GravDrive == 2
            StartTimer(18, 10)   
            StartTimer(0, 15) 
	 ElseIf GravDrive == 3
            StartTimer(15, 10)  
            StartTimer(0, 15) 
     ElseIf GravDrive == 4
            StartTimer(12, 10) 
            StartTimer(0, 15) 
     ElseIf GravDrive == 5
            StartTimer(10, 10) 
            StartTimer(0, 15) 
     ElseIf GravDrive == 6
            StartTimer(8, 10) 	 
            StartTimer(0, 15) 
     ElseIf GravDrive == 7
            StartTimer(6, 10) 
            StartTimer(0, 15) 
     ElseIf GravDrive == 8
            StartTimer(5, 10) 
            StartTimer(0, 15) 
     ElseIf GravDrive == 9
            StartTimer(4, 10)  
            StartTimer(0, 15) 
     ElseIf GravDrive == 10	 
            StartTimer(3, 10)  
            StartTimer(0, 15) 
     ElseIf GravDrive == 11	 
            StartTimer(2, 10)  	 
            StartTimer(0, 15) 
     ElseIf GravDrive >= 12	 	 
            StartTimer(1, 10)  
            StartTimer(0, 15) 
      EndIf

EndIf

EndFunction

Function AutoRefuelingFuel()

      SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	  
	  Int TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount) as Int
      Int FuelTankAmount = akShip.GetValue(SpaceshipFuelTank) As Int / 3

               If akShip.GetItemCount(SpaceshipFuel) > FuelTankAmount
                    If TotalFuelInTheTank <= FuelTankAmount
					   FuelFillExecute()
                 EndIf
            EndIf

EndFunction

Function AutoRefuelingCharge()

      SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

      Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) As Int / 3
 	  Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int 
      
	  If GravDriveDamaged == False

                 If akShip.GetItemCount(SpaceshipGravBattery) > GravDriveChargeAmount
                      If TotalChargeInGravDrive <= GravDriveChargeAmount
						 GravDriveFillExecute()
                   EndIf
              EndIf
   EndIf

EndFunction

Function FuelFillSpecialFX()

                             If GV_SpaceshipRefuelingType.GetValue() == 0      

										  CameraShakeOnFuelFill = True
										  StartTimer(0, 8)
         						          SoundEventChargeInTheProcess.PlayAndWait(PlayerRef, None, None) 
                                          CameraShakeOnFuelFill = False
         						          SoundEventFuelFillEnd.Play(PlayerRef, None, None) 
                                          SoundEventFuelFillBeep.Play(PlayerRef, None, None) 

                         Else
         						          SoundEventFuelFillEnd.Play(PlayerRef, None, None) 
                          EndIf

EndFunction

Function FuelFillSpecialFXOutside()

                             SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                             If GV_SpaceshipRefuelingType.GetValue() == 0      

         						          SoundEventChargeInTheProcess.PlayAndWait(akShip, None, None) 
         						          SoundEventFuelFillEnd.Play(akShip, None, None) 
                                          SoundEventFuelFillBeep.Play(akShip, None, None) 

                         Else
         						          SoundEventFuelFillEnd.Play(akShip, None, None) 
                          EndIf

EndFunction

Function ChargeFillSpecialFX()

                             SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                             If GV_SpaceshipRefuelingType.GetValue() == 0  

									 CameraShakeOnFuelFill = True
									 StartTimer(0, 8)
									 SoundEventFuelFillInTheProcess.PlayAndWait(PlayerRef, None, None)
                                     CameraShakeOnFuelFill = False
                                     SoundEventChargeEnd.PlayAndWait(PlayerRef, None, None) 
									 SoundEventChargeBeep.Play(PlayerRef, None, None)
                                     PlayerRef.Placeatme(ImpulseExplosion, 1, False, false, true, none, none, True)
									 GravDriveRechargeFX.Play(akShip, 0.3) 
									 ShakeAndRumble02()

                         Else
                                     SoundEventChargeEnd.Play(PlayerRef, None, None) 
                          EndIf

EndFunction

Function ChargeFillSpecialFXOutside()

                             SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                             If GV_SpaceshipRefuelingType.GetValue() == 0  

									 SoundEventFuelFillInTheProcess.PlayAndWait(akShip, None, None)
                                     SoundEventChargeEnd.PlayAndWait(akShip, None, None) 
									 SoundEventChargeBeep.Play(akShip, None, None)
                                     PlayerRef.Placeatme(ImpulseExplosion, 1, False, false, true, none, none, True)
									 GravDriveRechargeFX.Play(akShip, 0.3) 
									 ShakeAndRumble02()

                         Else
                                     SoundEventChargeEnd.Play(akShip, None, None) 
                          EndIf

EndFunction

Function ChargeTakeoutSpecialFX()

                             SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                             If GV_SpaceshipRefuelingType.GetValue() == 0  

                                     SoundEventChargeStart.PlayAndWait(akShip, None, None) 
									 CameraShakeOnFuelFill = True
									 StartTimer(0, 8)
									 SoundEventFuelFillInTheProcess.PlayAndWait(PlayerRef, None, None)
                                     CameraShakeOnFuelFill = False
                                     SoundEventChargeEnd.PlayAndWait(PlayerRef, None, None) 
									 SoundEventFuelFillEnd.Play(PlayerRef, None, None) 

                         Else
                                     SoundEventChargeEnd.Play(PlayerRef, None, None) 
                          EndIf

EndFunction

Function MaintenanceSpecialFX()

                 SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                 
				 StartTimer(0, 16)
				 RepairBotsVisualFX.Play(akShip, 5)
				 SoundEventBotsRepairStart.Play(akShip, None, None)
		         SoundEventMaintenanceAtWork.Play(PlayerRef, None, None)

EndFunction

Function FuelFillExecute()

                         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

						 Float FuelTankAmount = akShip.GetValue(SpaceshipFuelTank)                        
						 Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount)
                         Float FuelToFillWith = 0.0
                             
	If RefuelFuelStarted == False
       RefuelFuelStarted = True

       FuelFillSpecialFX()
																				
										FuelToFillWith = Math.Round(akShip.GetValue(SpaceshipFuelTank) - akShip.GetValue(SpaceshipTotalFuelAmount))
										akShip.Restorevalue(SpaceshipTotalFuelAmount, FuelToFillWith)							          
										akShip.RemoveItem(SpaceshipFuel, FuelToFillWith as Int, True, None)
										  										  										   										   
										   If TotalFuelInTheTank == FuelTankAmount
										   	  GV_SpaceshipNeedsRefueling.SetValue(0)
										EndIf
										   
										   If GV_DebugNotification.GetValue() == 1
										      Debug.Notification("SPACESHIP REFUELED")								        
										EndIf
								   						  
						                   If SpaceshipIsReadyToFly == False || TravelDisabled == True
						                      SpaceshipIsReadyToFly = True
				                              TravelDisabled = False
					                          UnblockTravel()
				                        EndIf
                         
						                CheckSystems()
						                SpaceshipSystemStatus()
                                        RefuelFuelStarted = False
						                TutorialFillFuel = True
                                        GV_PrepareFuelStandBy.SetValue(0)
 
 EndIf
EndFunction 

Function GravDriveFillExecute()

                         SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                         
						 Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) as Int
						 Int GravDriveChargeAmountBase = akShip.GetBaseValue(SpaceshipGravDriveHealth) as Int
                         Int TotalChargeInTheGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int                    
						 Int ChargeToFillWith = 0
	
	If RefuelChargeStarted == False
       RefuelChargeStarted = True

       ChargeFillSpecialFX()
  
										ChargeToFillWith = Math.Round(akShip.GetValue(SpaceshipGravDriveHealth) - akShip.GetValue(SpaceshipTotalChargeAmount))
										akShip.Restorevalue(SpaceshipTotalChargeAmount, ChargeToFillWith)							          									
										akShip.RemoveItem(SpaceshipGravBattery, ChargeToFillWith, True, None)
																				  										   										   
										   If TotalChargeInTheGravDrive == GravDriveChargeAmount
										   	  GV_SpaceshipNeedsRecharging.SetValue(0)
										EndIf
										   
										   If GV_DebugNotification.GetValue() == 1
										      Debug.Notification("SPACESHIP RECHARGED")								        
										EndIf
								                            
								        SpaceshipSystemStatus()
                                        RefuelChargeStarted = False
						                TutorialFillCharge = True
                                        GV_PrepareBatteryStandBy.SetValue(0) 
 
 EndIf
EndFunction

Function FuelPumpoutExecute()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                                     
                                     Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount)
								     
									 FuelConsumptionStopOnPumpOut()
                                     FuelFillSpecialFX()
 
									    akShip.AddItem(SpaceshipFuel, TotalFuelInTheTank as Int, True)						        
										akShip.Damagevalue(SpaceshipTotalFuelAmount, TotalFuelInTheTank)						          
										
                                        GV_PrepareFuelStandBy.SetValue(0)
										GV_SpaceshipNeedsRefueling.SetValue(1)
										   
										   If GV_DebugNotification.GetValue() == 1
										      Debug.Notification("SHIP FUEL PUMPED OUT")
								        EndIf
						           
								        SpaceshipSystemStatus()
                                        CheckSystems()

EndFunction

Function ChargesTakeoutExecute()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                                     
                                     Int TotalChargeInTheGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int  
									 									 
									 ChargeTakeoutSpecialFX()

									    akShip.AddItem(SpaceshipGravBattery, TotalChargeInTheGravDrive, True)
										akShip.Damagevalue(SpaceshipTotalChargeAmount, TotalChargeInTheGravDrive)	
										
										GV_PrepareBatteryStandBy.SetValue(0)
										GV_SpaceshipNeedsRecharging.SetValue(1) 
									   										   
										   If GV_DebugNotification.GetValue() == 1
										      Debug.Notification("SHIP GRAV DRIVE EMPTIED")
								        EndIf
                                  
						                SpaceshipSystemStatus()
                                        GravDriveCheck()
EndFunction

Function SpaceshipFuelConsumptionOff()

      SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()

      Int Engine = akShip.GetPartPower(1, 0)

      SpaceshipEngineIgnited == False

      CancelTimer(1)

	  GV_FuelConsumeDMGOnPower.SetValue(Engine)

EndFunction

Function SpaceshipFuelConsumptionOn()

    SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()
    Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue()
    Int Engine = akShip.GetPartPower(1, 0)

                       If SpaceshipIsReadyToFly == True && TravelDisabled == False
					       If akShip.IsDocked() == False && akShip.IsInSpace() == True
							     If Engine > 0
                                       If SpaceshipEngineIgnited == False
									      StartTimer(ConsumeFuelCycle, 1)                           
                                          SpaceshipEngineIgnited = True
                                    EndIf
							  EndIf
						EndIf
					EndIf

EndFunction

Function FuelConsumptionCalculation()
               
			   SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
               
			   Float ConsumeFuelDMGOnMoveAdvanced = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue()
               Float ConsumeFuelDMGOnMoveAdvancedAstro01 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.15
               Float ConsumeFuelDMGOnMoveAdvancedAstro02 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.20
			   Float ConsumeFuelDMGOnMoveAdvancedAstro03 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveAdvancedAstro04 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.35
			   
			   Float ConsumeFuelDMGOnMoveBasic = GV_SpaceshipFuelCalculationBasic.GetValue()
			   Float ConsumeFuelDMGOnMoveBasicAstro01 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.15
			   Float ConsumeFuelDMGOnMoveBasicAstro02 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.20
			   Float ConsumeFuelDMGOnMoveBasicAstro03 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveBasicAstro04 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.35
               
			   Float ConsumeFuelDMGOnMoveStory = GV_SpaceshipFuelCalculationStory.GetValue()
               Float ConsumeFuelDMGOnMoveStoryAstro01 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.15
               Float ConsumeFuelDMGOnMoveStoryAstro02 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.20
			   Float ConsumeFuelDMGOnMoveStoryAstro03 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveStoryAstro04 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.35
               
			   Float ConsumeFuelDMGOnMoveManual = GV_SpaceshipFuelCalculationManual.GetValue()
               Float ConsumeFuelDMGOnMoveManualAstro01 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.15			   
               Float ConsumeFuelDMGOnMoveManualAstro02 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.20
               Float ConsumeFuelDMGOnMoveManualAstro03 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveManualAstro04 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.35

			   Int i = -1
               Actor CrewMember = CurrentCrew.GetAt(i) as Actor 

						           If GV_SpaceshipFuelCalculationMode.GetValue() == 0
								      									    
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveAdvancedAstro04)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveAdvancedAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveAdvancedAstro03)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveAdvancedAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveAdvancedAstro02)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveAdvancedAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveAdvancedAstro01)
                                                  StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveAdvancedAstro01
										  Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveAdvanced)
											      StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveAdvanced
											EndIf
					   							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 1
										       
											   If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveBasicAstro04)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveBasicAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveBasicAstro03)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveBasicAstro03 
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveBasicAstro02)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveBasicAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveBasicAstro01)
                                                  StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveBasicAstro01
										  Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveBasic)
											      StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveBasic
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 2
											   
											   If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveStoryAstro04)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveStoryAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveStoryAstro03)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveStoryAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveStoryAstro02)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveStoryAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveStoryAstro01)
                                                  StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveStoryAstro01
										  Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveStory)
											      StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveStory
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 3
											   
											   If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveManualAstro04)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveManualAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveManualAstro03)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveManualAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveManualAstro02)
										          StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveManualAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveManualAstro01)
                                                  StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveManualAstro01
										  Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnMoveManual)
											      StoreFuelConsumptionValues = ConsumeFuelDMGOnMoveManual
											EndIf
								
								EndIf

EndFunction

Function FuelConsumption()

               SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()            
			   
			   Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue() 

               CurrentLoc = PlayerRef.GetCurrentlocation()
                
	If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True  
               
			   If SpaceshipIsReadyToFly == True && TravelDisabled == False                       

		               If akShip.IsDocked() == False && akShip.IsInSpace() == True
                          FuelConsumptionCalculation()
																    								 
                                      If akShip.GetValue(SpaceshipTotalFuelAmount) <= 0 
                                         SpaceshipIsReadyToFly = False
				                         TravelDisabled = True

									        If SpaceshipPowerValueStored == False
									           StoreValuesSpaceshipPower()
								         EndIf

								         AllPowerOff()
								         BlockTravel()
								         CancelTimer(1)
										 CheckSystems()
                                           
										   If EnginePowerRestricted == False
                                              EnginePowerRestricted = True
                                        EndIf							 
			                            
										FuelThresholds()						        
										
										MSG_SpaceshipOutOfFuel.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                                   
								 Else
								 		
										If GV_SpaceshipNeedsRefueling.Getvalue() == 0
								           GV_SpaceshipNeedsRefueling.SetValue(1)
								     EndIf
										
										FuelThresholds()						        
										StartTimer(ConsumeFuelCycle, 1)    
								   
								   EndIf
								   						                   									
									If GV_DebugNotification.GetValue() == 1
								       Debug.Notification("CONSUMING FUEL FROM HOMESHIP")
								 EndIf
                         			
						 Else
								   CancelTimer(1)
								   CheckSystems()					
					EndIf
            EndIf
Else

	 CancelTimer(0)
     CancelTimer(1)

EndIf

EndFunction

Function MaintenanceSystem()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef() 

    Float fPercentDamageStage1 = 10
    Float fPercentDamageStage2 = 20
    Float fPercentDamageStage3 = 30
    Float fPercentDamageStage4 = 40	

    Float DamageWeapon1Stage1 = (akShip.GetValue(SpaceshipWeaponHealth) / 100) * fPercentDamageStage1
    Float DamageWeapon1Stage2 = (akShip.GetValue(SpaceshipWeaponHealth) / 100) * fPercentDamageStage2
    Float DamageWeapon1Stage3 = (akShip.GetValue(SpaceshipWeaponHealth) / 100) * fPercentDamageStage3
    Float DamageWeapon1Stage4 = (akShip.GetValue(SpaceshipWeaponHealth) / 100) * fPercentDamageStage4	

    Float DamageWeapon2Stage1 = (akShip.GetValue(SpaceshipWeaponHealth02) / 100) * fPercentDamageStage1
    Float DamageWeapon2Stage2 = (akShip.GetValue(SpaceshipWeaponHealth02) / 100) * fPercentDamageStage2
    Float DamageWeapon2Stage3 = (akShip.GetValue(SpaceshipWeaponHealth02) / 100) * fPercentDamageStage3
    Float DamageWeapon2Stage4 = (akShip.GetValue(SpaceshipWeaponHealth02) / 100) * fPercentDamageStage4	

    Float DamageWeapon3Stage1 = (akShip.GetValue(SpaceshipWeaponHealth03) / 100) * fPercentDamageStage1
    Float DamageWeapon3Stage2 = (akShip.GetValue(SpaceshipWeaponHealth03) / 100) * fPercentDamageStage2
    Float DamageWeapon3Stage3 = (akShip.GetValue(SpaceshipWeaponHealth03) / 100) * fPercentDamageStage3
    Float DamageWeapon3Stage4 = (akShip.GetValue(SpaceshipWeaponHealth03) / 100) * fPercentDamageStage4	

    Float DamageEngineStage1 = (akShip.GetValue(SpaceshipSystemEngineHealth) / 100) * fPercentDamageStage1
    Float DamageEngineStage2 = (akShip.GetValue(SpaceshipSystemEngineHealth) / 100) * fPercentDamageStage2
    Float DamageEngineStage3 = (akShip.GetValue(SpaceshipSystemEngineHealth) / 100) * fPercentDamageStage3
    Float DamageEngineStage4 = (akShip.GetValue(SpaceshipSystemEngineHealth) / 100) * fPercentDamageStage4

    Float DamageShieldStage1 = (akShip.GetValue(SpaceshipShieldHealth) / 100) * fPercentDamageStage1
    Float DamageShieldStage2 = (akShip.GetValue(SpaceshipShieldHealth) / 100) * fPercentDamageStage2
    Float DamageShieldStage3 = (akShip.GetValue(SpaceshipShieldHealth) / 100) * fPercentDamageStage3
    Float DamageShieldStage4 = (akShip.GetValue(SpaceshipShieldHealth) / 100) * fPercentDamageStage4	

    Float DamageGravJumpStage1 = (akShip.GetValue(SpaceshipSystemGravdriveHealth) / 100) * fPercentDamageStage1
    Float DamageGravJumpStage2 = (akShip.GetValue(SpaceshipSystemGravdriveHealth) / 100) * fPercentDamageStage2
    Float DamageGravJumpStage3 = (akShip.GetValue(SpaceshipSystemGravdriveHealth) / 100) * fPercentDamageStage3
    Float DamageGravJumpStage4 = (akShip.GetValue(SpaceshipSystemGravdriveHealth) / 100) * fPercentDamageStage4

    Float DamageHealthStage1 = (akShip.GetValue(SpaceshipHealth) / 100) * fPercentDamageStage1
    Float DamageHealthStage2 = (akShip.GetValue(SpaceshipHealth) / 100) * fPercentDamageStage2
    Float DamageHealthStage3 = (akShip.GetValue(SpaceshipHealth) / 100) * fPercentDamageStage3
    Float DamageHealthStage4 = (akShip.GetValue(SpaceshipHealth) / 100) * fPercentDamageStage4

	Float MaintenanceDMG = GV_SpaceshipMaintenanceDMG.GetValue()
	
	Float MaintenanceDMGPerk01 = GV_SpaceshipMaintenanceDMG.GetValue() / 1.5
	Float MaintenanceDMGPerk02 = GV_SpaceshipMaintenanceDMG.GetValue() / 2.5
	Float MaintenanceDMGPerk03 = GV_SpaceshipMaintenanceDMG.GetValue() / 3.5
	Float MaintenanceDMGPerk04 = GV_SpaceshipMaintenanceDMG.GetValue() / 5.0  
	
	int RandomSystem = Utility.RandomInt(0,6)
                     
    If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True  
               If SpaceshipIsReadyToFly == True && TravelDisabled == False                       

		               If akShip.IsDocked() == False && akShip.IsInSpace() == True

					               If PlayerRef.Hasperk(SpaceshipMaintenanceMaxAmountPerk04)
				                      akShip.Damagevalue(SpaceshipTotalMaintenanceAmount, MaintenanceDMGPerk04)                               
							   ElseIf PlayerRef.Hasperk(SpaceshipMaintenanceMaxAmountPerk03)
				                      akShip.Damagevalue(SpaceshipTotalMaintenanceAmount, MaintenanceDMGPerk03)			                                  
							   ElseIf PlayerRef.Hasperk(SpaceshipMaintenanceMaxAmountPerk02)
				                      akShip.Damagevalue(SpaceshipTotalMaintenanceAmount, MaintenanceDMGPerk02)		                               
							   ElseIf PlayerRef.Hasperk(SpaceshipMaintenanceMaxAmountPerk01)
				                      akShip.Damagevalue(SpaceshipTotalMaintenanceAmount, MaintenanceDMGPerk01)		
				           Else
				                      akShip.Damagevalue(SpaceshipTotalMaintenanceAmount, MaintenanceDMG)		  
			                    EndIf
                                
								   If GV_SpaceshipSystemDamaged.GetValue() == 0
                                      GV_SpaceshipSystemDamaged.SetValue(1)
                                EndIf								
								   
								   If akShip.GetValue(SpaceshipTotalMaintenanceAmount) <= 0.00
                                      akShip.Kill(None) 

                               ElseIf akShip.GetValue(SpaceshipTotalMaintenanceAmount) < 20.00
									    
										If GV_SpaceshipMaintenanceAtWork.GetValue() == 0
									          If MaintenanceEmergency == False
									             MaintenanceEmergencySoundInstance = -1
									             MaintenanceEmergencySoundInstance = SoundEventMaintenanceEmergency.Play(akShip, None, None)
									             MaintenanceEmergency = True
								            EndIf
								     EndIf
										
										If (RandomSystem == 0)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage4)
									ElseIf (RandomSystem == 1)
									        akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage4)
									ElseIf (RandomSystem == 2)
									        akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage4)									  
									ElseIf (RandomSystem == 3)
                                            akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage4)
									ElseIf (RandomSystem == 4)
                                            akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage4)
									ElseIf (RandomSystem == 5)
                                            akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage4)
									ElseIf (RandomSystem == 6)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage4)
											akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage4)
                                            akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage4)
											akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage4)
											akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage4)
											akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage4)
                                     EndIf

                               ElseIf akShip.GetValue(SpaceshipTotalMaintenanceAmount) < 40.00
									    
										If (RandomSystem == 0)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage3)
									ElseIf (RandomSystem == 1)
									        akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage3)
									ElseIf (RandomSystem == 2)
									        akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage3)									  
									ElseIf (RandomSystem == 3)
                                            akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage3)
									ElseIf (RandomSystem == 4)
                                            akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage3)
									ElseIf (RandomSystem == 5)
                                            akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage3)
									ElseIf (RandomSystem == 6)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage3)
											akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage3)
                                            akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage3)
											akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage3)
											akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage3)
											akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage3)
                                     EndIf

                               ElseIf akShip.GetValue(SpaceshipTotalMaintenanceAmount) < 60.00
									    
										If GV_SpaceshipAutoRepair.GetValue() == 1
									       GV_SpaceshipAutoRepair.SetValue(0)
									 EndIf	
										
										If (RandomSystem == 0)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage2)
									ElseIf (RandomSystem == 1)
									        akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage2)
									ElseIf (RandomSystem == 2)
									        akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage2)									  
									ElseIf (RandomSystem == 3)
                                            akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage2)
									ElseIf (RandomSystem == 4)
                                            akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage2)
									ElseIf (RandomSystem == 5)
                                            akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage2)
									ElseIf (RandomSystem == 6)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage2)
											akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage2)
                                            akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage2)
											akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage2)
											akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage2)
											akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage2)
                                     EndIf

                               ElseIf akShip.GetValue(SpaceshipTotalMaintenanceAmount) < 80.00
									    
										If (RandomSystem == 0)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage1)
									ElseIf (RandomSystem == 1)
									        akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage1)
									ElseIf (RandomSystem == 2)
									        akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage1)									  
									ElseIf (RandomSystem == 3)
                                            akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage1)
									ElseIf (RandomSystem == 4)
                                            akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage1)
									ElseIf (RandomSystem == 5)
                                            akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage1)
									ElseIf (RandomSystem == 6)
									        akShip.DamageValue(SpaceshipWeaponHealth, DamageWeapon1Stage1)
											akShip.DamageValue(SpaceshipWeaponHealth02, DamageWeapon2Stage1)
                                            akShip.DamageValue(SpaceshipWeaponHealth03, DamageWeapon3Stage1)
											akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngineStage1)
											akShip.DamageValue(SpaceshipShieldHealth, DamageShieldStage1)
											akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJumpStage1)
                                     EndIf

                                EndIf         
                                GravDriveDMGToGravDriveHealth()
                                MaintenanceThresholds()

			                       If GV_DebugNotification.GetValue() == 1
				                      Debug.Notification("MAINTENANCE DAMAGE TO SPACESHIP")
			                    EndIf

                    Else
								   CancelTimer(6)					
					EndIf
            EndIf
Else

	 CancelTimer(0)
     CancelTimer(1)
     CancelTimer(6)

EndIf
                                              
EndFunction

Function EmergencyRepairBots()

           SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
       
	          If PlayerRef.Hasperk(SpaceshipEmergencyRepairBotsPerk) == False
			     PlayerRef.AddPerk(SpaceshipEmergencyRepairBotsPerk, False)
                 akShip.Removeitem(SpaceshipEmergencyRepairBotsMisc, 1, True, None)
				 BotsStartSoundInstance = SoundEventBotsRepairStart.Play(akShip, None, None)	
				 StartTimer(2, 14)
	     Else
                 MSG_BotsAlreadyInUse.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
   
           EndIf

EndFunction

Function MaintenanceRepairKit()

        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()  

 If PlayerRef.Hasperk(SpaceshipMaintenanceMaxAmountPerk03) == False
    If akShip.IsDocked() == True || akShip.IsLanded() == True

	              If GV_SpaceshipMaintenanceAtWork.GetValue() == 0
                     GV_SpaceshipMaintenanceAtWork.SetValue(1)
	  			     akShip.Removeitem(SpaceshipMaintenanceKitMisc, 1, True, None)
			 		 MaintenanceSpecialFX()
					 DisableGroundTravel()
   	                 DisableSpaceTravel()
    	             DisableTakeoff()
					 wwiseevent.StopInstance(MaintenanceEmergencySoundInstance)
    	             MaintenanceEmergencySoundInstance = -1
		             MaintenanceEmergency = False
					     
						 If PlayerRef.HasPerk(SpaceshipMaintenanceMaxAmountPerk03)
					        StartTimer(15, 7)
			          Else
			                StartTimer(45, 7)
			          EndIf
			  Else
         	         MSG_MaintenanceKitAlreadyInUse.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
   
         	   EndIf

	Else
                 	MSG_MaintenanceRules.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
	EndIf

Else

	              If GV_SpaceshipMaintenanceAtWork.GetValue() == 0
                     GV_SpaceshipMaintenanceAtWork.SetValue(1)
	  			     akShip.Removeitem(SpaceshipMaintenanceKitMisc, 1, True, None)
			 		 MaintenanceSpecialFX()
					 DisableGroundTravel()
   	                 DisableSpaceTravel()
    	             DisableTakeoff()
					 wwiseevent.StopInstance(MaintenanceEmergencySoundInstance)
    	             MaintenanceEmergencySoundInstance = -1
		             MaintenanceEmergency = False
						 
						 If PlayerRef.HasPerk(SpaceshipMaintenanceMaxAmountPerk03)
					        StartTimer(15, 7)
			          Else
			                StartTimer(45, 7)
			          EndIf
			  Else
         	         MSG_MaintenanceKitAlreadyInUse.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
   
         	   EndIf
EndIf
EndFunction

Function EmergencySystemRepairWeaponGroup01()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                                     int RandomRepair = Utility.RandomInt(0,100)                                                                          

										If (RandomRepair <= 15)
									        akShip.RestoreValue(SpaceshipWeaponHealth, 99999.0) 
									          If GV_DebugNotification.GetValue() == 1
										         Debug.Notification("WEAPON GROUP 03 SUBSYSTEM HAS BEEN FULLY REPAIRED")
								           EndIf
                                     EndIf						                   

EndFunction

Function EmergencySystemRepairWeaponGroup02()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                                     int RandomRepair = Utility.RandomInt(0,100)   
										
										If (RandomRepair <= 15)                                                                          
									       akShip.RestoreValue(SpaceshipWeaponHealth02, 99999.0)
									          If GV_DebugNotification.GetValue() == 1
										         Debug.Notification("WEAPON GROUP 02 SUBSYSTEM HAS BEEN FULLY REPAIRED")
								           EndIf
                                     EndIf						                   
EndFunction

Function EmergencySystemRepairWeaponGroup03()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                                     int RandomRepair = Utility.RandomInt(0,100)   
                                       
									   If (RandomRepair <= 15)                                  
									      akShip.RestoreValue(SpaceshipWeaponHealth03, 99999.0) 
									          If GV_DebugNotification.GetValue() == 1
										         Debug.Notification("WEAPON GROUP 03 SUBSYSTEM HAS BEEN FULLY REPAIRED")
								           EndIf
                                    EndIf		 				                   

EndFunction

Function EmergencySystemRepairEngine()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                                     int RandomRepair = Utility.RandomInt(0,100)   
                                       	
										If (RandomRepair <= 15)                                     
		                                   akShip.RestoreValue(SpaceshipSystemEngineHealth, 99999.0) 
									          If GV_DebugNotification.GetValue() == 1
										         Debug.Notification("ENGINE SUBSYSTEM HAS BEEN FULLY REPAIRED")
								           EndIf
                                     EndIf					                   
										
EndFunction

Function EmergencySystemRepairShield()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                                     int RandomRepair = Utility.RandomInt(0,100)   
										
										If (RandomRepair <= 15)                                                                           
									       akShip.RestoreValue(SpaceshipShieldHealth, 99999.0) 
									          If GV_DebugNotification.GetValue() == 1
										         Debug.Notification("SHIELD SUBSYSTEM HAS BEEN FULLY REPAIRED")
								           EndIf
                                     EndIf					                   
										
EndFunction

Function EmergencySystemRepairGravDrive()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
		                             Cell shipInterior = akShip.GetLinkedCell(SpaceshipLinkedInterior)
		                             Float gravity = 0

                                     int RandomRepair = Utility.RandomInt(0,100)   
										
										If (RandomRepair <= 15)                                                                           
									       akShip.RestoreValue(SpaceshipSystemGravdriveHealth, 99999.0) 
                                           GravDriveCheck()
									          If GV_DebugNotification.GetValue() == 1
										         Debug.Notification("GRAV DRIVE SUBSYSTEM HAS BEEN FULLY REPAIRED")
								           EndIf
									 Else
									 		If GV_SpaceshipGravityToggle.GetValue() == 1
		                                       shipInterior.SetGravityScale(gravity)	 
		                                 Else
		                                       DisableGravJump()
		                                  EndIf
									 
									 EndIf					                   
										
EndFunction

Function CalculateRepairCost()

     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
     
	 Float DiscountCalculate = DiscountCost()      
     Float RepairHullCostPerUnit = GV_SpaceshipRepairHullCostPerUnit.GetValue()
     Float RepairSystemCostPerUnit = GV_SpaceshipRepairSystemCostPerUnit.GetValue()
     Float MaintenanceCostPerUnit = GV_SpaceshipRepairMaintenanceCostPerUnit.GetValue()
     Float HullDMGAmount = 0.0
     Float MaintenanceDMGAmount = 0.0
     Float SystemDMGAmountWeapon01 = 0.0
     Float SystemDMGAmountWeapon02 = 0.0
     Float SystemDMGAmountWeapon03 = 0.0
     Float SystemDMGAmountEngine = 0.0
     Float SystemDMGAmountShield = 0.0
     Float SystemDMGAmountGravDrive = 0.0
     Float RepairCost = 0.0

    If akShip

	   HullDMGAmount = akShip.GetBaseValue(SpaceshipHealth) - akShip.GetValue(SpaceshipHealth)
       MaintenanceDMGAmount = akShip.GetBaseValue(SpaceshipTotalMaintenanceAmount) - akShip.GetValue(SpaceshipTotalMaintenanceAmount)
       SystemDMGAmountWeapon01 = akShip.GetBaseValue(SpaceshipWeaponHealth) - akShip.GetValue(SpaceshipWeaponHealth)
       SystemDMGAmountWeapon02 = akShip.GetBaseValue(SpaceshipWeaponHealth02) - akShip.GetValue(SpaceshipWeaponHealth02)
       SystemDMGAmountWeapon03 = akShip.GetBaseValue(SpaceshipWeaponHealth03) - akShip.GetValue(SpaceshipWeaponHealth03)	   
       SystemDMGAmountEngine = akShip.GetBaseValue(SpaceshipSystemEngineHealth) - akShip.GetValue(SpaceshipSystemEngineHealth)
       SystemDMGAmountShield = akShip.GetBaseValue(SpaceshipShieldHealth) - akShip.GetValue(SpaceshipShieldHealth)
       SystemDMGAmountGravDrive = akShip.GetBaseValue(SpaceshipSystemGravdriveHealth) - akShip.GetValue(SpaceshipSystemGravdriveHealth)

       RepairCost = Math.Round(((MaintenanceDMGAmount * MaintenanceCostPerUnit) + (HullDMGAmount * RepairHullCostPerUnit) + ((SystemDMGAmountWeapon01 + SystemDMGAmountWeapon02 + SystemDMGAmountWeapon03 + SystemDMGAmountEngine + SystemDMGAmountShield + SystemDMGAmountGravDrive) * RepairSystemCostPerUnit)) / DiscountCalculate) as Float
	   
EndIf
      
   GV_ShipServiceRepairCost.SetValue(RepairCost)
   
   (DialogueShipServices as DialogueShipServicesScript).ResetTechDialogues()

EndFunction

Function MaintenanceAtShipService()
                                     
									 SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
						             
									 Float TotalMaintenance = akShip.GetValue(SpaceshipTotalMaintenanceAmount)
									 
									 GV_SpaceshipMaintenanceAtWork.SetValue(0) 									 
									 GV_SpaceshipAutoRepair.SetValue(1)
									 GV_SpaceshipSystemDamaged.SetValue(0)					                                                       
									 
									 MaintenanceEmergency = False
								     
									 akShip.Restorevalue(SpaceshipTotalMaintenanceAmount, 99999)
									 akShip.RestoreValue(SpaceshipHealth, 99999.0)
		                             akShip.RestoreValue(SpaceshipSystemEngineHealth, 99999.0) 
									 akShip.RestoreValue(SpaceshipShieldHealth, 99999.0) 
									 akShip.RestoreValue(SpaceshipSystemGravdriveHealth, 99999.0) 
									 akShip.RestoreValue(SpaceshipWeaponHealth, 99999.0) 
									 akShip.RestoreValue(SpaceshipWeaponHealth02, 99999.0)
									 akShip.RestoreValue(SpaceshipWeaponHealth03, 99999.0) 
									 									 
									 SoundEventBotsRepairStart.Play(akShip, None, None)
                                    						                   
										   If GV_DebugNotification.GetValue() == 1
										      Debug.Notification("SPACESHIP HAS BEEN FULLY REPAIRED")
								        EndIf

EndFunction

Function CheckAndStoreFuelValuesForTech()
     
	 spaceshipreference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

	 Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) as Int
	 Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int	
	 
	 Float HealthAmount = akShip.GetValue(SpaceshipHealth) 
	 Float HealthAmountBase = akShip.GetBaseValue(SpaceshipHealth)      
	 Float FuelTankAmount = akShip.GetValue(SpaceshipFuelTank) 
	 Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount) 
     Float TotalMaintenance = akShip.GetValue(SpaceshipTotalMaintenanceAmount)   
     Float TotalMaintenanceBase = akShip.GetBaseValue(SpaceshipTotalMaintenanceAmount)

			   If TotalFuelInTheTank < FuelTankAmount
				  GV_SpaceshipNeedsRefueling.SetValue(1)
		   ElseIf TotalFuelInTheTank == FuelTankAmount
				  GV_SpaceshipNeedsRefueling.SetValue(0)
			EndIf

			   If TotalChargeInGravDrive < GravDriveChargeAmount
				  GV_SpaceshipNeedsRecharging.SetValue(1)
		   ElseIf TotalChargeInGravDrive == GravDriveChargeAmount
				  GV_SpaceshipNeedsRecharging.SetValue(0)
			EndIf

			   If akShip.GetValue(SpaceshipTotalMaintenanceAmount) > 60 
			      GV_SpaceshipAutoRepair.SetValue(1)
             Else
			      GV_SpaceshipAutoRepair.SetValue(0)
            EndIf

			   If TotalMaintenance < TotalMaintenanceBase || HealthAmount < HealthAmountBase 
			      GV_SpaceshipSystemDamaged.SetValue(1)
            Else
			      GV_SpaceshipSystemDamaged.SetValue(0)
			EndIf
            
			CalculateFuelCost()
			CalculateRepairCost()

EndFunction

Float Function DiscountCost()
     
	 Float DiscountPercent00 = 1.00
     Float DiscountPercent01 = 1.15 	 
     Float DiscountPercent02 = 1.25 
     Float DiscountPercent03 = 1.35 
     Float DiscountPercent04 = 1.50 	 
		
		If PlayerRef.Hasperk(SpaceshipFuelDiscountPerk04)     
		   Return DiscountPercent04 
	ElseIf PlayerRef.Hasperk(SpaceshipFuelDiscountPerk03)  
	       Return DiscountPercent03
	ElseIf PlayerRef.Hasperk(SpaceshipFuelDiscountPerk02) 	 
           Return DiscountPercent02
	ElseIf PlayerRef.Hasperk(SpaceshipFuelDiscountPerk01)
           Return DiscountPercent01 
Else	
           Return DiscountPercent00
     EndIf

EndFunction

Function CalculateFuelCost()

     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
     
	 Float DiscountCalculate = DiscountCost() 	      
	 Float fuelCostPerUnit = SpaceshipFuel.GetGoldValue() * GV_SpaceshipFuelPriceMult.GetValue() / DiscountCalculate
     Float ChargeCostPerUnit = SpaceshipGravBattery.GetGoldValue() * GV_SpaceshipChargePriceMult.GetValue() / DiscountCalculate
	 Float FuelAmount = 0.0
     Float ChargeAmount = 0.0
     Float FuelAndChargeCost = 0.0

     If akShip

       FuelAmount = akShip.GetBaseValue(SpaceshipFuelTank) - akShip.GetValue(SpaceshipTotalFuelAmount)
       ChargeAmount = akShip.GetBaseValue(SpaceshipGravDriveHealth) - akShip.GetValue(SpaceshipTotalChargeAmount)

       fuelAndChargeCost = Math.Round(FuelAmount * fuelCostPerUnit + ChargeAmount * ChargeCostPerUnit) as Float

  EndIf

  GV_ShipServiceFuelCost.SetValue(fuelAndChargeCost)
  
  (DialogueShipServices as DialogueShipServicesScript).ResetTechDialogues()

EndFunction

Function RefuelAtShipService()

                                     SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
									 								  
                                     GV_SpaceshipNeedsRefueling.SetValue(0)
                                     GV_SpaceshipNeedsRecharging.SetValue(0)
									 
                                     FuelFillSpecialFXOutside()									 
									 akShip.Restorevalue(SpaceshipTotalFuelAmount, 999999.0)
									                                      
									 ChargeFillSpecialFXOutside()                                     			                     
									 akShip.Restorevalue(SpaceshipTotalChargeAmount, 999999.0)						                  										   
										   
										   If GV_DebugNotification.GetValue() == 1
										      Debug.Notification("SHIP HAS BEEN REFUELED AND RECHARGED")
								        EndIf

EndFunction

Function FuelConsumptionStartOnUndock()

        Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue() 

        If GV_SpaceshipSystemsToggle.GetValue() == 1              
			  StartTimer(ConsumeFuelCycle, 1)
	 EndIf					 														

EndFunction

Function FuelConsumptionStopOnPumpOut()

                SpaceshipIsReadyToFly = False
			    TravelDisabled = True

				CancelTimer(1)

                If SpaceshipPowerValueStored == False
				   StoreValuesSpaceshipPower()
			 EndIf

				AllPowerOff()
				BlockTravel()

                If EnginePowerRestricted == False
                   EnginePowerRestricted = True
             EndIf							 
														
EndFunction

Function GravJumpStopOnChargeOut()

				DisableGravJump()
						 
EndFunction

Function SpaceshipDamage()

                       SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                       Float DamageEngine = akShip.GetValue(SpaceshipSystemEngineHealth) / 40 * ShipGravDrivePowerStore
                       Float DamageGravJump = akShip.GetValue(SpaceshipSystemGravdriveHealth) / 20 * ShipGravDrivePowerStore
                       
                       akShip.DamageValue(SpaceshipSystemEngineHealth, DamageEngine)
                       akShip.DamageValue(SpaceshipSystemGravdriveHealth, DamageGravJump)
                       
					   EngineDamageThreshold()
					   GravDriveDMGToGravDriveHealth()
EndFunction

Function GravDriveDMGToGravDriveHealth()

                       SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

		               Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) As Int
				       Int TotalChargeInGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int  
					   Int DecreaseTotalCharge = 0 
						  
						  If TotalChargeInGravDrive > GravDriveChargeAmount
						     DecreaseTotalCharge = Math.Round(akShip.GetValue(SpaceshipTotalChargeAmount) - akShip.GetValue(SpaceshipGravDriveHealth))
							 akShip.DamageValue(SpaceshipTotalChargeAmount, DecreaseTotalCharge)                          
					   EndIf
				       
					   FuelThresholds()

EndFunction

Function EngineDamageThreshold()

                       SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                       Float Engine = - akShip.GetValue(SpaceshipSystemEngineHealth)
                       Float GravDrive = - akShip.GetValue(SpaceshipSystemGravdriveHealth)

					   If akShip.GetValue(SpaceshipSystemEngineHealth) < 0
					      akShip.RestoreValue(SpaceshipSystemEngineHealth, Engine)          
					EndIf

					   If akShip.GetValue(SpaceshipSystemGravdriveHealth) < 0
					      akShip.RestoreValue(SpaceshipSystemGravdriveHealth, GravDrive)					
					EndIf

EndFunction

Function DebtChecker()

                        If PlayerRef.GetItemCount(Credits) >= RescueDebt
                           PlayerRef.RemoveItem(Credits, RescueDebt, False, None)
						   RescueDebt = 0
						   MSG_StarviewEmergencyResponderDeptCover.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)			 
					       CancelTimer(5)
					Else
                           StartTimer(60, 5)
                     EndIf

EndFunction

Function Teleporter()

     SpaceShipReference akShip = PlayerShip.getShipRef()
     CurrentLoc = PlayerRef.GetCurrentlocation()
		
		If CurrentLoc == playerShipInteriorLocation.GetLocation() == False
           PlayerRef.SetGhost(True)
		   PlayerRef.SetPlayerControls(False)
		   Utility.Wait(1.0)
		   PlayerRef.PlaceAtMe(TeleportExplosion, 1, False, False, True, None, None, True)
		   TeleportFX02.Play(PlayerRef, 1.0)
		   TeleportFX.Play(PlayerRef, 1.0)		   
		   Utility.Wait(1.5)
		   PlayerRef.moveto(akShip, 0.0, 0.0, 0.0, false, false)
              
			  If PlayerRef.WaitFor3DLoad()
		         TeleportFX02.Play(PlayerRef, 1.0)
		         TeleportFX.Play(PlayerRef, 1.0)
			     Utility.Wait(5.5)		   
		         PlayerRef.PlaceAtMe(TeleportExplosion, 1, False, False, True, None, None, True) 
		         PlayerRef.SetPlayerControls(True)
		         Utility.Wait(0.5)
		         PlayerRef.SetGhost(False)
	       EndIf
	Else
	       MSG_SpaceshipTeleporter.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
		   PlayerRef.Additem(SpaceshipTeleporter, 1, True)
	 EndIf

EndFunction

Function TeleporterDebug()
           
		   SpaceShipReference akShip = PlayerShip.getShipRef()		
           
		   PlayerRef.SetGhost(True)
		   PlayerRef.SetPlayerControls(False)
		   Utility.Wait(1.0)
		   PlayerRef.PlaceAtMe(TeleportExplosion, 1, False, False, True, None, None, True)
		   TeleportFX02.Play(PlayerRef, 1.0)
		   TeleportFX.Play(PlayerRef, 1.0)		   
		   Utility.Wait(1.5)
		   PlayerRef.moveto(akShip, 0.0, 0.0, 0.0, false, false)
              
			  If PlayerRef.WaitFor3DLoad()
		         TeleportFX02.Play(PlayerRef, 1.0)
		         TeleportFX.Play(PlayerRef, 1.0)
			     Utility.Wait(5.5)		   
		         PlayerRef.PlaceAtMe(TeleportExplosion, 1, False, False, True, None, None, True) 
		         PlayerRef.SetPlayerControls(True)
		         Utility.Wait(0.5)
		         PlayerRef.SetGhost(False)
	       EndIf

EndFunction
  
Function OnBoost()

            SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

            Float ConsumeFuelDMGOnBoostAdvanced = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * akShip.GetValue(SpaceshipBoostSpeed) * GV_FuelConsumeDMGOnPower.GetValue()
            Float ConsumeFuelDMGOnBoostAdvancedAstro01 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * akShip.GetValue(SpaceshipBoostSpeed) * GV_FuelConsumeDMGOnPower.GetValue() / 1.15
			Float ConsumeFuelDMGOnBoostAdvancedAstro02 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * akShip.GetValue(SpaceshipBoostSpeed) * GV_FuelConsumeDMGOnPower.GetValue() / 1.20
			Float ConsumeFuelDMGOnBoostAdvancedAstro03 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * akShip.GetValue(SpaceshipBoostSpeed) * GV_FuelConsumeDMGOnPower.GetValue() / 1.25
			Float ConsumeFuelDMGOnBoostAdvancedAstro04 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * akShip.GetValue(SpaceshipBoostSpeed) * GV_FuelConsumeDMGOnPower.GetValue() / 1.35
            
			Float ConsumeFuelDMGOnBoostBasic = GV_SpaceshipFuelCalculationBasicOnBoost.GetValue()
			Float ConsumeFuelDMGOnBoostBasicAstro01 = GV_SpaceshipFuelCalculationBasicOnBoost.GetValue() / 1.15
			Float ConsumeFuelDMGOnBoostBasicAstro02 = GV_SpaceshipFuelCalculationBasicOnBoost.GetValue() / 1.20
			Float ConsumeFuelDMGOnBoostBasicAstro03 = GV_SpaceshipFuelCalculationBasicOnBoost.GetValue() / 1.25
			Float ConsumeFuelDMGOnBoostBasicAstro04 = GV_SpaceshipFuelCalculationBasicOnBoost.GetValue() / 1.35
            
			Float ConsumeFuelDMGOnBoostStory = GV_SpaceshipFuelCalculationStoryOnBoost.GetValue()
			Float ConsumeFuelDMGOnBoostStoryAstro01 = GV_SpaceshipFuelCalculationStoryOnBoost.GetValue() / 1.15
			Float ConsumeFuelDMGOnBoostStoryAstro02 = GV_SpaceshipFuelCalculationStoryOnBoost.GetValue() / 1.20
			Float ConsumeFuelDMGOnBoostStoryAstro03 = GV_SpaceshipFuelCalculationStoryOnBoost.GetValue() / 1.25
			Float ConsumeFuelDMGOnBoostStoryAstro04 = GV_SpaceshipFuelCalculationStoryOnBoost.GetValue() / 1.35
			
			Float ConsumeFuelDMGOnBoostManual = GV_SpaceshipFuelCalculationManualOnBoost.GetValue()
			Float ConsumeFuelDMGOnBoostManualAstro01 = GV_SpaceshipFuelCalculationManualOnBoost.GetValue() / 1.15
			Float ConsumeFuelDMGOnBoostManualAstro02 = GV_SpaceshipFuelCalculationManualOnBoost.GetValue() / 1.20
			Float ConsumeFuelDMGOnBoostManualAstro03 = GV_SpaceshipFuelCalculationManualOnBoost.GetValue() / 1.25
			Float ConsumeFuelDMGOnBoostManualAstro04 = GV_SpaceshipFuelCalculationManualOnBoost.GetValue() / 1.35

			Int i = -1
            Actor CrewMember = CurrentCrew.GetAt(i) as Actor 

      If GV_SpaceshipSystemsToggle.GetValue() == 1
			If akShip.GetValue(SpaceshipBoostActive) > 0
               				          
						           If GV_SpaceshipFuelCalculationMode.GetValue() == 0
								      									    
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostAdvancedAstro04)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostAdvancedAstro03)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostAdvancedAstro02)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostAdvancedAstro01)
                                          Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostAdvanced)
											EndIf
					   							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 1
										       
											   If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostBasicAstro04)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostBasicAstro03)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostBasicAstro02)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostBasicAstro01)
                                          Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostBasic)
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 2
											   
											   If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostStoryAstro04)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostStoryAstro03)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostStoryAstro02)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostStoryAstro01)
                                          Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostStory)
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 3
											   
											   If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostManualAstro04)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostManualAstro03)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostManualAstro02)
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostManualAstro01)
                                          Else
												  akShip.Damagevalue(SpaceshipTotalFuelAmount, ConsumeFuelDMGOnBoostManual)
											EndIf
								
								EndIf
					      
						  If GV_SpaceshipNeedsMaintenanceToggle.GetValue() == 1
					         MaintenanceSystem()
					   EndIf
					   
						  If GV_SpaceshipNeedsRefueling.Getvalue() == 0
							 GV_SpaceshipNeedsRefueling.SetValue(1)
					   EndIf	

                          If akShip.GetValue(SpaceshipTotalFuelAmount) <= 0
                             SpaceshipIsReadyToFly = False
				             TravelDisabled = True

									If SpaceshipPowerValueStored == False
									   StoreValuesSpaceshipPower()
								 EndIf
								 
								 AllPowerOff()
								 BlockTravel()
								 CancelTimer(1)
                                 CheckSystems()
                                   
								   If EnginePowerRestricted == False
                                      EnginePowerRestricted = True
                                EndIf							 
								MSG_SpaceshipOutOfFuel.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                       EndIf
	 	 			   
					   FuelThresholds()

						  If GV_DebugNotification.GetValue() == 1
					         Debug.Notification("HOMESHIP BOOST STARTED")
                       EndIf

		 EndIf
   
   EndIf

EndFunction	

Function EngineUp()
 
    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
    Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue()
    Int Engine = akShip.GetPartPower(1, 0)

					   If EnginePowerRestricted == True
                          akShip.SetPartPower(1, 0, 0)
                    EndIf

                       If SpaceshipIsReadyToFly == True && TravelDisabled == False
					       If akShip.IsDocked() == False && akShip.IsInSpace() == True

							     If Engine > 0
                                       If SpaceshipEngineIgnited == False
									      StartTimer(ConsumeFuelCycle, 1)                           
										  SpaceshipEngineIgnited = True
                                    EndIf
							  EndIf
                              ClutchUp()
						EndIf
					EndIf
                    
EndFunction

Function EngineDown()
 
    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
    Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue()
    Int Engine = akShip.GetPartPower(1, 0)

                       If SpaceshipIsReadyToFly == True && TravelDisabled == False
					       If akShip.IsDocked() == False && akShip.IsInSpace() == True

					   	         If Engine <= 0
                                    CancelTimer(1)                            
									SpaceshipEngineIgnited = False
							  EndIf
                              ClutchDown()
						EndIf
					EndIf
EndFunction

Function ClutchPowerSet()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int Engine = akShip.GetPartPower(1, 0)

	GV_FuelConsumeDMGOnPower.SetValue(Engine)

EndFunction

Function ClutchUp()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int Engine = akShip.GetPartPower(1, 0)

                 If SpaceshipIsReadyToFly == True && TravelDisabled == False
					  If akShip.IsDocked() == False && akShip.IsInSpace() == True

					   	   If Engine > 0                           
                              ClutchPowerSet()
					   ElseIf Engine <= 0 					 
					          ClutchPowerSet()
						EndIf

				   EndIf
			   EndIf
EndFunction

Function ClutchDown()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int Engine = akShip.GetPartPower(1, 0)

                 If SpaceshipIsReadyToFly == True && TravelDisabled == False
					  If akShip.IsDocked() == False && akShip.IsInSpace() == True

					   	   If Engine > 0                           
                              ClutchPowerSet()
					   ElseIf Engine <= 0 					 
					          ClutchPowerSet()
						EndIf
		          EndIf
              EndIf
EndFunction

Function GriveDrivePowerSet()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int GravDrive = akShip.GetPartPower(3, 0)

	ShipGravDrivePowerStore = GravDrive
    GravDriveCalculatePreparation()

EndFunction

Function GravDriveStagesUp()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int GravDrive = akShip.GetPartPower(3, 0)

                 If SpaceshipIsReadyToFly == True && TravelDisabled == False
					  If akShip.IsDocked() == False && akShip.IsInSpace() == True                        
							    If GravDrive > 0                                                           
                                   GriveDrivePowerSet()
							ElseIf GravDrive <= 0    
								   SpaceshipGravDriveStartFX.Stop(akShip)
								   akShip.setvalue(SpaceshipGravDriveInitiated, -1)
					         	   wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
                                   GravDrivePrepareSoundInstance = -1
							       GravJumpInitiated = False
							       CancelTimer(10)
							 	   CancelTimer(15)	
							 EndIf
				   EndIf
		      EndIf
EndFunction

Function GravDriveStagesDown()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Int GravDrive = akShip.GetPartPower(3, 0)

                 If SpaceshipIsReadyToFly == True && TravelDisabled == False
					  If akShip.IsDocked() == False && akShip.IsInSpace() == True                                               
							    If GravDrive > 0                                                           
                                   GriveDrivePowerSet()
							ElseIf GravDrive <= 0    
								   SpaceshipGravDriveStartFX.Stop(akShip)
								   akShip.setvalue(SpaceshipGravDriveInitiated, -1)
					               wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
                                   GravDrivePrepareSoundInstance = -1
							       GravJumpInitiated = False
							       CancelTimer(10)
							       CancelTimer(15)							       
							 EndIf
                   EndIf
		      EndIf
EndFunction
						  
Function AllPowerOff()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
    Int Engine = akShip.GetPartPower(1, 0)

     If SpaceshipPower == False
		SpaceshipPower = True
		Utility.Wait(0.1)
		akShip.SetPartPower(1, 0, 0)

	    GV_FuelConsumeDMGOnPower.SetValue(Engine)

        EngineSoundFX()

   EndIf

EndFunction

Function AllPowerOn()

        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

     If SpaceshipPower == True
		SpaceshipPower = False
		Utility.Wait(0.1)
		akShip.SetPartPower(1, 0, ShipPowerEngine)
        SpaceshipPowerValueStored = False

	    GV_FuelConsumeDMGOnPower.SetValue(ShipPowerEngine)

        EngineSoundFX()

   EndIf

EndFunction

Function EngineSoundFX()

        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

        EngineOnSoundInstance = SoundEventEngineOn.Play(akShip, None, None)
        Utility.Wait(2.0)
		wwiseevent.StopInstance(EngineOnSoundInstance)
        EngineOnSoundInstance = -1

EndFunction

Function StoreValuesSpaceshipPower()

        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

        Int Engine = akShip.GetPartPower(1, 0)

        ShipPowerEngine = Engine

        SpaceshipPowerValueStored = True

		GV_FuelConsumeDMGOnPower.SetValue(Engine)

EndFunction

Function CheckSystemsAtGetUp()

        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

        If GV_SpaceshipSystemsToggle.GetValue() == 1
           StoreValuesSpaceshipPower()
           BlockTravelWithoutPiloting()
           SpaceshipEngineIgnited = False
           CancelFuelTimerOnLeavingSpaceship()        
	 EndIf

EndFunction

Function BlockTravelWithoutPiloting()

         DisableGroundTravel()
         DisableSpaceTravel()
         DisableTakeoff()

EndFunction

Function BlockTravel()

      If TravelDisabled == True
         DisableGroundTravel()
         DisableSpaceTravel()
         DisableTakeoff()
   EndIf

EndFunction

Function UnblockTravel()

      If TravelDisabled == False
         EnableGroundTravel()
         EnableGravJump()
         EnableSpaceTravel()
         EnableTakeoff()
   EndIf

EndFunction

Function EnableGravJump()
	GravJump.EnableGravJump(True) 
	GravJump.Reset()
	GravJump.Delete()
	GravJump = inputEnableLayer.Create()
	GravJump.EnableGravJump(True)
Endfunction

Function DisableGravJump()
	GravJump = inputEnableLayer.Create()
	GravJump.Reset()
	GravJump.Delete() 
	GravJump = inputEnableLayer.Create()
	GravJump.EnableGravJump(False)
endfunction

Function EnableSpaceTravel()
	SpaceTravel.EnableFarTravel(True)
	SpaceTravel.reset()
	SpaceTravel.Delete()
	SpaceTravel = inputEnableLayer.Create()
	SpaceTravel.EnableFarTravel(True)
endfunction

Function DisableSpaceTravel()
	SpaceTravel.EnableFarTravel(False)
	SpaceTravel.reset()
	SpaceTravel.Delete()
	SpaceTravel = inputEnableLayer.Create()
	SpaceTravel.EnableFarTravel(False)
Endfunction

Function EnableTakeoff()
	TakeOff.EnableTakeoff(True)
	TakeOff.Reset()
	TakeOff.delete()
	TakeOff = inputEnableLayer.Create()
	TakeOff.EnableTakeoff(True)
Endfunction

Function DisableTakeOff()
	TakeOff.EnableTakeoff(False)
	TakeOff.Reset()
	TakeOff.delete()
	TakeOff = inputEnableLayer.Create()
	TakeOff.EnableTakeoff(False)
Endfunction

Function EnableGroundTravel()
	GroundAndLocalTravel.EnableFastTravel(True)
	GroundAndLocalTravel.reset()
	GroundAndLocalTravel.delete()
	GroundAndLocalTravel = inputEnableLayer.Create()
	GroundAndLocalTravel.EnableFastTravel(True)
Endfunction

Function DisableGroundTravel()
	GroundAndLocalTravel.EnableFastTravel(False)
	GroundAndLocalTravel.reset()
	GroundAndLocalTravel.delete()
	GroundAndLocalTravel= inputEnableLayer.Create()
	GroundAndLocalTravel.EnableFastTravel(False)
Endfunction

Function LeveledCargos()

	If SpaceshipContainerType01																
		AddItems(SpaceshipContainerType01, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType02																
		AddItems(SpaceshipContainerType02, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType03																
		AddItems(SpaceshipContainerType03, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType04																
		AddItems(SpaceshipContainerType04, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType05																
		AddItems(SpaceshipContainerType05, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType06																
		AddItems(SpaceshipContainerType06, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType07																
		AddItems(SpaceshipContainerType07, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType08																
		AddItems(SpaceshipContainerType08, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType09																
		AddItems(SpaceshipContainerType09, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType10																
		AddItems(SpaceshipContainerType10, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType11																
		AddItems(SpaceshipContainerType11, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType12																
		AddItems(SpaceshipContainerType12, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType13																
		AddItems(SpaceshipContainerType13, PlayerLevel_InjectList)		
	EndIf	
EndFunction	

Function AddSpaceshipAmmo()

	If SpaceshipContainerType01																
		AddSpaceshipArsenal(SpaceshipContainerType01, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType02																
		AddSpaceshipArsenal(SpaceshipContainerType02, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType03																
		AddSpaceshipArsenal(SpaceshipContainerType03, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType04																
		AddSpaceshipArsenal(SpaceshipContainerType04, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType05																
		AddSpaceshipArsenal(SpaceshipContainerType05, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType06																
		AddSpaceshipArsenal(SpaceshipContainerType06, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType07																
		AddSpaceshipArsenal(SpaceshipContainerType07, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType08																
		AddSpaceshipArsenal(SpaceshipContainerType08, PlayerLevel_InjectList)		
	EndIf
	If SpaceshipContainerType09																
		AddSpaceshipArsenal(SpaceshipContainerType09, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType10																
		AddSpaceshipArsenal(SpaceshipContainerType10, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType11																
		AddSpaceshipArsenal(SpaceshipContainerType11, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType12																
		AddSpaceshipArsenal(SpaceshipContainerType12, PlayerLevel_InjectList)		
	EndIf	
	If SpaceshipContainerType13																
		AddSpaceshipArsenal(SpaceshipContainerType13, PlayerLevel_InjectList)		
	EndIf	

EndFunction

Function AddItems(LeveledItem lst, int custlvl)

    int RandomizeFuel = Utility.RandomInt(20, 100)
    int RandomizeBattery = Utility.RandomInt(10, 50)
	int lvl = PlayerLevel
	If custlvl != 0														
		lvl = custlvl														
	EndIf

	If SpaceshipContainerInjectFuel																
		lst.AddForm(SpaceshipContainerInjectFuel as Form, lvl, RandomizeFuel)								
        Utility.Wait(0.3)
		lst.AddForm(SpaceshipContainerInjectBattery as Form, lvl, RandomizeBattery)	
        Utility.Wait(0.3)
		lst.AddForm(SpaceshipContainerInjectMaintenanceKit as Form, lvl, 1)	
        Utility.Wait(0.3)
		lst.AddForm(SpaceshipContainerInjectEmergencyBot as Form, lvl, 1)	
 EndIf

EndFunction

Function AddSpaceshipArsenal(LeveledItem lst, int custlvl)

	int lvl = PlayerLevel
	If custlvl != 0														
		lvl = custlvl														
	EndIf

	If SpaceshipNPCRandomAmmo																
		lst.AddForm(SpaceshipNPCRandomAmmo as Form, lvl, 1)								
 EndIf

EndFunction

Function CalculateRandomValuesForSpaceships()
                                        
										SpaceShipReference homeShipRef = HomeShip.GetShipRef()
                                        SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()
                                        
	                                    Int RandomMult = Utility.RandomInt(2, 10)
                                        Int RandomFuelAmount = Utility.RandomInt(0, 50)
                                        Int RandomChargeAmount = Utility.RandomInt(0, 25)	                                    
										Int RandomChanceRepairDrones = Utility.RandomInt(0, 100)
										Int RandomChanceMaintenanceKits = Utility.RandomInt(0, 100)
										Int RandomAmountRepairDrones = Utility.RandomInt(1, 3)
										Int RandomAmountMaintenanceKits = Utility.RandomInt(1, 3)										
										
										Float FuelAmount = 0.0
	                                    Float ChargeAmount = 0.0
	                                    Float MaintenanceAmount = 0.0
                                
								If PlayerShips.Find(akShip) > -1   
									
									If GV_DebugNotification.GetValue() == 1	
			                           Debug.Notification("STORED SHIP EXCLUDED FROM CALCULATION") 
                                 EndIf
							
							Else
                               			   If akShip != homeShipRef

											   If akShip.GetItemCount(BlockCalculation) <= 0
				                                  akShip.Additem(BlockCalculation, 1, True)
	            		                          akShip.Additem(SpaceshipFuel, RandomFuelAmount, True)
				                                  akShip.Additem(SpaceshipGravBattery, RandomChargeAmount, True)
												  
												  FuelAmount = akShip.GetValue(SpaceshipFuelTank) / RandomMult * 2
				                                  akShip.DamageValue(SpaceshipTotalFuelAmount, FuelAmount)
	            
				                                  ChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) / RandomMult * 2
				                                  akShip.DamageValue(SpaceshipTotalChargeAmount, ChargeAmount)
	            
				                                  MaintenanceAmount = akShip.GetValue(SpaceshipTotalMaintenanceAmount) / RandomMult * 2
				                                  akShip.DamageValue(SpaceshipTotalMaintenanceAmount, MaintenanceAmount)	
				                                      
													  If RandomChanceRepairDrones <= 10
                                                         akShip.Additem(SpaceshipEmergencyRepairBotsMisc, RandomAmountRepairDrones, True)
												   EndIf
													  
													  If RandomChanceMaintenanceKits <= 10
				                                         akShip.Additem(SpaceshipMaintenanceKitMisc, RandomAmountMaintenanceKits, True)
												   EndIf
													  
													  If GV_DebugNotification.GetValue() == 1
				                                         Debug.Notification("NON STORED SHIP HAS BEEN CALCULATED") 
		                                           EndIf
		  
		                                    EndIf
                                        EndIf      
                              EndIf
EndFunction

Function SongbirdAudioplayer(Int Message = 0, Int Button = 0, Bool MenuOpened = True)

  While MenuOpened
  SoundEventClick.Play(PlayerRef, None, None)

	 If Button == -1

 ElseIf Message == 0

		button = MSG_StarviewRadioSongbird.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
                                           
										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioClassicBaroque
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									ElseIf (button == 1)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioClassicNeoRomantic
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

	                                ElseIf (button == 2)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioCountryBlues
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									
									ElseIf (button == 3)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioCrimsonMetal
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									ElseIf (button == 4)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioDarkSynth
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 5)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioElectronica
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

	                                ElseIf (button == 6)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioJazz
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
																		
									ElseIf (button == 7)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioPop
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									ElseIf (button == 8)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioTechnoAstralLounge
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 9)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioTechnoClean
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 10)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioTechnoParty
                                           RadioSoundInstance = Radio.Play(PlayerRef, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 11)
										   
										   MusicSilence.Remove()
									       wwiseevent.StopInstance(RadioSoundInstance)
										   GV_SpaceshipSystemsRadioToggle.SetValue(0)                                      
									
									ElseIf (button == 12)

                                           ; Exit
                                           MenuOpened = False
									 
									 EndIf

  EndIf

EndWhile
EndFunction

SpaceShipReference Function SetProperShipReferenceForDataView()
	  
	  SpaceShipReference akShipInterior = PlayerRef.GetCurrentShipRef()      
      SpaceShipReference akShipOutside = SQ_PlayerShip.PlayerShip.GetShipRef()	  
	  
	  CurrentLoc = PlayerRef.GetCurrentlocation()
	  
	  If PlayerRef.IsInInterior() == True
	      If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True      
		     Return akShipInterior
	  ElseIf CurrentLoc == playerShipInteriorLocation02.GetLocation() == False || CurrentLoc == playerShipInteriorLocation.GetLocation() == False
		     Return akShipInterior      
	   EndIf
  
  ElseIf PlayerRef.IsInInterior() == False
		 Return akShipOutside
   EndIf

Endfunction

Float Function FuelConsumptionDataView()

               SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()            
               
			   CurrentLoc = PlayerRef.GetCurrentlocation()
               
			   Float ConsumeFuelDMGOnMoveAdvanced = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue()
               Float ConsumeFuelDMGOnMoveAdvancedAstro01 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.15
               Float ConsumeFuelDMGOnMoveAdvancedAstro02 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.20
			   Float ConsumeFuelDMGOnMoveAdvancedAstro03 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveAdvancedAstro04 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipEngineThrust) * GV_FuelConsumeDMGOnPower.GetValue() / 1.35
			   
			   Float ConsumeFuelDMGOnMoveBasic = GV_SpaceshipFuelCalculationBasic.GetValue()
			   Float ConsumeFuelDMGOnMoveBasicAstro01 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.15
			   Float ConsumeFuelDMGOnMoveBasicAstro02 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.20
			   Float ConsumeFuelDMGOnMoveBasicAstro03 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveBasicAstro04 = GV_SpaceshipFuelCalculationBasic.GetValue() / 1.35
               
			   Float ConsumeFuelDMGOnMoveStory = GV_SpaceshipFuelCalculationStory.GetValue()
               Float ConsumeFuelDMGOnMoveStoryAstro01 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.15
               Float ConsumeFuelDMGOnMoveStoryAstro02 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.20
			   Float ConsumeFuelDMGOnMoveStoryAstro03 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveStoryAstro04 = GV_SpaceshipFuelCalculationStory.GetValue() / 1.35
               
			   Float ConsumeFuelDMGOnMoveManual = GV_SpaceshipFuelCalculationManual.GetValue()
               Float ConsumeFuelDMGOnMoveManualAstro01 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.15			   
               Float ConsumeFuelDMGOnMoveManualAstro02 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.20
               Float ConsumeFuelDMGOnMoveManualAstro03 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.25
			   Float ConsumeFuelDMGOnMoveManualAstro04 = GV_SpaceshipFuelCalculationManual.GetValue() / 1.35
			   
			   Int i = -1
               
			   Actor CrewMember = CurrentCrew.GetAt(i) as Actor 
	
						           If GV_SpaceshipFuelCalculationMode.GetValue() == 0
								      									    
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return ConsumeFuelDMGOnMoveAdvancedAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return ConsumeFuelDMGOnMoveAdvancedAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return ConsumeFuelDMGOnMoveAdvancedAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return ConsumeFuelDMGOnMoveAdvancedAstro01
                                          Else
												  Return ConsumeFuelDMGOnMoveAdvanced
											EndIf
					   							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 1
										       
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return ConsumeFuelDMGOnMoveBasicAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return ConsumeFuelDMGOnMoveBasicAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return ConsumeFuelDMGOnMoveBasicAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return ConsumeFuelDMGOnMoveBasicAstro01
                                          Else
												  Return ConsumeFuelDMGOnMoveBasic
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 2
											   
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return ConsumeFuelDMGOnMoveStoryAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return ConsumeFuelDMGOnMoveStoryAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return ConsumeFuelDMGOnMoveStoryAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return ConsumeFuelDMGOnMoveStoryAstro01
                                          Else
												  Return ConsumeFuelDMGOnMoveStory
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 3
											   
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return ConsumeFuelDMGOnMoveManualAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return ConsumeFuelDMGOnMoveManualAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return ConsumeFuelDMGOnMoveManualAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return ConsumeFuelDMGOnMoveManualAstro01
                                          Else
												  Return ConsumeFuelDMGOnMoveManual
											EndIf
								
								EndIf

Endfunction

Float Function ChargeConsumptionDataView()

               SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()            
               
			   CurrentLoc = PlayerRef.GetCurrentlocation()
               
										Float GravJumpChargeCostAdvanced = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4
										Float GravJumpChargeCostAdvancedAstro01 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.15 
										Float GravJumpChargeCostAdvancedAstro02 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.20 
										Float GravJumpChargeCostAdvancedAstro03 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.25 
										Float GravJumpChargeCostAdvancedAstro04 = akShip.GetValue(SpaceshipMass) / akShip.GetValue(SpaceshipGravThrust) * ShipGravDrivePowerStore / 4 / 1.35                                        
										
										Float GravJumpChargeCostBasic = GV_SpaceshipChargeCalculationBasic.GetValue()
                                        Float GravJumpChargeCostBasicAstro01 = GV_SpaceshipChargeCalculationBasic.GetValue() / 1.15                                         
                                        Float GravJumpChargeCostBasicAstro02 = GV_SpaceshipChargeCalculationBasic.GetValue() / 1.20 
										Float GravJumpChargeCostBasicAstro03 = GV_SpaceshipChargeCalculationBasic.GetValue() / 1.25 
										Float GravJumpChargeCostBasicAstro04 = GV_SpaceshipChargeCalculationBasic.GetValue() / 1.35 
										
										Float GravJumpChargeCostStory = GV_SpaceshipChargeCalculationStory.GetValue()                                        
										Float GravJumpChargeCostStoryAstro01 = GV_SpaceshipChargeCalculationStory.GetValue() / 1.15                                        
                                        Float GravJumpChargeCostStoryAstro02 = GV_SpaceshipChargeCalculationStory.GetValue() / 1.20 
										Float GravJumpChargeCostStoryAstro03 = GV_SpaceshipChargeCalculationStory.GetValue() / 1.25 
										Float GravJumpChargeCostStoryAstro04 = GV_SpaceshipChargeCalculationStory.GetValue() / 1.35 
										
										Float GravJumpChargeCostManual = GV_SpaceshipChargeCalculationManual.GetValue()
                                        Float GravJumpChargeCostManualAstro01 = GV_SpaceshipChargeCalculationManual.GetValue() / 1.15                                        
                                        Float GravJumpChargeCostManualAstro02 = GV_SpaceshipChargeCalculationManual.GetValue() / 1.20  
										Float GravJumpChargeCostManualAstro03 = GV_SpaceshipChargeCalculationManual.GetValue() / 1.25  
										Float GravJumpChargeCostManualAstro04 = GV_SpaceshipChargeCalculationManual.GetValue() / 1.35  
										
			                            Int i = -1
                                        Actor CrewMember = CurrentCrew.GetAt(i) as Actor
	
						           If GV_SpaceshipFuelCalculationMode.GetValue() == 0
								      									    
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return GravJumpChargeCostAdvancedAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return GravJumpChargeCostAdvancedAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return GravJumpChargeCostAdvancedAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return GravJumpChargeCostAdvancedAstro01
                                          Else
                                                  Return GravJumpChargeCostAdvanced
											EndIf
					   							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 1
										       
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return GravJumpChargeCostBasicAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return GravJumpChargeCostBasicAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return GravJumpChargeCostBasicAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return GravJumpChargeCostBasicAstro01
                                          Else
                                                  Return GravJumpChargeCostBasic
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 2
											   
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return GravJumpChargeCostStoryAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return GravJumpChargeCostStoryAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return GravJumpChargeCostStoryAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return GravJumpChargeCostStoryAstro01
                                          Else
                                                  Return GravJumpChargeCostStory
											EndIf
							   
							   ElseIf GV_SpaceshipFuelCalculationMode.GetValue() == 3
											   
										       If CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics04)
                                                  Return GravJumpChargeCostManualAstro04
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics03)
                                                  Return GravJumpChargeCostManualAstro03
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics02)
                                                  Return GravJumpChargeCostManualAstro02
										   ElseIf CrewMember && CrewMember.HasSpell(SpaceshipCrewAstroDynamics01)
                                                  Return GravJumpChargeCostManualAstro01
                                          Else
                                                  Return GravJumpChargeCostManual
											EndIf
								
								EndIf

Endfunction

Function Starview(Int Message = 0, Int Button = 0, Bool MenuOpened = True)

  While MenuOpened
  SoundEventClick.Play(PlayerRef, None, None)

	 If Button == -1

 ElseIf Message == 0

                                        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                                        SpaceShipReference ShipValuesCheck = SetProperShipReferenceForDataView()                                        
																				
										CurrentLoc = PlayerRef.GetCurrentlocation()
										
										Int RepairDronesAmount = ShipValuesCheck.GetItemCount(SpaceshipEmergencyRepairBotsMisc)
                                        Int MaintenanceKitsAmount = ShipValuesCheck.GetItemCount(SpaceshipMaintenanceKitMisc)
										Int AvailableFuelInTheCargo = ShipValuesCheck.GetItemCount(SpaceshipFuel)
                                        Int AvailableBatteriesInTheCargo = ShipValuesCheck.GetItemCount(SpaceshipGravBattery)
		                                Int GravDriveChargeAmount = ShipValuesCheck.GetValue(SpaceshipGravDriveHealth) as Int
										Int TotalChargeInTheGravDrive = ShipValuesCheck.GetValue(SpaceshipTotalChargeAmount) as Int                                       
										
										Float FuelTankAmount = ShipValuesCheck.GetValue(SpaceshipFuelTank)                               
										Float TotalFuelInTheTank = ShipValuesCheck.GetValue(SpaceshipTotalFuelAmount)
										
										Float MaintenanceValues = ShipValuesCheck.GetValue(SpaceshipTotalMaintenanceAmount)
                                        Float MaintenanceValuesMax = ShipValuesCheck.GetBaseValue(SpaceshipTotalMaintenanceAmount)		
		
		button = MSG_StarviewMain.show(TotalFuelInTheTank, FuelTankAmount, TotalChargeInTheGravDrive, GravDriveChargeAmount, MaintenanceValues, MaintenanceValuesMax, RepairDronesAmount, MaintenanceKitsAmount, afArg9 = 0.0)

	                                    If (button == 0)

	                                             If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True      
		                                            Message = 1
	                                         ElseIf CurrentLoc == playerShipInteriorLocation02.GetLocation() == False || CurrentLoc == playerShipInteriorLocation.GetLocation() == False
		                                              If PlayerRef.GetFurnitureUsing() == PlayerShipPilotSeat.GetRef()
													     Message = 1    
	                                              Else
											             MSG_SpaceshipSystemsPilotSeat.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
											       EndIf
											  EndIf								

									ElseIf (button == 1)

		                                    Message = 22

	                                ElseIf (button == 2)
									
	                                             If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True      
		                                            
													Message = 07
											 
											 ElseIf CurrentLoc == playerShipInteriorLocation02.GetLocation() == False || CurrentLoc == playerShipInteriorLocation.GetLocation() == False
		                                              If PlayerRef.GetFurnitureUsing() == PlayerShipPilotSeat.GetRef()
		                                                 Message = 07 
	                                              Else
											             MSG_SpaceshipSystemsPilotSeat.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
											       EndIf
											  EndIf	
									
									ElseIf (button == 3)

	                                             If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True      
		                                               If akShip.GetItemCount(SpaceshipEmergencyRepairBotsMisc) > 0
	                                                      EmergencyRepairBots()
                                                   Else
                                                          MSG_NoRepairBotsAvailable.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                                                    EndIf
											 
											 ElseIf CurrentLoc == playerShipInteriorLocation02.GetLocation() == False || CurrentLoc == playerShipInteriorLocation.GetLocation() == False
		                                              If PlayerRef.GetFurnitureUsing() == PlayerShipPilotSeat.GetRef()
		                                                    If akShip.GetItemCount(SpaceshipEmergencyRepairBotsMisc) > 0
	                                                           EmergencyRepairBots()
                                                        Else
                                                               MSG_NoRepairBotsAvailable.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                                                         EndIf  
	                                              Else
											             MSG_SpaceshipSystemsPilotSeat.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
											       EndIf
											  EndIf	
										                                                                                                          
									ElseIf (button == 4)

	                                             If CurrentLoc == playerShipInteriorLocation02.GetLocation() == True || CurrentLoc == playerShipInteriorLocation.GetLocation() == True      
	                                                   If akShip.GetItemCount(SpaceshipMaintenanceKitMisc) > 0
                                                          MaintenanceRepairKit()
                                                   Else
                                                          MSG_NoMaintenanceKitsAvailable.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                                                    EndIf
											 
											 ElseIf CurrentLoc == playerShipInteriorLocation02.GetLocation() == False || CurrentLoc == playerShipInteriorLocation.GetLocation() == False
		                                              If PlayerRef.GetFurnitureUsing() == PlayerShipPilotSeat.GetRef()
	                                                        If akShip.GetItemCount(SpaceshipMaintenanceKitMisc) > 0
                                                               MaintenanceRepairKit()
                                                        Else
                                                               MSG_NoMaintenanceKitsAvailable.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                                                         EndIf 
	                                              Else
											             MSG_SpaceshipSystemsPilotSeat.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
											       EndIf
											  EndIf	

									ElseIf (button == 5)

	                                             If akShip    
	                                                CalculateRepairCost()
                                                    CalculateFuelCost()
											  EndIf	
																		
									ElseIf (button == 6)

                                           ; Exit
                                           MenuOpened = False
									 
									 EndIf

 ElseIf Message == 07
                                        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
		
		button = MSG_StarviewRadio.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
                                           
										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioClassicBaroque
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									ElseIf (button == 1)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioClassicNeoRomantic
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

	                                ElseIf (button == 2)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioCountryBlues
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
																		
									ElseIf (button == 3)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioCrimsonMetal
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									ElseIf (button == 4)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioDarkSynth
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 5)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioElectronica
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

	                                ElseIf (button == 6)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioJazz
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
																		
									ElseIf (button == 7)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioPop
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)
									
									ElseIf (button == 8)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioTechnoAstralLounge
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 9)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioTechnoClean
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 10)

										   MusicSilence.Remove()
										   wwiseevent.StopInstance(RadioSoundInstance)
                                           Radio = SoundEventRadioTechnoParty
                                           RadioSoundInstance = Radio.Play(akShip, None, None)
									       MusicSilence.Add()
									       GV_SpaceshipSystemsRadioToggle.SetValue(1)

									ElseIf (button == 11)
										   
										   MusicSilence.Remove()
									       wwiseevent.StopInstance(RadioSoundInstance)
										   GV_SpaceshipSystemsRadioToggle.SetValue(0)                                      

									ElseIf (button == 12)
									
									       Message = 0
									
									ElseIf (button == 13)

                                           ; Exit
                                           MenuOpened = False
									 
									 EndIf

 ElseIf Message == 22
                                        
										SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                                        SpaceShipReference ShipValuesCheck = SetProperShipReferenceForDataView()
										
										Float MaintenanceValues = ShipValuesCheck.GetValue(SpaceshipTotalMaintenanceAmount)
                                        Float MaintenanceValuesMax = ShipValuesCheck.GetBaseValue(SpaceshipTotalMaintenanceAmount)

        button = MSG_SpaceshipInformation.show(MaintenanceValues, MaintenanceValuesMax, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

										   Message = 231

									ElseIf (button == 1)

                                           Message = 232

									ElseIf (button == 2)

                                           Message = 233

									ElseIf (button == 3)

                                           Message = 0

									ElseIf (button == 4)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 231
                                        
										SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
                                        SpaceShipReference ShipValuesCheck = SetProperShipReferenceForDataView()										
										
										Int AvailableFuelInTheCargo = ShipValuesCheck.GetItemCount(SpaceshipFuel)
                                        Int AvailableBatteriesInTheCargo = ShipValuesCheck.GetItemCount(SpaceshipGravBattery)                                        
	                                    Int TotalChargeInGravDrive = ShipValuesCheck.GetValue(SpaceshipTotalChargeAmount) as Int
		                                Int GravDriveChargeAmount = ShipValuesCheck.GetValue(SpaceshipGravDriveHealth) as Int

                                        Float FuelConsumption = FuelConsumptionDataView()
										Float ChargeConsumption = ChargeConsumptionDataView()
										
										Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue()					                
										Float TotalFuelInTheTank = ShipValuesCheck.GetValue(SpaceshipTotalFuelAmount)
										Float TotalMaintenance = ShipValuesCheck.GetValue(SpaceshipTotalMaintenanceAmount)
                                        Float FuelTankAmount = ShipValuesCheck.GetValue(SpaceshipFuelTank)

        button = MSG_SpaceshipInformationCapacity.show(AvailableFuelInTheCargo, TotalFuelInTheTank, FuelTankAmount, FuelConsumption, ConsumeFuelCycle, AvailableBatteriesInTheCargo, TotalChargeInGravDrive, GravDriveChargeAmount, ChargeConsumption)

	                                    If (button == 0)

										   Message = 22

									ElseIf (button == 1)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 232

                                        SpaceShipReference ShipValuesCheck = SetProperShipReferenceForDataView()		                                
										
										Int GravDriveChargeAmount = ShipValuesCheck.GetValue(SpaceshipGravDriveHealth) as Int
                                        Float Mass = ShipValuesCheck.GetValue(SpaceshipMass)
                                        Float FuelTankAmount = ShipValuesCheck.GetValue(SpaceshipFuelTank)									
		                                Float EngineThrust = ShipValuesCheck.GetValue(SpaceshipEngineThrust)
		                                Float GravDriveThrust = ShipValuesCheck.GetValue(SpaceshipGravThrust)
		                                Float BoostPower = ShipValuesCheck.GetValue(SpaceshipBoostSpeed)

        button = MSG_SpaceshipInformationTech.show(Mass, FuelTankAmount, GravDriveChargeAmount, EngineThrust, GravDriveThrust, BoostPower, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

										   Message = 22

									ElseIf (button == 1)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 233

                                        SpaceShipReference ShipValuesCheck = SetProperShipReferenceForDataView()	
                                        
										Float CalculateWeaponHealthInPercent01 = ShipValuesCheck.GetValue(SpaceshipWeaponHealth) / ShipValuesCheck.GetBaseValue(SpaceshipWeaponHealth) * 100
                                        Float CalculateWeaponHealthInPercent02 = ShipValuesCheck.GetValue(SpaceshipWeaponHealth02) / ShipValuesCheck.GetBaseValue(SpaceshipWeaponHealth02) * 100
                                        Float CalculateWeaponHealthInPercent03 = ShipValuesCheck.GetValue(SpaceshipWeaponHealth03) / ShipValuesCheck.GetBaseValue(SpaceshipWeaponHealth03) * 100
                                        Float CalculateEngineHealthInPercent = ShipValuesCheck.GetValue(SpaceshipSystemEngineHealth) / ShipValuesCheck.GetBaseValue(SpaceshipSystemEngineHealth) * 100
                                        Float CalculateShieldHealthInPercent = ShipValuesCheck.GetValue(SpaceshipShieldHealth) / ShipValuesCheck.GetBaseValue(SpaceshipShieldHealth) * 100
                                        Float CalculateGravDriveHealthInPercent = ShipValuesCheck.GetValue(SpaceshipSystemGravdriveHealth) / ShipValuesCheck.GetBaseValue(SpaceshipSystemGravdriveHealth) * 100

        button = MSG_SpaceshipInformationSubSystems.show(CalculateWeaponHealthInPercent01, CalculateWeaponHealthInPercent02, CalculateWeaponHealthInPercent03, CalculateEngineHealthInPercent, CalculateShieldHealthInPercent, CalculateGravDriveHealthInPercent, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

										   Message = 22

									ElseIf (button == 1)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf
                              
 ElseIf Message == 1

                                        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()								
										
										Int AvailableFuelInTheCargo = akShip.GetItemCount(SpaceshipFuel)
                                        Int AvailableBatteriesInTheCargo = akShip.GetItemCount(SpaceshipGravBattery)
		                                Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) as Int
										Int TotalChargeInTheGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int                                       

                                        Float FuelConsumption = FuelConsumptionDataView()
										Float ChargeConsumption = ChargeConsumptionDataView()
										
										Float FuelTankAmount = akShip.GetValue(SpaceshipFuelTank)                                  
										Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount)

										Float ConsumeFuelCycle = GV_FuelConsumeTimeOnMove.GetValue() 										

		  button = MSG_StarviewFuelManagement.show(AvailableFuelInTheCargo, TotalFuelInTheTank, FuelTankAmount, FuelConsumption, ConsumeFuelCycle, AvailableBatteriesInTheCargo, TotalChargeInTheGravDrive, GravDriveChargeAmount, ChargeConsumption)
         
	                                    If (button == 0)

                                                        If TotalFuelInTheTank < FuelTankAmount && AvailableFuelInTheCargo > 0
                                                           GV_PrepareFuelStandBy.SetValue(1)
                                                           FuelFillExecute()
											               MenuOpened = False
										           Else
										                      If AvailableFuelInTheCargo <= 0
											                     MSG_SpaceshipNoFuelTanks.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
										                  ElseIf TotalFuelInTheTank == FuelTankAmount
	                                                             MSG_SpaceshipFullFuelTanks.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
										                   EndIf
										 
										             EndIf
									
									ElseIf (button == 1)

                                                       If TotalChargeInTheGravDrive < GravDriveChargeAmount && AvailableBatteriesInTheCargo > 0
                                                          GV_PrepareBatteryStandBy.SetValue(1)
                                                          GravDriveFillExecute()
											              MenuOpened = False
										           Else
										                       If AvailableBatteriesInTheCargo <= 0
											                      MSG_SpaceshipNoGravDriveCharge.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
										                   ElseIf TotalChargeInTheGravDrive == GravDriveChargeAmount
	                                                              MSG_SpaceshipFullGravDriveCharge.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
										                    EndIf
										 
										            EndIf

	                                ElseIf (button == 2)
                                            
                                                       If TotalFuelInTheTank > 0
                                                          GV_PrepareFuelStandBy.SetValue(1)
											              FuelPumpoutExecute()
											              MenuOpened = False
										            EndIf                                            	                                

									ElseIf (button == 3)
                                                                                                   
													   If TotalChargeInTheGravDrive > 0
                                                          GV_PrepareBatteryStandBy.SetValue(1)
											              ChargesTakeoutExecute()
											              MenuOpened = False
										            EndIf

	                                ElseIf (button == 4)

                                            GV_AutoInjector.SetValue(0)
                                            CancelTimer(13)
                                            	                                
									ElseIf (button == 5)

                                            GV_AutoInjector.SetValue(1)
                                            StartTimer(0, 13)

	                                ElseIf (button == 6)
                                          
                                            Message = 0
                                            	                                
									ElseIf (button == 7)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

  EndIf

EndWhile
EndFunction

Function FuelEmergencyServiceFuelOfProblems(Int Message = 0, Int Button = 0, Bool MenuOpened = True)
                               
  While MenuOpened
  SoundEventCallChatter.PlayAndWait(PlayerRef, None, None)  
	 
	 If Button == -1

 ElseIf Message == 0

                                         SpaceShipReference homeShipRef = HomeShip.GetShipRef()
										 
										 Float TotalFuelInTheTank = homeShipRef.GetValue(SpaceshipTotalFuelAmount)
        			                     Int i = -1
                                         
										 Actor CrewMember = CurrentCrew.GetAt(i) as Actor
		                                 CurrentLoc = CrewMember.GetCurrentlocation()
		
		button = MSG_StarviewEmergencyCall.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

									 If (button == 0)

                                               If EmergencyIsOnTheirWay == False
		                                          Message = 1
                                           Else
	                                              MSG_EmergencyGroupIsOnTheirWay.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
									        EndIf

								 ElseIf (button == 1)
                                        
										If PlayerRef.GetDistance(homeShipRef) >= 1000
										      
											  If GV_SpaceshipSystemsToggle.GetValue() == 1 

															 If CrewMember && CrewMember.HasPerk(SpaceshipCrewPiloting) && CurrentLoc == playerShipInteriorLocation.GetLocation() == True 
															        If TotalFuelInTheTank > 25
										                               CallShip()
							                                    Else
                                                                      MSG_SpaceshipCallAbort02.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
									                             EndIf
									                     Else
												                MSG_SpaceshipCallAbort03.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
												          EndIf

										 Else
									            CallShip()
									       EndIf
									Else
                                           MSG_SpaceshipCallAbort.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                                     EndIf

								 ElseIf (button == 2)

                                        ; Exit
                                        MenuOpened = False
                                  EndIf

 ElseIf Message == 1
		button = MSG_StarviewEmergencyResponder.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
	                                    If (button == 0)

                                           Message = 2
									
									ElseIf (button == 1)

                                           ; Exit
                                           MenuOpened = False
									 EndIf

 ElseIf Message == 2
                                        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

                                        Int Payment = GV_RescuePayment.GetValue() As Int

		button = MSG_StarviewEmergencyResponderPayment.show(Payment, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
                                           If TutorialRescueCallTrigger == False
                                                      If PlayerRef.IsInSpace() == True
											               If akShip.GetItemCount(SpaceshipEmergencyBeaconPotion) > 0
															  Message = 3
										               Else
												              MSG_Tutorial_EmergencyBeacon02.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
												        EndIf
												   Else
										                 Message = 4
										           EndIf
                                        Else
                                                      If PlayerRef.IsInSpace() == True
											               If akShip.GetItemCount(SpaceshipEmergencyBeaconPotion) > 0
															      If PlayerRef.GetItemCount(Credits) >= Payment
															         PlayerRef.RemoveItem(Credits, Payment, False, None)
																	 Message = 3
										                      Else
													                 MSG_StarviewEmergencyResponderNotEnoughCredits.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
													           EndIf
													   Else
												              MSG_Tutorial_EmergencyBeacon02.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
												        EndIf
												   Else
										                   If PlayerRef.GetItemCount(Credits) >= Payment
														      PlayerRef.RemoveItem(Credits, Payment, False, None)
															  Message = 4
										               Else
												              MSG_StarviewEmergencyResponderNotEnoughCredits.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
												        EndIf
												   EndIf

                                        EndIf
	                                
									ElseIf (button == 1)
                                          
                                            	If PlayerRef.IsInSpace() == True
											         If akShip.GetItemCount(SpaceshipEmergencyBeaconPotion) > 0
												        Message = 3
										                RescueDebt += Payment
		                                                StartTimer(0, 5)
												 Else
											            MSG_Tutorial_EmergencyBeacon02.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
											      EndIf
											Else
										           Message = 4
										           RescueDebt += Payment
		                                           StartTimer(0, 5)
											 EndIf                                

									ElseIf (button == 2)

                                           ; Exit
                                           MenuOpened = False
									 EndIf

 ElseIf Message == 3
                                        										
                                        Int RescueTime = GV_RescueTeamTime.GetValue() As Int

		button = MSG_StarviewEmergencyResponderHelpIsOnTheWay.show(RescueTime, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

									           EmergencyIsOnTheirWay = True
                                               StartTimer(RescueTime, 4)

                                               ; Exit
                                               MenuOpened = False
								 
									 EndIf

 ElseIf Message == 4
		button = MSG_StarviewEmergencyResponderUseBeacon.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)

									       EmergencyIsOnTheirWay = True
                                           GV_BeaconTrigger.SetValue(1)

                                           ; Exit
                                           MenuOpened = False
									 EndIf

  EndIf

SoundEventCallChatterOff.Play(PlayerRef, None, None) 

EndWhile

EndFunction

Function CallShip()
	
	ObjectReference markerRef = FindLandingMarker()  
	SpaceShipReference homeShipRef = HomeShip.GetShipRef()
	
	RegisterForCustomEvent(self, "SISA_SpaceshipFuel_LandingRequested")
	 
	Var[] akArgs = new Var[1]
	akArgs[0] = markerRef
	   
	   If LandingPad == False
	      markerRef.MoveTo(playerRef, 0.0, 0.0, 0.0, True, False)
    EndIf
	
	SendCustomEvent("SISA_SpaceshipFuel_LandingRequested", akArgs)

EndFunction

Event SISA_SpaceshipFuel.LandingRequested(SISA_SpaceshipFuel akSender, Var[] akArgs)
	
	ObjectReference landingMarker = akArgs[0] As ObjectReference
	SpaceShipReference homeShipRef = HomeShip.GetShipRef()

	homeShipRef.TakeOff()	
	Utility.Wait(35.0)
	homeShipRef.MoveTo(landingMarker, 0, 0, 0, True, False)
	homeShipRef.SetLinkedRef(landingMarker, SpaceshipEnabledLandingLink, True)
	homeShipRef.Enable(False)
	homeShipRef.EnableWithLanding()

    If LandingPad == True
       LandingPad = False
 EndIf

EndEvent

ObjectReference Function FindLandingMarker()

	Float[] offsets = new Float[6]
    offsets[0] = 0.0
    offsets[1] = 30.0
    offsets[2] = 0.0
    offsets[3] = 0.0
    offsets[4] = 0.0
    offsets[5] = 180.0
	
	ObjectReference PadlandingMarker = Game.FindClosestReferenceOfAnyTypeInListFromRef(SpaceshipLandingMarkers, playerRef, 300)
    ObjectReference PlayerlandingMarker = PlayerRef.PlaceAtMe(ShipLandingMarker, 1, False, False, True, offsets, None, True)
    SpaceShipReference homeShipRef = HomeShip.GetShipRef()    

	   If PadlandingMarker && homeShipRef.CanLandAtMarker(PadlandingMarker) && !PadlandingMarker.IsFurnitureInUse(False)
		  LandingPad = True
		  Return PadlandingMarker
	Else
          Return PlayerlandingMarker	
	EndIf
 
EndFunction

Function TutorialIntroduction(Int Message = 0, Int Button = 0, Bool MenuOpened = True)

  While MenuOpened

	 If Button == -1

 ElseIf Message == 0										
		button = MSG_Tutorial_Main.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	                                    If (button == 0)
                                           GV_SpaceshipSystemsToggle.SetValue(1)
                                           PrepareSystemsTutorial()
									       TutorialIntroduction = True
                                           CancelTimer(12)
										   StartTimer(1, 11)
									       AllPowerOff()
										   MenuOpened = False
									
									ElseIf (button == 1)
                                           GV_SpaceshipSystemsToggle.SetValue(1)
										   PrepareSystems() 
										   CancelTimer(12)
                                           TutorialIntroduction = True
                                           TutorialRescueCallTrigger = True
										   GV_SpaceshipSystemsTutorial01.SetValue(1)
                                           GV_SpaceshipTutorial03.SetValue(1)
                                           AllPowerOff()
										   ; Exit                                           
                                           MenuOpened = False

									ElseIf (button == 2)
										   GV_SpaceshipSystemsToggle.SetValue(0)                                           
										   CancelTimer(12)
										   TutorialIntroduction = True
										   ; Exit                                           
                                           MenuOpened = False

									 EndIf

  EndIf

EndWhile
EndFunction

Function SpawnEmergencyResponder()

     Int iDatumIndex = FriendIndex

     If iDatumIndex < 0 || iDatumIndex >= FriendsShipData.Length
        iDatumIndex = 0
  EndIf 

  SISA_SpaceshipFuel:Friendshipdatum currFriend = FriendsShipData[iDatumIndex]
  Int iNumFriendsToSpawn = Utility.RandomInt(currFriend.MinFriends.GetValueInt(), currFriend.MaxFriends.GetValueInt())
  Int I = 0

       ObjectReference currSpawn = GeneralMarker.GetRef()
       Float[] offsets = new Float[6]

       Int iRandY = Utility.RandomInt(0, 2)
       Int iRandomizerValue = 0
       Int iRandomizer = Utility.RandomInt(0, 2)

      If iRandomizer < 1
        iRandomizerValue = OffsetRandomizer
      ElseIf iRandomizer == 1
        iRandomizerValue = OffsetRandomizer * -1
      Else
        iRandomizerValue = 0 
      EndIf

      If iRandY < 1
        offsets[0] = (OffsetDistanceY + iRandomizerValue) as Float
      ElseIf iRandY == 1
        offsets[0] = (OffsetDistanceY * -1 + iRandomizerValue) as Float
      Else
        offsets[0] = (OffsetDistanceY * (I + iNumFriendsToSpawn) + iRandomizerValue) as Float
      EndIf

      offsets[1] = (GV_SpawnDistanceOffset.GetValueInt() + iRandomizer) as Float
      currSpawn = PlayerShip.GetRef()
      SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()

      spaceshipreference newShip01 = currSpawn.PlaceShipAtMe(currFriend.ShipToSpawn as Form, 4, True, False, False, True, offsets, None, None, True)
      Utility.Wait(3.0)
      SoundEventFuelFillEnd.Play(akShip, None, None) 
	  akShip.Additem(SpaceshipResourcePackage, 1, False)
	  Utility.Wait(3.0)
      newShip01.DisableWithGravJump() 

      EmergencyCallReset()

         If TutorialRescueCallTrigger == False
	        Utility.Wait(2.0)
			MSG_Tutorial_RescueCall.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
			TutorialRescueCallTrigger = True
      EndIf

EndFunction

Function EmergencyCallReset()

         If EmergencyIsOnTheirWay == True
            EmergencyIsOnTheirWay = False
      EndIf

EndFunction

Function EmergencyBeaconActivator()

       PlayerRef.Placeatme(SpaceshipEmergencyBeaconActivator as Form, 1, False, False, True, None, None, True)

       If TutorialEmergencyBeacon == False
		  Utility.Wait(1.0)
		  MSG_Tutorial_EmergencyBeacon.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
          TutorialEmergencyBeacon = True
	EndIf

EndFunction

Function ShakeAndRumble02()

       Game.ShakeCamera(PlayerRef, 0.3, 1)
       Game.ShakeController(0.01, 0.01, 0.5)

EndFunction

Function FuelThresholds()
         
		 SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	 
	     Float RestoreFuelIfNegative = - akShip.GetValue(SpaceshipTotalFuelAmount)
	     Int RestoreChargeIfNegative = - akShip.GetValue(SpaceshipTotalChargeAmount) as Int
         
		 If akShip.GetValue(SpaceshipTotalFuelAmount) < 0 
            akShip.RestoreValue(SpaceshipTotalFuelAmount, RestoreFuelIfNegative)
      EndIf

         If akShip.GetValue(SpaceshipTotalChargeAmount) < 0 
            akShip.RestoreValue(SpaceshipTotalChargeAmount, RestoreChargeIfNegative)
      EndIf

      SpaceshipSystemStatus()

EndFunction

Function MaintenanceThresholds()

    SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()

    Float DamageWeapon1 = - akShip.GetValue(SpaceshipWeaponHealth)
    Float DamageWeapon2 = - akShip.GetValue(SpaceshipWeaponHealth02)
    Float DamageWeapon3 = - akShip.GetValue(SpaceshipWeaponHealth03)

    Float DamageEngine = - akShip.GetValue(SpaceshipSystemEngineHealth)
    Float DamageShield = - akShip.GetValue(SpaceshipShieldHealth)
    Float DamageGravJump = - akShip.GetValue(SpaceshipSystemGravdriveHealth)
    Float DamageHealth = - akShip.GetValue(SpaceshipHealth)

    Float RestoreMaintenanceIfNegative = - akShip.GetValue(SpaceshipTotalMaintenanceAmount)

		 If akShip.GetValue(SpaceshipSystemEngineHealth) < 0
			akShip.RestoreValue(SpaceshipSystemEngineHealth, DamageEngine)          
	  EndIf

		 If akShip.GetValue(SpaceshipShieldHealth) < 0
			akShip.RestoreValue(SpaceshipShieldHealth, DamageShield)          
	  EndIf

		 If akShip.GetValue(SpaceshipSystemGravdriveHealth) < 0
			akShip.RestoreValue(SpaceshipSystemGravdriveHealth, DamageGravJump)          
	  EndIf

		 If akShip.GetValue(SpaceshipWeaponHealth) < 0
			akShip.RestoreValue(SpaceshipWeaponHealth, DamageWeapon1)          
	  EndIf

		 If akShip.GetValue(SpaceshipWeaponHealth02) < 0
			akShip.RestoreValue(SpaceshipWeaponHealth02, DamageWeapon2)          
	  EndIf

		 If akShip.GetValue(SpaceshipWeaponHealth03) < 0
			akShip.RestoreValue(SpaceshipWeaponHealth03, DamageWeapon3)          
	  EndIf

         If akShip.Getvalue(SpaceshipTotalMaintenanceAmount) < 0 
            akShip.RestoreValue(SpaceshipTotalMaintenanceAmount, RestoreMaintenanceIfNegative) 
      EndIf

EndFunction

Function SpaceshipSystemStatus()

                                        SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
										
										Float TotalFuelInTheTank = akShip.GetValue(SpaceshipTotalFuelAmount)									
                                        Float FuelTankAmount = akShip.GetValue(SpaceshipFuelTank)
                                        Float FuelTankAmount02 = akShip.GetValue(SpaceshipFuelTank) / 3
		                                
										Int GravDriveChargeAmount = akShip.GetValue(SpaceshipGravDriveHealth) as Int
		                                Int GravDriveChargeAmount02 = akShip.GetValue(SpaceshipGravDriveHealth) as Int / 3
										Int TotalChargeInTheGravDrive = akShip.GetValue(SpaceshipTotalChargeAmount) as Int         		   
		  
		  Utility.Wait(0.1)
		         
				 If GV_SpaceshipFuelConsumptionType.GetValue() == 1
				    MSG_SpaceshipAnalizerCheckerInfo.show(TotalFuelInTheTank, FuelTankAmount, TotalChargeInTheGravDrive, GravDriveChargeAmount, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
		     
			 ElseIf GV_SpaceshipFuelConsumptionType.GetValue() == 2
                         If TotalFuelInTheTank < FuelTankAmount02 || TotalChargeInTheGravDrive < GravDriveChargeAmount02 
						    MSG_SpaceshipAnalizerCheckerInfo.show(TotalFuelInTheTank, FuelTankAmount, TotalChargeInTheGravDrive, GravDriveChargeAmount, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                      EndIf
              EndIf

EndFunction

Function SpaceshipSystemsIntroduction()

         CurrentLoc = PlayerRef.GetCurrentlocation()

        If CurrentLoc == playerShipInteriorLocation.GetLocation() == True

               If TutorialIntroduction == False
                  TutorialIntroduction()
			EndIf

     EndIf

EndFunction

Function SpaceshipSystemsTutorials()

         spaceshipreference homeShipRef = HomeShip.GetShipRef()
		 
		 Int GravDriveChargeAmount = homeShipRef.GetValue(SpaceshipGravDriveHealth) as Int
	     Int TotalChargeInGravDrive = homeShipRef.GetValue(SpaceshipTotalChargeAmount) as Int
         
		 Float FuelTankAmount = homeShipRef.GetValue(SpaceshipFuelTank)
	     Float TotalFuelInTheTank = homeShipRef.GetValue(SpaceshipTotalFuelAmount)
        
		 CurrentLoc = PlayerRef.GetCurrentlocation()

     If GV_SpaceshipSystemsToggle.GetValue() == 1

        If CurrentLoc == playerShipInteriorLocation.GetLocation() == True

               If TutorialRefueling == False
			      MSG_Tutorial_Refueling.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                  PlayerRef.Additem(SpaceshipFuel, 250, False)
                  PlayerRef.Additem(SpaceshipGravBattery, 125, False)
				  homeShipRef.Additem(SpaceshipEmergencyRepairBotsMisc, 2, False)
				  homeShipRef.Additem(SpaceshipMaintenanceKitMisc, 3, False)
				  homeShipRef.DamageValue(SpaceshipTotalFuelAmount, TotalFuelInTheTank)
				  homeShipRef.DamageValue(SpaceshipTotalChargeAmount, TotalChargeInGravDrive)
				  TutorialRefueling = True

	       ElseIf TutorialRefuelingApply == False

                       If homeShipRef.GetItemCount(SpaceshipFuel) > 0 && homeShipRef.GetItemCount(SpaceshipGravBattery) > 0
				          Utility.Wait(1.0)
			              PlayerRef.Additem(SpaceshipAnalizer, 1, False)
						  MSG_Tutorial_RefuelingApply.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                          TutorialRefuelingApply = True
                    EndIf

	       ElseIf TutorialRefuelingDone == False

                     If TutorialFillFuel == True && TutorialFillCharge == True
				        homeShipRef.Removeitem(SpaceshipFuel, 99999, True, None)
                        homeShipRef.Removeitem(SpaceshipGravBattery, 99999, True, None)
				        PlayerRef.Additem(SpaceshipEmergencyCallPotion, 1, False)
						PlayerRef.Additem(SpaceshipEmergencyBeaconPotion, 1, False)
						homeShipRef.DamageValue(SpaceshipTotalFuelAmount, TotalFuelInTheTank)
				        homeShipRef.DamageValue(SpaceshipTotalChargeAmount, TotalChargeInGravDrive)
						MSG_Tutorial_RefuelingDone.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)                          
                        TutorialRefuelingDone = True
                        GV_SpaceshipSystemsTutorial01.SetValue(1)
				  EndIf

	       ElseIf TutorialRescueCall == False

                       If TutorialRescueCallTrigger == True
						  GV_SpaceshipTutorial03.SetValue(1)
						  TutorialRescueCall = True
					EndIf

            EndIf

     EndIf

	          If TutorialAdditionalInfo == False && TutorialRescueCall == True || TutorialRescueCallOnLand == True

                          CancelTimer(11)
				          Utility.Wait(2.0)
						  MSG_Tutorial_AdditionalInfo.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                          TutorialAdditionalInfo = True
                          homeShipRef.Additem(SpaceshipFuel, 250, False)
                          homeShipRef.Additem(SpaceshipGravBattery, 125, False)
                          PlayerRef.Additem(SongbirdPortableAudioPlayer, 1, False)    
	                      PlayerRef.Additem(SpaceshipTeleporter, 5, False)
		                  LeveledCargos()
		  ElseIf TutorialRescueCallOnLand == False

                       If GV_SpaceshipTutorial02.GetValue() == 1
				          Utility.Wait(1.0)
						  MSG_Tutorial_RescueCall02.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
                          GV_SpaceshipTutorial03.SetValue(1)
						  TutorialRescueCallOnLand = True
                          homeShipRef.Additem(SpaceshipFuel, 250, False)
                          homeShipRef.Additem(SpaceshipGravBattery, 125, False)
				          homeShipRef.RestoreValue(SpaceshipTotalFuelAmount, FuelTankAmount)
				          homeShipRef.RestoreValue(SpaceshipTotalChargeAmount, GravDriveChargeAmount)
						  PlayerRef.Additem(SongbirdPortableAudioPlayer, 1, False)   
					      PlayerRef.Additem(SpaceshipTeleporter, 5, False)
					      LeveledCargos()
					EndIf

            EndIf

  EndIf

EndFunction

Function SpaceshipZegoGOn()

    Guard GravityGuard
		 SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()  
		 Cell shipInterior = akShip.GetLinkedCell(SpaceshipLinkedInterior)
		 Float gravity = 0
		 GravDriveDamaged = True
			If PlayerRef.Hasperk(SpaceshipMaintenanceMaxAmountPerk04)
			   EmergencySystemRepairGravDrive()
        Else
		          If GV_SpaceshipGravityToggle.GetValue() == 1
		             shipInterior.SetGravityScale(gravity)	 
		             CheckSystemsAtGetUp()
			   Else
		             DisableGravJump()
		       EndIf
         EndIf
		 SoundEventChargeBeep.Play(PlayerRef, None, None)
		 PlayerRef.Placeatme(ImpulseExplosion, 1, False, false, true, none, none, True)
	     GravDriveRechargeFX.Play(akShip, 0.3)
		 AlertSoundInstance = SoundEventAlert.Play(akShip, None, None)   
		 ShakeAndRumble02()
EndGuard

EndFunction

Function SpaceshipZegoGOff()

   Guard GravityGuard
		 SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()  
		 Cell shipInterior = akShip.GetLinkedCell(SpaceshipLinkedInterior)
		 Float gravity = 1
		 GravDriveDamaged = False
		    If GV_SpaceshipGravityToggle.GetValue() == 1
		       shipInterior.SetGravityScale(gravity)
	     Else
		       GravDriveCheck()
		 EndIf
		 SoundEventChargeBeep.Play(PlayerRef, None, None)
		 PlayerRef.Placeatme(ImpulseExplosion, 1, False, false, true, none, none, True)
	     GravDriveRechargeFX.Play(akShip, 0.3)
		 wwiseevent.StopInstance(AlertSoundInstance)
		 AlertSoundInstance = -1
		 ShakeAndRumble02()
EndGuard

EndFunction

Function SpaceshipSystemStart()
  
  StartTimer(2, 12) 
  
EndFunction

Function Register()

  RegisterForMenuOpenCloseEvent("GalaxyStarMapMenu")
  RegisterForMenuOpenCloseEvent("SpaceshipEditorMenu")

  RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")

  RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipGravJump")	 
  RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipLanding") 
  RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipTakeOff")

  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnEnterShipInterior") 
  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnExitShipInterior")  
  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnHomeShipSet")
  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerModifiedShip")
       
  PlayerRef.Addperk(SpaceshipMaintenanceRepairPerk, False) 
  PlayerRef.Addperk(SpaceshipFuelDiscountPerk, False)
  PlayerRef.Addperk(SpaceshipStarviewOpenizer, False)

EndFunction

Function Unregister()
        
		        SpaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()  
                
				UnregisterForMenuOpenCloseEvent("GalaxyStarMapMenu")
                UnregisterForMenuOpenCloseEvent("SpaceshipEditorMenu")

                UnregisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")

                UnregisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipGravJump")	 
                UnregisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipLanding") 
                UnregisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipTakeOff")

                UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnEnterShipInterior") 
                UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnExitShipInterior")  
                UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnHomeShipSet")
                UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerModifiedShip")          
		        
				PlayerRef.Removeperk(SpaceshipMaintenanceRepairPerk)
                PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk01)
                PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk02)
	            PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk03)
	            PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk04)
	            PlayerRef.Removeperk(SpaceshipFuelDiscountPerk)
	            PlayerRef.Removeperk(SpaceshipStarviewOpenizer)
				   
				   If PlayerRef.GetItemCount(SpaceshipAnalizer) > 0
                      PlayerRef.Removeitem(SpaceshipAnalizer, 9999, True, None)                                       
				EndIf

                   If PlayerRef.GetItemCount(SpaceshipFuel) > 0
                      PlayerRef.Removeitem(SpaceshipFuel, 9999, True, None)                                       
				EndIf
				
                   If PlayerRef.GetItemCount(SpaceshipGravBattery) > 0
                      PlayerRef.Removeitem(SpaceshipGravBattery, 9999, True, None)                                       
				EndIf				

                   If PlayerRef.GetItemCount(SpaceshipEmergencyBeaconPotion) > 0
                      PlayerRef.Removeitem(SpaceshipEmergencyBeaconPotion, 9999, True, None)                                       
				EndIf		

                   If PlayerRef.GetItemCount(SpaceshipEmergencyRepairBotsMisc) > 0
                      PlayerRef.Removeitem(SpaceshipEmergencyRepairBotsMisc, 9999, True, None)                                       
				EndIf	

                   If PlayerRef.GetItemCount(SpaceshipEmergencyCallPotion) > 0
                      PlayerRef.Removeitem(SpaceshipEmergencyCallPotion, 9999, True, None)                                       
				EndIf	

                   If PlayerRef.GetItemCount(SpaceshipMaintenanceKitMisc) > 0
                      PlayerRef.Removeitem(SpaceshipMaintenanceKitMisc, 9999, True, None)                                       
				EndIf

                   If akShip.GetItemCount(SpaceshipAnalizer) > 0
                      akShip.Removeitem(SpaceshipAnalizer, 9999, True, None)                                       
				EndIf

                   If akShip.GetItemCount(SpaceshipEmergencyBeaconPotion) > 0
                      akShip.Removeitem(SpaceshipEmergencyBeaconPotion, 9999, True, None)                                       
				EndIf		

                   If akShip.GetItemCount(SpaceshipEmergencyCallPotion) > 0
                      akShip.Removeitem(SpaceshipEmergencyCallPotion, 9999, True, None)                                       
				EndIf	

                   If akShip.GetItemCount(SpaceshipGravBattery) > 0
                      akShip.Removeitem(SpaceshipGravBattery, 9999, True, None)                                       
				EndIf				

                   If akShip.GetItemCount(SpaceshipFuel) > 0
                      akShip.Removeitem(SpaceshipFuel, 9999, True, None)                                       
				EndIf	

                   If akShip.GetItemCount(SpaceshipEmergencyRepairBotsMisc) > 0
                      akShip.Removeitem(SpaceshipEmergencyRepairBotsMisc, 9999, True, None)                                       
				EndIf	

                   If akShip.GetItemCount(SpaceshipMaintenanceKitMisc) > 0
                      akShip.Removeitem(SpaceshipMaintenanceKitMisc, 9999, True, None)                                       
				EndIf

                   GV_SpaceshipNeedsMaintenanceToggle.SetValue(0)

                   EnableGravJump()
                   EnableGroundTravel()
                   EnableSpaceTravel()
                   EnableTakeOff()

                   TravelDisabled = False
                   SpaceshipIsReadyToFly = False
                   SpaceshipPowerValueStored = False
                   SpaceshipEngineIgnited = False
                   TutorialIntroduction = False
                   TutorialEmergencyBeacon = False
                   TutorialRefueling = False
                   TutorialRefuelingApply = False
                   TutorialRefuelingDone = False
                   TutorialRescueCall = False
                   TutorialRescueCallOnLand = False
                   TutorialRescueCallTrigger = False
                   TutorialAdditionalInfo = False
                   TutorialFillFuel = False
                   TutorialFillCharge = False
                   EmergencyIsOnTheirWay = False
                   SpaceshipPower = False
                   EnginePowerRestricted = False
                   GravJumpInitiated = False
                   GravDriveDamaged = False
                   RefuelFuelStarted = False
                   RefuelChargeStarted = False
                   CameraShakeOnFuelFill = False
                   MaintenanceEmergency = False
                   LandingPad = False

                   CancelTimer(1)
                   CancelTimer(3)
                   CancelTimer(4)
                   CancelTimer(5)
                   CancelTimer(6)
                   CancelTimer(7)
                   CancelTimer(8)
                   CancelTimer(10)
				   CancelTimer(11)
                   CancelTimer(12)	
                   CancelTimer(14)
				   CancelTimer(15)
                   CancelTimer(16)		

		           wwiseevent.StopInstance(AlertSoundInstance)
		           AlertSoundInstance = -1	

		           wwiseevent.StopInstance(RadioSoundInstance)
		           RadioSoundInstance = -1	

		           wwiseevent.StopInstance(GravDrivePrepareSoundInstance)
		           GravDrivePrepareSoundInstance = -1	

		           wwiseevent.StopInstance(EngineOnSoundInstance)
		           EngineOnSoundInstance = -1	

		           wwiseevent.StopInstance(BotsStartSoundInstance)
		           BotsStartSoundInstance = -1	

		           wwiseevent.StopInstance(BotsEndSoundInstance)
		           BotsEndSoundInstance = -1

EndFunction

Function UnregisterMaintenance()
        
                SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()       
				
				GV_SpaceshipNeedsMaintenanceToggle.SetValue(0)
			    GV_SpaceshipSystemDamaged.SetValue(0)		  
		        
				PlayerRef.Removeperk(SpaceshipMaintenanceRepairPerk)
                PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk01)
                PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk02)
	            PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk03)
	            PlayerRef.Removeperk(SpaceshipMaintenanceMaxAmountPerk04)
                   			
                   If PlayerRef.GetItemCount(SpaceshipEmergencyRepairBotsMisc) > 0
                      PlayerRef.Removeitem(SpaceshipEmergencyRepairBotsMisc, 9999, True, None)                                       
				EndIf	

                   If akShip.GetItemCount(SpaceshipEmergencyRepairBotsMisc) > 0
                      akShip.Removeitem(SpaceshipEmergencyRepairBotsMisc, 9999, True, None)                                       
				EndIf	

                   If PlayerRef.GetItemCount(SpaceshipMaintenanceKitMisc) > 0
                      PlayerRef.Removeitem(SpaceshipMaintenanceKitMisc, 9999, True, None)                                       
				EndIf

                   If akShip.GetItemCount(SpaceshipMaintenanceKitMisc) > 0
                      akShip.Removeitem(SpaceshipMaintenanceKitMisc, 9999, True, None)                                       
				EndIf
                   	 			   
			    akShip.RestoreValue(SpaceshipHealth, 99999.0)
		        akShip.RestoreValue(SpaceshipSystemEngineHealth, 99999.0) 
			    akShip.RestoreValue(SpaceshipShieldHealth, 99999.0) 
			    akShip.RestoreValue(SpaceshipSystemGravdriveHealth, 99999.0) 
			    akShip.RestoreValue(SpaceshipWeaponHealth, 99999.0) 
			    akShip.RestoreValue(SpaceshipWeaponHealth02, 99999.0)
			    akShip.RestoreValue(SpaceshipWeaponHealth03, 99999.0) 
               
			    MaintenanceEmergency = False
		 	   
			    wwiseevent.StopInstance(MaintenanceEmergencySoundInstance)
    	        MaintenanceEmergencySoundInstance = -1

EndFunction

Function RegisterMaintenance()
        
                SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()       
				
				GV_SpaceshipNeedsMaintenanceToggle.SetValue(1)		  
		        
				PlayerRef.Addperk(SpaceshipMaintenanceRepairPerk, False)
                   			
                   If akShip.GetItemCount(SpaceshipEmergencyRepairBotsMisc) <= 0
                      akShip.Additem(SpaceshipEmergencyRepairBotsMisc, 2, False)                                       
				EndIf	

                   If akShip.GetItemCount(SpaceshipMaintenanceKitMisc) <= 0
                      akShip.Additem(SpaceshipMaintenanceKitMisc, 3, False)                                       
				EndIf
                   


EndFunction

Function EssentialItems()
         
		           SpaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
				   
				   akShip.Additem(SpaceshipFuel, 250, False)
                   akShip.Additem(SpaceshipGravBattery, 125, False)
                   akShip.Additem(SpaceshipMaintenanceKitMisc, 3, False)
				   akShip.Additem(SpaceshipEmergencyRepairBotsMisc, 2, False)
				   
				   PlayerRef.Additem(SpaceshipAnalizer, 1, False)
				   PlayerRef.Additem(SpaceshipEmergencyCallPotion, 1, False)
				   PlayerRef.Additem(SpaceshipEmergencyBeaconPotion, 1, False)
				   PlayerRef.Additem(SongbirdPortableAudioPlayer, 1, False)                   
				   PlayerRef.Additem(SpaceshipTeleporter, 5, False)

EndFunction

Function EssentialItemsDebug()
         				   				   
				   If PlayerRef.GetItemCount(SpaceshipAnalizer) <= 0
				      PlayerRef.Additem(SpaceshipAnalizer, 1, False)
				EndIf
				   
				   If PlayerRef.GetItemCount(SpaceshipEmergencyCallPotion) <= 0				   
				      PlayerRef.Additem(SpaceshipEmergencyCallPotion, 1, False)
				EndIf
				   
				   If PlayerRef.GetItemCount(SpaceshipEmergencyBeaconPotion) <= 0
				      PlayerRef.Additem(SpaceshipEmergencyBeaconPotion, 1, False)
				EndIf
				   
				   If PlayerRef.GetItemCount(SongbirdPortableAudioPlayer) <= 0
				      PlayerRef.Additem(SongbirdPortableAudioPlayer, 1, False)                   
                EndIf
EndFunction

Function PrepareSystemsTutorial()

     Register()  
             
     If EnginePowerRestricted == False
        EnginePowerRestricted = True
  EndIf

  DisableSpaceTravel() 
  DisableTakeOff() 
  DisableGroundTravel()
    
EndFunction

Function PrepareSystems()
                            
         Register()

         If GV_NGPlusStarted.GetValue() == 0             

                   If EnginePowerRestricted == False
                      EnginePowerRestricted = True
                EndIf

                   DisableSpaceTravel() 
                   DisableTakeOff() 
                   DisableGroundTravel()

                   SpaceshipIsReadyToFly = False
                   TravelDisabled = True 
                   
				   EssentialItems()
                   CheckSystems()
				   LeveledCargos()
  Else
                   PrepareSystemsNGPlus()
      EndIf    

EndFunction

Function PrepareSystemsNGPlus()
                      
         DisableGroundTravel()
         DisableSpaceTravel()
         DisableTakeoff()
         
		 SpaceshipIsReadyToFly = True
         TravelDisabled = False                    
         
		 EssentialItems()
       
     If EnginePowerRestricted == True
        EnginePowerRestricted = False
  EndIf
        CheckSystems()
		LeveledCargos()

EndFunction

Function SpaceshipSystemBook()
      
	         If GV_SpaceshipSystemsToggle.GetValue() == 0
                GV_SpaceshipSystemsToggle.SetValue(1)
                TutorialIntroduction = False
                StartTimer(2, 12) 

         ElseIf GV_SpaceshipSystemsToggle.GetValue() == 1
                GV_SpaceshipSystemsToggle.SetValue(0)
                
				Unregister()
                MSG_SpaceshipSystemsTurnedOff.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
    EndIf

EndFunction

Function SpaceshipSystemISSPatch()

       SpaceShipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()     

       If GV_SpaceshipSystemsToggle.GetValue() == 1
          GV_SpaceshipSystemsToggle.SetValue(0)

          Unregister()
          MSG_SpaceshipSystemsTurnedOff.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
    
	EndIf

EndFunction

Function SpaceshipSystemDCPatch()

         UnregisterMaintenance()   
         MSG_SpaceshipSystemsTurnedOffDC.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

EndFunction

Function SpaceshipSystemUninstallExterminatus()
     
         Unregister()
         MSG_SpaceshipSystemsTurnedOff.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

EndFunction

Function SpaceshipMaintenanceSystemBook()
            			
			If GV_SpaceshipNeedsMaintenanceToggle.GetValue() == 0
               RegisterMaintenance()
		
		ElseIf GV_SpaceshipNeedsMaintenanceToggle.GetValue() == 1	           
               UnregisterMaintenance()		 
		 EndIf

EndFunction

Function Update31()

         RegisterForMenuOpenCloseEvent("SpaceshipEditorMenu")

EndFunction

Function Update40()

         PlayerRef.Addperk(SpaceshipMaintenanceRepairPerk, False)

         CalculateFuelCost()		 
         CalculateRepairCost()

EndFunction

Function Update41()

         LeveledCargos()

EndFunction

Function Update42()
         
		 If PlayerRef.GetitemCount(SongbirdPortableAudioPlayer) <= 0
            PlayerRef.Additem(SongbirdPortableAudioPlayer, 1, False)
      EndIf

EndFunction

Function Update50()

         RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerModifiedShip")
         PlayerRef.Addperk(SpaceshipFuelDiscountPerk, False)

EndFunction

Function Update52()

           PlayerRef.Addperk(SpaceshipStarviewOpenizer, False)

EndFunction